/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import shaded.io.github.spannm.jackcess.expr.EvalContext;
import shaded.io.github.spannm.jackcess.expr.EvalException;
import shaded.io.github.spannm.jackcess.expr.Expression;
import shaded.io.github.spannm.jackcess.expr.Function;
import shaded.io.github.spannm.jackcess.expr.FunctionLookup;
import shaded.io.github.spannm.jackcess.expr.Identifier;
import shaded.io.github.spannm.jackcess.expr.LocaleContext;
import shaded.io.github.spannm.jackcess.expr.ParseException;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.BaseDelayedValue;
import shaded.io.github.spannm.jackcess.impl.expr.BuiltinOperators;
import shaded.io.github.spannm.jackcess.impl.expr.ExpressionTokenizer;
import shaded.io.github.spannm.jackcess.impl.expr.ValueSupport;
import shaded.io.github.spannm.jackcess.util.StringUtil;

public class Expressionator {
    private static final String FUNC_START_DELIM = "(";
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final String FUNC_PARAM_SEP = ",";
    private static final Map<String, WordType> WORD_TYPES = new HashMap<String, WordType>();
    private static final Collection<String> TRUE_STRS;
    private static final Collection<String> FALSE_STRS;
    private static final Map<OpType, Integer> PRECENDENCE;
    private static final Set<Character> REGEX_SPEC_CHARS;
    private static final Pattern UNMATCHABLE_REGEX;
    private static final Expr THIS_COL_VALUE;
    private static final Expr NULL_VALUE;
    private static final Expr TRUE_VALUE;
    private static final Expr FALSE_VALUE;

    private Expressionator() {
    }

    public static Expression parse(Type exprType, String exprStr, Value.Type resultType, ParseContext context) {
        List<ExpressionTokenizer.Token> tokens = Expressionator.trimSpaces(ExpressionTokenizer.tokenize(exprType, exprStr, context));
        if (tokens == null) {
            throw new ParseException("null/empty expression");
        }
        TokBuf buf = new TokBuf(exprType, tokens, context);
        if (Expressionator.isLiteralDefaultValue(buf, resultType, exprStr)) {
            return new ExprWrapper(exprStr, new ELiteralValue(Value.Type.STRING, exprStr), resultType);
        }
        Expr expr = Expressionator.parseExpression(buf, false);
        if (exprType == Type.FIELD_VALIDATOR && !expr.isValidationExpr()) {
            expr = new EImplicitCompOp(expr);
        }
        switch (exprType) {
            case DEFAULT_VALUE: 
            case EXPRESSION: {
                return expr.isConstant() ? new MemoizedExprWrapper(exprStr, expr, resultType) : new ExprWrapper(exprStr, expr, resultType);
            }
            case FIELD_VALIDATOR: 
            case RECORD_VALIDATOR: {
                return expr.isConstant() ? new MemoizedCondExprWrapper(exprStr, expr) : new CondExprWrapper(exprStr, expr);
            }
        }
        throw new ParseException("unexpected expression type " + exprType);
    }

    private static List<ExpressionTokenizer.Token> trimSpaces(List<ExpressionTokenizer.Token> tokens) {
        if (tokens == null) {
            return null;
        }
        for (int i = 1; i < tokens.size() - 1; ++i) {
            ExpressionTokenizer.Token t = tokens.get(i);
            if (t.getType() != ExpressionTokenizer.TokenType.SPACE || tokens.get(i - 1).getType() == ExpressionTokenizer.TokenType.STRING && Expressionator.isDelim(tokens.get(i + 1), "(")) continue;
            tokens.remove(i);
            --i;
        }
        return tokens;
    }

    private static Expr parseExpression(TokBuf buf, boolean singleExpr) {
        Expr expr;
        while (buf.hasNext()) {
            ExpressionTokenizer.Token t = buf.next();
            block0 : switch (t.getType()) {
                case OBJ_NAME: {
                    Expressionator.parseObjectRefExpression(t, buf);
                    break;
                }
                case LITERAL: {
                    buf.setPendingExpr(new ELiteralValue(t.getValueType(), t.getValue()));
                    break;
                }
                case OP: {
                    WordType wordType = Expressionator.getWordType(t);
                    if (wordType == null) {
                        throw new ParseException("Invalid operator " + t);
                    }
                    switch (wordType) {
                        case OP: {
                            Expressionator.parseOperatorExpression(t, buf);
                            break block0;
                        }
                        case COMP: {
                            Expressionator.parseCompOpExpression(t, buf);
                            break block0;
                        }
                    }
                    throw new ParseException("Unexpected OP word type " + wordType);
                }
                case DELIM: {
                    Expressionator.parseDelimExpression(t, buf);
                    break;
                }
                case STRING: {
                    WordType wordType = Expressionator.getWordType(t);
                    if (wordType == null) {
                        if (Expressionator.maybeParseFuncCallExpression(t, buf)) break;
                        ExpressionTokenizer.Token next = buf.peekNext();
                        if (next != null && Expressionator.isObjNameSep(next)) {
                            Expressionator.parseObjectRefExpression(t, buf);
                            break;
                        }
                        throw new UnsupportedOperationException("FIXME");
                    }
                    switch (wordType) {
                        case OP: {
                            Expressionator.parseOperatorExpression(t, buf);
                            break block0;
                        }
                        case LOG_OP: {
                            Expressionator.parseLogicalOpExpression(t, buf);
                            break block0;
                        }
                        case CONST: {
                            Expressionator.parseConstExpression(t, buf);
                            break block0;
                        }
                        case SPEC_OP_PREFIX: {
                            Expressionator.parseSpecOpExpression(t, buf);
                            break block0;
                        }
                    }
                    throw new ParseException("Unexpected STRING word type " + wordType);
                }
                case SPACE: {
                    break;
                }
                default: {
                    throw new ParseException("unknown token type " + t);
                }
            }
            if (!singleExpr || !buf.hasPendingExpr()) continue;
            break;
        }
        if ((expr = buf.takePendingExpr()) == null) {
            throw new ParseException("No expression found? " + buf);
        }
        return expr;
    }

    private static void parseObjectRefExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        LinkedList<String> objNames = new LinkedList<String>();
        objNames.add(firstTok.getValueStr());
        ExpressionTokenizer.Token t = null;
        boolean atSep = false;
        while ((t = buf.peekNext()) != null) {
            if (!atSep) {
                if (!Expressionator.isObjNameSep(t)) break;
                buf.next();
                atSep = true;
                continue;
            }
            if (t.getType() != ExpressionTokenizer.TokenType.OBJ_NAME && t.getType() != ExpressionTokenizer.TokenType.STRING) break;
            buf.next();
            objNames.addFirst(t.getValueStr());
            atSep = false;
        }
        int numNames = objNames.size();
        if (atSep || numNames > 3) {
            throw new ParseException("Invalid object reference " + buf);
        }
        String propName = null;
        if (numNames == 3) {
            propName = (String)objNames.poll();
        }
        String objName = (String)objNames.poll();
        String collectionName = (String)objNames.poll();
        buf.setPendingExpr(new EObjValue(new Identifier(collectionName, objName, propName)));
    }

    private static void parseDelimExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        if (!Expressionator.isDelim(firstTok, "(") || buf.hasPendingExpr()) {
            throw new ParseException("Unexpected delimiter " + firstTok.getValue() + " " + buf);
        }
        Expr subExpr = Expressionator.findParenExprs(buf, false).get(0);
        buf.setPendingExpr(new EParen(subExpr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean maybeParseFuncCallExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        int startPos = buf.curPos();
        boolean foundFunc = false;
        try {
            ExpressionTokenizer.Token t = buf.peekNext();
            if (!Expressionator.isDelim(t, "(")) {
                boolean bl = false;
                return bl;
            }
            buf.next();
            List<Expr> params = Expressionator.findParenExprs(buf, true);
            String funcName = firstTok.getValueStr();
            Function func = buf.getFunction(funcName);
            if (func == null) {
                throw new ParseException("Could not find function '" + funcName + "' " + buf);
            }
            buf.setPendingExpr(new EFunc(func, params));
            foundFunc = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (!foundFunc) {
                buf.reset(startPos);
            }
        }
    }

    private static List<Expr> findParenExprs(TokBuf buf, boolean allowMulti) {
        ExpressionTokenizer.Token t;
        if (allowMulti && Expressionator.isDelim(t = buf.peekNext(), CLOSE_PAREN)) {
            buf.next();
            return List.of();
        }
        ArrayList<Expr> exprs = new ArrayList<Expr>(3);
        int level = 1;
        int startPos = buf.curPos();
        while (buf.hasNext()) {
            TokBuf subBuf;
            ExpressionTokenizer.Token t2 = buf.next();
            if (Expressionator.isDelim(t2, "(")) {
                ++level;
                continue;
            }
            if (Expressionator.isDelim(t2, CLOSE_PAREN)) {
                if (--level != 0) continue;
                subBuf = buf.subBuf(startPos, buf.prevPos());
                exprs.add(Expressionator.parseExpression(subBuf, false));
                return exprs;
            }
            if (!allowMulti || level != 1 || !Expressionator.isDelim(t2, FUNC_PARAM_SEP)) continue;
            subBuf = buf.subBuf(startPos, buf.prevPos());
            exprs.add(Expressionator.parseExpression(subBuf, false));
            startPos = buf.curPos();
        }
        throw new ParseException("Missing closing ') " + buf);
    }

    private static void parseOperatorExpression(ExpressionTokenizer.Token t, TokBuf buf) {
        if (buf.hasPendingExpr()) {
            Expressionator.parseBinaryOpExpression(t, buf);
        } else if (Expressionator.isEitherOp(t, "-", "+")) {
            Expressionator.parseUnaryOpExpression(t, buf);
        } else {
            throw new ParseException("Missing left expression for binary operator " + t.getValue() + " " + buf);
        }
    }

    private static void parseBinaryOpExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        BinaryOp op = Expressionator.getOpType(firstTok, BinaryOp.class);
        Expr leftExpr = buf.takePendingExpr();
        Expr rightExpr = Expressionator.parseExpression(buf, true);
        buf.setPendingExpr(new EBinaryOp(op, leftExpr, rightExpr));
    }

    private static void parseUnaryOpExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        ExpressionTokenizer.Token nextTok;
        UnaryOp op = Expressionator.getOpType(firstTok, UnaryOp.class);
        UnaryOp numOp = op.getUnaryNumOp();
        if (numOp != null && (nextTok = buf.peekNext()) != null && nextTok.getType() == ExpressionTokenizer.TokenType.LITERAL && nextTok.getValueType().isNumeric()) {
            op = numOp;
        }
        Expr val = Expressionator.parseExpression(buf, true);
        buf.setPendingExpr(new EUnaryOp(op, val));
    }

    private static void parseCompOpExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        if (!buf.hasPendingExpr()) {
            if (buf.getExprType() == Type.FIELD_VALIDATOR) {
                buf.setPendingExpr(THIS_COL_VALUE);
            } else {
                throw new ParseException("Missing left expression for comparison operator " + firstTok.getValue() + " " + buf);
            }
        }
        CompOp op = Expressionator.getOpType(firstTok, CompOp.class);
        Expr leftExpr = buf.takePendingExpr();
        Expr rightExpr = Expressionator.parseExpression(buf, true);
        buf.setPendingExpr(new ECompOp(op, leftExpr, rightExpr));
    }

    private static void parseLogicalOpExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        if (!buf.hasPendingExpr()) {
            throw new ParseException("Missing left expression for logical operator " + firstTok.getValue() + " " + buf);
        }
        LogOp op = Expressionator.getOpType(firstTok, LogOp.class);
        Expr leftExpr = buf.takePendingExpr();
        Expr rightExpr = Expressionator.parseExpression(buf, true);
        buf.setPendingExpr(new ELogicalOp(op, leftExpr, rightExpr));
    }

    private static void parseSpecOpExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        SpecOp specOp = Expressionator.getSpecialOperator(firstTok, buf);
        if (specOp == SpecOp.NOT) {
            Expressionator.parseUnaryOpExpression(firstTok, buf);
            return;
        }
        if (!buf.hasPendingExpr()) {
            if (buf.getExprType() == Type.FIELD_VALIDATOR) {
                buf.setPendingExpr(THIS_COL_VALUE);
            } else {
                throw new ParseException("Missing left expression for comparison operator " + specOp + " " + buf);
            }
        }
        Expr expr = buf.takePendingExpr();
        ESpecOp specOpExpr = null;
        switch (specOp) {
            case IS_NULL: 
            case IS_NOT_NULL: {
                specOpExpr = new ENullOp(specOp, expr);
                break;
            }
            case LIKE: 
            case NOT_LIKE: {
                ExpressionTokenizer.Token t = buf.next();
                if (t.getType() != ExpressionTokenizer.TokenType.LITERAL || t.getValueType() != Value.Type.STRING) {
                    throw new ParseException("Missing Like pattern " + buf);
                }
                String patternStr = t.getValueStr();
                specOpExpr = new ELikeOp(specOp, expr, patternStr);
                break;
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                Expr tmpExpr;
                Expr startRangeExpr = null;
                while (true) {
                    tmpExpr = Expressionator.parseExpression(buf, true);
                    ExpressionTokenizer.Token tmpT = buf.peekNext();
                    if (tmpT == null) {
                        throw new ParseException("Missing 'And' for 'Between' expression " + buf);
                    }
                    if (Expressionator.isString(tmpT, "and")) break;
                    buf.restorePendingExpr(tmpExpr);
                }
                buf.next();
                startRangeExpr = tmpExpr;
                Expr endRangeExpr = Expressionator.parseExpression(buf, true);
                specOpExpr = new EBetweenOp(specOp, expr, startRangeExpr, endRangeExpr);
                break;
            }
            case IN: 
            case NOT_IN: {
                ExpressionTokenizer.Token t = buf.next();
                if (t.getType() == ExpressionTokenizer.TokenType.SPACE) {
                    t = buf.next();
                }
                if (!Expressionator.isDelim(t, "(")) {
                    throw new ParseException("Malformed 'In' expression " + buf);
                }
                List<Expr> exprs = Expressionator.findParenExprs(buf, true);
                specOpExpr = new EInOp(specOp, expr, exprs);
                break;
            }
            default: {
                throw new ParseException("Unexpected special op " + specOp);
            }
        }
        buf.setPendingExpr(specOpExpr);
    }

    private static SpecOp getSpecialOperator(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        String opStr = firstTok.getValueStr().toLowerCase();
        if ("is".equals(opStr)) {
            ExpressionTokenizer.Token t = buf.peekNext();
            if (Expressionator.isString(t, "null")) {
                buf.next();
                return SpecOp.IS_NULL;
            }
            if (Expressionator.isString(t, "not")) {
                buf.next();
                t = buf.peekNext();
                if (Expressionator.isString(t, "null")) {
                    buf.next();
                    return SpecOp.IS_NOT_NULL;
                }
            }
        } else {
            if ("like".equals(opStr)) {
                return SpecOp.LIKE;
            }
            if ("between".equals(opStr)) {
                return SpecOp.BETWEEN;
            }
            if ("in".equals(opStr)) {
                return SpecOp.IN;
            }
            if ("not".equals(opStr)) {
                ExpressionTokenizer.Token t = buf.peekNext();
                if (Expressionator.isString(t, "between")) {
                    buf.next();
                    return SpecOp.NOT_BETWEEN;
                }
                if (Expressionator.isString(t, "in")) {
                    buf.next();
                    return SpecOp.NOT_IN;
                }
                if (Expressionator.isString(t, "like")) {
                    buf.next();
                    return SpecOp.NOT_LIKE;
                }
                return SpecOp.NOT;
            }
        }
        throw new ParseException("Malformed special operator " + opStr + " " + buf);
    }

    private static void parseConstExpression(ExpressionTokenizer.Token firstTok, TokBuf buf) {
        Expr constExpr = null;
        String tokStr = firstTok.getValueStr().toLowerCase();
        if (TRUE_STRS.contains(tokStr)) {
            constExpr = TRUE_VALUE;
        } else if (FALSE_STRS.contains(tokStr)) {
            constExpr = FALSE_VALUE;
        } else if ("null".equals(tokStr)) {
            constExpr = NULL_VALUE;
        } else {
            throw new ParseException("Unexpected CONST word " + firstTok.getValue());
        }
        buf.setPendingExpr(constExpr);
    }

    private static boolean isObjNameSep(ExpressionTokenizer.Token t) {
        return Expressionator.isDelim(t, ".") || Expressionator.isDelim(t, "!");
    }

    private static boolean isOp(ExpressionTokenizer.Token t, String opStr) {
        return t != null && t.getType() == ExpressionTokenizer.TokenType.OP && opStr.equalsIgnoreCase(t.getValueStr());
    }

    private static boolean isEitherOp(ExpressionTokenizer.Token t, String opStr1, String opStr2) {
        return t != null && t.getType() == ExpressionTokenizer.TokenType.OP && (opStr1.equalsIgnoreCase(t.getValueStr()) || opStr2.equalsIgnoreCase(t.getValueStr()));
    }

    private static boolean isDelim(ExpressionTokenizer.Token t, String opStr) {
        return t != null && t.getType() == ExpressionTokenizer.TokenType.DELIM && opStr.equalsIgnoreCase(t.getValueStr());
    }

    private static boolean isString(ExpressionTokenizer.Token t, String opStr) {
        return t != null && t.getType() == ExpressionTokenizer.TokenType.STRING && opStr.equalsIgnoreCase(t.getValueStr());
    }

    private static WordType getWordType(ExpressionTokenizer.Token t) {
        return WORD_TYPES.get(t.getValueStr().toLowerCase());
    }

    private static <T extends Enum<T>> T getOpType(ExpressionTokenizer.Token t, Class<T> opClazz) {
        String str = t.getValueStr();
        for (Enum op : (Enum[])opClazz.getEnumConstants()) {
            if (!str.equalsIgnoreCase(op.toString())) continue;
            return (T)op;
        }
        throw new ParseException("Unexpected op string " + t.getValueStr());
    }

    private static StringBuilder appendLeadingExpr(Expr expr, LocaleContext ctx, StringBuilder sb, boolean isDebug) {
        int len = sb.length();
        expr.toString(ctx, sb, isDebug);
        if (sb.length() > len) {
            sb.append(' ');
        }
        return sb;
    }

    private static boolean isHigherPrecendence(OpType op1, OpType op2) {
        int prec2;
        int prec1 = PRECENDENCE.get(op1);
        return prec1 < (prec2 = PRECENDENCE.get(op2).intValue());
    }

    private static Map<OpType, Integer> buildPrecedenceMap(OpType[] ... opArrs) {
        HashMap<OpType, Integer> prec = new HashMap<OpType, Integer>();
        int level = 0;
        OpType[][] opTypeArray = opArrs;
        int n = opTypeArray.length;
        for (int i = 0; i < n; ++i) {
            OpType[] ops;
            for (OpType op : ops = opTypeArray[i]) {
                prec.put(op, level);
            }
            ++level;
        }
        return prec;
    }

    private static void exprListToString(List<Expr> exprs, String sep, LocaleContext ctx, StringBuilder sb, boolean isDebug) {
        Iterator<Expr> iter = exprs.iterator();
        iter.next().toString(ctx, sb, isDebug);
        while (iter.hasNext()) {
            sb.append(sep);
            iter.next().toString(ctx, sb, isDebug);
        }
    }

    private static Value[] exprListToValues(List<Expr> exprs, EvalContext ctx) {
        Value[] paramVals = new Value[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            paramVals[i] = exprs.get(i).eval(ctx);
        }
        return paramVals;
    }

    private static Value[] exprListToDelayedValues(List<Expr> exprs, EvalContext ctx) {
        Value[] paramVals = new Value[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            paramVals[i] = new DelayedValue(exprs.get(i), ctx);
        }
        return paramVals;
    }

    private static boolean areConstant(List<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static boolean areConstant(Expr ... exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static void literalStrToString(String str, StringBuilder sb) {
        sb.append("\"").append(StringUtil.replace(str, "\"", "\"\"")).append("\"");
    }

    public static Pattern likePatternToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c == '?') {
                sb.append('.');
                continue;
            }
            if (c == '#') {
                sb.append("\\d");
                continue;
            }
            if (c == '[') {
                int startPos = i + 1;
                int endPos = -1;
                for (int j = startPos; j < pattern.length(); ++j) {
                    if (pattern.charAt(j) != ']') continue;
                    endPos = j;
                    break;
                }
                if (endPos == -1) {
                    return UNMATCHABLE_REGEX;
                }
                Object charClass = pattern.substring(startPos, endPos);
                if (!((String)charClass).isEmpty() && ((String)charClass).charAt(0) == '!') {
                    charClass = "^" + ((String)charClass).substring(1);
                }
                sb.append('[').append((String)charClass).append(']');
                i += endPos - startPos + 1;
                continue;
            }
            if (Expressionator.isRegexSpecialChar(c)) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        try {
            return Pattern.compile(sb.toString(), 98);
        }
        catch (PatternSyntaxException ignored) {
            return UNMATCHABLE_REGEX;
        }
    }

    public static boolean isRegexSpecialChar(char c) {
        return REGEX_SPEC_CHARS.contains(Character.valueOf(c));
    }

    private static Value toLiteralValue(Value.Type valType, Object value) {
        switch (valType) {
            case STRING: {
                return ValueSupport.toValue((String)value);
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return ValueSupport.toValue(valType, (LocalDateTime)value);
            }
            case LONG: {
                return ValueSupport.toValue((Integer)value);
            }
            case DOUBLE: {
                return ValueSupport.toValue((Double)value);
            }
            case BIG_DEC: {
                return ValueSupport.toValue((BigDecimal)value);
            }
        }
        throw new ParseException("unexpected literal type " + valType);
    }

    private static boolean isLiteralDefaultValue(TokBuf buf, Value.Type resultType, String exprStr) {
        if (buf.getExprType() != Type.DEFAULT_VALUE) {
            return false;
        }
        if (Expressionator.isOp(buf.peekNext(), "=")) {
            buf.next();
            return false;
        }
        return resultType == Value.Type.STRING && (exprStr.isEmpty() || exprStr.charAt(0) != '\"');
    }

    static {
        Stream.of("+", "-", "*", "/", "\\", "^", "&", "mod").forEach(w -> WORD_TYPES.put((String)w, WordType.OP));
        Stream.of("<", "<=", ">", ">=", "=", "<>").forEach(w -> WORD_TYPES.put((String)w, WordType.COMP));
        Stream.of("and", "or", "eqv", "xor", "imp").forEach(w -> WORD_TYPES.put((String)w, WordType.LOG_OP));
        Stream.of("true", "false", "null", "on", "off", "yes", "no").forEach(w -> WORD_TYPES.put((String)w, WordType.CONST));
        Stream.of("is", "like", "between", "in", "not").forEach(w -> WORD_TYPES.put((String)w, WordType.SPEC_OP_PREFIX));
        Stream.of(".", "!", FUNC_PARAM_SEP, "(", CLOSE_PAREN).forEach(w -> WORD_TYPES.put((String)w, WordType.DELIM));
        TRUE_STRS = List.of("true", "yes", "on");
        FALSE_STRS = List.of("false", "no", "off");
        PRECENDENCE = Expressionator.buildPrecedenceMap({UnaryOp.NEG_NUM, UnaryOp.POS_NUM}, {BinaryOp.EXP}, {UnaryOp.NEG, UnaryOp.POS}, {BinaryOp.MULT, BinaryOp.DIV}, {BinaryOp.INT_DIV}, {BinaryOp.MOD}, {BinaryOp.PLUS, BinaryOp.MINUS}, {BinaryOp.CONCAT}, {CompOp.LT, CompOp.GT, CompOp.NE, CompOp.LTE, CompOp.GTE, CompOp.EQ, SpecOp.LIKE, SpecOp.NOT_LIKE, SpecOp.IS_NULL, SpecOp.IS_NOT_NULL}, {UnaryOp.NOT}, {LogOp.AND}, {LogOp.OR}, {LogOp.XOR}, {LogOp.EQV}, {LogOp.IMP}, {SpecOp.IN, SpecOp.NOT_IN, SpecOp.BETWEEN, SpecOp.NOT_BETWEEN});
        REGEX_SPEC_CHARS = Set.of(Character.valueOf('\\'), Character.valueOf('.'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('$'), Character.valueOf('^'), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('&'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('*'), Character.valueOf('?'));
        UNMATCHABLE_REGEX = Pattern.compile("(?!)");
        THIS_COL_VALUE = new EThisValue();
        NULL_VALUE = new EConstValue(ValueSupport.NULL_VAL, "Null");
        TRUE_VALUE = new EConstValue(ValueSupport.TRUE_VAL, "True");
        FALSE_VALUE = new EConstValue(ValueSupport.FALSE_VAL, "False");
    }

    private static final class MemoizedCondExprWrapper
    extends CondExprWrapper {
        private Object _val;

        private MemoizedCondExprWrapper(String rawExprStr, Expr expr) {
            super(rawExprStr, expr);
        }

        @Override
        public Object eval(EvalContext ctx) {
            if (this._val == null) {
                this._val = super.eval(ctx);
            }
            return this._val;
        }
    }

    private static final class MemoizedExprWrapper
    extends ExprWrapper {
        private Object _val;

        private MemoizedExprWrapper(String rawExprStr, Expr expr, Value.Type resultType) {
            super(rawExprStr, expr, resultType);
        }

        @Override
        public Object eval(EvalContext ctx) {
            if (this._val == null) {
                this._val = super.eval(ctx);
            }
            return this._val;
        }
    }

    private static class CondExprWrapper
    extends BaseExprWrapper {
        private CondExprWrapper(String rawExprStr, Expr expr) {
            super(rawExprStr, expr);
        }

        @Override
        public Object eval(EvalContext ctx) {
            return this.evalCondition(ctx);
        }
    }

    private static class ExprWrapper
    extends BaseExprWrapper {
        private final Value.Type _resultType;

        private ExprWrapper(String rawExprStr, Expr expr, Value.Type resultType) {
            super(rawExprStr, expr);
            this._resultType = resultType;
        }

        @Override
        public Object eval(EvalContext ctx) {
            return this.evalValue(this._resultType, ctx);
        }
    }

    private static abstract class BaseExprWrapper
    implements Expression {
        private final String _rawExprStr;
        private final Expr _expr;

        private BaseExprWrapper(String rawExprStr, Expr expr) {
            this._rawExprStr = rawExprStr;
            this._expr = expr;
        }

        @Override
        public String toDebugString(LocaleContext ctx) {
            return this._expr.toDebugString(ctx);
        }

        @Override
        public String toRawString() {
            return this._rawExprStr;
        }

        @Override
        public String toCleanString(LocaleContext ctx) {
            return this._expr.toCleanString(ctx);
        }

        @Override
        public boolean isConstant() {
            return this._expr.isConstant();
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            this._expr.collectIdentifiers(identifiers);
        }

        public String toString() {
            return this.toRawString();
        }

        protected Object evalValue(Value.Type resultType, EvalContext ctx) {
            Value val = this._expr.eval(ctx);
            if (val.isNull()) {
                return null;
            }
            if (resultType == null) {
                return val.get();
            }
            switch (resultType) {
                case STRING: {
                    return val.getAsString(ctx);
                }
                case DATE: 
                case TIME: 
                case DATE_TIME: {
                    return val.getAsLocalDateTime(ctx);
                }
                case LONG: {
                    return val.getAsLongInt(ctx);
                }
                case DOUBLE: {
                    return val.getAsDouble(ctx);
                }
                case BIG_DEC: {
                    return val.getAsBigDecimal(ctx);
                }
            }
            throw new IllegalStateException("unexpected result type " + resultType);
        }

        protected Boolean evalCondition(EvalContext ctx) {
            Value val = this._expr.eval(ctx);
            if (val.isNull()) {
                throw new EvalException("Condition evaluated to Null");
            }
            return val.getAsBoolean(ctx);
        }
    }

    private static class EBetweenOp
    extends ESpecOp
    implements RightAssocExpr {
        private final Expr _startRangeExpr;
        private Expr _endRangeExpr;

        private EBetweenOp(SpecOp op, Expr expr, Expr startRangeExpr, Expr endRangeExpr) {
            super(op, expr);
            this._startRangeExpr = startRangeExpr;
            this._endRangeExpr = endRangeExpr;
        }

        @Override
        public boolean isConstant() {
            return this._expr.isConstant() && Expressionator.areConstant(this._startRangeExpr, this._endRangeExpr);
        }

        @Override
        public Expr getRight() {
            return this._endRangeExpr;
        }

        @Override
        public void setRight(Expr right) {
            this._endRangeExpr = right;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._op.eval(ctx, this._expr.eval(ctx), new DelayedValue(this._startRangeExpr, ctx), new DelayedValue(this._endRangeExpr, ctx));
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            super.collectIdentifiers(identifiers);
            this._startRangeExpr.collectIdentifiers(identifiers);
            this._endRangeExpr.collectIdentifiers(identifiers);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            Expressionator.appendLeadingExpr(this._expr, ctx, sb, isDebug).append(this._op).append(' ');
            this._startRangeExpr.toString(ctx, sb, isDebug);
            sb.append(" And ");
            this._endRangeExpr.toString(ctx, sb, isDebug);
        }
    }

    private static class EInOp
    extends ESpecOp {
        private final List<Expr> _exprs;

        private EInOp(SpecOp op, Expr expr, List<Expr> exprs) {
            super(op, expr);
            this._exprs = exprs;
        }

        @Override
        public boolean isConstant() {
            return super.isConstant() && Expressionator.areConstant(this._exprs);
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._op.eval(ctx, this._expr.eval(ctx), Expressionator.exprListToDelayedValues(this._exprs, ctx), null);
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            for (Expr expr : this._exprs) {
                expr.collectIdentifiers(identifiers);
            }
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            Expressionator.appendLeadingExpr(this._expr, ctx, sb, isDebug).append(this._op).append(" (");
            Expressionator.exprListToString(this._exprs, Expressionator.FUNC_PARAM_SEP, ctx, sb, isDebug);
            sb.append(')');
        }
    }

    private static class ELikeOp
    extends ESpecOp {
        private final String _patternStr;
        private Pattern _pattern;

        private ELikeOp(SpecOp op, Expr expr, String patternStr) {
            super(op, expr);
            this._patternStr = patternStr;
        }

        private Pattern getPattern() {
            if (this._pattern == null) {
                this._pattern = Expressionator.likePatternToRegex(this._patternStr);
            }
            return this._pattern;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._op.eval(ctx, this._expr.eval(ctx), this.getPattern(), null);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            Expressionator.appendLeadingExpr(this._expr, ctx, sb, isDebug).append(this._op).append(' ');
            Expressionator.literalStrToString(this._patternStr, sb);
            if (isDebug) {
                sb.append('(').append(this.getPattern()).append(')');
            }
        }
    }

    private static class ENullOp
    extends ESpecOp {
        private ENullOp(SpecOp op, Expr expr) {
            super(op, expr);
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._op.eval(ctx, this._expr.eval(ctx), null, null);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            Expressionator.appendLeadingExpr(this._expr, ctx, sb, isDebug).append(this._op);
        }
    }

    private static abstract class ESpecOp
    extends Expr
    implements LeftAssocExpr {
        protected final SpecOp _op;
        protected Expr _expr;

        private ESpecOp(SpecOp op, Expr expr) {
            this._op = op;
            this._expr = expr;
        }

        @Override
        public boolean isConstant() {
            return this._expr.isConstant();
        }

        @Override
        public OpType getOp() {
            return this._op;
        }

        @Override
        public Expr getLeft() {
            return this._expr;
        }

        @Override
        public void setLeft(Expr left) {
            this._expr = left;
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            this._expr.collectIdentifiers(identifiers);
        }

        @Override
        protected boolean isValidationExpr() {
            return true;
        }
    }

    private static class ELogicalOp
    extends EBaseBinaryOp {
        private ELogicalOp(LogOp op, Expr left, Expr right) {
            super(op, left, right);
        }

        @Override
        protected boolean isValidationExpr() {
            return true;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return ((LogOp)this._op).eval(ctx, new DelayedValue(this._left, ctx), new DelayedValue(this._right, ctx));
        }
    }

    private static class EImplicitCompOp
    extends ECompOp {
        private EImplicitCompOp(Expr right) {
            super(CompOp.EQ, THIS_COL_VALUE, right);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            if (isDebug) {
                super.toExprString(ctx, sb, isDebug);
            } else {
                this._right.toString(ctx, sb, isDebug);
            }
        }
    }

    private static class ECompOp
    extends EBaseBinaryOp {
        private ECompOp(CompOp op, Expr left, Expr right) {
            super(op, left, right);
        }

        @Override
        protected boolean isValidationExpr() {
            return true;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return ((CompOp)this._op).eval(ctx, this._left.eval(ctx), this._right.eval(ctx));
        }
    }

    private static class EUnaryOp
    extends Expr
    implements RightAssocExpr {
        private final OpType _op;
        private Expr _expr;

        private EUnaryOp(UnaryOp op, Expr expr) {
            this._op = op;
            this._expr = expr;
        }

        @Override
        public boolean isConstant() {
            return this._expr.isConstant();
        }

        @Override
        public OpType getOp() {
            return this._op;
        }

        @Override
        public Expr getRight() {
            return this._expr;
        }

        @Override
        public void setRight(Expr right) {
            this._expr = right;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return ((UnaryOp)this._op).eval(ctx, this._expr.eval(ctx));
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            this._expr.collectIdentifiers(identifiers);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            sb.append(this._op);
            if (isDebug || ((UnaryOp)this._op).needsSpace()) {
                sb.append(' ');
            }
            this._expr.toString(ctx, sb, isDebug);
        }
    }

    private static class EBinaryOp
    extends EBaseBinaryOp {
        private EBinaryOp(BinaryOp op, Expr left, Expr right) {
            super(op, left, right);
        }

        @Override
        public Value eval(EvalContext ctx) {
            return ((BinaryOp)this._op).eval(ctx, this._left.eval(ctx), this._right.eval(ctx));
        }
    }

    private static abstract class EBaseBinaryOp
    extends Expr
    implements LeftAssocExpr,
    RightAssocExpr {
        protected final OpType _op;
        protected Expr _left;
        protected Expr _right;

        private EBaseBinaryOp(OpType op, Expr left, Expr right) {
            this._op = op;
            this._left = left;
            this._right = right;
        }

        @Override
        public boolean isConstant() {
            return Expressionator.areConstant(this._left, this._right);
        }

        @Override
        public OpType getOp() {
            return this._op;
        }

        @Override
        public Expr getLeft() {
            return this._left;
        }

        @Override
        public void setLeft(Expr left) {
            this._left = left;
        }

        @Override
        public Expr getRight() {
            return this._right;
        }

        @Override
        public void setRight(Expr right) {
            this._right = right;
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            this._left.collectIdentifiers(identifiers);
            this._right.collectIdentifiers(identifiers);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            Expressionator.appendLeadingExpr(this._left, ctx, sb, isDebug).append(this._op).append(' ');
            this._right.toString(ctx, sb, isDebug);
        }
    }

    private static class EFunc
    extends Expr {
        private final Function _func;
        private final List<Expr> _params;

        private EFunc(Function func, List<Expr> params) {
            this._func = func;
            this._params = params;
        }

        @Override
        public boolean isConstant() {
            return this._func.isPure() && Expressionator.areConstant(this._params);
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._func.eval(ctx, Expressionator.exprListToValues(this._params, ctx));
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            for (Expr param : this._params) {
                param.collectIdentifiers(identifiers);
            }
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            sb.append(this._func.getName()).append('(');
            if (!this._params.isEmpty()) {
                Expressionator.exprListToString(this._params, Expressionator.FUNC_PARAM_SEP, ctx, sb, isDebug);
            }
            sb.append(')');
        }
    }

    private static class EParen
    extends Expr {
        private final Expr _expr;

        private EParen(Expr expr) {
            this._expr = expr;
        }

        @Override
        public boolean isConstant() {
            return this._expr.isConstant();
        }

        @Override
        protected boolean isValidationExpr() {
            return this._expr.isValidationExpr();
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._expr.eval(ctx);
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            this._expr.collectIdentifiers(identifiers);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            sb.append('(');
            this._expr.toString(ctx, sb, isDebug);
            sb.append(')');
        }
    }

    private static final class EObjValue
    extends Expr {
        private final Identifier _identifier;

        private EObjValue(Identifier identifier) {
            this._identifier = identifier;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return ctx.getIdentifierValue(this._identifier);
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
            identifiers.add(this._identifier);
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            sb.append(this._identifier);
        }
    }

    private static final class ELiteralValue
    extends Expr {
        private final Value _val;

        private ELiteralValue(Value.Type valType, Object value) {
            this._val = Expressionator.toLiteralValue(valType, value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._val;
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            if (this._val.getType() == Value.Type.STRING) {
                Expressionator.literalStrToString((String)this._val.get(), sb);
            } else if (this._val.getType().isTemporal()) {
                sb.append('#').append(this._val.getAsString(ctx)).append('#');
            } else {
                sb.append(this._val.get());
            }
        }
    }

    private static final class EThisValue
    extends Expr {
        private EThisValue() {
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return ctx.getThisColumnValue();
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            if (isDebug) {
                sb.append("<THIS_COL>");
            }
        }
    }

    private static final class EConstValue
    extends Expr {
        private final Value _val;
        private final String _str;

        private EConstValue(Value val, String str) {
            this._val = val;
            this._str = str;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public Value eval(EvalContext ctx) {
            return this._val;
        }

        @Override
        public void collectIdentifiers(Collection<Identifier> identifiers) {
        }

        @Override
        protected void toExprString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            sb.append(this._str);
        }
    }

    private static abstract class Expr {
        private Expr() {
        }

        public String toCleanString(LocaleContext ctx) {
            return this.toString(ctx, new StringBuilder(), false).toString();
        }

        public String toDebugString(LocaleContext ctx) {
            return this.toString(ctx, new StringBuilder(), true).toString();
        }

        protected boolean isValidationExpr() {
            return false;
        }

        protected StringBuilder toString(LocaleContext ctx, StringBuilder sb, boolean isDebug) {
            if (isDebug) {
                sb.append('<').append(this.getClass().getSimpleName()).append(">{");
            }
            this.toExprString(ctx, sb, isDebug);
            if (isDebug) {
                sb.append('}');
            }
            return sb;
        }

        protected Expr resolveOrderOfOperations() {
            if (!(this instanceof LeftAssocExpr)) {
                return this;
            }
            Expr outerExpr = this;
            LeftAssocExpr thisExpr = (LeftAssocExpr)((Object)this);
            Expr thisLeft = thisExpr.getLeft();
            if (thisLeft instanceof RightAssocExpr) {
                RightAssocExpr leftOp = (RightAssocExpr)((Object)thisLeft);
                thisExpr.setLeft(leftOp.getRight());
                leftOp.setRight(this.resolveOrderOfOperations());
                outerExpr = thisLeft;
                if (leftOp.getRight() == this && !Expressionator.isHigherPrecendence(thisExpr.getOp(), leftOp.getOp())) {
                    leftOp.setRight(thisExpr.getLeft());
                    thisExpr.setLeft(thisLeft);
                    outerExpr = this;
                }
            }
            return outerExpr;
        }

        public abstract boolean isConstant();

        public abstract Value eval(EvalContext var1);

        public abstract void collectIdentifiers(Collection<Identifier> var1);

        protected abstract void toExprString(LocaleContext var1, StringBuilder var2, boolean var3);
    }

    private static final class DelayedValue
    extends BaseDelayedValue {
        private final Expr _expr;
        private final EvalContext _ctx;

        private DelayedValue(Expr expr, EvalContext ctx) {
            this._expr = expr;
            this._ctx = ctx;
        }

        @Override
        public Value eval() {
            return this._expr.eval(this._ctx);
        }
    }

    private static interface RightAssocExpr {
        public OpType getOp();

        public Expr getRight();

        public void setRight(Expr var1);
    }

    private static interface LeftAssocExpr {
        public OpType getOp();

        public Expr getLeft();

        public void setLeft(Expr var1);
    }

    private static final class TokBuf {
        private final Type _exprType;
        private final List<ExpressionTokenizer.Token> _tokens;
        private final TokBuf _parent;
        private final int _parentOff;
        private final ParseContext _ctx;
        private int _pos;
        private Expr _pendingExpr;

        private TokBuf(Type exprType, List<ExpressionTokenizer.Token> tokens, ParseContext context) {
            this(exprType, tokens, null, 0, context);
        }

        private TokBuf(List<ExpressionTokenizer.Token> tokens, TokBuf parent, int parentOff) {
            this(parent._exprType, tokens, parent, parentOff, parent._ctx);
        }

        private TokBuf(Type exprType, List<ExpressionTokenizer.Token> tokens, TokBuf parent, int parentOff, ParseContext context) {
            this._exprType = exprType;
            this._tokens = tokens;
            this._parent = parent;
            this._parentOff = parentOff;
            this._ctx = context;
        }

        public Type getExprType() {
            return this._exprType;
        }

        public int curPos() {
            return this._pos;
        }

        public int prevPos() {
            return this._pos - 1;
        }

        public boolean hasNext() {
            return this._pos < this._tokens.size();
        }

        public ExpressionTokenizer.Token peekNext() {
            if (!this.hasNext()) {
                return null;
            }
            return this._tokens.get(this._pos);
        }

        public ExpressionTokenizer.Token next() {
            if (!this.hasNext()) {
                throw new ParseException("Unexpected end of expression " + this);
            }
            return this._tokens.get(this._pos++);
        }

        public void reset(int pos) {
            this._pos = pos;
        }

        public TokBuf subBuf(int start, int end) {
            return new TokBuf(this._tokens.subList(start, end), this, start);
        }

        public void setPendingExpr(Expr expr) {
            if (this._pendingExpr != null) {
                throw new ParseException("Found multiple expressions with no operator " + this);
            }
            this._pendingExpr = expr.resolveOrderOfOperations();
        }

        public void restorePendingExpr(Expr expr) {
            this._pendingExpr = expr;
        }

        public Expr takePendingExpr() {
            Expr expr = this._pendingExpr;
            this._pendingExpr = null;
            return expr;
        }

        public boolean hasPendingExpr() {
            return this._pendingExpr != null;
        }

        private Map.Entry<Integer, List<ExpressionTokenizer.Token>> getTopPos() {
            int pos = this._pos;
            List<ExpressionTokenizer.Token> toks = this._tokens;
            TokBuf cur = this;
            while (cur._parent != null) {
                pos += cur._parentOff;
                cur = cur._parent;
                toks = cur._tokens;
            }
            return ExpressionTokenizer.newEntry(pos, toks);
        }

        public Function getFunction(String funcName) {
            return this._ctx.getFunctionLookup().getFunction(funcName);
        }

        public String toString() {
            Map.Entry<Integer, List<ExpressionTokenizer.Token>> e = this.getTopPos();
            StringBuilder sb = new StringBuilder("[token ").append(e.getKey()).append("] (");
            Iterator<ExpressionTokenizer.Token> iter = e.getValue().iterator();
            while (iter.hasNext()) {
                ExpressionTokenizer.Token t = iter.next();
                sb.append('\'').append(t.getValueStr()).append('\'');
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            sb.append(')');
            if (this._pendingExpr != null) {
                sb.append(" [pending '").append(this._pendingExpr.toDebugString(this._ctx)).append("']");
            }
            return sb.toString();
        }
    }

    private static enum SpecOp implements OpType
    {
        NOT("Not"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        IS_NULL("Is Null"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.isNull(param1);
            }
        }
        ,
        IS_NOT_NULL("Is Not Null"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.isNotNull(param1);
            }
        }
        ,
        LIKE("Like"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.like(ctx, param1, (Pattern)param2);
            }
        }
        ,
        NOT_LIKE("Not Like"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.notLike(ctx, param1, (Pattern)param2);
            }
        }
        ,
        BETWEEN("Between"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.between(ctx, param1, (Value)param2, (Value)param3);
            }
        }
        ,
        NOT_BETWEEN("Not Between"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.notBetween(ctx, param1, (Value)param2, (Value)param3);
            }
        }
        ,
        IN("In"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.in(ctx, param1, (Value[])param2);
            }
        }
        ,
        NOT_IN("Not In"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Object param2, Object param3) {
                return BuiltinOperators.notIn(ctx, param1, (Value[])param2);
            }
        };

        private final String _str;

        private SpecOp(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }

        public abstract Value eval(EvalContext var1, Value var2, Object var3, Object var4);
    }

    private static enum LogOp implements OpType
    {
        AND("And"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.and(ctx, param1, param2);
            }
        }
        ,
        OR("Or"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.or(ctx, param1, param2);
            }
        }
        ,
        EQV("Eqv"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.eqv(ctx, param1, param2);
            }
        }
        ,
        XOR("Xor"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.xor(ctx, param1, param2);
            }
        }
        ,
        IMP("Imp"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.imp(ctx, param1, param2);
            }
        };

        private final String _str;

        private LogOp(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }

        public abstract Value eval(EvalContext var1, Value var2, Value var3);
    }

    private static enum CompOp implements OpType
    {
        LT("<"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.lessThan(ctx, param1, param2);
            }
        }
        ,
        LTE("<="){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.lessThanEq(ctx, param1, param2);
            }
        }
        ,
        GT(">"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.greaterThan(ctx, param1, param2);
            }
        }
        ,
        GTE(">="){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.greaterThanEq(ctx, param1, param2);
            }
        }
        ,
        EQ("="){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.equals(ctx, param1, param2);
            }
        }
        ,
        NE("<>"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.notEquals(ctx, param1, param2);
            }
        };

        private final String _str;

        private CompOp(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }

        public abstract Value eval(EvalContext var1, Value var2, Value var3);
    }

    private static enum BinaryOp implements OpType
    {
        PLUS("+"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.add(ctx, param1, param2);
            }
        }
        ,
        MINUS("-"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.subtract(ctx, param1, param2);
            }
        }
        ,
        MULT("*"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.multiply(ctx, param1, param2);
            }
        }
        ,
        DIV("/"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.divide(ctx, param1, param2);
            }
        }
        ,
        INT_DIV("\\"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.intDivide(ctx, param1, param2);
            }
        }
        ,
        EXP("^"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.exp(ctx, param1, param2);
            }
        }
        ,
        CONCAT("&"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.concat(ctx, param1, param2);
            }
        }
        ,
        MOD("Mod"){

            @Override
            public Value eval(EvalContext ctx, Value param1, Value param2) {
                return BuiltinOperators.mod(ctx, param1, param2);
            }
        };

        private final String _str;

        private BinaryOp(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }

        public abstract Value eval(EvalContext var1, Value var2, Value var3);
    }

    private static enum UnaryOp implements OpType
    {
        NEG("-", false){

            @Override
            public Value eval(EvalContext ctx, Value param1) {
                return BuiltinOperators.negate(ctx, param1);
            }

            @Override
            public UnaryOp getUnaryNumOp() {
                return NEG_NUM;
            }
        }
        ,
        POS("+", false){

            @Override
            public Value eval(EvalContext ctx, Value param1) {
                return param1;
            }

            @Override
            public UnaryOp getUnaryNumOp() {
                return POS_NUM;
            }
        }
        ,
        NOT("Not", true){

            @Override
            public Value eval(EvalContext ctx, Value param1) {
                return BuiltinOperators.not(ctx, param1);
            }
        }
        ,
        NEG_NUM("-", false){

            @Override
            public Value eval(EvalContext ctx, Value param1) {
                return BuiltinOperators.negate(ctx, param1);
            }
        }
        ,
        POS_NUM("+", false){

            @Override
            public Value eval(EvalContext ctx, Value param1) {
                return param1;
            }
        };

        private final String _str;
        private final boolean _needSpace;

        private UnaryOp(String str, boolean needSpace) {
            this._str = str;
            this._needSpace = needSpace;
        }

        public boolean needsSpace() {
            return this._needSpace;
        }

        public String toString() {
            return this._str;
        }

        public UnaryOp getUnaryNumOp() {
            return null;
        }

        public abstract Value eval(EvalContext var1, Value var2);
    }

    private static interface OpType {
    }

    private static enum WordType {
        OP,
        COMP,
        LOG_OP,
        CONST,
        SPEC_OP_PREFIX,
        DELIM;

    }

    public static interface ParseContext
    extends LocaleContext {
        public FunctionLookup getFunctionLookup();
    }

    public static enum Type {
        DEFAULT_VALUE,
        EXPRESSION,
        FIELD_VALIDATOR,
        RECORD_VALIDATOR;

    }
}

