/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.util.Try;
import shaded.io.github.spannm.jackcess.CursorBuilder;
import shaded.io.github.spannm.jackcess.Database;
import shaded.io.github.spannm.jackcess.Index;
import shaded.io.github.spannm.jackcess.IndexCursor;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.util.OleBlob;

public class BlobKey
implements Serializable {
    private static final long serialVersionUID = -8580858159403159903L;
    public static final int MAX_SIZE = 4096;
    private Map<String, Object> key;
    private final String tableName;
    private final String columnName;

    public BlobKey(Map<String, Object> _key, String _tableName, String _columnName) {
        this.key = _key;
        this.tableName = _tableName;
        this.columnName = _columnName;
    }

    public BlobKey(Table _table, String _columnName, Row _row) {
        this.tableName = _table.getName();
        this.columnName = _columnName;
        if (BlobKey.hasPrimaryKey(_table)) {
            List<? extends Index.Column> cl = _table.getPrimaryKeyIndex().getColumns();
            HashMap<String, Object> keyMap = new HashMap<String, Object>();
            for (Index.Column column : cl) {
                keyMap.put(column.getName(), _row.get(column.getName()));
            }
            this.key = keyMap;
        }
    }

    public static boolean hasPrimaryKey(Table _table) {
        for (Index index : _table.getIndexes()) {
            if (!index.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public OleBlob getOleBlob(Database _db) throws UcanaccessSQLException {
        return Try.catching(() -> {
            Table t = _db.getTable(this.tableName);
            IndexCursor c = CursorBuilder.createPrimaryKeyCursor(t);
            return c.findFirstRow(this.key) ? c.getCurrentRow().getBlob(this.columnName) : null;
        }).orThrow(UcanaccessSQLException::new);
    }

    public byte[] getBytes() throws UcanaccessSQLException {
        return Try.withResources(ByteArrayOutputStream::new, bais -> {
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)bais);
            oos.writeObject(this);
            oos.flush();
            return bais.toByteArray();
        }).orThrow(UcanaccessSQLException::new);
    }

    public static BlobKey getBlobKey(byte[] _bytes) {
        return Try.withResources(() -> new ByteArrayInputStream(_bytes), bais -> {
            ObjectInputStream ois = new ObjectInputStream((InputStream)bais);
            Object obj = ois.readObject();
            return obj instanceof BlobKey ? (BlobKey)obj : null;
        }).orIgnore();
    }

    public static BlobKey getBlobKey(InputStream _is) {
        return Try.catching(() -> {
            byte[] bt = new byte[4096];
            int readBytes = _is.read(bt);
            return readBytes > 0 ? BlobKey.getBlobKey(bt) : null;
        }).orIgnore();
    }

    public Map<String, Object> getKey() {
        return this.key;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

