/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.UcanaccessConnection;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.DataType;
import shaded.io.github.spannm.jackcess.Index;
import shaded.io.github.spannm.jackcess.Table;

public class BlobAction
implements IFeedbackAction {
    private final Table table;
    private boolean containsBlob;
    private final Set<BlobKey> keys = new HashSet<BlobKey>();

    /*
     * WARNING - void declaration
     */
    public BlobAction(Table _table, Object[] newValues) {
        this.table = _table;
        if (!BlobKey.hasPrimaryKey(_table)) {
            return;
        }
        Index pk = _table.getPrimaryKeyIndex();
        HashSet<String> hsKey = new HashSet<String>();
        for (Index.Column column : pk.getColumns()) {
            hsKey.add(column.getName());
        }
        HashSet<String> hsBlob = new HashSet<String>();
        boolean bl = false;
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        for (Column column : _table.getColumns()) {
            void var6_8;
            if (column.getType().equals((Object)DataType.OLE) && newValues[var6_8] != null) {
                this.containsBlob = true;
                hsBlob.add(column.getName());
            }
            if (hsKey.contains(column.getName())) {
                keyMap.put(column.getName(), newValues[var6_8]);
            }
            ++var6_8;
        }
        for (String string : hsBlob) {
            this.keys.add(new BlobKey(keyMap, this.table.getName(), string));
        }
    }

    @Override
    public void doAction(ICommand toChange) throws SQLException {
        if (this.containsBlob) {
            UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
            Connection connHsqldb = conn.getHSQLDBConnection();
            for (BlobKey bkey : this.keys) {
                ArrayList<Object> values = new ArrayList<Object>(bkey.getKey().values());
                String sql = String.format("UPDATE %s SET %s=? WHERE %s", SQLConverter.escapeIdentifier(this.table.getName(), connHsqldb), SQLConverter.escapeIdentifier(bkey.getColumnName(), connHsqldb), bkey.getKey().keySet().stream().map(k -> SQLConverter.escapeIdentifier(k, connHsqldb) + " = ?").collect(Collectors.joining(" AND ")));
                conn.setFeedbackState(true);
                conn.setFeedbackState(true);
                try (PreparedStatement ps = connHsqldb.prepareStatement(sql);){
                    ps.setObject(1, bkey.getBytes());
                    int i = 2;
                    for (Object e : values) {
                        ps.setObject(i, e);
                        ++i;
                    }
                    ps.executeUpdate();
                    conn.setFeedbackState(false);
                }
            }
        }
    }
}

