/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.rights;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.Routine;
import shaded.org.hsqldb.RoutineSchema;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.SqlInvariants;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.IntValueHashMap;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.List;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.lib.StringConverter;
import shaded.org.hsqldb.lib.java.JavaSystem;
import shaded.org.hsqldb.rights.Grantee;
import shaded.org.hsqldb.rights.Right;
import shaded.org.hsqldb.rights.User;

public class GranteeManager {
    static User systemAuthorisation;
    private OrderedHashMap<String, Grantee> map = new OrderedHashMap();
    private OrderedHashMap<String, Grantee> roleMap = new OrderedHashMap();
    Database database;
    private MessageDigest digester;
    private String digestAlgo;
    Grantee publicRole;
    Grantee dbaRole;
    Grantee schemaRole;
    Grantee changeAuthRole;
    Grantee scriptOpsRole;
    static final IntValueHashMap<String> rightsStringLookup;

    public GranteeManager(Database database) {
        this.database = database;
        this.addRole(this.database.nameManager.newHsqlName("PUBLIC", false, 11));
        this.publicRole = this.getRole("PUBLIC");
        this.publicRole.isPublic = true;
        this.addRole(this.database.nameManager.newHsqlName("DBA", false, 11));
        this.dbaRole = this.getRole("DBA");
        this.dbaRole.setAdminDirect();
        this.addRole(this.database.nameManager.newHsqlName("CREATE_SCHEMA", false, 11));
        this.schemaRole = this.getRole("CREATE_SCHEMA");
        this.addRole(this.database.nameManager.newHsqlName("CHANGE_AUTHORIZATION", false, 11));
        this.changeAuthRole = this.getRole("CHANGE_AUTHORIZATION");
        this.addRole(this.database.nameManager.newHsqlName("SCRIPT_OPS", false, 11));
        this.scriptOpsRole = this.getRole("SCRIPT_OPS");
    }

    public Grantee getDBARole() {
        return this.dbaRole;
    }

    public static Grantee getSystemRole() {
        return systemAuthorisation;
    }

    public void grant(Session session, OrderedHashSet<String> orderedHashSet, SchemaObject schemaObject, Right right, Grantee grantee, boolean bl) {
        if (schemaObject instanceof RoutineSchema) {
            SchemaObject[] schemaObjectArray = ((RoutineSchema)schemaObject).getSpecificRoutines();
            this.grant(session, orderedHashSet, schemaObjectArray, right, grantee, bl);
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!grantee.isAccessible(schemaObject)) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
        if (!grantee.isGrantable(schemaObject, right)) {
            session.addWarning(Error.error(1007, grantee.getName().getNameString()));
            return;
        }
        if (grantee.isAdmin()) {
            grantee = schemaObject.getOwner();
        }
        this.checkGranteeList(orderedHashSet);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Grantee grantee2 = this.get(orderedHashSet.get(i));
            if (!grantee2.isRole && right.hasFilter()) {
                throw Error.error(2200, grantee2.getName().name);
            }
            grantee2.grant(hsqlName, right, grantee, bl);
            if (!grantee2.isRole) continue;
            this.updateAllRights(grantee2);
        }
    }

    public void grant(Session session, OrderedHashSet<String> orderedHashSet, SchemaObject[] schemaObjectArray, Right right, Grantee grantee, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            if (!grantee.isGrantable(schemaObjectArray[i], right)) continue;
            this.grant(session, orderedHashSet, schemaObjectArray[i], right, grantee, bl);
            bl2 = true;
        }
        if (!bl2) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
    }

    public void checkGranteeList(OrderedHashSet<String> orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string = orderedHashSet.get(i);
            Grantee grantee = this.get(string);
            if (grantee == null) {
                throw Error.error(4001, string);
            }
            if (GranteeManager.isImmutable(string)) {
                throw Error.error(4002, string);
            }
            if (!(grantee instanceof User) || !((User)grantee).isExternalOnly) continue;
            throw Error.error(4000, string);
        }
    }

    public void grant(String string, String string2, Grantee grantee) {
        Grantee grantee2 = this.get(string);
        if (grantee2 == null) {
            throw Error.error(4001, string);
        }
        if (GranteeManager.isImmutable(string)) {
            throw Error.error(4002, string);
        }
        Grantee grantee3 = this.getRole(string2);
        if (grantee3 == null) {
            throw Error.error(2200, string2);
        }
        if (grantee3 == grantee2) {
            throw Error.error(2251, string);
        }
        if (grantee3.hasRole(grantee2)) {
            throw Error.error(2251, string2);
        }
        if (!grantee.isGrantable(grantee3)) {
            throw Error.error(2000, grantee.getName().getNameString());
        }
        grantee2.grant(grantee3);
        grantee2.updateAllRights();
        if (grantee2.isRole) {
            this.updateAllRights(grantee2);
        }
    }

    public void checkRoleList(String string, OrderedHashSet<String> orderedHashSet, Grantee grantee, boolean bl) {
        Grantee grantee2 = this.get(string);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string2 = orderedHashSet.get(i);
            Grantee grantee3 = this.getRole(string2);
            if (grantee3 == null) {
                throw Error.error(2200, string2);
            }
            if (string2.equals("_SYSTEM") || string2.equals("PUBLIC")) {
                throw Error.error(4002, string2);
            }
            if (bl ? grantee2.getDirectRoles().contains(grantee3) : !grantee2.getDirectRoles().contains(grantee3)) {
                // empty if block
            }
            if (grantee.isAdmin()) continue;
            throw Error.error(2000, grantee.getName().getNameString());
        }
    }

    public void grantSystemToPublic(SchemaObject schemaObject, Right right) {
        this.publicRole.grant(schemaObject.getName(), right, systemAuthorisation, true);
    }

    public void revoke(String string, String string2, Grantee grantee) {
        if (!grantee.isAdmin()) {
            throw Error.error(5507);
        }
        Grantee grantee2 = this.get(string);
        if (grantee2 == null) {
            throw Error.error(4000, string);
        }
        Grantee grantee3 = (Grantee)this.roleMap.get((Object)string2);
        grantee2.revoke(grantee3);
        grantee2.updateAllRights();
        if (grantee2.isRole) {
            this.updateAllRights(grantee2);
        }
    }

    public void revoke(OrderedHashSet<String> orderedHashSet, SchemaObject schemaObject, Right right, Grantee grantee, boolean bl, boolean bl2) {
        if (schemaObject instanceof RoutineSchema) {
            SchemaObject[] schemaObjectArray = ((RoutineSchema)schemaObject).getSpecificRoutines();
            this.revoke(orderedHashSet, schemaObjectArray, right, grantee, bl, bl2);
            return;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (!grantee.isFullyAccessibleByRole(hsqlName)) {
            throw Error.error(5501, schemaObject.getName().name);
        }
        if (grantee.isAdmin()) {
            grantee = schemaObject.getOwner();
        }
        this.checkGranteeList(orderedHashSet);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            String string = orderedHashSet.get(i);
            Grantee grantee2 = this.get(string);
            grantee2.revoke(schemaObject, right, grantee, bl);
            grantee2.updateAllRights();
            if (!grantee2.isRole) continue;
            this.updateAllRights(grantee2);
        }
    }

    public void revoke(OrderedHashSet<String> orderedHashSet, SchemaObject[] schemaObjectArray, Right right, Grantee grantee, boolean bl, boolean bl2) {
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            this.revoke(orderedHashSet, schemaObjectArray[i], right, grantee, bl, bl2);
        }
    }

    void removeEmptyRole(Grantee grantee) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee grantee2 = this.map.get(i);
            grantee2.roles.remove(grantee);
        }
    }

    public void removeDbObject(HsqlNameManager.HsqlName hsqlName) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee grantee = this.map.get(i);
            grantee.revokeDbObject(hsqlName);
        }
    }

    public void removeDbObjects(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        Iterator iterator = orderedHashSet.iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            for (int i = 0; i < this.map.size(); ++i) {
                Grantee grantee = this.map.get(i);
                grantee.revokeDbObject(hsqlName);
            }
        }
    }

    void updateAllRights(Grantee grantee) {
        Grantee grantee2;
        int n;
        for (n = 0; n < this.map.size(); ++n) {
            grantee2 = this.map.get(n);
            if (!grantee2.isRole) continue;
            grantee2.updateNestedRoles(grantee);
        }
        for (n = 0; n < this.map.size(); ++n) {
            grantee2 = this.map.get(n);
            if (grantee2.isRole) continue;
            grantee2.updateAllRights();
        }
    }

    public boolean removeGrantee(String string) {
        if (GranteeManager.isReserved(string)) {
            return false;
        }
        Grantee grantee = this.map.remove(string);
        if (grantee == null) {
            return false;
        }
        grantee.clearPrivileges();
        this.updateAllRights(grantee);
        if (grantee.isRole) {
            this.roleMap.remove(string);
            this.removeEmptyRole(grantee);
        }
        return true;
    }

    public Grantee addRole(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            throw Error.error(4003, hsqlName.name);
        }
        if ("_SYSTEM".equals(hsqlName.name)) {
            throw Error.error(4002, hsqlName.name);
        }
        if (SqlInvariants.isLobsSchemaName(hsqlName.name) || SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(4002, hsqlName.name);
        }
        Grantee grantee = new Grantee(hsqlName, this);
        grantee.isRole = true;
        this.map.put(hsqlName.name, grantee);
        this.roleMap.add(hsqlName.name, grantee);
        return grantee;
    }

    public User addUser(HsqlNameManager.HsqlName hsqlName) {
        if (this.map.containsKey(hsqlName.name)) {
            throw Error.error(4003, hsqlName.name);
        }
        if ("_SYSTEM".equals(hsqlName.name)) {
            throw Error.error(4002, hsqlName.name);
        }
        if (SqlInvariants.isLobsSchemaName(hsqlName.name) || SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(4002, hsqlName.name);
        }
        User user = new User(hsqlName, this);
        this.map.put(hsqlName.name, user);
        return user;
    }

    public void removeNewUser(HsqlNameManager.HsqlName hsqlName) {
        this.map.remove(hsqlName.name);
    }

    boolean isGrantee(String string) {
        return this.map.containsKey(string);
    }

    public static int getCheckSingleRight(String string) {
        int n = GranteeManager.getRight(string);
        if (n != 0) {
            return n;
        }
        throw Error.error(5581, string);
    }

    public static int getRight(String string) {
        return rightsStringLookup.get((Object)string, 0);
    }

    public Grantee get(String string) {
        return (Grantee)this.map.get((Object)string);
    }

    public Collection<Grantee> getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String string) {
        return GranteeManager.getRight(string) != 0;
    }

    public static boolean isImmutable(String string) {
        return string.equals("_SYSTEM") || string.equals("DBA") || string.equals("CREATE_SCHEMA") || string.equals("CHANGE_AUTHORIZATION") || string.equals("SCRIPT_OPS");
    }

    public static boolean isReserved(String string) {
        return string.equals("_SYSTEM") || string.equals("DBA") || string.equals("CREATE_SCHEMA") || string.equals("CHANGE_AUTHORIZATION") || string.equals("SCRIPT_OPS") || string.equals("PUBLIC");
    }

    public void dropRole(String string) {
        if (!this.isRole(string)) {
            throw Error.error(2200, string);
        }
        if (GranteeManager.isReserved(string)) {
            throw Error.error(5507);
        }
        this.removeGrantee(string);
    }

    public Set<String> getRoleNames() {
        return this.roleMap.keySet();
    }

    public Collection<Grantee> getRoles() {
        return this.roleMap.values();
    }

    public Grantee getRole(String string) {
        Grantee grantee = (Grantee)this.roleMap.get((Object)string);
        if (grantee == null) {
            throw Error.error(2200, string);
        }
        return grantee;
    }

    public boolean isRole(String string) {
        return this.roleMap.containsKey(string);
    }

    public List<String> getSQLArray() {
        Grantee grantee;
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        Iterator<Grantee> iterator = this.getRoles().iterator();
        while (iterator.hasNext()) {
            grantee = iterator.next();
            if (GranteeManager.isReserved(grantee.getName().getNameString())) continue;
            hsqlArrayList.add(grantee.getSQL());
        }
        iterator = this.getGrantees().iterator();
        while (iterator.hasNext()) {
            grantee = iterator.next();
            if (!(grantee instanceof User) || ((User)grantee).isExternalOnly) continue;
            hsqlArrayList.add(grantee.getSQL());
            if (!((User)grantee).isLocalOnly) continue;
            hsqlArrayList.add(((User)grantee).getLocalUserSQL());
        }
        return hsqlArrayList;
    }

    public List<String> getRightsSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        Iterator<Grantee> iterator = this.getGrantees().iterator();
        while (iterator.hasNext()) {
            Grantee grantee = iterator.next();
            String string = grantee.getName().getNameString();
            if (GranteeManager.isImmutable(string) || grantee instanceof User && ((User)grantee).isExternalOnly) continue;
            HsqlArrayList<String> hsqlArrayList2 = grantee.getRightsSQL();
            hsqlArrayList.addAll(hsqlArrayList2);
        }
        return hsqlArrayList;
    }

    public void setDigestAlgo(String string) {
        this.digestAlgo = string;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    synchronized MessageDigest getDigester() {
        if (this.digester == null) {
            try {
                this.digester = MessageDigest.getInstance(this.digestAlgo);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw Error.error(458, noSuchAlgorithmException);
            }
        }
        return this.digester;
    }

    String digest(String string) throws RuntimeException {
        byte[] byArray = string.getBytes(JavaSystem.CS_ISO_8859_1);
        byArray = this.getDigester().digest(byArray);
        return StringConverter.byteArrayToHexString(byArray);
    }

    static {
        HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newSystemObjectName("_SYSTEM", 11);
        systemAuthorisation = new User(hsqlName, null);
        GranteeManager.systemAuthorisation.isSystem = true;
        systemAuthorisation.setAdminDirect();
        systemAuthorisation.setInitialSchema(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SESSION_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SYSTEM_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.LOBS_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SQLJ_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        rightsStringLookup = new IntValueHashMap(11);
        rightsStringLookup.put("ALL", 63);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
        rightsStringLookup.put("EXECUTE", 32);
        rightsStringLookup.put("USAGE", 16);
        rightsStringLookup.put("REFERENCES", 64);
        rightsStringLookup.put("TRIGGER", 128);
    }
}

