/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class LongDeque {
    private long[] list;
    private int firstindex = 0;
    private int endindex = 0;
    private int elementCount;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;

    public LongDeque() {
        this(8);
    }

    public LongDeque(int n) {
        this.list = new long[n];
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public long getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public long getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public long get(int n) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        return this.list[n2];
    }

    public long removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        long l = this.list[this.firstindex];
        this.list[this.firstindex] = 0L;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return l;
    }

    public long removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        long l = this.list[this.endindex];
        this.list[this.endindex] = 0L;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return l;
    }

    public boolean add(long l) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = l;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(long l) {
        return this.add(l);
    }

    public boolean addFirst(long l) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = l;
        ++this.elementCount;
        return true;
    }

    public int addAll(LongDeque longDeque) {
        int n = 0;
        for (int i = 0; i < longDeque.size(); ++i) {
            this.add(longDeque.get(i));
            ++n;
        }
        return n;
    }

    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        Arrays.fill(this.list, 0L);
    }

    public void zeroSize() {
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
    }

    public int indexOf(long l) {
        for (int i = 0; i < this.elementCount; ++i) {
            int n = this.firstindex + i;
            if (n >= this.list.length) {
                n -= this.list.length;
            }
            if (this.list[n] != l) continue;
            return i;
        }
        return -1;
    }

    public long remove(int n) {
        int n2 = this.getInternalIndex(n);
        long l = this.list[n2];
        if (n2 == this.firstindex) {
            this.list[this.firstindex] = 0L;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (n2 > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, n2 - this.firstindex);
            this.list[this.firstindex] = 0L;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, n2 + 1, this.list, n2, this.endindex - n2 - 1);
            --this.endindex;
            this.list[this.endindex] = 0L;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return l;
    }

    public boolean contains(long l) {
        for (int i = 0; i < this.elementCount; ++i) {
            int n = this.firstindex + i;
            if (n >= this.list.length) {
                n -= this.list.length;
            }
            if (this.list[n] != l) continue;
            return true;
        }
        return false;
    }

    public void toArray(int[] nArray) {
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = (int)this.get(i);
        }
    }

    public void toArray(long[] lArray) {
        for (int i = 0; i < this.elementCount; ++i) {
            lArray[i] = this.get(i);
        }
    }

    public long[] toArray() {
        long[] lArray = new long[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            lArray[i] = this.get(i);
        }
        return lArray;
    }

    private int getInternalIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.firstindex + n;
        if (n2 >= this.list.length) {
            n2 -= this.list.length;
        }
        return n2;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        long[] lArray = new long[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, lArray, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, lArray, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = lArray;
    }
}

