/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.Objects;
import shaded.org.hsqldb.lib.AbstractReadOnlyCollection;
import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.Map;
import shaded.org.hsqldb.lib.MapEntry;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.map.BaseHashMap;

public class IntKeyHashMap<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;

    public IntKeyHashMap() {
        this(8);
    }

    public IntKeyHashMap(int n) throws IllegalArgumentException {
        super(n, 1, 3, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.containsIntKey(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsKey(int n) {
        return super.containsIntKey(n);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Integer n) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        return this.get(n2);
    }

    @Override
    public V get(int n) {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            return (V)this.objectValueTable[n2];
        }
        return null;
    }

    @Override
    public V put(Integer n, V v) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        return this.put(n2, v);
    }

    @Override
    public V put(int n, V v) {
        return (V)super.addOrUpdate(n, 0L, null, v);
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.remove(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(int n) {
        return (V)super.remove(n, 0L, null, null, false, false);
    }

    public void putAll(IntKeyHashMap<V> intKeyHashMap) {
        Iterator iterator = intKeyHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.nextInt();
            this.put(n, intKeyHashMap.get(n));
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    public int[] getKeyArray() {
        return this.intKeyTable;
    }

    public Object[] getValueArray() {
        return this.objectValueTable;
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            Objects.requireNonNull(intKeyHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            Objects.requireNonNull(intKeyHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer n = super.nextInt();
            Object object = IntKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(n, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

