/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.ObjectComparator;
import shaded.org.hsqldb.lib.Set;
import shaded.org.hsqldb.map.BaseHashMap;

public class HashSet<E>
extends BaseHashMap
implements Set<E> {
    public HashSet() {
        this(8);
    }

    public HashSet(int n) throws IllegalArgumentException {
        super(n, 3, 0, false);
    }

    public HashSet(int n, ObjectComparator<E> objectComparator) throws IllegalArgumentException {
        this(n);
        this.comparator = objectComparator;
    }

    public HashSet(E[] EArray) {
        this(EArray.length);
        for (int i = 0; i < EArray.length; ++i) {
            this.add(EArray[i]);
        }
    }

    @Override
    public boolean contains(Object object) {
        return super.containsObjectKey(object);
    }

    public boolean containsAll(Collection<E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public E getOrAdd(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        E e2 = this.get(e);
        if (e2 == null) {
            e2 = e;
            this.add(e);
        }
        return e2;
    }

    public E get(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int n = this.getLookup(e);
        if (n < 0) {
            return null;
        }
        return (E)this.objectKeyTable[n];
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.addOrUpdate(0L, 0L, e, null);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public boolean addAll(E[] EArray) {
        boolean bl = false;
        for (int i = 0; i < EArray.length; ++i) {
            bl |= this.add(EArray[i]);
        }
        return bl;
    }

    public boolean addAll(E[] EArray, int n, int n2) {
        boolean bl = false;
        for (int i = n; i < EArray.length && i < n2; ++i) {
            bl |= this.add(EArray[i]);
        }
        return bl;
    }

    @Override
    public boolean remove(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return super.removeObject(e, false) != null;
    }

    public boolean removeAll(Collection<E> collection) {
        Iterator<E> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            bl &= this.remove(iterator.next());
        }
        return bl;
    }

    public boolean removeAll(E[] EArray) {
        boolean bl = true;
        for (int i = 0; i < EArray.length; ++i) {
            bl &= this.remove(EArray[i]);
        }
        return bl;
    }

    @Override
    public int capacity() {
        return super.capacity();
    }

    public int getCommonElementCount(Set<E> set) {
        int n = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!set.contains(iterator.next())) continue;
            ++n;
        }
        return n;
    }

    public <T> T[] toArray(T[] TArray) {
        return this.toArray(TArray, true);
    }

    public Object[] toArray() {
        return this.toArray(true);
    }

    @Override
    public Iterator<E> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator<E> iterator = this.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

