/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import shaded.org.hsqldb.lib.FileAccess;
import shaded.org.hsqldb.lib.java.JavaSystem;

public class FileArchiver {
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_ZIP = 1;
    public static final int COMPRESSION_GZIP = 2;
    private static final int COPY_BLOCK_SIZE = 65536;

    public static void copyFile(String string, String string2, FileAccess fileAccess) throws IOException {
        FileArchiver.archive(string, string2, fileAccess, 0);
    }

    public static void archive(String string, String string2, FileAccess fileAccess, int n) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        DeflaterOutputStream deflaterOutputStream = null;
        boolean bl = false;
        if (!fileAccess.isStreamElement(string)) {
            return;
        }
        try {
            int n2;
            byte[] byArray = new byte[65536];
            inputStream = fileAccess.openInputStreamElement(string);
            outputStream2 = outputStream = fileAccess.openOutputStreamElementAppend(string2);
            switch (n) {
                case 1: {
                    deflaterOutputStream = new DeflaterOutputStream(outputStream, new Deflater(1), byArray.length);
                    outputStream = deflaterOutputStream;
                    break;
                }
                case 2: {
                    deflaterOutputStream = new GZIPOutputStream(outputStream, byArray.length);
                    outputStream = deflaterOutputStream;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("FileArchiver" + n);
                }
            }
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            throw JavaSystem.toIOException(throwable);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    if (deflaterOutputStream != null) {
                        deflaterOutputStream.finish();
                    }
                    if (outputStream2 instanceof FileOutputStream) {
                        fileAccess.getFileSync(outputStream2).sync();
                    }
                    outputStream.close();
                }
                if (!bl && fileAccess.isStreamElement(string2)) {
                    fileAccess.removeElement(string2);
                }
            }
            catch (Throwable throwable) {
                throw JavaSystem.toIOException(throwable);
            }
        }
    }

    public static void unarchive(String string, String string2, FileAccess fileAccess, int n) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            int n2;
            if (!fileAccess.isStreamElement(string)) {
                return;
            }
            fileAccess.removeElement(string2);
            byte[] byArray = new byte[65536];
            inputStream = fileAccess.openInputStreamElement(string);
            switch (n) {
                case 1: {
                    inputStream = new InflaterInputStream(inputStream, new Inflater());
                    break;
                }
                case 2: {
                    inputStream = new GZIPInputStream(inputStream, byArray.length);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("FileArchiver: " + n);
                }
            }
            outputStream = fileAccess.openOutputStreamElement(string2);
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            throw JavaSystem.toIOException(throwable);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    if (outputStream instanceof FileOutputStream) {
                        fileAccess.getFileSync(outputStream).sync();
                    }
                    outputStream.close();
                }
                if (!bl && fileAccess.isStreamElement(string2)) {
                    fileAccess.removeElement(string2);
                }
            }
            catch (Throwable throwable) {
                throw JavaSystem.toIOException(throwable);
            }
        }
    }
}

