/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import shaded.org.hsqldb.jdbc.JDBCConnection;
import shaded.org.hsqldb.jdbc.JDBCUtil;
import shaded.org.hsqldb.result.ResultMetaData;
import shaded.org.hsqldb.types.IntervalType;
import shaded.org.hsqldb.types.Type;

public class JDBCParameterMetaData
implements ParameterMetaData,
Wrapper {
    ResultMetaData rmd;
    int parameterCount;
    private boolean translateTTIType;

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkRange(n);
        return 2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.isNumberType();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        if (type.isDateTimeType()) {
            return type.displaySize();
        }
        long l = type.precision;
        if (l > Integer.MAX_VALUE) {
            l = 0L;
        }
        return (int)l;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.scale;
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getJDBCTypeCode();
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getNameString();
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getJDBCClassName();
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.checkRange(n);
        return this.rmd.paramModes[--n];
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCParameterMetaData(JDBCConnection jDBCConnection, ResultMetaData resultMetaData) {
        this.rmd = resultMetaData;
        this.parameterCount = this.rmd.getColumnCount();
        this.translateTTIType = jDBCConnection.isTranslateTTIType;
    }

    private Type translateType(Type type) {
        if (this.translateTTIType && type.isIntervalType()) {
            type = ((IntervalType)type).getCharacterType();
        }
        return type;
    }

    void checkRange(int n) throws SQLException {
        if (n < 1 || n > this.parameterCount) {
            String string = n + " is out of range";
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        int n = this.getParameterCount();
        if (n == 0) {
            stringBuilder.append("[parameterCount=0]");
            return stringBuilder.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuilder.append('[');
        int n2 = methodArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\n').append("    parameter_").append(i + 1).append('=').append('[');
            for (int j = 0; j < n2; ++j) {
                Method method = methodArray[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuilder.append(method.getName()).append('=').append(method.invoke((Object)this, i + 1));
                if (j + 1 >= n2) continue;
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(']');
            if (i + 1 >= n) continue;
            stringBuilder.append(',').append(' ');
        }
        stringBuilder.append('\n').append(']');
        return stringBuilder.toString();
    }
}

