/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.ParserDQL;
import shaded.org.hsqldb.Scanner;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableDerived;
import shaded.org.hsqldb.TableUtil;
import shaded.org.hsqldb.TriggerDef;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.OrderedHashSet;

public class View
extends TableDerived {
    private String statement;
    private HsqlNameManager.HsqlName[] columnNames;
    private OrderedHashSet<HsqlNameManager.HsqlName> schemaObjectNames;
    private int checkOption;
    private Table baseTable;
    boolean isTriggerInsertable;
    boolean isTriggerUpdatable;
    boolean isTriggerDeletable;

    View(Database database, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray, int n) {
        super(database, hsqlName, 8);
        this.columnNames = hsqlNameArray;
        this.checkOption = n;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        return this.schemaObjectNames;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        ParserDQL parserDQL = new ParserDQL(session, new Scanner(session, this.statement), null);
        parserDQL.isViewDefinition = true;
        parserDQL.read();
        TableDerived tableDerived = parserDQL.XreadViewSubqueryTable(this, true);
        this.queryExpression = tableDerived.queryExpression;
        if (this.getColumnCount() == 0) {
            if (this.columnNames == null) {
                this.columnNames = tableDerived.queryExpression.getResultColumnNames();
            }
            if (this.columnNames.length != tableDerived.queryExpression.getColumnCount()) {
                throw Error.error(5593, this.getName().statementName);
            }
            TableUtil.setColumnsInSchemaTable(this, this.columnNames, this.queryExpression.getColumnTypes());
        }
        this.schemaObjectNames = parserDQL.compileContext.getSchemaObjectNames();
        this.canRecompile = true;
        this.baseTable = this.queryExpression.getBaseTable();
        if (this.baseTable == null) {
            return;
        }
        switch (this.checkOption) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("CREATE").append(' ').append("VIEW").append(' ').append(this.getName().getSchemaQualifiedStatementName()).append(' ').append('(');
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getColumn((int)i).getName().statementName);
            if (i >= n - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')').append(' ').append("AS").append(' ').append(this.getStatement());
        return stringBuilder.toString();
    }

    @Override
    public int[] getUpdatableColumns() {
        return this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public boolean isTriggerInsertable() {
        return this.isTriggerInsertable;
    }

    @Override
    public boolean isTriggerUpdatable() {
        return this.isTriggerUpdatable;
    }

    @Override
    public boolean isTriggerDeletable() {
        return this.isTriggerDeletable;
    }

    @Override
    public boolean isInsertable() {
        return !this.isTriggerInsertable && super.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        return !this.isTriggerUpdatable && super.isUpdatable();
    }

    @Override
    void addTrigger(TriggerDef triggerDef, HsqlNameManager.HsqlName hsqlName) {
        switch (triggerDef.operationType) {
            case 55: {
                if (this.isTriggerInsertable) {
                    throw Error.error(5538);
                }
                this.isTriggerInsertable = true;
                break;
            }
            case 19: {
                if (this.isTriggerDeletable) {
                    throw Error.error(5538);
                }
                this.isTriggerDeletable = true;
                break;
            }
            case 92: {
                if (this.isTriggerUpdatable) {
                    throw Error.error(5538);
                }
                this.isTriggerUpdatable = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.addTrigger(triggerDef, hsqlName);
    }

    @Override
    void removeTrigger(TriggerDef triggerDef) {
        switch (triggerDef.operationType) {
            case 55: {
                this.isTriggerInsertable = false;
                break;
            }
            case 19: {
                this.isTriggerDeletable = false;
                break;
            }
            case 92: {
                this.isTriggerUpdatable = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.removeTrigger(triggerDef);
    }

    @Override
    public void setDataReadOnly(boolean bl) {
        throw Error.error(4000);
    }

    public int getCheckOption() {
        return this.checkOption;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String string) {
        this.statement = string;
    }

    @Override
    public TableDerived newDerivedTable(Session session, ParserDQL.CompileContext compileContext) {
        ParserDQL parserDQL = new ParserDQL(session, new Scanner(), compileContext);
        parserDQL.compileContext.setCurrentSubquery(this.tableName);
        parserDQL.reset(session, this.statement);
        parserDQL.read();
        TableDerived tableDerived = parserDQL.XreadViewSubqueryTable(this, false);
        return tableDerived;
    }
}

