/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.NumberSequence;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.TableBase;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.CharArrayWriter;
import shaded.org.hsqldb.lib.HashMap;
import shaded.org.hsqldb.lib.HsqlByteArrayOutputStream;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.LongKeyHashMap;
import shaded.org.hsqldb.lib.LongKeyLongValueHashMap;
import shaded.org.hsqldb.lib.ReaderInputStream;
import shaded.org.hsqldb.navigator.RowSetNavigator;
import shaded.org.hsqldb.navigator.RowSetNavigatorClient;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.persist.PersistentStoreCollectionSession;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.result.ResultLob;
import shaded.org.hsqldb.result.ResultProperties;
import shaded.org.hsqldb.types.BlobData;
import shaded.org.hsqldb.types.BlobDataID;
import shaded.org.hsqldb.types.ClobData;
import shaded.org.hsqldb.types.ClobDataID;
import shaded.org.hsqldb.types.LobData;

public class SessionData {
    private final Database database;
    private final Session session;
    public PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap<Result> resultMap;
    Object currentValue;
    HashMap<HsqlNameManager.HsqlName, Number> sequenceMap;
    HashMap<NumberSequence, Number> sequenceUpdateMap;
    LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();
    static final long noLobFloor = -1L;
    long newLobFloor = -1L;

    public SessionData(Database database, Session session) {
        this.database = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getSubqueryRowStore(TableBase tableBase) {
        PersistentStore persistentStore = this.persistentStoreCollection.getStore(tableBase);
        persistentStore.removeAll();
        return persistentStore;
    }

    public PersistentStore getNewResultRowStore(TableBase tableBase, boolean bl) {
        try {
            PersistentStore persistentStore = this.persistentStoreCollection.getStore(tableBase);
            if (!bl) {
                persistentStore.setMemory(true);
            }
            return persistentStore;
        }
        catch (HsqlException hsqlException) {
            throw Error.runtimeError(201, "SessionData");
        }
    }

    void setResultSetProperties(Result result, Result result2) {
        int n = result.rsProperties;
        int n2 = result2.getStatement().getResultProperties();
        if (n != n2) {
            if (ResultProperties.isUpdatable(n) && ResultProperties.isReadOnly(n2)) {
                this.session.addWarning(Error.error(4712));
            }
            if (ResultProperties.isSensitive(n)) {
                this.session.addWarning(Error.error(4711));
            }
            n2 = ResultProperties.addScrollable(n2, ResultProperties.isScrollable(n));
            result2.rsProperties = n2 = ResultProperties.addHoldable(n2, ResultProperties.isHoldable(n));
        }
    }

    Result getDataResultHead(Result result, Result result2, boolean bl) {
        int n = result.getFetchSize();
        result2.setResultId(this.session.actionSCN);
        int n2 = result.rsProperties;
        int n3 = result2.rsProperties;
        if (n2 != n3) {
            n3 = ResultProperties.isReadOnly(n2) ? ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2)) : (ResultProperties.isReadOnly(n3) ? ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2)) : (this.session.isAutoCommit() ? ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2)) : ResultProperties.addHoldable(n3, false)));
            result2.rsProperties = n3 = ResultProperties.addScrollable(n3, ResultProperties.isScrollable(n2));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (ResultProperties.isUpdatable(result2.rsProperties)) {
            bl2 = true;
        }
        if (bl) {
            if (n != 0 && result2.getNavigator().getSize() > n) {
                bl3 = true;
                bl2 = true;
            }
        } else if (!result2.getNavigator().isMemory()) {
            bl2 = true;
        }
        if (bl2) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result2.getResultId(), result2);
            result2.rsProperties = ResultProperties.addIsHeld(result2.rsProperties, true);
        }
        if (bl3) {
            result2 = Result.newDataHeadResult(this.session, result2, 0, n);
        }
        return result2;
    }

    Result getDataResultSlice(long l, int n, int n2) {
        Result result = this.resultMap.get(l);
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (n + n2 > rowSetNavigator.getSize()) {
            n2 = rowSetNavigator.getSize() - n;
        }
        return Result.newDataRowsResult(result, n, n2);
    }

    Result getDataResult(long l) {
        Result result = this.resultMap.get(l);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long l, int n, int n2) {
        Result result = this.resultMap.get(l);
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (n + n2 > rowSetNavigator.getSize()) {
            n2 = rowSetNavigator.getSize() - n;
        }
        return new RowSetNavigatorClient(rowSetNavigator, n, n2);
    }

    public void closeNavigator(long l) {
        Result result = this.resultMap.remove(l);
        if (result != null) {
            result.getNavigator().release();
        }
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator<Result> iterator = this.resultMap.values().iterator();
        while (iterator.hasNext()) {
            Result result = iterator.next();
            result.getNavigator().release();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator<Result> iterator = this.resultMap.values().iterator();
        while (iterator.hasNext()) {
            Result result = iterator.next();
            if (ResultProperties.isHoldable(result.rsProperties)) continue;
            result.getNavigator().release();
            iterator.remove();
        }
    }

    public void adjustLobUsageCount(LobData lobData, int n) {
        if (this.session.isProcessingLog() || this.session.isProcessingScript()) {
            return;
        }
        if (lobData == null) {
            return;
        }
        this.database.lobManager.adjustUsageCount(this.session, lobData.getId(), n);
    }

    public void adjustLobUsageCount(TableBase tableBase, Object[] objectArray, int n) {
        if (!tableBase.hasLobColumn) {
            return;
        }
        if (tableBase.isTemp) {
            return;
        }
        if (this.session.isProcessingLog() || this.session.isProcessingScript()) {
            return;
        }
        for (int i = 0; i < tableBase.columnCount; ++i) {
            Object object;
            if (!tableBase.colTypes[i].isLobType() || (object = objectArray[i]) == null) continue;
            this.database.lobManager.adjustUsageCount(this.session, ((LobData)object).getId(), n);
        }
    }

    public Result allocateLobForResult(ResultLob resultLob) {
        Result result = Result.updateZeroResult;
        InputStream inputStream = resultLob.getInputStream();
        long l = resultLob.getLobID();
        long l2 = resultLob.getBlockLength();
        try {
            switch (resultLob.getSubType()) {
                case 7: {
                    l2 = resultLob.getBlockLength();
                    if (l >= 0L) {
                        if (l2 < 0L) {
                            result = this.allocateBlobSegments(resultLob, inputStream);
                            break;
                        }
                        result = this.database.lobManager.setBytesForNewBlob(l, inputStream, l2);
                        break;
                    }
                    BlobDataID blobDataID = this.session.createBlob(l2);
                    this.resultLobs.put(l, blobDataID.getId());
                    l = blobDataID.getId();
                    result = this.database.lobManager.setBytesForNewBlob(l, inputStream, l2);
                    break;
                }
                case 8: {
                    if (l >= 0L) {
                        if (l2 < 0L) {
                            result = this.allocateClobSegments(resultLob, resultLob.getReader());
                            break;
                        }
                        if (resultLob.getReader() != null) {
                            inputStream = new ReaderInputStream(resultLob.getReader());
                        }
                        result = this.database.lobManager.setCharsForNewClob(l, inputStream, resultLob.getBlockLength());
                        break;
                    }
                    ClobDataID clobDataID = this.session.createClob(l2);
                    this.resultLobs.put(l, clobDataID.getId());
                    l = clobDataID.getId();
                    result = this.database.lobManager.setCharsForNewClob(l, inputStream, resultLob.getBlockLength());
                    break;
                }
                case 2: {
                    if (l < 0L) {
                        l = this.resultLobs.get(l);
                    }
                    byte[] byArray = resultLob.getByteArray();
                    result = this.database.lobManager.setBytes(l, resultLob.getOffset(), byArray, (int)l2);
                    break;
                }
                case 4: {
                    if (l < 0L) {
                        l = this.resultLobs.get(l);
                    }
                    char[] cArray = resultLob.getCharArray();
                    result = this.database.lobManager.setChars(l, resultLob.getOffset(), cArray, (int)l2);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            this.resultLobs.clear();
            throw Error.error(458, throwable);
        }
        return result;
    }

    Result allocateBlobSegments(ResultLob resultLob, InputStream inputStream) throws IOException {
        long l = resultLob.getOffset();
        int n = this.session.getStreamBlockSize();
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(n);
        Result result = null;
        long l2 = 0L;
        do {
            hsqlByteArrayOutputStream.reset();
            hsqlByteArrayOutputStream.write(inputStream, n);
            if (hsqlByteArrayOutputStream.size() == 0) break;
            byte[] byArray = hsqlByteArrayOutputStream.getBuffer();
            result = this.database.lobManager.setBytes(resultLob.getLobID(), l, byArray, hsqlByteArrayOutputStream.size());
            if (result.isError()) break;
            l += (long)hsqlByteArrayOutputStream.size();
            l2 += (long)hsqlByteArrayOutputStream.size();
        } while (hsqlByteArrayOutputStream.size() >= n);
        if (result == null) {
            result = ResultLob.newLobSetResponse(resultLob.getLobID(), l2);
        }
        return result;
    }

    private Result allocateClobSegments(ResultLob resultLob, Reader reader) throws IOException {
        return this.allocateClobSegments(resultLob.getLobID(), resultLob.getOffset(), reader);
    }

    private Result allocateClobSegments(long l, long l2, Reader reader) throws IOException {
        int n = this.session.getStreamBlockSize();
        CharArrayWriter charArrayWriter = new CharArrayWriter(n);
        long l3 = l2;
        do {
            charArrayWriter.reset();
            charArrayWriter.write(reader, n);
            char[] cArray = charArrayWriter.getBuffer();
            if (charArrayWriter.size() == 0) {
                return Result.updateZeroResult;
            }
            Result result = this.database.lobManager.setChars(l, l3, cArray, charArrayWriter.size());
            if (result.isError()) {
                return result;
            }
            l3 += (long)charArrayWriter.size();
        } while (charArrayWriter.size() >= n);
        return Result.updateZeroResult;
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (rowSetNavigator == null) {
            this.registerLobsForRow((Object[])result.valueData);
        } else {
            while (rowSetNavigator.next()) {
                Object[] objectArray = rowSetNavigator.getCurrent();
                this.registerLobsForRow(objectArray);
            }
            rowSetNavigator.reset();
        }
        this.resultLobs.clear();
    }

    private void registerLobsForRow(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            long l;
            LobData lobData;
            if (objectArray[i] instanceof BlobDataID) {
                lobData = (BlobDataID)objectArray[i];
                l = lobData.getId();
                if (l < 0L) {
                    l = this.resultLobs.get(l);
                }
                objectArray[i] = this.database.lobManager.getBlob(l);
                continue;
            }
            if (!(objectArray[i] instanceof ClobDataID)) continue;
            lobData = (ClobDataID)objectArray[i];
            l = lobData.getId();
            if (l < 0L) {
                l = this.resultLobs.get(l);
            }
            objectArray[i] = this.database.lobManager.getClob(l);
        }
    }

    ClobData createClobFromFile(String string, String string2) {
        File file = this.getFile(string);
        long l = file.length();
        InputStream inputStream = null;
        try {
            ClobDataID clobDataID = this.session.createClob(l);
            inputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            this.allocateClobSegments(clobDataID.getId(), 0L, inputStreamReader);
            ClobDataID clobDataID2 = clobDataID;
            return clobDataID2;
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, iOException.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    BlobData createBlobFromFile(String string) {
        File file = this.getFile(string);
        long l = file.length();
        InputStream inputStream = null;
        try {
            BlobDataID blobDataID = this.session.createBlob(l);
            inputStream = new FileInputStream(file);
            this.database.lobManager.setBytesForNewBlob(blobDataID.getId(), inputStream, l);
            BlobDataID blobDataID2 = blobDataID;
            return blobDataID2;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private File getFile(String string) {
        this.session.checkAdmin();
        String string2 = this.database.logger.getSecurePath(string, false, false);
        if (string2 == null) {
            throw Error.error(457, string);
        }
        File file = new File(string2);
        boolean bl = file.exists();
        if (!bl) {
            throw Error.error(452);
        }
        return file;
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Number getSequenceValue(NumberSequence numberSequence) {
        HsqlNameManager.HsqlName hsqlName;
        Number number;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateMap = new HashMap();
        }
        if ((number = this.sequenceMap.get((Object)(hsqlName = numberSequence.getName()))) == null) {
            number = numberSequence.getValueObject();
            this.sequenceMap.put(hsqlName, number);
            this.sequenceUpdateMap.put(numberSequence, number);
        }
        return number;
    }

    public Number getSequenceCurrent(NumberSequence numberSequence) {
        return this.sequenceUpdateMap == null ? (Number)null : (Number)this.sequenceUpdateMap.get((Object)numberSequence);
    }
}

