/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import shaded.org.hsqldb.ColumnSchema;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.ParserBase;
import shaded.org.hsqldb.ParserRoutine;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.RangeVariable;
import shaded.org.hsqldb.RoutineSchema;
import shaded.org.hsqldb.Scanner;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.SqlInvariants;
import shaded.org.hsqldb.Statement;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableDerived;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.jdbc.JDBCResultSet;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.map.BitMap;
import shaded.org.hsqldb.map.ValuePool;
import shaded.org.hsqldb.persist.HsqlDatabaseProperties;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.rights.Grantee;
import shaded.org.hsqldb.types.RowType;
import shaded.org.hsqldb.types.Type;
import shaded.org.hsqldb.types.Types;

public class Routine
implements SchemaObject,
RangeGroup,
Cloneable {
    public static final int NO_SQL = 1;
    public static final int CONTAINS_SQL = 2;
    public static final int READS_SQL = 3;
    public static final int MODIFIES_SQL = 4;
    public static final int LANGUAGE_JAVA = 1;
    public static final int LANGUAGE_SQL = 2;
    public static final int PARAM_STYLE_JAVA = 1;
    public static final int PARAM_STYLE_SQL = 2;
    static final Routine[] emptyArray = new Routine[0];
    RoutineSchema routineSchema;
    private HsqlNameManager.HsqlName name;
    private HsqlNameManager.HsqlName specificName;
    Type[] parameterTypes;
    int typeGroups;
    Type returnType;
    Table returnTable;
    final int routineType;
    int language = 2;
    int dataImpact = 2;
    int parameterStyle;
    boolean isDeterministic;
    boolean isNullInputOutput;
    boolean isNewSavepointLevel = true;
    int maxDynamicResults = 0;
    boolean isRecursive;
    boolean returnsTable;
    Statement statement;
    boolean isAggregate;
    boolean isIndex;
    boolean isSearch;
    private String methodName;
    Method javaMethod;
    boolean javaMethodWithConnection;
    private boolean isLibraryRoutine;
    OrderedHashMap<String, ColumnSchema> parameterList = new OrderedHashMap();
    RangeVariable[] ranges = RangeVariable.emptyArray;
    int variableCount;
    int cursorCount;
    OrderedHashSet<HsqlNameManager.HsqlName> references;
    Table triggerTable;
    int triggerType;
    int triggerOperation;

    public Routine(int n) {
        this.routineType = n;
        this.returnType = Type.SQL_ALL_TYPES;
        this.ranges = new RangeVariable[]{new RangeVariable(this.parameterList, null, false, 3)};
    }

    public Routine(Table table, RangeVariable[] rangeVariableArray, int n, int n2, int n3) {
        this.routineType = 8;
        this.returnType = Type.SQL_ALL_TYPES;
        this.dataImpact = n;
        this.ranges = rangeVariableArray;
        this.triggerTable = table;
        this.triggerType = n2;
        this.triggerOperation = n3;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        if (this.routineType == 8) {
            return this.triggerTable.getSchemaName();
        }
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        return this.references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        ParserRoutine parserRoutine = new ParserRoutine(session, new Scanner(session, this.statement.getSQL()));
        session.sessionContext.pushRoutineTables();
        try {
            parserRoutine.read();
            ParserBase.Recorder recorder = parserRoutine.startRecording();
            Statement statement = parserRoutine.compileSQLProcedureStatementOrNull(this, null);
            String string = recorder.getSQL();
            statement.setSQL(string);
            this.setProcedure(statement);
            this.resolve(session);
        }
        finally {
            session.sessionContext.popRoutineTables();
        }
    }

    @Override
    public String getSQL() {
        return this.getDefinitionSQL(true);
    }

    public String getSQLAlter() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("ALTER").append(' ').append("SPECIFIC").append(' ').append("ROUTINE").append(' ').append(this.specificName.getSchemaQualifiedStatementName()).append(' ').append("BODY").append(' ').append(this.statement.getSQL());
        return stringBuilder.toString();
    }

    public String getSQLDeclaration() {
        return this.getDefinitionSQL(false);
    }

    private String getDefinitionSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ');
        if (this.isAggregate) {
            stringBuilder.append("AGGREGATE").append(' ');
        }
        if (this.routineType == 17) {
            stringBuilder.append("PROCEDURE");
        } else {
            stringBuilder.append("FUNCTION");
        }
        stringBuilder.append(' ').append(this.name.getSchemaQualifiedStatementName()).append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            ColumnSchema columnSchema = this.parameterList.get(i);
            stringBuilder.append(columnSchema.getSQL());
        }
        stringBuilder.append(')').append(' ');
        if (this.routineType == 16) {
            stringBuilder.append("RETURNS").append(' ');
            if (this.returnsTable) {
                stringBuilder.append("TABLE").append(this.returnTable.getColumnListWithTypeSQL());
            } else {
                stringBuilder.append(this.returnType.getTypeDefinition());
            }
            stringBuilder.append(' ');
        }
        if (this.specificName != null) {
            stringBuilder.append("SPECIFIC").append(' ').append(this.specificName.getStatementName()).append(' ');
        }
        stringBuilder.append("LANGUAGE").append(' ');
        if (this.language == 1) {
            stringBuilder.append("JAVA");
        } else {
            stringBuilder.append("SQL");
        }
        stringBuilder.append(' ');
        if (!this.isDeterministic) {
            stringBuilder.append("NOT").append(' ');
        }
        stringBuilder.append("DETERMINISTIC").append(' ');
        stringBuilder.append(this.getDataImpactString()).append(' ');
        if (this.routineType == 16) {
            if (this.isNullInputOutput) {
                stringBuilder.append("RETURNS").append(' ').append("NULL");
            } else {
                stringBuilder.append("CALLED");
            }
            stringBuilder.append(' ').append("ON").append(' ').append("NULL").append(' ').append("INPUT").append(' ');
        } else {
            if (this.isNewSavepointLevel) {
                stringBuilder.append("NEW");
            } else {
                stringBuilder.append("OLD");
            }
            stringBuilder.append(' ').append("SAVEPOINT").append(' ').append("LEVEL").append(' ');
            if (this.maxDynamicResults != 0) {
                stringBuilder.append(' ').append("DYNAMIC").append(' ').append("RESULT").append(' ').append("SETS").append(' ').append(this.maxDynamicResults).append(' ');
            }
        }
        if (this.language == 1) {
            stringBuilder.append("EXTERNAL").append(' ').append("NAME").append(' ').append('\'').append(this.methodName).append('\'');
        } else if (bl) {
            stringBuilder.append(this.statement.getSQL());
        } else {
            stringBuilder.append("SIGNAL").append(' ').append("SQLSTATE").append(' ').append('\'').append("45000").append('\'');
        }
        return stringBuilder.toString();
    }

    public String getSQLBodyDefinition() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.language == 1) {
            stringBuilder.append("EXTERNAL").append(' ').append("NAME").append(' ').append('\'').append(this.methodName).append('\'');
        } else {
            stringBuilder.append(this.statement.getSQL());
        }
        return stringBuilder.toString();
    }

    public String getExternalName() {
        if (this.language == 1) {
            return this.methodName;
        }
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public void addParameter(ColumnSchema columnSchema) {
        HsqlNameManager.HsqlName hsqlName = columnSchema.getName();
        String string = hsqlName == null ? HsqlNameManager.getAutoNoNameColumnString(this.parameterList.size()) : hsqlName.name;
        boolean bl = this.parameterList.add(string, columnSchema);
        if (!bl) {
            throw Error.error(5614);
        }
    }

    public void setLanguage(int n) {
        this.language = n;
    }

    public int getLanguage() {
        return this.language;
    }

    boolean isPSM() {
        return this.language == 2;
    }

    public void setDataImpact(int n) {
        this.dataImpact = n;
    }

    public int getDataImpact() {
        return this.dataImpact;
    }

    public String getDataImpactString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.dataImpact) {
            case 1: {
                stringBuilder.append("NO").append(' ').append("SQL");
                break;
            }
            case 2: {
                stringBuilder.append("CONTAINS").append(' ').append("SQL");
                break;
            }
            case 3: {
                stringBuilder.append("READS").append(' ').append("SQL").append(' ').append("DATA");
                break;
            }
            case 4: {
                stringBuilder.append("MODIFIES").append(' ').append("SQL").append(' ').append("DATA");
            }
        }
        return stringBuilder.toString();
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Table getTable() {
        return this.returnTable;
    }

    public void setProcedure(Statement statement) {
        this.statement = statement;
    }

    public Statement getProcedure() {
        return this.statement;
    }

    public void setSpecificName(HsqlNameManager.HsqlName hsqlName) {
        this.specificName = hsqlName;
    }

    public int getMaxDynamicResults() {
        return this.maxDynamicResults;
    }

    public void setName(HsqlNameManager.HsqlName hsqlName) {
        this.name = hsqlName;
    }

    public HsqlNameManager.HsqlName getSpecificName() {
        return this.specificName;
    }

    public void setDeterministic(boolean bl) {
        this.isDeterministic = bl;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public void setNullInputOutput(boolean bl) {
        this.isNullInputOutput = bl;
    }

    public boolean isNullInputOutput() {
        return this.isNullInputOutput;
    }

    public void setNewSavepointLevel(boolean bl) {
        this.isNewSavepointLevel = bl;
    }

    public void setMaxDynamicResults(int n) {
        this.maxDynamicResults = n;
    }

    public void setParameterStyle(int n) {
        this.parameterStyle = n;
    }

    public void setMethodURL(String string) {
        this.methodName = string;
    }

    public Method getMethod() {
        return this.javaMethod;
    }

    public void setMethod(Method method) {
        this.javaMethod = method;
    }

    public void setReturnTable(TableDerived tableDerived) {
        this.returnTable = tableDerived;
        this.returnsTable = true;
        HsqlNameManager.SimpleName[] simpleNameArray = new HsqlNameManager.SimpleName[tableDerived.getColumnCount()];
        Type[] typeArray = tableDerived.getColumnTypes();
        this.returnType = new RowType(typeArray);
    }

    public boolean returnsTable() {
        return this.returnsTable;
    }

    public void setAggregate(boolean bl) {
        this.isAggregate = bl;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void resolve(Session session) {
        ColumnSchema columnSchema;
        int n;
        this.setLanguage(this.language);
        if (this.language == 2) {
            if (this.dataImpact == 1) {
                throw Error.error(5604, "CONTAINS SQL");
            }
            if (this.parameterStyle == 1) {
                throw Error.error(5604, "PARAMETER STYLE");
            }
        }
        if (this.language == 2 && this.parameterStyle != 0 && this.parameterStyle != 2) {
            throw Error.error(5604, "PARAMETER STYLE");
        }
        this.parameterTypes = new Type[this.parameterList.size()];
        this.typeGroups = 0;
        for (n = 0; n < this.parameterTypes.length; ++n) {
            columnSchema = this.parameterList.get(n);
            this.parameterTypes[n] = columnSchema.dataType;
            if (n >= 4) continue;
            this.typeGroups = BitMap.setByte(this.typeGroups, (byte)columnSchema.dataType.typeComparisonGroup, n * 8);
        }
        if (this.isAggregate) {
            if (this.parameterTypes.length != 4) {
                throw Error.error(5610);
            }
            n = this.parameterTypes[1].typeCode == 16 ? 1 : 0;
            columnSchema = this.parameterList.get(0);
            n &= columnSchema.getParameterMode() == 1 ? 1 : 0;
            columnSchema = this.parameterList.get(1);
            n &= columnSchema.getParameterMode() == 1 ? 1 : 0;
            columnSchema = this.parameterList.get(2);
            n &= columnSchema.getParameterMode() == 2 ? 1 : 0;
            columnSchema = this.parameterList.get(3);
            if ((n &= columnSchema.getParameterMode() == 2 ? 1 : 0) == 0) {
                throw Error.error(5610);
            }
        }
        this.resolveReferences(session);
    }

    void resolveReferences(Session session) {
        if (this.statement != null) {
            this.statement.resolve(session);
            this.checkSQLData(session);
        }
        if (this.methodName != null && this.javaMethod == null) {
            boolean[] blArray = new boolean[1];
            this.javaMethod = Routine.getMethod(this.methodName, this, blArray, this.returnsTable);
            if (this.javaMethod == null) {
                throw Error.error(6013);
            }
            this.javaMethodWithConnection = blArray[0];
            String string = this.javaMethod.getDeclaringClass().getName();
            if (string.equals("java.lang.Math")) {
                this.isLibraryRoutine = true;
            }
        }
        this.setReferences();
    }

    private void setReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ColumnSchema columnSchema = this.parameterList.get(i);
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = columnSchema.getReferences();
            if (orderedHashSet2 == null) continue;
            orderedHashSet.addAll(orderedHashSet2);
        }
        if (this.statement != null) {
            orderedHashSet.addAll(this.statement.getReferences());
        }
        this.isRecursive = false;
        if (orderedHashSet.contains(this.getSpecificName())) {
            orderedHashSet.remove(this.getSpecificName());
            this.isRecursive = true;
        }
        this.references = orderedHashSet;
    }

    void checkSQLData(Session session) {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = this.statement.getReferences();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = orderedHashSet.get(i);
            if (hsqlName.type != 24) continue;
            Routine routine = (Routine)session.database.schemaManager.findSchemaObject(hsqlName);
            if (routine.dataImpact == 3) {
                if (this.dataImpact != 2) continue;
                throw Error.error(5608, "READS SQL DATA");
            }
            if (routine.dataImpact != 4 || this.dataImpact != 2 && this.dataImpact != 3) continue;
            throw Error.error(5608, "MODIFIES SQL DATA");
        }
        if (this.dataImpact == 2 || this.dataImpact == 3) {
            HsqlNameManager.HsqlName[] hsqlNameArray = this.statement.getTableNamesForWrite();
            for (int i = 0; i < hsqlNameArray.length; ++i) {
                if (hsqlNameArray[i].schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                throw Error.error(5608, "MODIFIES SQL DATA");
            }
        }
        if (this.dataImpact == 2) {
            HsqlNameManager.HsqlName[] hsqlNameArray = this.statement.getTableNamesForRead();
            for (int i = 0; i < hsqlNameArray.length; ++i) {
                if (hsqlNameArray[i].schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                throw Error.error(5608, "READS SQL DATA");
            }
        }
    }

    public boolean isTrigger() {
        return this.routineType == 8;
    }

    public boolean isProcedure() {
        return this.routineType == 17;
    }

    public boolean isFunction() {
        return this.routineType == 16;
    }

    public ColumnSchema getParameter(int n) {
        return this.parameterList.get(n);
    }

    Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    int getParameterSignature() {
        return this.typeGroups;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public int getParameterCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            ColumnSchema columnSchema = this.parameterList.get(i);
            if (columnSchema.getParameterMode() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getParameterIndex(String string) {
        return this.parameterList.getIndex(string);
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.ranges;
    }

    @Override
    public void setCorrelated() {
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public int getCursorCount() {
        return this.cursorCount;
    }

    public boolean isLibraryRoutine() {
        return this.isLibraryRoutine;
    }

    public HsqlNameManager.HsqlName[] getTableNamesForRead() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForRead();
    }

    public HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForWrite();
    }

    public void resetAlteredRoutineSettings() {
        if (this.isPSM()) {
            this.methodName = null;
            this.javaMethod = null;
            this.javaMethodWithConnection = false;
            this.parameterStyle = 2;
            if (this.dataImpact == 1) {
                this.dataImpact = 2;
            }
        } else {
            this.statement = null;
            this.references = null;
            this.variableCount = 0;
            this.cursorCount = 0;
            this.ranges = RangeVariable.emptyArray;
        }
    }

    public void setAsAlteredRoutine(Routine routine) {
        this.language = routine.language;
        this.dataImpact = routine.dataImpact;
        this.parameterStyle = routine.parameterStyle;
        this.isDeterministic = routine.isDeterministic;
        this.isNullInputOutput = routine.isNullInputOutput;
        this.maxDynamicResults = routine.maxDynamicResults;
        this.isRecursive = routine.isRecursive;
        this.javaMethod = routine.javaMethod;
        this.isRecursive = routine.isRecursive;
        this.javaMethodWithConnection = routine.javaMethodWithConnection;
        this.methodName = routine.methodName;
        this.statement = routine.statement;
        this.references = routine.references;
        this.variableCount = routine.variableCount;
        this.cursorCount = routine.cursorCount;
        this.ranges = routine.ranges;
    }

    Object[] convertArgsToJava(Session session, Object[] objectArray) {
        int n;
        int n2 = this.javaMethodWithConnection ? 1 : 0;
        Object[] objectArray2 = new Object[this.javaMethod.getParameterTypes().length];
        Type[] typeArray = this.getParameterTypes();
        for (n = 0; n < typeArray.length; ++n) {
            Object object = objectArray[n];
            ColumnSchema columnSchema = this.getParameter(n);
            if (columnSchema.parameterMode == 1) {
                objectArray2[n + n2] = typeArray[n].convertSQLToJava(session, object);
                continue;
            }
            Object object2 = typeArray[n].convertSQLToJava(session, object);
            Class clazz = typeArray[n].getJDBCClass();
            Object object3 = Array.newInstance(clazz, 1);
            Array.set(object3, 0, object2);
            objectArray2[n + n2] = object3;
        }
        while (n + n2 < objectArray2.length) {
            objectArray2[n + n2] = new ResultSet[1];
            ++n;
        }
        return objectArray2;
    }

    void convertArgsToSQL(Session session, Object[] objectArray, Object[] objectArray2) {
        Object object;
        Object object2;
        int n;
        int n2 = this.javaMethodWithConnection ? 1 : 0;
        Type[] typeArray = this.getParameterTypes();
        for (n = 0; n < typeArray.length; ++n) {
            object2 = objectArray2[n + n2];
            object = this.getParameter(n);
            if (((ColumnSchema)object).parameterMode != 1) {
                object2 = Array.get(object2, 0);
            }
            objectArray[n] = typeArray[n].convertJavaToSQL(session, object2);
        }
        object2 = null;
        while (n + n2 < objectArray2.length) {
            object = ((ResultSet[])objectArray2[n + n2])[0];
            if (object != null) {
                if (object instanceof JDBCResultSet) {
                    Result result = ((JDBCResultSet)object).result;
                    if (object2 == null) {
                        objectArray[n] = result;
                        object2 = result;
                    } else {
                        ((Result)object2).addChainedResult(result);
                    }
                } else {
                    throw Error.error(6000, "ResultSet not native");
                }
            }
            ++n;
        }
    }

    public Result invokeJavaMethodDirect(Object[] objectArray) {
        Result result;
        try {
            Object object = this.javaMethod.invoke(null, objectArray);
            object = this.returnType.convertJavaToSQL(null, object);
            result = Result.newPSMResult(object);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(Error.error(throwable, 6000, this.getName().name));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Result invokeJavaMethod(Session session, Object[] objectArray) {
        Result result;
        HsqlNameManager.HsqlName hsqlName = session.getCurrentSchemaHsqlName();
        try {
            if (this.dataImpact == 1) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
                session.setNoSQL();
            } else if (this.dataImpact == 2) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
            } else if (this.dataImpact == 3) {
                session.sessionContext.isReadOnly = Boolean.TRUE;
            }
            session.setCurrentSchemaHsqlName(this.getSchemaName());
            Object object = this.javaMethod.invoke(null, objectArray);
            if (this.returnsTable()) {
                if (!(object instanceof JDBCResultSet)) throw Error.runtimeError(201, "FunctionSQLInvoked");
                result = ((JDBCResultSet)object).result;
            } else {
                object = this.returnType.convertJavaToSQL(session, object);
                result = Result.newPSMResult(object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            result = Result.newErrorResult(Error.error(invocationTargetException, 6000, this.getName().name));
        }
        catch (IllegalAccessException illegalAccessException) {
            result = Result.newErrorResult(Error.error(illegalAccessException, 6000, this.getName().name));
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(Error.error(throwable, 6000, this.getName().name));
        }
        session.setCurrentSchemaHsqlName(hsqlName);
        return result;
    }

    public Result invoke(Session session, Object[] objectArray, Object[] objectArray2, boolean bl) {
        Result result;
        if (bl) {
            session.sessionContext.pushRoutineInvocation();
        }
        if (this.isPSM()) {
            try {
                session.sessionContext.routineArguments = objectArray;
                session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
                if (this.variableCount > 0) {
                    session.sessionContext.routineVariables = new Object[this.variableCount];
                }
                session.sessionContext.routineCursors = Result.emptyArray;
                if (this.cursorCount > 0) {
                    session.sessionContext.routineCursors = new Result[this.cursorCount];
                }
                result = this.statement.execute(session);
                if (objectArray2 != null) {
                    System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
                }
            }
            catch (Throwable throwable) {
                result = Result.newErrorResult(throwable);
            }
        } else {
            if (this.isAggregate) {
                objectArray = this.convertArgsToJava(session, objectArray);
            }
            result = this.invokeJavaMethod(session, objectArray);
            if (this.isAggregate) {
                Object[] objectArray3 = new Object[objectArray.length];
                this.convertArgsToSQL(session, objectArray3, objectArray);
                System.arraycopy(objectArray3, 1, objectArray2, 0, objectArray2.length);
            }
        }
        if (bl) {
            session.sessionContext.popRoutineInvocation();
        }
        return result;
    }

    public Routine duplicate() {
        try {
            return (Routine)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Type");
        }
    }

    static Method getMethod(String string, Routine routine, boolean[] blArray, boolean bl) {
        int n = string.indexOf(58);
        if (n != -1) {
            if (!string.substring(0, n).equals("CLASSPATH")) {
                throw Error.error(6012, string);
            }
            string = string.substring(n + 1);
        }
        Method[] methodArray = Routine.getMethods(string);
        int n2 = -1;
        for (n = 0; n < methodArray.length; ++n) {
            int n3;
            int n4;
            int n5 = 0;
            blArray[0] = false;
            Method method = methodArray[n];
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
                n5 = 1;
                blArray[0] = true;
            }
            int n6 = classArray.length - n5;
            if (routine.isProcedure()) {
                for (n4 = n5; n4 < classArray.length; ++n4) {
                    if (!classArray[n4].isArray() || !ResultSet.class.isAssignableFrom(classArray[n4].getComponentType())) continue;
                    n6 = n4 - n5;
                    break;
                }
            }
            if (n6 != routine.parameterTypes.length) continue;
            if (bl) {
                if (!ResultSet.class.isAssignableFrom(method.getReturnType())) {
                    continue;
                }
            } else {
                Type type = Types.getParameterSQLType(method.getReturnType());
                if (type == null || !routine.returnType.canBeAssignedFrom(type)) continue;
                if (type.isLobType() || !type.isBinaryType() && !type.isCharacterType()) {
                    n3 = routine.returnType.typeCode;
                    if (n3 == 2) {
                        n3 = 3;
                    }
                    if (type.typeCode != n3) continue;
                }
            }
            for (n4 = 0; n4 < routine.parameterTypes.length; ++n4) {
                boolean bl2;
                Type type;
                n3 = 0;
                Class<?> clazz = classArray[n4 + n5];
                if (clazz.isArray() && !byte[].class.equals(clazz)) {
                    if ((clazz = clazz.getComponentType()).isPrimitive()) {
                        method = null;
                        break;
                    }
                    n3 = 1;
                }
                if ((type = Types.getParameterSQLType(clazz)) == null) {
                    method = null;
                    break;
                }
                boolean bl3 = bl2 = routine.parameterTypes[n4].typeComparisonGroup == type.typeComparisonGroup;
                if (bl2 && routine.parameterTypes[n4].isNumberType()) {
                    int n7 = routine.parameterTypes[n4].typeCode;
                    if (n7 == 2) {
                        n7 = 3;
                    }
                    boolean bl4 = bl2 = n7 == type.typeCode;
                }
                if (n3 != 0 && routine.getParameter((int)n4).parameterMode == 1) {
                    bl2 = false;
                }
                if (bl2) continue;
                method = null;
                if (n4 + n5 <= n2) break;
                n2 = n4 + n5;
                break;
            }
            if (method == null) continue;
            for (n4 = 0; n4 < routine.parameterTypes.length; ++n4) {
                routine.getParameter(n4).setNullable(!classArray[n4 + n5].isPrimitive());
            }
            return method;
        }
        if (n2 >= 0) {
            ColumnSchema columnSchema = routine.getParameter(n2);
            throw Error.error(6021, columnSchema.getNameString());
        }
        return null;
    }

    static Method[] getMethods(String string) {
        Class<?> clazz;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw Error.error(5501, string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Method[] methodArray = null;
        if (!HsqlDatabaseProperties.supportsJavaMethod(string)) {
            throw Error.error(5501, string2);
        }
        try {
            clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName(string2);
            }
            catch (Throwable throwable2) {
                throw Error.error(throwable2, 5501, 26, new String[]{throwable2.toString(), string2});
            }
        }
        try {
            methodArray = clazz.getMethods();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 5501, 26, new String[]{throwable.toString(), string2});
        }
        HsqlArrayList<Method> hsqlArrayList = new HsqlArrayList<Method>();
        for (n = 0; n < methodArray.length; ++n) {
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            Method method = methodArray[n];
            int n4 = method.getModifiers();
            if (!method.getName().equals(string3) || !Modifier.isStatic(n4) || !Modifier.isPublic(n4)) continue;
            Class<?>[] classArray = methodArray[n].getParameterTypes();
            if (classArray.length > 0 && classArray[0].equals(Connection.class)) {
                n2 = 1;
            }
            for (int i = n2; i < classArray.length; ++i) {
                Type type;
                Class<?> clazz2 = classArray[i];
                if (clazz2.isArray()) {
                    if (!byte[].class.equals(clazz2)) {
                        if ((clazz2 = clazz2.getComponentType()).isPrimitive()) {
                            method = null;
                            break;
                        }
                        if (ResultSet.class.isAssignableFrom(clazz2) && n3 > i) {
                            n3 = i;
                        }
                    }
                    if (i >= n3) {
                        if (ResultSet.class.isAssignableFrom(clazz2)) continue;
                        method = null;
                        break;
                    }
                } else if (i > n3) {
                    method = null;
                    break;
                }
                if ((type = Types.getParameterSQLType(clazz2)) != null) continue;
                method = null;
                break;
            }
            if (method == null) continue;
            if (ResultSet.class.isAssignableFrom(method.getReturnType())) {
                hsqlArrayList.add(methodArray[n]);
                continue;
            }
            Type type = Types.getParameterSQLType(method.getReturnType());
            if (type == null) continue;
            hsqlArrayList.add(methodArray[n]);
        }
        methodArray = new Method[hsqlArrayList.size()];
        hsqlArrayList.toArray(methodArray);
        return methodArray;
    }

    public static Routine[] newRoutines(Session session, Method[] methodArray) {
        Routine[] routineArray = new Routine[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            routineArray[i] = Routine.newRoutine(session, method);
        }
        return routineArray;
    }

    public static Routine newRoutine(Session session, Method method) {
        Routine routine = new Routine(16);
        Class<?>[] classArray = method.getParameterTypes();
        String string = method.getDeclaringClass().getName();
        int n = classArray.length > 0 && classArray[0].equals(Connection.class) ? 1 : 0;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("CLASSPATH:").append(method.getDeclaringClass().getName()).append('.').append(method.getName());
        String string2 = stringBuilder.toString();
        if (string.equals("java.lang.Math")) {
            routine.isLibraryRoutine = true;
        }
        for (int i = n; i < classArray.length; ++i) {
            Type type = Types.getParameterSQLType(classArray[i]);
            HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newHsqlName("C" + (i - n + 1), false, 23);
            ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, !classArray[i].isPrimitive(), false, null);
            routine.addParameter(columnSchema);
        }
        routine.setLanguage(1);
        routine.setMethod(method);
        routine.setMethodURL(string2);
        routine.setDataImpact(1);
        Type type = Types.getParameterSQLType(method.getReturnType());
        routine.javaMethodWithConnection = n == 1;
        routine.setReturnType(type);
        routine.resolve(session);
        return routine;
    }

    public static void createRoutines(Session session, HsqlNameManager.HsqlName hsqlName, String string) {
        Method[] methodArray = Routine.getMethods(string);
        Routine[] routineArray = Routine.newRoutines(session, methodArray);
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newHsqlName(hsqlName, string, true, 16);
        for (int i = 0; i < routineArray.length; ++i) {
            if (routineArray[i].getReturnType() == Type.SQL_ALL_TYPES) continue;
            routineArray[i].setName(hsqlName2);
            session.database.schemaManager.addSchemaObject(routineArray[i]);
        }
    }
}

