/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.ColumnBase;
import shaded.org.hsqldb.ColumnSchema;
import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.ExpressionAccessor;
import shaded.org.hsqldb.ExpressionAggregate;
import shaded.org.hsqldb.ExpressionArithmetic;
import shaded.org.hsqldb.ExpressionArrayAggregate;
import shaded.org.hsqldb.ExpressionBoolean;
import shaded.org.hsqldb.ExpressionColumn;
import shaded.org.hsqldb.ExpressionJSON;
import shaded.org.hsqldb.ExpressionLike;
import shaded.org.hsqldb.ExpressionLogical;
import shaded.org.hsqldb.ExpressionOp;
import shaded.org.hsqldb.ExpressionOrderBy;
import shaded.org.hsqldb.ExpressionPeriod;
import shaded.org.hsqldb.ExpressionPeriodOp;
import shaded.org.hsqldb.ExpressionTable;
import shaded.org.hsqldb.ExpressionValue;
import shaded.org.hsqldb.FunctionCustom;
import shaded.org.hsqldb.FunctionSQL;
import shaded.org.hsqldb.FunctionSQLInvoked;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.NumberSequence;
import shaded.org.hsqldb.OpTypes;
import shaded.org.hsqldb.ParserBase;
import shaded.org.hsqldb.PeriodDefinition;
import shaded.org.hsqldb.QueryExpression;
import shaded.org.hsqldb.QuerySpecification;
import shaded.org.hsqldb.RangeGroup;
import shaded.org.hsqldb.RangeVariable;
import shaded.org.hsqldb.RangeVariableJoined;
import shaded.org.hsqldb.ReferenceObject;
import shaded.org.hsqldb.Routine;
import shaded.org.hsqldb.RoutineSchema;
import shaded.org.hsqldb.Scanner;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.SortAndSlice;
import shaded.org.hsqldb.SqlInvariants;
import shaded.org.hsqldb.StatementCursor;
import shaded.org.hsqldb.StatementDMQL;
import shaded.org.hsqldb.StatementQuery;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableDerived;
import shaded.org.hsqldb.Token;
import shaded.org.hsqldb.View;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.List;
import shaded.org.hsqldb.lib.LongDeque;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.lib.OrderedIntKeyHashMap;
import shaded.org.hsqldb.map.BaseHashMap;
import shaded.org.hsqldb.map.BitMap;
import shaded.org.hsqldb.map.ValuePool;
import shaded.org.hsqldb.result.ResultProperties;
import shaded.org.hsqldb.types.ArrayType;
import shaded.org.hsqldb.types.Charset;
import shaded.org.hsqldb.types.Collation;
import shaded.org.hsqldb.types.IntervalType;
import shaded.org.hsqldb.types.Type;
import shaded.org.hsqldb.types.Types;
import shaded.org.hsqldb.types.UserTypeModifier;

public class ParserDQL
extends ParserBase {
    protected Database database;
    protected Session session;
    protected final CompileContext compileContext;

    ParserDQL(Session session, Scanner scanner, CompileContext compileContext) {
        super(scanner);
        this.session = session;
        this.database = session.getDatabase();
        this.compileContext = new CompileContext(session, this, compileContext);
    }

    @Override
    void reset(Session session, String string) {
        super.reset(session, string);
        this.compileContext.reset();
        this.lastError = null;
    }

    void checkIsSchemaObjectName() {
        if (this.database.sqlEnforceNames) {
            this.checkIsNonReservedIdentifier();
        } else {
            this.checkIsNonCoreReservedIdentifier();
        }
        if (this.database.sqlRegularNames) {
            this.checkIsIrregularCharInIdentifier();
        }
    }

    Type readTypeDefinition(boolean bl, boolean bl2) {
        SchemaObject schemaObject;
        int n = Integer.MIN_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = this.database.sqlEnforceSize;
        boolean bl9 = true;
        long l = 0L;
        int n2 = 0;
        this.checkIsIdentifier();
        if (this.token.namePrefix == null) {
            n = Type.getTypeNr(this.token.tokenString);
        }
        if (this.database.sqlSyntaxOra && !this.session.isProcessingScript() && n == 91) {
            this.read();
            return Type.SQL_TIMESTAMP_NO_FRACTION;
        }
        if (n == Integer.MIN_VALUE) {
            if (bl2) {
                this.checkIsSchemaObjectName();
                schemaObject = this.database.schemaManager.findDomainOrUDT(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix, this.token.namePrePrePrefix);
                if (schemaObject != null) {
                    this.getRecordedToken().setExpression(schemaObject);
                    this.compileContext.addDomainOrType(schemaObject);
                    this.read();
                    return schemaObject;
                }
            }
            if (this.token.namePrefix != null) {
                throw Error.error(5509, this.token.tokenString);
            }
            if (this.database.sqlSyntaxOra) {
                switch (this.token.tokenType) {
                    case 611: 
                    case 612: {
                        this.read();
                        return Type.SQL_DOUBLE;
                    }
                    case 723: {
                        this.read();
                        if (this.token.tokenType == 767) {
                            this.read();
                            return Type.getType(61, null, null, 0x40000000L, 0);
                        }
                        this.readIfThis(379);
                        return Type.getType(12, null, this.database.collation, 0x40000000L, 0);
                    }
                    case 543: {
                        this.read();
                        if (this.token.tokenType == 926) {
                            int n3;
                            this.read();
                            if (this.token.tokenType == 910) {
                                this.read();
                                n3 = 40;
                            } else {
                                n3 = this.readInteger();
                            }
                            n2 = 0;
                            if (this.token.tokenType == 913) {
                                this.read();
                                n2 = this.readInteger();
                            }
                            this.readThis(911);
                            return Type.getType(3, null, null, n3, n2);
                        }
                        return Type.SQL_DECIMAL_DEFAULT;
                    }
                    case 767: {
                        n = 61;
                        break;
                    }
                    case 847: {
                        bl7 = true;
                        bl8 = false;
                        n = 12;
                        break;
                    }
                    case 754: {
                        n = 12;
                        break;
                    }
                    case 223: {
                        n = 1;
                        break;
                    }
                }
            }
            if (this.database.sqlSyntaxMss) {
                if ("MONEY".equals(this.token.tokenString)) {
                    return Type.getType(3, null, null, 18L, 4);
                }
                if ("UNIQUEIDENTIFIER".equals(this.token.tokenString)) {
                    return Type.SQL_GUID;
                }
                if ("DATETIME2".equals(this.token.tokenString)) {
                    n = 93;
                } else if ("IMAGE".equals(this.token.tokenString)) {
                    n = -4;
                } else if ("NTEXT".equals(this.token.tokenString)) {
                    n = -1;
                }
                switch (this.token.tokenType) {
                    case 655: {
                        n = 95;
                        break;
                    }
                    case 814: {
                        n = -1;
                    }
                }
            }
            if (this.database.sqlSyntaxPgs) {
                switch (this.token.tokenType) {
                    case 814: {
                        n = -1;
                        bl7 = true;
                        break;
                    }
                    case 630: {
                        n = 100;
                        break;
                    }
                    default: {
                        if ("BYTEA".equals(this.token.tokenString)) {
                            n = -4;
                            break;
                        }
                        if ("INT2".equals(this.token.tokenString)) {
                            n = 5;
                            break;
                        }
                        if ("INT4".equals(this.token.tokenString)) {
                            n = 4;
                            break;
                        }
                        if ("INT8".equals(this.token.tokenString)) {
                            n = 25;
                            break;
                        }
                        if ("REAL".equals(this.token.tokenString)) {
                            n = 8;
                            break;
                        }
                        if (!"TIMESTAMPTZ".equals(this.token.tokenString)) break;
                        n = 95;
                        n2 = 6;
                    }
                }
            }
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 677: {
                        return this.readMysEnum();
                    }
                    case 820: {
                        n = 12;
                        bl9 = false;
                        break;
                    }
                    case 725: 
                    case 730: 
                    case 814: {
                        n = -1;
                        bl9 = false;
                        break;
                    }
                    case 819: {
                        n = -3;
                        bl9 = false;
                        break;
                    }
                    case 724: 
                    case 729: {
                        n = -4;
                        bl9 = false;
                    }
                }
            }
            if (n == Integer.MIN_VALUE) {
                throw Error.error(5509, this.token.tokenString);
            }
        }
        this.read();
        switch (n) {
            case 1: {
                if (this.token.tokenType == 380) {
                    this.read();
                    n = 12;
                    break;
                }
                if (this.token.tokenType == 184) {
                    this.read();
                    this.readThis(544);
                    n = 40;
                    break;
                }
                if (!this.database.sqlSyntaxOra) break;
                bl7 = true;
                break;
            }
            case 8: {
                if (this.token.tokenType != 266) break;
                this.read();
                break;
            }
            case 60: {
                if (this.token.tokenType == 380) {
                    this.read();
                    n = 61;
                    break;
                }
                if (this.token.tokenType != 184) break;
                this.read();
                this.readThis(544);
                n = 30;
                break;
            }
            case 14: {
                if (this.token.tokenType != 380) break;
                this.read();
                n = 15;
                break;
            }
            case 10: {
                return this.readIntervalType(this.session, false);
            }
        }
        if (n == 93) {
            l = 6L;
        }
        if ((bl9 &= Types.acceptsPrecision(n)) && bl8 && Types.requiresPrecision(n) && this.token.tokenType != 926 && !this.session.isProcessingScript()) {
            throw Error.error(5599, Type.getDefaultType(n).getNameString());
        }
        if (this.database.sqlSyntaxMys) {
            switch (n) {
                case -6: 
                case 4: 
                case 5: 
                case 25: {
                    bl9 = true;
                }
            }
        }
        if (this.database.sqlSyntaxMss) {
            switch (n) {
                case 95: {
                    bl9 = true;
                }
            }
        }
        if (bl9) {
            if (this.token.tokenType == 926) {
                int n4 = 1;
                this.read();
                block37 : switch (this.token.tokenType) {
                    case 1011: {
                        if (this.token.dataType.typeCode == 4 || this.token.dataType.typeCode == 25) break;
                        throw this.unexpectedToken();
                    }
                    case 1018: {
                        if (n == 30 || n == 40 || n == 61 || n == 12) {
                            switch (this.token.lobMultiplierType) {
                                case 508: {
                                    n4 = 1024;
                                    break block37;
                                }
                                case 519: {
                                    n4 = 0x100000;
                                    break block37;
                                }
                                case 486: {
                                    n4 = 0x40000000;
                                    break block37;
                                }
                            }
                            throw this.unexpectedToken();
                        }
                        throw this.unexpectedToken(this.token.getFullString());
                    }
                    case 209: {
                        if (this.database.sqlSyntaxMss) {
                            this.token.tokenValue = Integer.MAX_VALUE;
                            break;
                        }
                        throw this.unexpectedToken();
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                bl3 = true;
                l = ((Number)this.token.tokenValue).longValue();
                if (l < 0L || l == 0L && !Types.acceptsZeroPrecision(n)) {
                    throw Error.error(5592);
                }
                l *= (long)n4;
                this.read();
                if (n == 1 || n == 12 || n == 40) {
                    if (this.token.tokenType == 426) {
                        this.read();
                    } else if (this.token.tokenType == 546) {
                        this.read();
                    }
                }
                if (Types.acceptsScaleCreateParam(n) && this.token.tokenType == 913) {
                    this.read();
                    n2 = this.readInteger();
                    if (!(n2 >= 0 || n == 3 && this.database.sqlSyntaxOra)) {
                        throw Error.error(5592);
                    }
                    if (n == 3 && (long)n2 > l) {
                        throw Error.error(5592);
                    }
                    bl4 = true;
                }
                if (bl7 && !this.readIfThis(42)) {
                    this.readIfThis(624);
                }
                this.readThis(911);
            } else if (n == 14) {
                l = 1L;
            } else if (n == 30 || n == 40) {
                l = 0x40000000L;
            } else if (bl8 && (n == 1 || n == 60)) {
                l = 1L;
            }
            switch (n) {
                case 92: 
                case 93: 
                case 95: {
                    if (l > 9L) {
                        throw Error.error(5592);
                    }
                    n2 = (int)l;
                    l = 0L;
                    if (n == 95) break;
                    if (this.token.tokenType == 390) {
                        this.read();
                        this.readThis(349);
                        this.readThis(563);
                        if (n == 93) {
                            n = 95;
                            break;
                        }
                        n = 94;
                        break;
                    }
                    if (this.token.tokenType != 392) break;
                    this.read();
                    this.readThis(349);
                    this.readThis(563);
                }
            }
        }
        switch (n) {
            case -1: {
                if (this.database.sqlLongvarIsLob) {
                    n = 40;
                    l = 0x40000000L;
                    break;
                }
                n = 12;
                if (bl3) break;
                l = 0x1000000L;
                break;
            }
            case -4: {
                if (this.database.sqlLongvarIsLob) {
                    n = 30;
                    l = 0x40000000L;
                    break;
                }
                n = 61;
                if (bl3) break;
                l = 0x1000000L;
                break;
            }
            case 1: {
                if (this.database.sqlSyntaxDb2 && this.readIfThis(133)) {
                    this.readThis(614);
                    this.readThis(451);
                    n = 60;
                    break;
                }
                bl5 = true;
                break;
            }
            case 40: {
                bl5 = true;
                break;
            }
            case 100: {
                n = 12;
                bl6 = true;
            }
            case 12: {
                if (this.database.sqlSyntaxDb2 && this.readIfThis(133)) {
                    this.readThis(614);
                    this.readThis(451);
                    n = 61;
                    if (bl3) break;
                    l = 32768L;
                    break;
                }
                bl5 = true;
                if (!bl3) {
                    l = 32768L;
                }
                if (this.session.isIgnorecase() && !this.session.isProcessingScript()) {
                    bl6 = true;
                }
                if (l <= Integer.MAX_VALUE) break;
                throw Error.error(5592);
            }
            case 60: {
                break;
            }
            case 61: {
                if (!bl3) {
                    l = 32768L;
                }
                if (l <= Integer.MAX_VALUE) break;
                throw Error.error(5592);
            }
            case 2: 
            case 3: {
                if (bl3 || bl4 || bl8) break;
                l = 128L;
                n2 = 32;
            }
        }
        schemaObject = this.database.collation;
        Charset charset = null;
        if (bl5 && bl) {
            if (this.token.tokenType == 44) {
                this.read();
                this.readThis(313);
                this.checkIsSchemaObjectName();
                charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, this.token.namePrefix);
                this.read();
            }
            if (this.token.tokenType == 51) {
                this.read();
                this.checkIsSchemaObjectName();
                schemaObject = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
                this.read();
            } else if (bl6) {
                schemaObject = Collation.getUpperCaseCompareCollation((Collation)schemaObject);
            }
        }
        Type type = Type.getType(n, charset, (Collation)schemaObject, l, n2);
        if (this.token.tokenType == 11) {
            if (type.isLobType()) {
                throw this.unexpectedToken();
            }
            this.read();
            int n5 = 0x100000;
            if (this.token.tokenType == 921) {
                this.read();
                n5 = this.readInteger();
                if (n5 < 0) {
                    throw Error.error(5592);
                }
                this.readThis(931);
            }
            type = new ArrayType(type, n5);
        }
        return type;
    }

    Type readMysEnum() {
        this.read();
        this.checkIsThis(926);
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("ENUM", false, 13);
        Type type = Type.getType(12, null, null, 32L, 0);
        type.userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        return type;
    }

    void readSimpleColumnNames(OrderedHashSet<String> orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        do {
            ColumnSchema columnSchema = this.readSimpleColumnName(rangeVariable, bl);
            if (orderedHashSet.add(columnSchema.getName().name)) continue;
            throw Error.error(5579, columnSchema.getName().name);
        } while (this.readIfThis(913));
        if (this.token.tokenType != 911) {
            throw this.unexpectedToken();
        }
    }

    void readTargetSpecificationList(OrderedHashSet<Expression> orderedHashSet, RangeVariable[] rangeVariableArray, LongDeque longDeque) {
        do {
            Expression expression;
            if (orderedHashSet.add(expression = this.XreadTargetSpecification(rangeVariableArray, longDeque))) continue;
            ColumnSchema columnSchema = expression.getColumn();
            throw Error.error(5579, columnSchema.getName().name);
        } while (this.readIfThis(913));
        if (this.token.tokenType != 911 && this.token.tokenType != 137) {
            throw this.unexpectedToken();
        }
    }

    int[] readColumnList(Table table, boolean bl) {
        OrderedHashSet<String> orderedHashSet = this.readColumnNames(bl);
        return table.getColumnIndexes(orderedHashSet);
    }

    void readSimpleColumnNames(OrderedHashSet<String> orderedHashSet, Table table, boolean bl) {
        do {
            ColumnSchema columnSchema = this.readSimpleColumnName(table, bl);
            if (orderedHashSet.add(columnSchema.getName().name)) continue;
            throw Error.error(5577, columnSchema.getName().name);
        } while (this.readIfThis(913));
        if (this.token.tokenType != 911) {
            throw this.unexpectedToken();
        }
    }

    HsqlNameManager.HsqlName[] readColumnNames(HsqlNameManager.HsqlName hsqlName) {
        BitMap bitMap = new BitMap(0, true);
        OrderedHashSet<String> orderedHashSet = this.readColumnNames(bitMap, false);
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            String string = orderedHashSet.get(i);
            boolean bl = bitMap.isSet(i);
            hsqlNameArray[i] = this.database.nameManager.newHsqlName(hsqlName.schema, string, bl, 9, hsqlName);
        }
        return hsqlNameArray;
    }

    OrderedHashSet<String> readColumnNames(boolean bl) {
        return this.readColumnNames(null, bl);
    }

    OrderedHashSet<String> readColumnNames(BitMap bitMap, boolean bl) {
        this.readThis(926);
        OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
        this.readColumnNameList(orderedHashSet, bitMap, bl);
        this.readThis(911);
        return orderedHashSet;
    }

    void readColumnNameList(OrderedHashSet<String> orderedHashSet, BitMap bitMap, boolean bl) {
        int n = 0;
        do {
            if (this.session.isProcessingScript()) {
                if (!this.isSimpleName()) {
                    this.token.isDelimitedIdentifier = true;
                }
            } else {
                this.checkIsSimpleName();
            }
            if (!orderedHashSet.add(this.token.tokenString)) {
                throw Error.error(5577, this.token.tokenString);
            }
            if (bitMap != null) {
                bitMap.setValue(n, this.isDelimitedIdentifier());
            }
            this.read();
            ++n;
            if (!bl || this.token.tokenType != 408 && this.token.tokenType != 462) continue;
            this.read();
        } while (this.readIfThis(913));
    }

    HsqlNameManager.SimpleName[] readColumnNameList(OrderedHashSet<String> orderedHashSet) {
        BitMap bitMap = new BitMap(0, true);
        this.readThis(926);
        this.readColumnNameList(orderedHashSet, bitMap, false);
        this.readThis(911);
        HsqlNameManager.SimpleName[] simpleNameArray = new HsqlNameManager.SimpleName[orderedHashSet.size()];
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.SimpleName simpleName;
            simpleNameArray[i] = simpleName = HsqlNameManager.getSimpleName(orderedHashSet.get(i), bitMap.isSet(i));
        }
        return simpleNameArray;
    }

    int XreadUnionType() {
        int n = 0;
        switch (this.token.tokenType) {
            case 366: {
                this.read();
                n = 1;
                if (this.token.tokenType == 4) {
                    n = 2;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 102) break;
                this.read();
                break;
            }
            case 163: {
                this.read();
                n = 3;
                if (this.token.tokenType == 4) {
                    n = 4;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 102) break;
                this.read();
                break;
            }
            case 119: 
            case 735: {
                this.read();
                n = 6;
                if (this.token.tokenType == 4) {
                    n = 5;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 102) break;
                this.read();
                break;
            }
        }
        return n;
    }

    void XreadUnionCorrespondingClause(QueryExpression queryExpression) {
        if (this.token.tokenType == 63) {
            this.read();
            queryExpression.setUnionCorresoponding();
            if (this.token.tokenType == 33) {
                this.read();
                OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
                queryExpression.setUnionCorrespondingColumns(orderedHashSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryExpression XreadQueryExpression() {
        try {
            this.XreadWithClause();
            QueryExpression queryExpression = this.XreadQueryExpressionBody();
            SortAndSlice sortAndSlice = this.XreadOrderByExpression();
            if (queryExpression.sortAndSlice == SortAndSlice.noSort) {
                queryExpression.addSortAndSlice(sortAndSlice);
            } else if (queryExpression.sortAndSlice.hasLimit()) {
                if (sortAndSlice.hasLimit()) {
                    throw Error.error(5549);
                }
                for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                    Expression expression = sortAndSlice.exprList.get(i);
                    queryExpression.sortAndSlice.addOrderExpression(expression);
                }
            } else if (sortAndSlice != SortAndSlice.noSort) {
                queryExpression.addSortAndSlice(sortAndSlice);
            }
            QueryExpression queryExpression2 = queryExpression;
            return queryExpression2;
        }
        finally {
            this.compileContext.unregisterSubqueries();
        }
    }

    void XreadWithClause() {
        if (this.token.tokenType == 390) {
            this.read();
            this.compileContext.unregisterSubqueries();
            this.compileContext.registerSubquery("RECURSIVE_TABLE");
            boolean bl = this.readIfThis(275);
            while (true) {
                boolean[] blArray;
                this.checkIsSimpleName();
                HsqlNameManager.HsqlName[] hsqlNameArray = null;
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 27);
                hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
                this.read();
                if (this.token.tokenType == 926) {
                    hsqlNameArray = this.readColumnNames(hsqlName);
                } else if (bl) {
                    throw this.unexpectedTokenRequire("(");
                }
                this.readThis(14);
                this.readThis(926);
                this.compileContext.registerSubquery(hsqlName.name);
                TableDerived tableDerived = this.XreadTableNamedSubqueryBody(hsqlName, hsqlNameArray);
                if (hsqlNameArray == null && ArrayUtil.countTrueElements(blArray = tableDerived.queryExpression.accessibleColumns) < blArray.length) {
                    throw Error.error(5578);
                }
                this.readThis(911);
                if (tableDerived.queryExpression != null && tableDerived.queryExpression.isRecursive()) {
                    this.XreadRecursiveFeatures(tableDerived);
                }
                this.compileContext.registerSubquery(hsqlName.name, tableDerived);
                this.compileContext.registerSubquery("RECURSIVE_TABLE", null);
                if (this.token.tokenType != 913) break;
                this.read();
            }
        }
    }

    void XreadRecursiveFeatures(TableDerived tableDerived) {
        Object object;
        QueryExpression.RecursiveQuerySettings recursiveQuerySettings = null;
        if (this.token.tokenType == 307) {
            this.read();
            recursiveQuerySettings = new QueryExpression.RecursiveQuerySettings();
            switch (this.token.tokenType) {
                case 460: {
                    this.read();
                    recursiveQuerySettings.searchOrderType = 1;
                    break;
                }
                case 415: {
                    this.read();
                    recursiveQuerySettings.searchOrderType = 2;
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("DEPTH or BREADTH");
                }
            }
            this.readThis(479);
            this.readThis(33);
            recursiveQuerySettings.searchOrderSort = this.XreadOrderBy();
            this.readThis(313);
            this.checkIsSimpleName();
            object = this.database.nameManager.newColumnHsqlName(tableDerived.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
            if (tableDerived.findColumn(((HsqlNameManager.HsqlName)object).name) != -1) {
                throw Error.error(5578, this.token.tokenString);
            }
            this.read();
            recursiveQuerySettings.searchOrderSetColumn = new ColumnSchema((HsqlNameManager.HsqlName)object, Type.SQL_INTEGER, true, false, null);
        }
        if (this.token.tokenType == 86) {
            this.read();
            if (recursiveQuerySettings == null) {
                recursiveQuerySettings = new QueryExpression.RecursiveQuerySettings();
            }
            object = new OrderedHashSet<String>();
            this.readColumnNameList((OrderedHashSet<String>)object, null, false);
            recursiveQuerySettings.cycleColumnList = tableDerived.getColumnIndexes((OrderedHashSet<String>)object);
            if (((BaseHashMap)object).size() > 1) {
                throw Error.error(5564, this.token.tokenString);
            }
            recursiveQuerySettings.cycleColumnFirst = tableDerived.getColumn(recursiveQuerySettings.cycleColumnList[0]);
            this.readThis(313);
            this.checkIsSimpleName();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(tableDerived.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
            recursiveQuerySettings.cycleMarkColumn = new ColumnSchema(hsqlName, Type.SQL_CHAR, false, false, null);
            if (tableDerived.findColumn(hsqlName.name) != -1) {
                throw Error.error(5578, this.token.tokenString);
            }
            this.read();
            this.readThis(353);
            recursiveQuerySettings.cycleMarkValue = this.readQuotedString();
            if (recursiveQuerySettings.cycleMarkValue.length() != 1) {
                throw this.unexpectedToken(recursiveQuerySettings.cycleMarkValue);
            }
            this.readThis(94);
            recursiveQuerySettings.noCycleMarkValue = this.readQuotedString();
            if (recursiveQuerySettings.noCycleMarkValue.length() != 1) {
                throw this.unexpectedToken(recursiveQuerySettings.noCycleMarkValue);
            }
            if (recursiveQuerySettings.cycleMarkValue.equals(recursiveQuerySettings.noCycleMarkValue)) {
                throw this.unexpectedToken(recursiveQuerySettings.cycleMarkValue);
            }
            if (this.readIfThis(374)) {
                this.checkIsSimpleName();
                HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newColumnHsqlName(tableDerived.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                if (tableDerived.findColumn(hsqlName2.name) != -1) {
                    throw Error.error(5578, this.token.tokenString);
                }
                this.read();
                ArrayType arrayType = new ArrayType(recursiveQuerySettings.cycleColumnFirst.getDataType(), 0x100000);
                recursiveQuerySettings.cyclePathColumn = new ColumnSchema(hsqlName2, arrayType, false, false, null);
            }
        }
        tableDerived.queryExpression.setRecursiveQuerySettings(recursiveQuerySettings);
    }

    QueryExpression XreadQueryExpressionBody() {
        QueryExpression queryExpression = this.XreadQueryTerm();
        block3: while (true) {
            switch (this.token.tokenType) {
                case 119: 
                case 366: 
                case 735: {
                    queryExpression = this.XreadSetOperation(queryExpression);
                    continue block3;
                }
            }
            break;
        }
        return queryExpression;
    }

    QueryExpression XreadQueryTerm() {
        QueryExpression queryExpression = this.XreadQueryPrimary();
        while (this.token.tokenType == 163) {
            queryExpression = this.XreadSetOperation(queryExpression);
        }
        return queryExpression;
    }

    private QueryExpression XreadSetOperation(QueryExpression queryExpression) {
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        int n = this.XreadUnionType();
        this.XreadUnionCorrespondingClause(queryExpression);
        QueryExpression queryExpression2 = this.XreadQueryTerm();
        queryExpression.addUnion(queryExpression2, n);
        return queryExpression;
    }

    QueryExpression XreadQueryPrimary() {
        switch (this.token.tokenType) {
            case 310: 
            case 344: 
            case 376: {
                QuerySpecification querySpecification = this.XreadSimpleTable();
                return querySpecification;
            }
            case 926: {
                this.read();
                QueryExpression queryExpression = this.XreadQueryExpressionBody();
                SortAndSlice sortAndSlice = this.XreadOrderByExpression();
                this.readThis(911);
                if (queryExpression.sortAndSlice == SortAndSlice.noSort) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                } else if (queryExpression.sortAndSlice.hasLimit()) {
                    if (sortAndSlice.hasLimit()) {
                        throw Error.error(5549);
                    }
                    for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                        Expression expression = sortAndSlice.exprList.get(i);
                        queryExpression.sortAndSlice.addOrderExpression(expression);
                    }
                } else if (sortAndSlice != SortAndSlice.noSort) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                }
                return queryExpression;
            }
        }
        throw this.unexpectedToken();
    }

    QuerySpecification XreadSimpleTable() {
        QuerySpecification querySpecification;
        switch (this.token.tokenType) {
            case 344: {
                this.read();
                Table table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName(true);
                }
                if (table.isView()) {
                    table = ((View)table).newDerivedTable(this.session, this.compileContext);
                }
                querySpecification = new QuerySpecification(this.session, table, this.compileContext, false);
                break;
            }
            case 376: {
                this.read();
                TableDerived tableDerived = this.XreadRowValueExpressionList();
                querySpecification = new QuerySpecification(this.session, tableDerived, this.compileContext, true);
                break;
            }
            case 310: {
                querySpecification = this.XreadQuerySpecification();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return querySpecification;
    }

    QuerySpecification XreadQuerySpecification() {
        QuerySpecification querySpecification = this.XreadSelect();
        if (!querySpecification.isValueList && querySpecification.getCurrentRangeVariableCount() == 0) {
            this.XreadTableExpression(querySpecification);
        }
        return querySpecification;
    }

    void XreadTableExpression(QuerySpecification querySpecification) {
        this.XreadFromClause(querySpecification);
        this.readWhereGroupHaving(querySpecification);
    }

    QuerySpecification XreadSelect() {
        QuerySpecification querySpecification;
        block10: {
            Object object;
            querySpecification = new QuerySpecification(this.compileContext);
            this.readThis(310);
            if ((this.token.tokenType == 822 || this.token.tokenType == 713) && (object = this.XreadTopOrLimit()) != null) {
                querySpecification.addSortAndSlice((SortAndSlice)object);
            }
            if (this.token.tokenType == 102) {
                querySpecification.setDistinctSelect();
                this.read();
            } else if (this.token.tokenType == 4) {
                this.read();
            }
            do {
                object = this.XreadValueExpression();
                if (this.token.tokenType == 14) {
                    if (((Expression)object).getType() == 99) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                if (this.isNonCoreReservedIdentifier()) {
                    if (((Expression)object).getType() == 99) {
                        throw this.unexpectedToken();
                    }
                    ((Expression)object).setAlias(HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier()));
                    this.read();
                }
                querySpecification.addSelectColumnExpression((Expression)object);
                if (this.token.tokenType == 137 || this.token.tokenType == 166) break block10;
            } while (this.readIfThis(913));
            if ((this.token.tokenType == 911 || this.token.tokenType == 1014 || this.token.tokenType == 932) && (this.database.sqlSyntaxMss || this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs)) {
                RangeVariable rangeVariable = new RangeVariable(this.database.schemaManager.dualTable, null, null, null, this.compileContext);
                querySpecification.addRangeVariable(this.session, rangeVariable);
                return querySpecification;
            }
            throw this.unexpectedToken();
        }
        return querySpecification;
    }

    void XreadFromClause(QuerySpecification querySpecification) {
        this.readThis(137);
        do {
            this.XreadTableReference(querySpecification);
        } while (this.readIfThis(913));
    }

    void XreadTableReference(QuerySpecification querySpecification) {
        boolean bl = false;
        RangeVariable rangeVariable = this.readTableOrSubquery();
        querySpecification.addRangeVariable(this.session, rangeVariable);
        block15: while (true) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = this.token.tokenType;
            switch (this.token.tokenType) {
                case 222: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl = true;
                    continue block15;
                }
                case 157: {
                    this.read();
                    this.readThis(169);
                    break;
                }
                case 70: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(169);
                    break;
                }
                case 366: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    int n2 = this.getPosition();
                    this.read();
                    if (this.token.tokenType == 169) {
                        this.read();
                        bl2 = true;
                        bl3 = true;
                        break;
                    }
                    this.rewind(n2);
                    bl4 = true;
                    break;
                }
                case 191: {
                    this.read();
                    this.readIfThis(248);
                    this.readThis(169);
                    bl2 = true;
                    break;
                }
                case 295: {
                    this.read();
                    this.readIfThis(248);
                    this.readThis(169);
                    bl3 = true;
                    break;
                }
                case 138: {
                    this.read();
                    this.readIfThis(248);
                    this.readThis(169);
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 169: {
                    this.read();
                    n = 157;
                    break;
                }
                default: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    bl4 = true;
                }
            }
            if (bl4) break;
            RangeVariable rangeVariable2 = this.readTableOrSubquery();
            Expression expression = null;
            rangeVariable2.setJoinType(bl2, bl3);
            switch (n) {
                case 70: {
                    querySpecification.addRangeVariable(this.session, rangeVariable2);
                    break;
                }
                case 366: {
                    expression = Expression.EXPR_FALSE;
                    rangeVariable2.addJoinCondition(expression);
                    querySpecification.addRangeVariable(this.session, rangeVariable2);
                    break;
                }
                case 138: 
                case 157: 
                case 191: 
                case 295: {
                    OrderedHashSet<String> orderedHashSet;
                    boolean bl5;
                    boolean bl6 = bl5 = this.token.tokenType == 374;
                    if (bl || bl5) {
                        rangeVariable.resolveRangeTable(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges());
                        rangeVariable2.resolveRangeTable(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges());
                    }
                    if (bl) {
                        orderedHashSet = rangeVariable2.getUniqueColumnNameSet();
                        expression = querySpecification.getEquiJoinExpressions(orderedHashSet, rangeVariable2, false);
                        rangeVariable2.addJoinCondition(expression);
                        querySpecification.addRangeVariable(this.session, rangeVariable2);
                        break;
                    }
                    if (bl5) {
                        this.read();
                        orderedHashSet = new OrderedHashSet();
                        this.readThis(926);
                        this.readSimpleColumnNames(orderedHashSet, rangeVariable2, false);
                        this.readThis(911);
                        expression = querySpecification.getEquiJoinExpressions(orderedHashSet, rangeVariable2, true);
                        rangeVariable2.addJoinCondition(expression);
                        querySpecification.addRangeVariable(this.session, rangeVariable2);
                        break;
                    }
                    if (this.token.tokenType == 241) {
                        this.read();
                        expression = this.XreadBooleanValueExpression();
                        rangeVariable2.addJoinCondition(expression);
                        querySpecification.addRangeVariable(this.session, rangeVariable2);
                        break;
                    }
                    throw this.unexpectedToken();
                }
            }
            bl = false;
        }
    }

    Expression getRowExpression(OrderedHashSet<String> orderedHashSet) {
        Expression[] expressionArray = new Expression[orderedHashSet.size()];
        for (int i = 0; i < expressionArray.length; ++i) {
            String string = orderedHashSet.get(i);
            expressionArray[i] = new ExpressionColumn(null, null, string);
        }
        return new Expression(25, expressionArray);
    }

    void readWhereGroupHaving(QuerySpecification querySpecification) {
        Object object;
        if (this.token.tokenType == 386) {
            this.read();
            object = this.XreadBooleanValueExpression();
            querySpecification.addQueryCondition((Expression)object);
        }
        if (this.token.tokenType == 145) {
            Expression[] expressionArray;
            this.read();
            this.readThis(33);
            if (this.readIfThis(102)) {
                querySpecification.setDistinctGroups();
            } else {
                this.readIfThis(4);
            }
            object = new HsqlArrayList();
            while (true) {
                expressionArray = this.XreadGroupByExpressionPrimary();
                ((HsqlArrayList)object).add(expressionArray);
                if (this.token.tokenType != 913) break;
                this.read();
            }
            expressionArray = new Expression[((HsqlArrayList)object).size()];
            ((HsqlArrayList)object).toArray(expressionArray);
            querySpecification.addGroupingSets(expressionArray);
        }
        if (this.token.tokenType == 149) {
            this.read();
            object = this.XreadBooleanValueExpression();
            querySpecification.addHavingExpression((Expression)object);
        }
    }

    SortAndSlice XreadOrderByExpression() {
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 246) {
            this.read();
            this.readThis(33);
            sortAndSlice = this.XreadOrderBy();
        }
        if (this.token.tokenType == 713 || this.token.tokenType == 128 || this.token.tokenType == 238) {
            if (sortAndSlice == null) {
                sortAndSlice = new SortAndSlice();
            }
            this.XreadLimit(sortAndSlice);
        }
        return sortAndSlice == null ? SortAndSlice.noSort : sortAndSlice;
    }

    private SortAndSlice XreadTopOrLimit() {
        int n;
        Expression expression = null;
        Expression expression2 = null;
        if (this.token.tokenType == 713) {
            n = this.getPosition();
            this.read();
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                this.rewind(n);
                return null;
            }
            this.readIfThis(913);
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(5563, 81);
            }
        } else if (this.token.tokenType == 822) {
            n = this.getPosition();
            this.read();
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                this.rewind(n);
                return null;
            }
            expression = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        } else {
            throw this.unexpectedToken();
        }
        n = 1;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, Type.SQL_INTEGER);
        } else if (expression.opType == 1) {
            n = expression.getDataType().typeCode == 4 && (Integer)expression.getValue(null) >= 0 ? 1 : 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (expression2.isUnresolvedParam()) {
            expression2.setDataType(this.session, Type.SQL_INTEGER);
        } else if (expression2.opType == 1) {
            n &= expression2.getDataType().typeCode == 4 && (Integer)expression2.getValue(null) >= 0 ? 1 : 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (n != 0) {
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.addLimitCondition(new ExpressionOp(96, expression, expression2));
            return sortAndSlice;
        }
        throw Error.error(5563, 81);
    }

    private void XreadLimit(SortAndSlice sortAndSlice) {
        boolean bl;
        Expression expression = null;
        Expression expression2 = null;
        if (this.token.tokenType == 238) {
            this.read();
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(5563, 81);
            }
            if (this.token.tokenType == 298 || this.token.tokenType == 299) {
                this.read();
            }
        }
        if (this.token.tokenType == 713) {
            this.read();
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(5563, 81);
            }
            if (expression == null) {
                if (this.token.tokenType == 913) {
                    this.read();
                    expression = expression2;
                    expression2 = this.XreadSimpleValueSpecificationOrNull();
                } else if (this.token.tokenType == 238) {
                    this.read();
                    expression = this.XreadSimpleValueSpecificationOrNull();
                }
            }
            if (this.database.sqlSyntaxPgs || this.database.sqlSyntaxMys) {
                sortAndSlice.setZeroLimitIsZero();
            }
        } else if (this.token.tokenType == 128) {
            this.read();
            bl = false;
            if (this.token.tokenType == 479 || this.token.tokenType == 534) {
                bl = true;
                this.read();
            }
            if ((expression2 = this.XreadSimpleValueSpecificationOrNull()) == null) {
                if (!bl) {
                    throw super.unexpectedTokenRequire("FIRST");
                }
                expression2 = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            if (this.token.tokenType == 298 || this.token.tokenType == 299) {
                this.read();
            }
            this.readThis(243);
            sortAndSlice.setStrictLimit();
        }
        if (sortAndSlice.hasOrder() && this.token.tokenType == 374) {
            this.read();
            this.readThis(697);
            sortAndSlice.setUsingIndex();
        }
        if (expression == null) {
            expression = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        bl = true;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (expression2 != null && expression2.isUnresolvedParam()) {
            expression2.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (bl) {
            sortAndSlice.addLimitCondition(new ExpressionOp(96, expression, expression2));
            return;
        }
        throw Error.error(5563, 81);
    }

    private SortAndSlice XreadOrderBy() {
        SortAndSlice sortAndSlice = new SortAndSlice();
        while (true) {
            boolean bl = false;
            boolean bl2 = false;
            Expression expression = this.XreadValueExpression();
            ExpressionOrderBy expressionOrderBy = new ExpressionOrderBy(expression);
            if (this.token.tokenType == 462) {
                expressionOrderBy.setDescending();
                bl = true;
                this.read();
            } else if (this.token.tokenType == 408) {
                this.read();
            }
            bl2 = this.database.sqlNullsOrder ? !this.database.sqlNullsFirst : this.database.sqlNullsFirst == bl;
            expressionOrderBy.setNullsLast(bl2);
            if (this.token.tokenType == 542) {
                this.read();
                if (this.token.tokenType == 479) {
                    this.read();
                    expressionOrderBy.setNullsLast(false);
                } else if (this.token.tokenType == 514) {
                    this.read();
                    expressionOrderBy.setNullsLast(true);
                } else {
                    throw this.unexpectedToken();
                }
            }
            sortAndSlice.addOrderExpression(expressionOrderBy);
            if (this.token.tokenType != 913) break;
            this.read();
        }
        return sortAndSlice;
    }

    protected RangeVariable readRangeVariableForDataChange(int n) {
        Table table = this.readTableName(true);
        ExpressionPeriodOp expressionPeriodOp = this.XreadQueryApplicationPeriodSpecOrNull(table);
        HsqlNameManager.SimpleName simpleName = null;
        if (expressionPeriodOp != null) {
            throw Error.error(1551);
        }
        if (n != 1215) {
            switch (this.token.tokenType) {
                case 554: {
                    break;
                }
                case 14: {
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                default: {
                    if (!this.isNonCoreReservedIdentifier() || this.database.sqlSyntaxMys && n == 55) break;
                    simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
                    this.read();
                }
            }
            if (simpleName == null && this.lastSynonym != null) {
                simpleName = HsqlNameManager.getSimpleName(this.lastSynonym.name, this.lastSynonym.isNameQuoted);
            }
        }
        if (table.isView) {
            switch (n) {
                case 56: {
                    if (table.isTriggerUpdatable() && table.isTriggerInsertable() || !table.isTriggerUpdatable() && !table.isTriggerInsertable() && table.isUpdatable() && table.isInsertable()) break;
                    throw Error.error(5545);
                }
                case 92: {
                    if (table.isTriggerUpdatable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 19: {
                    if (table.isTriggerDeletable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 55: {
                    if (table.isTriggerInsertable() || table.isInsertable() || this.session.isProcessingScript()) break;
                    throw Error.error(5545);
                }
                case 1215: {
                    throw Error.error(5545);
                }
            }
            table = ((View)table).newDerivedTable(this.session, this.compileContext);
        }
        RangeVariable rangeVariable = new RangeVariable(table, simpleName, null, null, this.compileContext);
        if (table.isSystemVersioned()) {
            ExpressionPeriodOp expressionPeriodOp2 = new ExpressionPeriodOp();
            expressionPeriodOp2.setSystemRangeVariable(this.session, RangeGroup.emptyArray, rangeVariable);
            rangeVariable.setSystemPeriodCondition(expressionPeriodOp2);
        }
        return rangeVariable;
    }

    protected Table readNamedSubqueryOrNull() {
        if (!this.isSimpleName()) {
            return null;
        }
        TableDerived tableDerived = this.compileContext.getNamedSubQuery(this.token.tokenString);
        if (tableDerived == null) {
            return null;
        }
        this.read();
        if (tableDerived.isRecompiled()) {
            tableDerived = tableDerived.newDerivedTable(this.session, this.compileContext);
        }
        return tableDerived;
    }

    protected RangeVariable readTableOrSubquery() {
        RangeVariable rangeVariable;
        Table table = null;
        HsqlNameManager.SimpleName simpleName = null;
        HsqlNameManager.SimpleName[] simpleNameArray = null;
        OrderedHashSet<String> orderedHashSet = null;
        ExpressionPeriodOp expressionPeriodOp = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.token.tokenType) {
            case 926: {
                table = this.XreadTableSubqueryOrNull(false);
                if (table != null) break;
                table = this.XreadJoinedTableAsSubqueryOrNull();
                if (table == null) {
                    table = this.XreadTableSubqueryOrNull(true);
                    if (table != null) break;
                    throw this.unexpectedToken();
                }
                bl = true;
                break;
            }
            case 369: {
                Expression expression = this.XreadCollectionDerivedTable(23);
                table = expression.getTable();
                bl2 = true;
                break;
            }
            case 186: {
                Expression expression = this.XreadLateralDerivedTable();
                table = expression.getTable();
                bl2 = true;
                break;
            }
            case 344: {
                Expression expression = this.XreadTableFunctionDerivedTable();
                table = expression.getTable();
                bl2 = true;
                break;
            }
            default: {
                table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName(true);
                    bl3 = true;
                    expressionPeriodOp = this.XreadQuerySystemPeriodSpecOrNull(table);
                }
                if (!table.isView()) break;
                table = ((View)table).newDerivedTable(this.session, this.compileContext);
            }
        }
        boolean bl4 = false;
        if (this.token.tokenType == 14) {
            this.read();
            this.checkIsNonCoreReservedIdentifier();
            bl4 = true;
        }
        if (this.isNonCoreReservedIdentifier()) {
            boolean bl5 = this.token.tokenType == 713 || this.token.tokenType == 238 || this.token.tokenType == 128;
            boolean bl6 = this.token.tokenType == 735;
            int n = this.getPosition();
            simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            if (this.token.tokenType == 926) {
                orderedHashSet = new OrderedHashSet<String>();
                simpleNameArray = this.readColumnNameList(orderedHashSet);
            } else if (!bl4 && bl5) {
                if (this.token.tokenType == 912 || this.token.tokenType == 928 || this.token.tokenType == 1011) {
                    simpleName = null;
                    this.rewind(n);
                }
            } else if (!bl4 && bl6) {
                this.rewind(n);
            }
        }
        if (bl3 && simpleName == null && this.lastSynonym != null) {
            simpleName = HsqlNameManager.getSimpleName(this.lastSynonym.name, this.lastSynonym.isNameQuoted);
        }
        if (this.database.sqlSyntaxMss && this.readIfThis(390)) {
            this.readNestedParenthesisedTokens();
        }
        if (bl) {
            rangeVariable = new RangeVariableJoined(table, simpleName, orderedHashSet, simpleNameArray, this.compileContext);
        } else {
            rangeVariable = new RangeVariable(table, simpleName, orderedHashSet, simpleNameArray, this.compileContext);
            if (expressionPeriodOp != null) {
                RangeGroup[] rangeGroupArray = this.compileContext.getOuterRanges();
                expressionPeriodOp.setSystemRangeVariable(this.session, rangeGroupArray, rangeVariable);
                rangeVariable.setSystemPeriodCondition(expressionPeriodOp);
            }
        }
        if (bl2) {
            rangeVariable.isLateral = true;
        }
        return rangeVariable;
    }

    private Expression readAggregateFunctionOrNull() {
        int n = this.getPosition();
        int n2 = this.token.tokenType;
        this.read();
        if (this.token.tokenType != 926) {
            this.rewind(n);
            return null;
        }
        this.readThis(926);
        Expression expression = this.readAggregateExpression(n2);
        this.readThis(911);
        this.readFilterClause(expression);
        return expression;
    }

    private void readFilterClause(Expression expression) {
        Expression expression2 = this.XreadFilterExpressionOrNull();
        if (expression2 != null) {
            expression.setCondition(expression2);
        }
    }

    Expression XreadFilterExpressionOrNull() {
        int n = this.getPosition();
        Expression expression = null;
        if (this.token.tokenType == 129) {
            this.read();
            if (this.token.tokenType != 926) {
                this.rewind(n);
                return null;
            }
            this.readThis(926);
            this.readThis(386);
            expression = this.XreadBooleanValueExpression();
            this.readThis(911);
        }
        return expression;
    }

    private Expression readAggregateExpression(int n) {
        int n2 = ParserDQL.getExpressionType(n);
        boolean bl = false;
        boolean bl2 = false;
        SortAndSlice sortAndSlice = null;
        String string = null;
        if (this.token.tokenType == 102) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 4) {
            bl2 = true;
            this.read();
        }
        int n3 = this.getPosition();
        Expression expression = this.XreadValueExpression();
        switch (n2) {
            case 74: {
                if (expression.getType() == 99) {
                    if (((ExpressionColumn)expression).tableName != null) {
                        throw this.unexpectedToken();
                    }
                    if (bl2 || bl) {
                        throw this.unexpectedToken();
                    }
                    expression.opType = 11;
                    break;
                }
                if (this.token.tokenType != 913) break;
                this.rewind(n3);
                expression = this.XreadRowElementList(false);
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 106: 
            case 107: {
                if (!bl2 && !bl) break;
                throw this.unexpectedToken(bl2 ? "ALL" : "DISTINCT");
            }
            case 85: 
            case 86: {
                if (this.token.tokenType == 246) {
                    this.read();
                    this.readThis(33);
                    sortAndSlice = this.XreadOrderBy();
                }
                if (n2 == 86 && this.token.tokenType == 790) {
                    this.read();
                    this.checkIsQuotedString();
                    string = (String)this.token.tokenValue;
                    this.read();
                }
                return new ExpressionArrayAggregate(n2, bl, expression, sortAndSlice, string);
            }
            case 87: {
                this.readThis(913);
                this.checkIsQuotedString();
                string = (String)this.token.tokenValue;
                this.read();
                if (this.token.tokenType == 246) {
                    this.read();
                    this.readThis(33);
                    sortAndSlice = this.XreadOrderBy();
                }
                return new ExpressionArrayAggregate(86, bl, expression, sortAndSlice, string);
            }
            case 89: {
                return new ExpressionArrayAggregate(n2, bl, expression, sortAndSlice, string);
            }
            default: {
                if (expression.getType() != 99 && expression.getType() != 11) break;
                throw this.unexpectedToken("*");
            }
        }
        ExpressionAggregate expressionAggregate = new ExpressionAggregate(n2, bl, expression);
        return expressionAggregate;
    }

    Expression XreadValueSpecificationOrNull() {
        Expression expression = null;
        boolean bl = false;
        switch (this.token.tokenType) {
            case 927: {
                this.read();
                break;
            }
            case 924: {
                this.read();
                bl = true;
                break;
            }
        }
        expression = this.XreadUnsignedValueSpecificationOrNull();
        if (expression == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionArithmetic(31, expression);
        }
        return expression;
    }

    Expression XreadUnsignedValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 362: {
                this.read();
                return new ExpressionBoolean(true);
            }
            case 127: {
                this.read();
                return new ExpressionBoolean(false);
            }
            case 94: {
                if (!this.compileContext.contextuallyTypedExpression) break;
                this.read();
                ExpressionColumn expressionColumn = new ExpressionColumn(4);
                return expressionColumn;
            }
            case 376: {
                if (!this.compileContext.onDuplicateTypedExpression) break;
                this.read();
                this.readThis(926);
                this.checkIsSimpleName();
                ExpressionColumn expressionColumn = new ExpressionColumn(this.token.tokenString);
                this.read();
                this.readThis(911);
                return expressionColumn;
            }
            case 232: {
                ExpressionValue expressionValue = new ExpressionValue(null, null);
                this.read();
                return expressionValue;
            }
            case 1011: {
                ExpressionValue expressionValue = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return expressionValue;
            }
            case 1012: 
            case 1013: {
                if (!this.token.isHostParameter) {
                    return null;
                }
                return null;
            }
            case 912: 
            case 928: {
                return this.XreadDynamicParameterOrNull();
            }
            case 429: {
                return this.XreadCurrentCollationSpec();
            }
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 83: 
            case 84: 
            case 312: 
            case 343: 
            case 373: 
            case 375: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    return null;
                }
                return this.readSQLFunction(functionSQL);
            }
        }
        return null;
    }

    Expression XreadDynamicParameterOrNull() {
        switch (this.token.tokenType) {
            case 912: {
                this.read();
                if (this.isIntegral()) {
                    int n = this.readInteger();
                    ExpressionColumn expressionColumn = new ExpressionColumn(8, n);
                    this.compileContext.addParameter(expressionColumn, this.getPosition());
                    return expressionColumn;
                }
                if (this.isUndelimitedSimpleName()) {
                    int n = this.compileContext.parameters.size();
                    ExpressionColumn expressionColumn = new ExpressionColumn(8, n);
                    this.compileContext.addParameter(expressionColumn, this.getPosition());
                    Token token = new Token();
                    token.tokenType = 1011;
                    token.dataType = Type.SQL_INTEGER;
                    token.tokenString = String.valueOf(expressionColumn.parameterIndex);
                    this.replaceToken(token, null);
                    this.read();
                    return expressionColumn;
                }
                throw this.unexpectedToken(":");
            }
            case 928: {
                int n = this.compileContext.parameters.size();
                ExpressionColumn expressionColumn = new ExpressionColumn(8, n);
                this.compileContext.addParameter(expressionColumn, this.getPosition());
                Token token = new Token();
                token.tokenType = 912;
                token.tokenString = ":";
                Token token2 = new Token();
                token2.tokenType = 1011;
                token2.dataType = Type.SQL_INTEGER;
                token2.tokenValue = expressionColumn.parameterIndex;
                token2.tokenString = String.valueOf(expressionColumn.parameterIndex);
                this.replaceToken(token, token2);
                this.read();
                return expressionColumn;
            }
        }
        return null;
    }

    Expression XreadSimpleValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 1011: {
                ExpressionValue expressionValue = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return expressionValue;
            }
            case 912: 
            case 928: {
                return this.XreadDynamicParameterOrNull();
            }
            case 1012: 
            case 1013: {
                this.checkValidCatalogName(this.token.namePrePrePrefix);
                ExpressionColumn expressionColumn = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
                this.read();
                return expressionColumn;
            }
        }
        return null;
    }

    Expression XreadAllTypesValueExpressionPrimary(boolean bl) {
        Expression expression = null;
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 122: 
            case 367: {
                if (!bl) break;
                return this.XreadPredicate();
            }
            case 260: {
                if (bl) break;
                this.read();
                if (this.readIfThis(926)) {
                    expression = this.XreadRowElementList(true);
                    if (expression.nodes.length != 2) {
                        throw Error.error(5564);
                    }
                    expression = new ExpressionPeriod(expression);
                    this.readThis(911);
                    break;
                }
                this.rewind(n);
                expression = this.XreadSimpleValueExpressionPrimary();
                if (expression == null) break;
                expression = this.XreadArrayElementReference(expression);
                break;
            }
            case 298: {
                if (bl) break;
                this.read();
                this.readThis(926);
                expression = this.XreadRowElementList(true);
                this.readThis(911);
                break;
            }
            default: {
                expression = this.XreadSimpleValueExpressionPrimary();
                if (expression == null) break;
                expression = this.XreadArrayElementReference(expression);
            }
        }
        if (expression == null) {
            if (this.token.tokenType == 298) {
                this.read();
                this.checkIsThis(926);
            } else if (this.token.tokenType == 260) {
                this.read();
                if (this.readIfThis(926)) {
                    expression = this.XreadRowElementList(true);
                    if (expression.nodes.length != 2) {
                        throw Error.error(5564);
                    }
                    expression = new ExpressionPeriod(expression);
                    this.readThis(911);
                } else {
                    this.rewind(n);
                    expression = this.XreadSimpleValueExpressionPrimary();
                    if (expression != null) {
                        expression = this.XreadArrayElementReference(expression);
                    }
                }
            }
            if (this.token.tokenType == 926) {
                this.read();
                expression = this.XreadRowElementList(true);
                this.readThis(911);
            }
        }
        if (bl && expression != null) {
            expression = this.XreadPredicateRightPart(expression);
        }
        return expression;
    }

    Expression XreadValueExpressionPrimary() {
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
            return expression;
        }
        if (this.token.tokenType != 926) {
            return null;
        }
        this.read();
        expression = this.XreadValueExpression();
        this.readThis(911);
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Expression XreadSimpleValueExpressionPrimary() {
        Expression expression = this.XreadUnsignedValueSpecificationOrNull();
        if (expression != null) {
            return expression;
        }
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 926: {
                this.read();
                int n2 = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 310: 
                    case 344: 
                    case 376: 
                    case 390: {
                        TableDerived tableDerived = null;
                        this.rewind(n2);
                        try {
                            tableDerived = this.XreadSubqueryTableBody(21);
                            this.readThis(911);
                        }
                        catch (HsqlException hsqlException) {
                            hsqlException.setLevel(this.compileContext.subqueryDepth);
                            if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                                this.lastError = hsqlException;
                            }
                            this.rewind(n);
                            return null;
                        }
                        if (tableDerived.queryExpression != null) {
                            expression = tableDerived.queryExpression.isSingleColumn() ? new Expression(21, tableDerived) : new Expression(22, tableDerived);
                        }
                        if (expression != null) {
                            return expression;
                        }
                        this.rewind(n);
                        return null;
                    }
                }
                this.rewind(n);
                return null;
            }
            case 910: {
                expression = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix);
                this.getRecordedToken().setExpression(expression);
                this.read();
                return expression;
            }
            case 189: {
                expression = this.readLeastExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 144: {
                expression = this.readGreatestExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 669: {
                expression = this.readDecodeExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 636: {
                expression = this.readConcatExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 637: {
                expression = this.readConcatSeparatorExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 493: 
            case 627: {
                expression = this.readCaseWhenExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 38: {
                return this.readCaseExpression();
            }
            case 233: {
                return this.readNullIfExpression();
            }
            case 50: {
                return this.readCoalesceExpression();
            }
            case 695: 
            case 703: {
                expression = this.readIfNullExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 755: {
                expression = this.readIfNull2ExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 39: {
                expression = this.readCastExpression();
                if (expression == null) break;
                return expression;
            }
            case 61: {
                expression = this.readConvertExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 87: 
            case 165: 
            case 349: 
            case 350: {
                expression = this.readDateTimeIntervalLiteral(this.session);
                if (expression == null) break;
                return expression;
            }
            case 11: {
                return this.readCollection(19);
            }
            case 8: 
            case 9: 
            case 12: 
            case 22: 
            case 66: 
            case 118: 
            case 209: 
            case 214: 
            case 321: 
            case 332: 
            case 333: 
            case 339: 
            case 381: 
            case 382: 
            case 689: 
            case 728: 
            case 801: 
            case 803: 
            case 848: {
                expression = this.readAggregateFunctionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 534: {
                expression = this.readSequenceExpressionOrNull(12);
                if (expression == null) break;
                return expression;
            }
            case 73: 
            case 762: {
                expression = this.readSequenceExpressionOrNull(13);
                if (expression == null) break;
                return expression;
            }
            case 644: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(926);
                String string = this.readQuotedString();
                Scanner scanner = this.session.getScanner();
                scanner.reset(this.session, string);
                scanner.scanNext();
                String string2 = this.session.getSchemaName(scanner.token.namePrefix);
                NumberSequence numberSequence = this.database.schemaManager.getSequence(scanner.token.tokenString, string2, true);
                expression = new ExpressionColumn(numberSequence, 13);
                this.readThis(911);
                return expression;
            }
            case 710: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(926);
                this.readThis(911);
                return FunctionCustom.newCustomFunction(this.session, "IDENTITY", 152);
            }
            case 747: {
                if (this.database.sqlSyntaxPgs) {
                    return this.readNextvalFunction();
                }
                if (!this.database.sqlSyntaxDb2 || (expression = this.readSequenceExpressionOrNull(12)) == null) break;
                return expression;
            }
            case 300: {
                this.read();
                if (this.token.tokenType == 926) {
                    this.read();
                    this.readThis(911);
                    this.readThis(249);
                    this.readThis(926);
                    this.readThis(911);
                    return new ExpressionColumn(14);
                }
                this.rewind(n);
                break;
            }
            case 787: {
                this.read();
                if (this.token.tokenType == 926) {
                    this.read();
                    if (this.token.tokenType == 911) {
                        this.read();
                        return new ExpressionColumn(14);
                    }
                    this.rewind(n);
                    break;
                }
                if (this.database.sqlSyntaxOra) return new ExpressionColumn(14);
                if (this.database.sqlSyntaxDb2) return new ExpressionColumn(14);
                this.rewind(n);
                break;
            }
            case 191: 
            case 295: {
                break;
            }
            case 344: {
                this.read();
                this.readThis(926);
                TableDerived tableDerived = this.XreadSubqueryTableBody(23);
                this.readThis(911);
                return new Expression(23, tableDerived);
            }
            case 376: {
                throw this.unexpectedToken();
            }
            case 146: {
                this.read();
                this.readThis(926);
                Expression expression2 = this.XreadRowElementList(true);
                this.readThis(911);
                return new ExpressionColumn(expression2);
            }
            case 171: {
                this.read();
                return this.readJSONArray();
            }
            case 172: {
                this.read();
                return this.readJSONArrayAgg();
            }
            case 174: {
                this.read();
                return this.readJSONObject();
            }
            case 175: {
                this.read();
                return this.readJSONObjectAgg();
            }
            default: {
                if (!this.isCoreReservedKey()) break;
                throw this.unexpectedToken();
            }
        }
        if (!(expression = this.readColumnOrFunctionExpression()).isSelfAggregate()) return expression;
        this.readFilterClause(expression);
        return expression;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Expression readJSONArray() {
        var1_1 = new HsqlArrayList<Expression>();
        var2_2 = null;
        var3_3 = true;
        var4_4 /* !! */  = Type.SQL_VARCHAR_LONG;
        this.readThis(926);
        var5_5 = this.getPosition();
        block6: while (true) {
            switch (this.token.tokenType) {
                case 2: 
                case 232: 
                case 911: {
                    break block6;
                }
                case 913: {
                    if (var1_1.isEmpty()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
                default: {
                    try {
                        var6_6 /* !! */  = this.XreadValueExpression();
                        var1_1.add(var6_6 /* !! */ );
                        continue block6;
                    }
                    catch (HsqlException var7_7) {
                        if (var1_1.size() > 0) {
                            throw var7_7;
                        }
                        this.rewind(var5_5);
                        ** break;
lbl26:
                        // 1 sources

                        break block6;
                    }
                }
            }
        }
        if (var1_1.isEmpty() && this.token.tokenType != 911) {
            var6_6 /* !! */  = this.XreadSubqueryTableBody(23);
            var2_2 = new Expression(102, (TableDerived)var6_6 /* !! */ );
        }
        var3_3 = this.readJSONNullClause(var3_3);
        if (this.readIfThis(593)) {
            var4_4 /* !! */  = this.readJSONReturningClause();
        }
        this.readThis(911);
        if (var2_2 == null) {
            return new ExpressionJSON.ExpressionJSONArrayFromValues(var1_1, var3_3, var4_4 /* !! */ );
        }
        return new ExpressionJSON.ExpressionJSONArrayFromQuery(var2_2, var3_3, var4_4 /* !! */ );
    }

    Expression readJSONArrayAgg() {
        boolean bl = false;
        Type type = Type.SQL_VARCHAR_LONG;
        SortAndSlice sortAndSlice = null;
        this.readThis(926);
        Expression expression = this.XreadValueExpression();
        if (this.token.tokenType == 246) {
            this.read();
            this.readThis(33);
            sortAndSlice = this.XreadOrderBy();
        }
        ExpressionArrayAggregate expressionArrayAggregate = new ExpressionArrayAggregate(85, false, expression, sortAndSlice, null);
        bl = this.readJSONNullClause(bl);
        if (this.readIfThis(593)) {
            type = this.readJSONReturningClause();
        }
        this.readThis(911);
        return new ExpressionJSON.ExpressionJSONArrayAgg(expressionArrayAggregate, bl, type);
    }

    Expression readJSONObject() {
        OrderedHashMap<Expression, Expression> orderedHashMap = new OrderedHashMap<Expression, Expression>();
        boolean bl = true;
        boolean bl2 = false;
        Type type = Type.SQL_VARCHAR_LONG;
        boolean bl3 = false;
        this.readThis(926);
        block4: while (true) {
            boolean bl4 = false;
            switch (this.token.tokenType) {
                case 2: 
                case 232: 
                case 390: 
                case 392: 
                case 911: {
                    break block4;
                }
                case 913: {
                    if (orderedHashMap.isEmpty()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
                default: {
                    Expression expression;
                    if (this.readIfThis(510)) {
                        bl4 = true;
                    }
                    int n = this.getPosition();
                    Expression expression2 = this.XreadCharacterValueExpression();
                    if (expression2.opType == 103) {
                        this.rewind(n);
                        throw this.unexpectedToken();
                    }
                    if (!this.readIfThis(375)) {
                        if (bl4) {
                            throw this.unexpectedToken();
                        }
                        this.readThis(912);
                    }
                    Expression expression3 = this.XreadValueExpression();
                    if (this.readIfThis(482)) {
                        this.readThis(170);
                        expression3 = new ExpressionJSON.ExpressionJSONWrapper(expression3);
                    }
                    if ((expression = orderedHashMap.put(expression2, expression3)) == null) continue block4;
                    bl3 = true;
                    continue block4;
                }
            }
            break;
        }
        bl = this.readJSONNullClause(bl);
        bl2 = this.readJSONUniqueClause(bl2);
        if (bl2 && bl3) {
            throw Error.error(104);
        }
        if (this.readIfThis(593)) {
            type = this.readJSONReturningClause();
        }
        this.readThis(911);
        return new ExpressionJSON.ExpressionJSONObject(orderedHashMap, bl, bl2, type);
    }

    Expression readJSONObjectAgg() {
        boolean bl = true;
        boolean bl2 = false;
        Type type = Type.SQL_VARCHAR_LONG;
        this.readThis(926);
        int n = this.getPosition();
        Expression expression = this.XreadCharacterValueExpression();
        if (expression.opType == 103) {
            this.rewind(n);
            throw this.unexpectedToken();
        }
        this.readThis(912);
        Expression expression2 = this.XreadValueExpression();
        ExpressionArrayAggregate expressionArrayAggregate = new ExpressionArrayAggregate(85, false, expression, null, null);
        ExpressionArrayAggregate expressionArrayAggregate2 = new ExpressionArrayAggregate(85, false, expression2, null, null);
        bl = this.readJSONNullClause(bl);
        bl2 = this.readJSONUniqueClause(bl2);
        if (this.readIfThis(593)) {
            type = this.readJSONReturningClause();
        }
        this.readThis(911);
        return new ExpressionJSON.ExpressionJSONObjectAgg(expressionArrayAggregate, expressionArrayAggregate2, bl, bl2, type);
    }

    boolean readJSONNullClause(boolean bl) {
        boolean bl2 = bl;
        switch (this.token.tokenType) {
            case 2: {
                this.read();
                this.readThis(241);
                this.readThis(232);
                bl2 = false;
                break;
            }
            case 232: {
                this.read();
                this.readThis(241);
                this.readThis(232);
                bl2 = true;
            }
        }
        return bl2;
    }

    boolean readJSONUniqueClause(boolean bl) {
        boolean bl2 = bl;
        switch (this.token.tokenType) {
            case 390: {
                this.read();
                this.readThis(367);
                this.readIfThis(513);
                bl2 = true;
                break;
            }
            case 392: {
                this.read();
                this.readThis(367);
                this.readIfThis(513);
                bl2 = false;
            }
        }
        return bl2;
    }

    Type readJSONReturningClause() {
        int n = this.getPosition();
        Type type = this.readTypeDefinition(false, true);
        if (type.typeCode == 12 || type.typeCode == 40) {
            return type;
        }
        this.rewind(n);
        throw super.unexpectedTokenRequire("VARCHAR or CLOB");
    }

    Expression readNextvalFunction() {
        this.read();
        this.readThis(926);
        String string = this.readQuotedString();
        Scanner scanner = this.session.getScanner();
        scanner.reset(this.session, string);
        scanner.scanNext();
        String string2 = this.session.getSchemaName(scanner.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(scanner.token.tokenString, string2, true);
        ExpressionColumn expressionColumn = new ExpressionColumn(numberSequence, 12);
        this.readThis(911);
        return expressionColumn;
    }

    Expression XreadAllTypesPrimary(boolean bl) {
        Expression expression = null;
        switch (this.token.tokenType) {
            case 1: 
            case 13: 
            case 36: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 124: 
            case 126: 
            case 132: 
            case 195: 
            case 202: 
            case 210: 
            case 216: 
            case 228: 
            case 235: 
            case 236: 
            case 251: 
            case 262: 
            case 263: 
            case 264: 
            case 328: 
            case 336: 
            case 337: 
            case 356: 
            case 360: 
            case 372: 
            case 388: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unsupportedFeature();
                }
                expression = this.readSQLFunction(functionSQL);
                if (expression != null) break;
            }
            default: {
                expression = this.XreadAllTypesValueExpressionPrimary(bl);
            }
        }
        expression = this.XreadModifier(expression);
        return expression;
    }

    Expression XreadModifier(Expression expression) {
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 18: {
                this.read();
                Expression expression2 = null;
                if (this.token.tokenType == 196) {
                    this.read();
                } else if (this.token.tokenType == 349) {
                    this.read();
                    this.readThis(563);
                    expression2 = this.XreadValueExpressionPrimary();
                    switch (this.token.tokenType) {
                        case 88: 
                        case 151: 
                        case 215: 
                        case 219: 
                        case 308: 
                        case 393: {
                            IntervalType intervalType = this.readIntervalType(this.session, false);
                            if (expression2.getType() == 33) {
                                expression2.dataType = intervalType;
                                break;
                            }
                            expression2 = new ExpressionOp(expression2, intervalType);
                            break;
                        }
                    }
                } else {
                    this.rewind(n);
                    return expression;
                }
                expression = new ExpressionOp(93, expression, expression2);
                break;
            }
            case 88: 
            case 151: 
            case 215: 
            case 219: 
            case 308: 
            case 393: {
                IntervalType intervalType = this.readIntervalType(this.session, true);
                if (expression.getType() == 33) {
                    expression.dataType = intervalType;
                    break;
                }
                expression = new ExpressionOp(expression, intervalType);
                break;
            }
            case 51: {
                this.read();
                Collation collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
                expression.setCollation(collation);
                this.read();
            }
        }
        return expression;
    }

    Expression XreadValueExpressionWithContext() {
        Expression expression;
        this.compileContext.contextuallyTypedExpression = true;
        try {
            expression = this.XreadValueExpression();
        }
        finally {
            this.compileContext.contextuallyTypedExpression = false;
        }
        return expression;
    }

    Expression XreadValueExpressionOnDuplicate() {
        Expression expression;
        this.compileContext.onDuplicateTypedExpression = true;
        try {
            expression = this.XreadValueExpression();
        }
        finally {
            this.compileContext.onDuplicateTypedExpression = false;
        }
        return expression;
    }

    Expression XreadGroupByExpressionPrimary() {
        if (this.token.tokenType == 146) {
            Expression[] expressionArray;
            this.read();
            this.readThis(516);
            this.readThis(926);
            HsqlArrayList<Expression[]> hsqlArrayList = new HsqlArrayList<Expression[]>();
            while (true) {
                expressionArray = this.XreadGroupByExpressionPrimary();
                hsqlArrayList.add(expressionArray);
                if (this.token.tokenType != 913) break;
                this.read();
            }
            this.readThis(911);
            expressionArray = new Expression[hsqlArrayList.size()];
            hsqlArrayList.toArray(expressionArray);
            Expression expression = new Expression(26, expressionArray);
            expression.groupingType = 516;
            return expression;
        }
        Expression expression = this.XreadGroupByExpression();
        return expression;
    }

    Expression XreadGroupByExpression() {
        int n = 0;
        switch (this.token.tokenType) {
            case 71: 
            case 297: {
                n = this.token.tokenType;
                this.read();
                this.readThis(926);
                Expression expression = this.XreadRowElementList(true);
                this.readThis(911);
                this.checkIfGroupingOrAggregate(expression);
                expression.groupingType = n;
                return expression;
            }
            case 926: {
                int n2 = this.getPosition();
                this.read();
                if (this.token.tokenType == 911) {
                    this.read();
                    return new ExpressionColumn(0);
                }
                this.rewind(n2);
                Expression expression = this.XreadValueExpression();
                this.checkIfGroupingOrAggregate(expression);
                return expression;
            }
        }
        Expression expression = this.XreadValueExpression();
        this.checkIfGroupingOrAggregate(expression);
        return expression;
    }

    private void checkIfGroupingOrAggregate(Expression expression) {
        if (expression == null) {
            return;
        }
        if (105 == expression.opType || OpTypes.subqueryAggregateExpressionSet.contains(expression.opType)) {
            throw Error.error(5572, "aggregate functions / subqueries are not allowed in GROUP BY");
        }
        for (int i = 0; i < expression.nodes.length; ++i) {
            this.checkIfGroupingOrAggregate(expression.nodes[i]);
        }
    }

    Expression XreadValueExpression() {
        Expression expression = this.XreadAllTypesCommonValueExpression(true);
        if (this.token.tokenType == 921) {
            this.read();
            Expression expression2 = this.XreadNumericValueExpression();
            this.readThis(931);
            expression = new ExpressionAccessor(expression, expression2);
        }
        return expression;
    }

    Expression XreadRowOrCommonValueExpression() {
        return this.XreadAllTypesCommonValueExpression(false);
    }

    Expression XreadAllTypesCommonValueExpression(boolean bl) {
        Expression expression = this.XreadAllTypesTerm(bl);
        int n = 0;
        boolean bl2 = false;
        while (true) {
            switch (this.token.tokenType) {
                case 927: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 924: {
                    n = 33;
                    bl = false;
                    break;
                }
                case 914: {
                    n = 36;
                    bl = false;
                    break;
                }
                case 245: {
                    if (bl) {
                        n = 50;
                        break;
                    }
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadAllTypesTerm(bl);
            expression = bl ? new ExpressionLogical(n, expression2, expression) : new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadAllTypesTerm(boolean bl) {
        Expression expression = this.XreadAllTypesFactor(bl);
        int n = 0;
        boolean bl2 = false;
        while (true) {
            switch (this.token.tokenType) {
                case 910: {
                    n = 34;
                    bl = false;
                    break;
                }
                case 915: {
                    n = 35;
                    bl = false;
                    break;
                }
                case 7: {
                    if (bl) {
                        n = 49;
                        break;
                    }
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadAllTypesFactor(bl);
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = bl ? new ExpressionLogical(n, expression2, expression) : new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadAllTypesFactor(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (this.token.tokenType) {
            case 927: {
                this.read();
                bl = false;
                break;
            }
            case 924: {
                this.read();
                bl = false;
                bl2 = true;
                break;
            }
            case 229: {
                if (!bl) break;
                this.read();
                bl3 = true;
                break;
            }
        }
        Expression expression = this.XreadAllTypesPrimary(bl);
        if (bl && this.token.tokenType == 167) {
            this.read();
            if (this.token.tokenType == 229) {
                this.read();
                boolean bl5 = bl3 = !bl3;
            }
            if (this.token.tokenType == 362) {
                this.read();
            } else if (this.token.tokenType == 127) {
                this.read();
                bl3 = !bl3;
            } else if (this.token.tokenType == 368) {
                this.read();
                bl4 = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (bl2) {
            expression = new ExpressionArithmetic(31, expression);
        }
        if (bl4) {
            expression = new ExpressionLogical(47, expression);
        }
        if (bl3) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadStringValueExpression() {
        return this.XreadCharacterValueExpression();
    }

    Expression XreadCharacterValueExpression() {
        Expression expression = this.XreadCharacterPrimary();
        Collation collation = this.readCollateClauseOrNull();
        while (this.token.tokenType == 914 || this.token.tokenType == 927) {
            this.read();
            Expression expression2 = expression;
            expression = this.XreadCharacterPrimary();
            collation = this.readCollateClauseOrNull();
            expression = new ExpressionArithmetic(36, expression2, expression);
        }
        return expression;
    }

    Expression XreadCharacterPrimary() {
        switch (this.token.tokenType) {
            case 202: 
            case 251: 
            case 336: 
            case 360: 
            case 372: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression == null) break;
                return expression;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericPrimary() {
        switch (this.token.tokenType) {
            case 1: 
            case 36: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 124: 
            case 126: 
            case 132: 
            case 195: 
            case 216: 
            case 236: 
            case 262: 
            case 264: 
            case 328: 
            case 388: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unexpectedToken();
                }
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression == null) break;
                return expression;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericValueExpression() {
        Expression expression = this.XreadTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 927) {
                n = 32;
            } else {
                if (this.token.tokenType != 924) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadTerm() {
        Expression expression = this.XreadFactor();
        while (true) {
            int n;
            if (this.token.tokenType == 910) {
                n = 34;
            } else {
                if (this.token.tokenType != 915) break;
                n = 35;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadFactor();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadFactor() {
        boolean bl = false;
        if (this.token.tokenType == 927) {
            this.read();
        } else if (this.token.tokenType == 924) {
            this.read();
            bl = true;
        }
        Expression expression = this.XreadNumericPrimary();
        if (expression == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionArithmetic(31, expression);
        }
        return expression;
    }

    Expression XreadDatetimeValueExpression() {
        Expression expression = this.XreadDateTimeIntervalTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 927) {
                n = 32;
            } else {
                if (this.token.tokenType != 924) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadDateTimeIntervalTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadIntervalValueExpression() {
        Expression expression = this.XreadDateTimeIntervalTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 927) {
                n = 32;
            } else {
                if (this.token.tokenType != 924) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadDateTimeIntervalTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadDateTimeIntervalTerm() {
        switch (this.token.tokenType) {
            case 1: 
            case 75: 
            case 81: 
            case 82: 
            case 197: 
            case 198: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unexpectedToken();
                }
                return this.readSQLFunction(functionSQL);
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadDateTimeValueFunctionOrNull() {
        FunctionSQL functionSQL = null;
        switch (this.token.tokenType) {
            case 75: 
            case 81: 
            case 82: 
            case 197: 
            case 198: {
                functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                break;
            }
            case 750: 
            case 808: 
            case 809: 
            case 821: {
                functionSQL = FunctionCustom.newCustomFunction(this.session, this.token.tokenString, this.token.tokenType);
                if (functionSQL != null) break;
                return null;
            }
            default: {
                return null;
            }
        }
        if (functionSQL == null) {
            throw this.unexpectedToken();
        }
        return this.readSQLFunction(functionSQL);
    }

    Expression XreadBooleanValueExpression() {
        try {
            Expression expression = this.XreadBooleanTermOrNull();
            if (expression == null) {
                throw Error.error(5568);
            }
            while (this.token.tokenType == 245) {
                int n = 50;
                this.read();
                Expression expression2 = expression;
                expression = this.XreadBooleanTermOrNull();
                if (expression == null) {
                    throw Error.error(5568);
                }
                expression = new ExpressionLogical(n, expression2, expression);
            }
            if (expression == null) {
                throw Error.error(5568);
            }
            return expression;
        }
        catch (HsqlException hsqlException) {
            HsqlException hsqlException2;
            hsqlException.setLevel(this.compileContext.subqueryDepth);
            if (this.lastError != null && this.lastError.getLevel() >= hsqlException.getLevel()) {
                hsqlException2 = this.lastError;
                this.lastError = null;
            }
            throw hsqlException2;
        }
    }

    Expression XreadBooleanTermOrNull() {
        Expression expression = this.XreadBooleanFactorOrNull();
        if (expression == null) {
            return null;
        }
        while (this.token.tokenType == 7) {
            int n = 49;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadBooleanFactorOrNull();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = new ExpressionLogical(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadBooleanFactorOrNull() {
        Expression expression;
        boolean bl = false;
        if (this.token.tokenType == 229) {
            this.read();
            bl = true;
        }
        if ((expression = this.XreadBooleanTestOrNull()) == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadBooleanTestOrNull() {
        boolean bl = false;
        boolean bl2 = false;
        Expression expression = this.XreadBooleanPrimaryOrNull();
        if (expression == null) {
            return expression;
        }
        if (this.token.tokenType == 167) {
            this.read();
            if (this.token.tokenType == 229) {
                this.read();
                bl2 = true;
            }
            if (this.token.tokenType == 362) {
                this.read();
                expression = new ExpressionLogical(expression, (Expression)new ExpressionBoolean(true));
            } else if (this.token.tokenType == 127) {
                this.read();
                expression = new ExpressionLogical(expression, (Expression)new ExpressionBoolean(false));
            } else if (this.token.tokenType == 368) {
                this.read();
                bl = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (bl) {
            expression = new ExpressionLogical(47, expression);
        }
        if (bl2) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadBooleanPrimaryOrNull() {
        int n;
        Expression expression = null;
        switch (this.token.tokenType) {
            case 122: 
            case 367: {
                return this.XreadPredicate();
            }
            case 298: {
                this.read();
                this.readThis(926);
                expression = this.XreadRowElementList(true);
                this.readThis(911);
                break;
            }
            default: {
                n = this.getPosition();
                try {
                    expression = this.XreadAllTypesCommonValueExpression(false);
                    break;
                }
                catch (HsqlException hsqlException) {
                    hsqlException.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                        this.lastError = hsqlException;
                    }
                    this.rewind(n);
                }
            }
        }
        if (expression == null && this.token.tokenType == 926) {
            this.read();
            n = this.getPosition();
            try {
                expression = this.XreadRowElementList(true);
                this.readThis(911);
            }
            catch (HsqlException hsqlException) {
                hsqlException.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                    this.lastError = hsqlException;
                }
                this.rewind(n);
                expression = this.XreadBooleanValueExpression();
                this.readThis(911);
            }
        }
        if (expression != null) {
            expression = this.XreadPredicateRightPart(expression);
        }
        return expression;
    }

    Expression XreadBooleanPredicand() {
        Expression expression;
        if (this.token.tokenType == 926) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            this.readThis(911);
        } else {
            expression = this.XreadSimpleValueExpressionPrimary();
            if (expression != null) {
                expression = this.XreadArrayElementReference(expression);
            }
        }
        return expression;
    }

    Expression XreadPredicate() {
        switch (this.token.tokenType) {
            case 122: {
                this.read();
                Expression expression = this.XreadTableSubquery(55);
                return new ExpressionLogical(55, expression);
            }
            case 367: {
                this.read();
                Expression expression = this.XreadTableSubquery(66);
                return new ExpressionLogical(66, expression);
            }
        }
        Expression expression = this.XreadRowValuePredicand();
        return this.XreadPredicateRightPart(expression);
    }

    Expression XreadPredicateRightPart(Expression expression) {
        boolean bl = false;
        boolean bl2 = false;
        ExpressionLogical expressionLogical = null;
        int n = this.getPosition();
        if (this.token.tokenType == 229) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 496) {
            this.read();
            if (this.token.tokenType != 265 && this.token.tokenType != 338) {
                throw this.unexpectedToken();
            }
            bl2 = true;
        }
        block0 : switch (this.token.tokenType) {
            case 167: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 229) {
                    bl = true;
                    this.read();
                }
                if (this.token.tokenType == 232) {
                    this.read();
                    if (bl) {
                        expressionLogical = new ExpressionLogical(39, expression);
                        bl = false;
                        break;
                    }
                    expressionLogical = new ExpressionLogical(47, expression);
                    break;
                }
                if (this.token.tokenType == 102) {
                    this.read();
                    this.readThis(137);
                    Expression expression2 = this.XreadRowValuePredicand();
                    expressionLogical = new ExpressionLogical(67, expression, expression2);
                    bl = !bl;
                    break;
                }
                this.rewind(n);
                return expression;
            }
            case 192: {
                expressionLogical = this.XreadLikePredicateRightPart(expression);
                break;
            }
            case 26: {
                expressionLogical = this.XreadBetweenPredicateRightPart(expression);
                break;
            }
            case 154: {
                expressionLogical = this.XreadInPredicateRightPart(expression);
                break;
            }
            case 60: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(59, expression);
                break;
            }
            case 116: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(60, expression);
                break;
            }
            case 250: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(61, expression);
                break;
            }
            case 265: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                if (bl2) {
                    expressionLogical = this.XreadPeriodPredicateRightPart(64, expression);
                    break;
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(62, expression);
                break;
            }
            case 338: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                if (bl2) {
                    expressionLogical = this.XreadPeriodPredicateRightPart(65, expression);
                    break;
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(63, expression);
                break;
            }
            case 471: 
            case 918: 
            case 919: 
            case 922: 
            case 923: 
            case 925: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                int n2 = ParserDQL.getExpressionType(this.token.tokenType);
                this.read();
                switch (this.token.tokenType) {
                    case 4: 
                    case 8: 
                    case 321: {
                        expressionLogical = this.XreadQuantifiedComparisonRightPart(n2, expression);
                        break block0;
                    }
                }
                Expression expression3 = this.XreadRowValuePredicand();
                expressionLogical = new ExpressionLogical(n2, expression, expression3);
                break;
            }
            case 205: {
                expressionLogical = this.XreadMatchPredicateRightPart(expression);
                break;
            }
            default: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                return expression;
            }
        }
        if (bl) {
            expressionLogical = new ExpressionLogical(48, (Expression)expressionLogical);
        }
        return expressionLogical;
    }

    private ExpressionLogical XreadBetweenPredicateRightPart(Expression expression) {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 17) {
            this.read();
        } else if (this.token.tokenType == 340) {
            bl = true;
            this.read();
        }
        Expression expression2 = this.XreadRowValuePredicand();
        this.readThis(7);
        Expression expression3 = this.XreadRowValuePredicand();
        ExpressionLogical expressionLogical = new ExpressionLogical(41, expression, expression2);
        ExpressionLogical expressionLogical2 = new ExpressionLogical(45, expression, expression3);
        ExpressionLogical expressionLogical3 = new ExpressionLogical(49, expressionLogical, expressionLogical2);
        if (bl) {
            expressionLogical = new ExpressionLogical(45, expression, expression2);
            expressionLogical2 = new ExpressionLogical(41, expression, expression3);
            ExpressionLogical expressionLogical4 = new ExpressionLogical(49, expressionLogical, expressionLogical2);
            return new ExpressionLogical(50, expressionLogical3, expressionLogical4);
        }
        return expressionLogical3;
    }

    private ExpressionLogical XreadQuantifiedComparisonRightPart(int n, Expression expression) {
        Cloneable cloneable;
        Expression expression2;
        int n2 = this.token.tokenType;
        int n3 = 0;
        switch (this.token.tokenType) {
            case 8: 
            case 321: {
                n3 = 52;
                break;
            }
            case 4: {
                n3 = 51;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ParserDQL");
            }
        }
        this.read();
        this.readThis(926);
        int n4 = this.getPosition();
        int n5 = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 369: {
                expression2 = this.XreadCollectionDerivedTable(54);
                this.readThis(911);
                this.readCloseBrackets(n5);
                break;
            }
            case 310: 
            case 344: 
            case 376: 
            case 390: {
                this.rewind(n4);
                cloneable = this.XreadSubqueryTableBody(54);
                expression2 = new Expression(23, (TableDerived)cloneable);
                this.readThis(911);
                break;
            }
            default: {
                this.rewind(n4);
                expression2 = this.readAggregateExpression(n2);
                this.readThis(911);
                this.readFilterClause(expression2);
            }
        }
        cloneable = new ExpressionLogical(n, expression, expression2);
        ((ExpressionLogical)cloneable).setSubType(n3);
        return cloneable;
    }

    private ExpressionLogical XreadInPredicateRightPart(Expression expression) {
        Cloneable cloneable;
        int n = expression.getDegree();
        Expression expression2 = null;
        this.read();
        this.readThis(926);
        int n2 = this.getPosition();
        int n3 = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 369: {
                expression2 = this.XreadCollectionDerivedTable(54);
                this.readThis(911);
                this.readCloseBrackets(n3);
                break;
            }
            case 310: 
            case 344: 
            case 376: 
            case 390: {
                this.rewind(n2);
                cloneable = this.XreadSubqueryTableBody(54);
                expression2 = new Expression(23, (TableDerived)cloneable);
                this.readThis(911);
                break;
            }
            default: {
                this.rewind(n2);
                expression2 = this.XreadInValueListConstructor(n);
                this.readThis(911);
            }
        }
        cloneable = new ExpressionLogical(40, expression, expression2);
        ((ExpressionLogical)cloneable).setSubType(52);
        return cloneable;
    }

    Expression XreadInValueList(int n) {
        Expression[] expressionArray;
        HsqlArrayList<Expression[]> hsqlArrayList = new HsqlArrayList<Expression[]>();
        while (true) {
            if ((expressionArray = this.XreadValueExpression()).getType() != 25) {
                expressionArray = new Expression(25, new Expression[]{expressionArray});
            }
            hsqlArrayList.add(expressionArray);
            if (this.token.tokenType != 913) break;
            this.read();
        }
        expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        Expression expression = new Expression(26, expressionArray);
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression[] expressionArray2;
            if (expressionArray[i].getType() != 25) {
                expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
            }
            if ((expressionArray2 = expressionArray[i].nodes).length != n) {
                throw this.unexpectedToken();
            }
            for (int j = 0; j < n; ++j) {
                if (expressionArray2[j].getType() != 25) continue;
                throw this.unexpectedToken();
            }
        }
        return expression;
    }

    private ExpressionLogical XreadLikePredicateRightPart(Expression expression) {
        this.read();
        Expression expression2 = this.XreadStringValueExpression();
        Expression expression3 = null;
        if (this.token.tokenString.equals("ESCAPE")) {
            this.read();
            expression3 = this.XreadStringValueExpression();
        }
        return new ExpressionLike(expression, expression2, expression3);
    }

    private ExpressionLogical XreadMatchPredicateRightPart(Expression expression) {
        boolean bl = false;
        int n = 68;
        this.read();
        if (this.token.tokenType == 367) {
            this.read();
            bl = true;
        }
        switch (this.token.tokenType) {
            default: {
                n = bl ? 71 : 68;
                break;
            }
            case 517: {
                this.read();
                n = bl ? 71 : 68;
                break;
            }
            case 563: {
                this.read();
                n = bl ? 72 : 69;
                break;
            }
            case 138: {
                this.read();
                n = bl ? 73 : 70;
            }
        }
        int n2 = bl ? 68 : 54;
        Expression expression2 = this.XreadTableSubquery(n2);
        return new ExpressionLogical(n, expression, expression2);
    }

    private ExpressionLogical XreadPeriodPredicateRightPart(int n, Expression expression) {
        boolean bl = false;
        switch (expression.getType()) {
            case 2: {
                expression = new ExpressionPeriod((ExpressionColumn)expression);
                break;
            }
            case 57: {
                break;
            }
            case 25: {
                if (expression.nodes.length != 2) {
                    throw Error.error(5564);
                }
                bl = true;
                break;
            }
            default: {
                throw Error.error(5564);
            }
        }
        this.read();
        boolean bl2 = false;
        if (this.token.tokenType == 260) {
            if (bl) {
                throw this.unexpectedToken();
            }
            this.read();
            bl2 = true;
            if (this.token.tokenType != 926) {
                throw this.unexpectedTokenRequire("(");
            }
        }
        Expression expression2 = this.XreadRowValuePredicand();
        switch (expression2.getType()) {
            case 2: {
                if (bl2) {
                    throw Error.error(5564);
                }
                expression2 = new ExpressionPeriod((ExpressionColumn)expression2);
                break;
            }
            case 25: {
                if (expression2.nodes.length == 2) {
                    if (bl2) {
                        expression2 = new ExpressionPeriod(expression2);
                        break;
                    }
                    if (n != 61) {
                        throw Error.error(5564);
                    }
                    return new ExpressionLogical(56, expression, expression2);
                }
                throw Error.error(5564);
            }
            default: {
                if (n != 59) {
                    throw Error.error(5564);
                }
                if (!bl2) break;
                throw Error.error(5564);
            }
        }
        return new ExpressionPeriodOp(n, expression, expression2);
    }

    Expression XreadRowValueExpression() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadTableRowValueConstructor() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadRowValuePredicand() {
        return this.XreadRowOrCommonValueExpression();
    }

    Expression XreadRowValueSpecialCase() {
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
        }
        return expression;
    }

    Expression XreadRowValueConstructor() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        expression = this.XreadRowOrCommonValueExpression();
        if (expression != null) {
            return expression;
        }
        return this.XreadBooleanValueExpression();
    }

    Expression XreadExplicitRowValueConstructorOrNull() {
        switch (this.token.tokenType) {
            case 926: {
                this.read();
                int n = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 310: 
                    case 344: 
                    case 376: {
                        this.rewind(n);
                        TableDerived tableDerived = this.XreadSubqueryTableBody(22);
                        this.readThis(911);
                        return new Expression(22, tableDerived);
                    }
                }
                this.rewind(n);
                Expression expression = this.XreadRowElementList(true);
                this.readThis(911);
                return expression;
            }
            case 298: {
                this.read();
                this.readThis(926);
                Expression expression = this.XreadRowElementList(false);
                this.readThis(911);
                return expression;
            }
        }
        return null;
    }

    Expression XreadRowElementList(boolean bl) {
        Expression expression;
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        while (true) {
            expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            if (this.token.tokenType != 913) break;
            this.read();
        }
        if (bl && hsqlArrayList.size() == 1) {
            return expression;
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new Expression(25, expressionArray);
    }

    Expression XreadCurrentCollationSpec() {
        throw Error.error(1500);
    }

    Expression XreadTableSubquery(int n) {
        this.readThis(926);
        TableDerived tableDerived = this.XreadSubqueryTableBody(n);
        this.readThis(911);
        return new Expression(23, tableDerived);
    }

    Table XreadTableSubqueryOrNull(boolean bl) {
        boolean bl2 = false;
        int n = this.getPosition();
        this.readThis(926);
        switch (this.token.tokenType) {
            case 310: 
            case 344: 
            case 376: 
            case 390: {
                break;
            }
            case 926: {
                if (bl) break;
            }
            default: {
                bl2 = true;
            }
        }
        if (bl2) {
            this.rewind(n);
            return null;
        }
        TableDerived tableDerived = this.XreadSubqueryTableBody(23);
        this.readThis(911);
        return tableDerived;
    }

    TableDerived XreadJoinedTableAsSubqueryOrNull() {
        int n = this.getPosition();
        ParserBase.Recorder recorder = this.startRecording();
        this.readThis(926);
        this.compileContext.incrementDepth();
        QuerySpecification querySpecification = this.XreadJoinedTableAsView();
        querySpecification.resolveReferences(this.session, this.compileContext.getOuterRanges());
        if (querySpecification.rangeVariables.length < 2) {
            this.compileContext.decrementDepth();
            this.rewind(n);
            return null;
        }
        querySpecification.resolveTypesPartOne(this.session);
        querySpecification.resolveTypesPartTwo(this.session);
        TableDerived tableDerived = this.newSubQueryTable(querySpecification, 23);
        this.readThis(911);
        String string = recorder.getSQL();
        tableDerived.setSQL(string);
        tableDerived.prepareTable(this.session);
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    QuerySpecification XreadJoinedTableAsView() {
        QuerySpecification querySpecification = new QuerySpecification(this.compileContext);
        ExpressionColumn expressionColumn = new ExpressionColumn(99);
        querySpecification.addSelectColumnExpression(expressionColumn);
        this.XreadTableReference(querySpecification);
        return querySpecification;
    }

    TableDerived XreadTableNamedSubqueryBody(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray) {
        TableDerived tableDerived;
        Object var4_3 = null;
        int n = this.getPosition();
        if (hsqlNameArray == null) {
            tableDerived = this.XreadSubqueryTableBody(hsqlName, 23);
            if (tableDerived.queryExpression != null) {
                tableDerived.queryExpression.resolve(this.session, this.compileContext.getOuterRanges(), null);
            }
            tableDerived.prepareTable(this.session);
        } else {
            try {
                tableDerived = this.XreadSubqueryTableBody(hsqlName, 23);
                if (tableDerived.queryExpression != null) {
                    tableDerived.queryExpression.resolve(this.session, this.compileContext.getOuterRanges(), null);
                }
                tableDerived.prepareTable(this.session, hsqlNameArray);
            }
            catch (HsqlException hsqlException) {
                String string;
                HsqlException hsqlException2 = hsqlException;
                if (hsqlException.getErrorCode() != 5501 && this.lastError != null && this.lastError.getErrorCode() == -5501) {
                    hsqlException2 = this.lastError;
                }
                if ("RECURSIVE_TABLE".equals(string = hsqlException2.getToken()) || hsqlName.name.equals(string)) {
                    this.rewind(n);
                    tableDerived = this.XreadRecursiveSubqueryBody(hsqlName, hsqlNameArray);
                }
                throw hsqlException;
            }
        }
        return tableDerived;
    }

    TableDerived XreadRecursiveSubqueryBody(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray) {
        int n = this.getPosition();
        QuerySpecification querySpecification = this.XreadSimpleTable();
        querySpecification.isBaseMergeable = false;
        querySpecification.isMergeable = false;
        ((QueryExpression)querySpecification).resolveReferences(this.session, this.compileContext.getOuterRanges());
        querySpecification.resolve(this.session);
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false, 27);
        TableDerived tableDerived = new TableDerived(this.database, hsqlName2, 2, hsqlNameArray, ((QueryExpression)querySpecification).getColumnTypes());
        TableDerived tableDerived2 = new TableDerived(this.database, hsqlName, 2, hsqlNameArray, ((QueryExpression)querySpecification).getColumnTypes());
        HsqlNameManager.HsqlName hsqlName3 = this.database.nameManager.newHsqlName("RECURSIVE_TABLE", false, 27);
        TableDerived tableDerived3 = new TableDerived(this.database, hsqlName3, 2, hsqlNameArray, ((QueryExpression)querySpecification).getColumnTypes());
        this.compileContext.registerSubquery(hsqlName3.name, tableDerived3);
        this.compileContext.registerSubquery(hsqlName.name, tableDerived2);
        this.checkIsThis(366);
        int n2 = this.XreadUnionType();
        this.compileContext.incrementDepth();
        QuerySpecification querySpecification2 = this.XreadSimpleTable();
        QueryExpression queryExpression = new QueryExpression(this.compileContext, querySpecification);
        querySpecification2.isBaseMergeable = false;
        querySpecification2.isMergeable = false;
        querySpecification2.resolveReferences(this.session, this.compileContext.getOuterRanges());
        queryExpression.addUnion(querySpecification2, n2);
        queryExpression.isRecursive = true;
        queryExpression.recursiveWorkTable = tableDerived2;
        queryExpression.recursiveResultTable = tableDerived3;
        queryExpression.isBaseMergeable = false;
        queryExpression.isMergeable = false;
        queryExpression.resolve(this.session);
        TableDerived tableDerived4 = this.newSubQueryTable(hsqlName, queryExpression, 23);
        tableDerived4.prepareTable(this.session, hsqlNameArray);
        tableDerived4.setSQL(this.getLastPart(n));
        this.compileContext.decrementDepth();
        return tableDerived4;
    }

    TableDerived newSubQueryTable(Expression expression, int n) {
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.getSubqueryTableName();
        TableDerived tableDerived = new TableDerived(this.database, hsqlName, 2, null, expression, n, this.compileContext.getDepth());
        return tableDerived;
    }

    TableDerived newSubQueryTable(QueryExpression queryExpression, int n) {
        return this.newSubQueryTable(null, queryExpression, n);
    }

    TableDerived newSubQueryTable(HsqlNameManager.HsqlName hsqlName, QueryExpression queryExpression, int n) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.getSubqueryTableName();
        }
        TableDerived tableDerived = new TableDerived(this.database, hsqlName, 2, queryExpression, null, n, this.compileContext.getDepth());
        return tableDerived;
    }

    TableDerived XreadSubqueryTableBody(int n) {
        return this.XreadSubqueryTableBody(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableDerived XreadSubqueryTableBody(HsqlNameManager.HsqlName hsqlName, int n) {
        int n2 = this.getPosition();
        this.compileContext.incrementDepth();
        try {
            QueryExpression queryExpression = this.XreadQueryExpression();
            TableDerived tableDerived = null;
            if (n == 55) {
                queryExpression.setAsExists();
            }
            if (queryExpression.isValueList) {
                tableDerived = ((QuerySpecification)queryExpression).getValueListTable();
            }
            if (tableDerived == null) {
                tableDerived = this.newSubQueryTable(hsqlName, queryExpression, n);
            }
            String string = this.getLastPart(n2);
            tableDerived.setSQL(string);
            TableDerived tableDerived2 = tableDerived;
            return tableDerived2;
        }
        finally {
            this.compileContext.decrementDepth();
        }
    }

    TableDerived XreadViewSubqueryTable(View view, boolean bl) {
        QueryExpression queryExpression;
        this.compileContext.incrementDepth();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        queryExpression.setView(view);
        queryExpression.resolveReferences(this.session, RangeGroup.emptyArray);
        queryExpression.resolveTypesPartOne(this.session);
        queryExpression.resolveTypesPartTwo(this.session);
        if (bl) {
            queryExpression.resolveTypesPartThree(this.session);
        }
        TableDerived tableDerived = new TableDerived(this.database, view.getName(), 8, queryExpression, null, 0, this.compileContext.getDepth());
        tableDerived.view = view;
        tableDerived.columnList = view.columnList;
        tableDerived.columnCount = view.columnList.size();
        tableDerived.createPrimaryKey();
        tableDerived.triggerList = view.triggerList;
        tableDerived.triggerLists = view.triggerLists;
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    Expression XreadContextuallyTypedTable(int n) {
        int n2;
        Expression expression = this.readRow();
        Expression[] expressionArray = expression.nodes;
        boolean bl = false;
        if (n == 1) {
            if (expression.getType() == 25) {
                expression.opType = 26;
                for (int i = 0; i < expressionArray.length; ++i) {
                    if (expressionArray[i].getType() != 25) {
                        expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
                        continue;
                    }
                    if (expressionArray[i].nodes.length == n) continue;
                    throw Error.error(5564);
                }
            } else {
                expression = new Expression(25, new Expression[]{expression});
                expression = new Expression(26, new Expression[]{expression});
            }
            return expression;
        }
        if (expression.getType() != 25) {
            throw Error.error(5564);
        }
        for (n2 = 0; n2 < expressionArray.length; ++n2) {
            if (expressionArray[n2].getType() != 25) continue;
            bl = true;
            break;
        }
        if (bl) {
            expression.opType = 26;
            for (n2 = 0; n2 < expressionArray.length; ++n2) {
                if (expressionArray[n2].getType() != 25) {
                    throw Error.error(5564);
                }
                Expression[] expressionArray2 = expressionArray[n2].nodes;
                if (expressionArray2.length != n) {
                    throw Error.error(5564);
                }
                for (int i = 0; i < n; ++i) {
                    if (expressionArray2[i].getType() != 25) continue;
                    throw Error.error(5564);
                }
            }
        } else {
            if (expressionArray.length != n) {
                throw Error.error(5564);
            }
            expression = new Expression(26, new Expression[]{expression});
        }
        return expression;
    }

    Expression XreadInValueListConstructor(int n) {
        int n2 = this.getPosition();
        this.compileContext.incrementDepth();
        Expression expression = this.XreadInValueList(n);
        TableDerived tableDerived = this.newSubQueryTable(expression, 54);
        tableDerived.setSQL(this.getLastPart(n2));
        expression.table = tableDerived;
        this.compileContext.decrementDepth();
        return expression;
    }

    private TableDerived XreadRowValueExpressionList() {
        this.compileContext.incrementDepth();
        Expression expression = this.XreadRowValueExpressionListBody();
        TableDerived tableDerived = this.prepareSubqueryTable(expression, null);
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    private TableDerived prepareSubqueryTable(Expression expression, HsqlNameManager.HsqlName[] hsqlNameArray) {
        List<Expression> list = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges(), null);
        ExpressionColumn.checkColumnsResolved(list);
        expression.resolveTypes(this.session, null);
        expression.prepareTable(this.session, null, expression.nodes[0].nodes.length);
        TableDerived tableDerived = this.newSubQueryTable(expression, 26);
        tableDerived.prepareTable(this.session, hsqlNameArray);
        return tableDerived;
    }

    Expression XreadRowValueExpressionListBody() {
        Expression expression = null;
        while (true) {
            int n = this.readOpenBrackets();
            Expression expression2 = this.readRow();
            this.readCloseBrackets(n);
            if (expression == null) {
                expression = new Expression(25, new Expression[]{expression2});
            } else {
                expression.nodes = (Expression[])ArrayUtil.resizeArray(expression.nodes, expression.nodes.length + 1);
                expression.nodes[expression.nodes.length - 1] = expression2;
            }
            if (this.token.tokenType != 913) break;
            this.read();
        }
        Expression[] expressionArray = expression.nodes;
        int n = 1;
        if (expressionArray[0].getType() == 25) {
            n = expressionArray[0].nodes.length;
        }
        expression.opType = 26;
        for (int i = 0; i < expressionArray.length; ++i) {
            if (expressionArray[i].getType() == 25) {
                if (expressionArray[i].nodes.length == n) continue;
                throw Error.error(5564);
            }
            if (n != 1) {
                throw Error.error(5564);
            }
            expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
        }
        return expression;
    }

    Expression XreadTargetSpecification(RangeVariable[] rangeVariableArray, LongDeque longDeque) {
        ColumnBase columnBase = null;
        int n = -1;
        this.checkIsIdentifier();
        if (this.token.namePrePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrePrefix);
        }
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            if (rangeVariableArray[i] == null || (n = rangeVariableArray[i].findColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString)) <= -1) continue;
            columnBase = rangeVariableArray[i].getColumn(n);
            this.read();
            break;
        }
        if (columnBase == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        longDeque.add(n);
        if (this.token.tokenType == 921) {
            if (!columnBase.getDataType().isArrayType()) {
                throw this.unexpectedToken();
            }
            this.read();
            Expression expression = this.XreadNumericValueExpression();
            if (expression == null) {
                throw Error.error(5501, this.token.tokenString);
            }
            expression = new ExpressionAccessor(((ColumnSchema)columnBase).getAccessor(), expression);
            this.readThis(931);
            return expression;
        }
        return ((ColumnSchema)columnBase).getAccessor();
    }

    Expression XreadCollectionDerivedTable(int n) {
        Expression[] expressionArray;
        boolean bl = false;
        int n2 = this.getPosition();
        this.readThis(369);
        this.readThis(926);
        this.compileContext.incrementDepth();
        HsqlArrayList<Expression[]> hsqlArrayList = new HsqlArrayList<Expression[]>();
        while (true) {
            expressionArray = this.XreadValueExpression();
            hsqlArrayList.add(expressionArray);
            if (this.token.tokenType != 913) break;
            this.read();
        }
        expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        this.readThis(911);
        if (this.token.tokenType == 390) {
            this.read();
            this.readThis(550);
            bl = true;
        }
        ExpressionTable expressionTable = new ExpressionTable(expressionArray, bl);
        TableDerived tableDerived = this.newSubQueryTable(expressionTable, n);
        tableDerived.setSQL(this.getLastPart(n2));
        this.compileContext.decrementDepth();
        return expressionTable;
    }

    Expression XreadTableFunctionDerivedTable() {
        int n = this.getPosition();
        this.readThis(344);
        this.readThis(926);
        this.compileContext.incrementDepth();
        Expression expression = this.XreadValueExpression();
        if (expression.getType() != 27 && expression.getType() != 28) {
            this.compileContext.decrementDepth();
            throw this.unexpectedToken("TABLE");
        }
        this.readThis(911);
        expression = new ExpressionTable(new Expression[]{expression}, false);
        TableDerived tableDerived = this.newSubQueryTable(expression, 23);
        tableDerived.setSQL(this.getLastPart(n));
        this.compileContext.decrementDepth();
        return expression;
    }

    Expression XreadLateralDerivedTable() {
        this.readThis(186);
        this.readThis(926);
        TableDerived tableDerived = this.XreadSubqueryTableBody(23);
        this.readThis(911);
        return new Expression(23, tableDerived);
    }

    Expression XreadArrayConstructor() {
        this.readThis(926);
        TableDerived tableDerived = this.XreadSubqueryTableBody(23);
        this.readThis(911);
        return new Expression(102, tableDerived);
    }

    Collation readCollateClauseOrNull() {
        if (this.token.tokenType == 51) {
            this.read();
            Collation collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
            return collation;
        }
        return null;
    }

    Expression XreadArrayElementReference(Expression expression) {
        if (this.token.tokenType == 921) {
            this.read();
            Expression expression2 = this.XreadNumericValueExpression();
            this.readThis(931);
            expression = new ExpressionAccessor(expression, expression2);
        }
        return expression;
    }

    Expression readRow() {
        Expression expression = null;
        while (true) {
            Expression expression2 = this.XreadValueExpressionWithContext();
            if (expression == null) {
                expression = expression2;
            } else if (expression.getType() == 25) {
                if (expression2.getType() == 25 && expression.nodes[0].getType() != 25) {
                    expression = new Expression(25, new Expression[]{expression, expression2});
                } else {
                    expression.nodes = (Expression[])ArrayUtil.resizeArray(expression.nodes, expression.nodes.length + 1);
                    expression.nodes[expression.nodes.length - 1] = expression2;
                }
            } else {
                expression = new Expression(25, new Expression[]{expression, expression2});
            }
            if (this.token.tokenType != 913) break;
            this.read();
        }
        return expression;
    }

    Expression readCaseExpression() {
        Expression expression = null;
        this.read();
        if (this.token.tokenType != 384) {
            expression = this.XreadRowValuePredicand();
        }
        return this.readCaseWhen(expression);
    }

    private Expression readCaseWhen(Expression expression) {
        Expression expression2;
        this.readThis(384);
        Expression expression3 = null;
        if (expression == null) {
            expression3 = this.XreadBooleanValueExpression();
        } else {
            while (true) {
                if (expression == (expression2 = this.XreadPredicateRightPart(expression))) {
                    expression2 = new ExpressionLogical(expression, this.XreadRowValuePredicand());
                }
                expression3 = expression3 == null ? expression2 : new ExpressionLogical(50, expression3, expression2);
                if (this.token.tokenType != 913) break;
                this.read();
            }
        }
        this.readThis(348);
        expression2 = this.XreadValueExpression();
        Expression expression4 = null;
        if (this.token.tokenType == 384) {
            expression4 = this.readCaseWhen(expression);
        } else if (this.token.tokenType == 109) {
            this.read();
            expression4 = this.XreadValueExpression();
            this.readThis(112);
            this.readIfThis(38);
        } else {
            expression4 = new ExpressionValue(null, null);
            this.readThis(112);
            this.readIfThis(38);
        }
        ExpressionOp expressionOp = new ExpressionOp(98, expression2, expression4);
        ExpressionOp expressionOp2 = new ExpressionOp(94, expression3, expressionOp);
        return expressionOp2;
    }

    private Expression readCaseWhenExpressionOrNull() {
        Expression expression = null;
        int n = this.getPosition();
        if (this.token.tokenType == 493 && !this.database.sqlSyntaxMys && !this.database.sqlSyntaxMss) {
            return null;
        }
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        expression = this.XreadBooleanValueExpression();
        this.readThis(913);
        Expression expression2 = this.XreadValueExpression();
        this.readThis(913);
        ExpressionOp expressionOp = new ExpressionOp(98, expression2, this.XreadValueExpression());
        expression = new ExpressionOp(94, expression, expressionOp);
        this.readThis(911);
        return expression;
    }

    private Expression readCastExpression() {
        this.read();
        this.readThis(926);
        Expression expression = this.XreadValueExpression();
        this.readThis(14);
        Type type = this.readTypeDefinition(false, true);
        String string = this.readIfThis(482) ? this.readQuotedString() : null;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, type);
        } else {
            expression = new ExpressionOp(expression, type, string);
        }
        this.readThis(911);
        return expression;
    }

    private Expression readConvertExpressionOrNull() {
        Expression expression;
        Type type;
        Expression expression2 = null;
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        if (this.database.sqlSyntaxMss) {
            type = this.readTypeDefinition(false, true);
            this.readThis(913);
            expression = this.XreadValueExpression();
            if (this.readIfThis(913)) {
                expression2 = this.XreadSimpleValueSpecificationOrNull();
            }
        } else {
            expression = this.XreadValueExpression();
            this.readThis(913);
            type = Type.getTypeForJDBCConvertToken(this.token.tokenType);
            if (type == null) {
                type = this.readTypeDefinition(false, true);
            } else {
                this.read();
            }
        }
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, type);
        } else {
            expression = new ExpressionOp(expression, type);
        }
        this.readThis(911);
        return expression;
    }

    private Expression readColumnOrFunctionExpression() {
        Expression[] expressionArray;
        Object object;
        Object object2;
        Object object3;
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedSimpleName();
        Token token = this.getRecordedToken();
        this.checkIsIdentifier();
        if (this.isUndelimitedSimpleName() && (object3 = this.readFunction()) != null) {
            return object3;
        }
        this.read();
        if (this.token.tokenType != 926) {
            this.checkValidCatalogName(token.namePrePrePrefix);
            object3 = new ExpressionColumn(token.namePrePrefix, token.namePrefix, string);
            return object3;
        }
        object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.session, string, token.namePrefix, token.namePrePrefix, 16);
        if (object3 == null && token.namePrefix == null && !this.isViewDefinition && (object2 = this.database.schemaManager.findSynonym(token.tokenString, (String)(object = this.session.getSchemaName(null)), 18)) != null) {
            expressionArray = ((ReferenceObject)object2).getTarget();
            object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(expressionArray.name, expressionArray.schema.name, 18);
        }
        if (object3 == null && bl) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, ((HsqlNameManager.HsqlName)object).name, 16);
            if (object3 == null) {
                Routine.createRoutines(this.session, (HsqlNameManager.HsqlName)object, string);
                object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, ((HsqlNameManager.HsqlName)object).name, 16);
            }
        }
        if (object3 == null) {
            if (this.lastError != null) {
                throw this.lastError;
            }
            throw Error.error(5501, string);
        }
        object = new HsqlArrayList();
        this.readThis(926);
        if (this.token.tokenType == 911) {
            this.read();
        } else {
            while (true) {
                object2 = this.XreadValueExpression();
                ((HsqlArrayList)object).add(object2);
                if (this.token.tokenType != 913) break;
                this.read();
            }
            this.readThis(911);
        }
        object2 = new FunctionSQLInvoked((RoutineSchema)object3);
        expressionArray = new Expression[((HsqlArrayList)object).size()];
        ((HsqlArrayList)object).toArray(expressionArray);
        ((FunctionSQLInvoked)object2).setArguments(expressionArray);
        this.compileContext.addFunctionCall((FunctionSQLInvoked)object2);
        token.setExpression((SchemaObject)object3);
        return object2;
    }

    Expression readFunction() {
        FunctionSQL functionSQL = FunctionCustom.newCustomFunction(this.session, this.token.tokenString, this.token.tokenType);
        if (functionSQL != null) {
            int n = this.getPosition();
            try {
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression != null) {
                    return expression;
                }
            }
            catch (HsqlException hsqlException) {
                hsqlException.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                    this.lastError = hsqlException;
                }
                this.rewind(n);
            }
        } else if (this.isReservedKey() && (functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext)) != null) {
            Expression expression = this.readSQLFunction(functionSQL);
            return expression;
        }
        return null;
    }

    Expression readCollection(int n) {
        this.read();
        if (this.token.tokenType == 926) {
            return this.XreadArrayConstructor();
        }
        this.readThis(921);
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        int n2 = 0;
        while (true) {
            if (this.token.tokenType == 931) break;
            if (n2 > 0) {
                this.readThis(913);
            }
            Expression expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            ++n2;
        }
        this.read();
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new Expression(19, expressionArray);
    }

    private Expression readDecodeExpressionOrNull() {
        ExpressionOp expressionOp;
        block6: {
            int n = this.getPosition();
            this.read();
            if (!this.readIfThis(926)) {
                this.rewind(n);
                return null;
            }
            expressionOp = null;
            Expression expression = null;
            Expression expression2 = this.XreadValueExpression();
            this.readThis(913);
            while (true) {
                Expression expression3 = this.XreadValueExpression();
                if (this.token.tokenType != 913) {
                    if (expression == null) {
                        throw this.unexpectedToken();
                    }
                    expression.setRightNode(expression3);
                    break block6;
                }
                this.readThis(913);
                ExpressionLogical expressionLogical = new ExpressionLogical(67, expression2, expression3);
                Expression expression4 = this.XreadValueExpression();
                ExpressionOp expressionOp2 = new ExpressionOp(98, expression4, null);
                ExpressionOp expressionOp3 = new ExpressionOp(94, expressionLogical, expressionOp2);
                if (expressionOp == null) {
                    expressionOp = expressionOp3;
                } else {
                    expression.setRightNode(expressionOp3);
                }
                expression = expressionOp2;
                if (this.token.tokenType != 913) break;
                this.readThis(913);
            }
            expression.setRightNode(new ExpressionValue(null, null));
        }
        this.readThis(911);
        return expressionOp;
    }

    private Expression readConcatExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(913);
        while (true) {
            Expression expression2 = this.XreadValueExpression();
            expression = new ExpressionArithmetic(36, expression, expression2);
            if (this.token.tokenType == 913) {
                this.readThis(913);
                continue;
            }
            if (this.token.tokenType == 911) break;
        }
        this.readThis(911);
        return expression;
    }

    private Expression readConcatSeparatorExpressionOrNull() {
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        hsqlArrayList.add(expression);
        this.readThis(913);
        expression = this.XreadValueExpression();
        hsqlArrayList.add(expression);
        this.readThis(913);
        while (true) {
            expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            if (this.token.tokenType == 913) {
                this.readThis(913);
                continue;
            }
            if (this.token.tokenType == 911) break;
        }
        this.readThis(911);
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new ExpressionOp(90, expressionArray);
    }

    private Expression readLeastExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        while (true) {
            expression = this.readValue(expression, 44);
            if (this.token.tokenType != 913) break;
            this.readThis(913);
        }
        this.readThis(911);
        return expression;
    }

    private Expression readGreatestExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        while (true) {
            expression = this.readValue(expression, 43);
            if (this.token.tokenType != 913) break;
            this.readThis(913);
        }
        this.readThis(911);
        return expression;
    }

    private Expression readValue(Expression expression, int n) {
        Expression expression2 = this.XreadValueExpression();
        if (expression == null) {
            return expression2;
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(n, expression, expression2);
        ExpressionOp expressionOp = new ExpressionOp(98, expression, expression2);
        return new ExpressionOp(94, expressionLogical, expressionOp);
    }

    private Expression readNullIfExpression() {
        this.read();
        this.readThis(926);
        Expression expression = this.XreadValueExpression();
        this.readThis(913);
        ExpressionOp expressionOp = new ExpressionOp(98, new ExpressionValue(null, null), expression);
        expression = new ExpressionLogical(expression, this.XreadValueExpression());
        expression = new ExpressionOp(94, expression, expressionOp);
        this.readThis(911);
        return expression;
    }

    private Expression readIfNullExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(913);
        Expression expression2 = this.XreadValueExpression();
        ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
        ExpressionOp expressionOp = new ExpressionOp(98, expression2, expression);
        expression = new ExpressionOp(94, expressionLogical, expressionOp);
        expression.setSubType(91);
        expressionOp.setSubType(91);
        this.readThis(911);
        return expression;
    }

    private Expression readIfNull2ExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(926)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(913);
        Expression expression2 = this.XreadValueExpression();
        this.readThis(913);
        Expression expression3 = this.XreadValueExpression();
        ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
        ExpressionOp expressionOp = new ExpressionOp(98, expression3, expression2);
        expression = new ExpressionOp(94, expressionLogical, expressionOp);
        expression.setSubType(91);
        expressionOp.setSubType(91);
        this.readThis(911);
        return expression;
    }

    private Expression readCoalesceExpression() {
        Expression expression;
        ExpressionOp expressionOp = null;
        this.read();
        this.readThis(926);
        Expression expression2 = null;
        while (true) {
            expression = this.XreadValueExpression();
            if (expression2 != null && this.token.tokenType == 911) break;
            ExpressionValue expressionValue = new ExpressionValue(null, null);
            ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
            ExpressionOp expressionOp2 = new ExpressionOp(98, expressionValue, expression);
            ExpressionOp expressionOp3 = new ExpressionOp(94, expressionLogical, expressionOp2);
            if (this.session.database.sqlSyntaxMys) {
                expressionOp2.setSubType(91);
                expressionOp3.setSubType(91);
            }
            if (expressionOp == null) {
                expressionOp = expressionOp3;
            } else {
                expression2.setLeftNode(expressionOp3);
            }
            expression2 = expressionOp2;
            this.readThis(913);
        }
        this.readThis(911);
        expression2.setLeftNode(expression);
        return expressionOp;
    }

    Expression readSQLFunction(FunctionSQL functionSQL) {
        boolean bl;
        int n = this.getPosition();
        this.read();
        short[] sArray = functionSQL.parseList;
        if (sArray.length == 0) {
            return functionSQL;
        }
        HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
        boolean bl2 = bl = this.token.tokenType == 926;
        if (!bl) {
            if (sArray[0] == 972) {
                return functionSQL;
            }
            this.rewind(n);
            return null;
        }
        try {
            this.readExpression(hsqlArrayList, sArray, 0, sArray.length, false);
            this.lastError = null;
        }
        catch (HsqlException hsqlException) {
            if (functionSQL.parseListAlt == null) {
                throw hsqlException;
            }
            this.rewind(n);
            this.read();
            sArray = functionSQL.parseListAlt;
            hsqlArrayList = new HsqlArrayList();
            this.readExpression(hsqlArrayList, sArray, 0, sArray.length, false);
            this.lastError = null;
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        functionSQL.setArguments(expressionArray);
        return functionSQL.getFunctionExpression();
    }

    void readExpression(HsqlArrayList<Expression> hsqlArrayList, short[] sArray, int n, int n2, boolean bl) {
        block10: for (int i = n; i < n + n2; ++i) {
            short s = sArray[i];
            switch (s) {
                case 928: {
                    Expression expression = null;
                    expression = this.XreadAllTypesCommonValueExpression(false);
                    hsqlArrayList.add(expression);
                    continue block10;
                }
                case 975: {
                    if (super.isUndelimitedSimpleName()) {
                        ExpressionValue expressionValue = new ExpressionValue(this.token.tokenString, Type.SQL_VARCHAR);
                        this.read();
                        hsqlArrayList.add(expressionValue);
                        continue block10;
                    }
                    throw this.unexpectedToken();
                }
                case 974: {
                    ExpressionValue expressionValue = null;
                    Object object = this.readIntegerObject();
                    if ((Integer)object < 0) {
                        throw Error.error(5592);
                    }
                    expressionValue = new ExpressionValue(object, Type.SQL_INTEGER);
                    hsqlArrayList.add(expressionValue);
                    continue block10;
                }
                case 972: {
                    int n3 = hsqlArrayList.size();
                    int n4 = this.getPosition();
                    int n5 = ++i;
                    ++i;
                    int n6 = sArray[n5];
                    int n7 = hsqlArrayList.size();
                    try {
                        this.readExpression(hsqlArrayList, sArray, i, n6, true);
                    }
                    catch (HsqlException hsqlException) {
                        hsqlException.setLevel(this.compileContext.subqueryDepth);
                        if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                            this.lastError = hsqlException;
                        }
                        this.rewind(n4);
                        hsqlArrayList.setSize(n3);
                        for (int j = i; j < i + n6; ++j) {
                            if (sArray[j] != 928 && sArray[j] != 971 && sArray[j] != 974) continue;
                            hsqlArrayList.add(null);
                        }
                        i += n6 - 1;
                        continue block10;
                    }
                    if (n7 == hsqlArrayList.size() && sArray[i] != 926) {
                        hsqlArrayList.add(null);
                    }
                    i += n6 - 1;
                    continue block10;
                }
                case 973: {
                    int n6;
                    int n8 = ++i;
                    short s2 = sArray[n8];
                    int n9 = ++i;
                    do {
                        n6 = hsqlArrayList.size();
                        this.readExpression(hsqlArrayList, sArray, n9, s2, true);
                    } while (hsqlArrayList.size() != n6);
                    i += s2 - 1;
                    continue block10;
                }
                case 971: {
                    short s3 = sArray[++i];
                    Object object = null;
                    if (ArrayUtil.find(sArray, this.token.tokenType, i + 1, s3) == -1) {
                        if (!bl) {
                            throw this.unexpectedToken();
                        }
                    } else {
                        object = new ExpressionValue(ValuePool.getInt(this.token.tokenType), Type.SQL_INTEGER);
                        this.read();
                    }
                    hsqlArrayList.add((Expression)object);
                    i += s3;
                    continue block10;
                }
                default: {
                    if (this.token.tokenType != s) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
            }
        }
    }

    private Expression readSequenceExpressionOrNull(int n) {
        int n2 = this.getPosition();
        switch (n) {
            case 12: {
                if (this.token.tokenType == 534) {
                    this.read();
                    if (this.token.tokenType != 375) {
                        this.rewind(n2);
                        return null;
                    }
                    this.readThis(375);
                    break;
                }
                if (this.database.sqlSyntaxDb2 && this.token.tokenType == 747) {
                    this.read();
                    break;
                }
                if (this.database.sqlSyntaxDb2 && this.token.tokenType == 762) {
                    this.read();
                    break;
                }
                this.rewind(n2);
                return null;
            }
            case 13: {
                this.read();
                this.readThis(375);
                break;
            }
        }
        this.readThis(133);
        this.checkIsSchemaObjectName();
        NumberSequence numberSequence = this.database.schemaManager.findSequence(this.session, this.token.tokenString, this.token.namePrefix);
        if (numberSequence == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        Token token = this.getRecordedToken();
        this.read();
        ExpressionColumn expressionColumn = new ExpressionColumn(numberSequence, n);
        token.setExpression(numberSequence);
        this.compileContext.addSequence(numberSequence);
        return expressionColumn;
    }

    HsqlNameManager.SimpleName readSimpleName() {
        this.checkIsSimpleName();
        HsqlNameManager.SimpleName simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        return simpleName;
    }

    HsqlNameManager.HsqlName readNewSchemaName() {
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(2, false);
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewSchemaObjectName(int n, boolean bl) {
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), n);
        if (this.token.namePrefix != null) {
            switch (n) {
                case 1: 
                case 11: 
                case 21: 
                case 22: {
                    throw this.unexpectedToken();
                }
                case 19: {
                    if (this.token.namePrePrefix == null && !this.token.isDelimitedPrefix && "MODULE".equals(this.token.namePrefix)) break;
                    throw this.unexpectedTokenRequire("MODULE");
                }
                case 2: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 25: 
                case 26: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 9: {
                    throw this.tooManyIdentifiers();
                }
                default: {
                    HsqlNameManager.HsqlName hsqlName2;
                    this.checkValidCatalogName(this.token.namePrePrefix);
                    if (bl) {
                        hsqlName2 = this.session.getSchemaHsqlName(this.token.namePrefix);
                    } else {
                        hsqlName2 = this.session.database.schemaManager.findSchemaHsqlName(this.token.namePrefix);
                        if (hsqlName2 == null) {
                            hsqlName2 = this.database.nameManager.newHsqlName(this.token.namePrefix, this.isDelimitedIdentifier(), 2);
                        }
                    }
                    hsqlName.setSchemaIfNull(hsqlName2);
                    break;
                }
            }
        }
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewDependentSchemaObjectName(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        hsqlName2.parent = hsqlName;
        hsqlName2.setSchemaIfNull(hsqlName.schema);
        if (hsqlName2.schema != null && hsqlName.schema != null && hsqlName2.schema != hsqlName.schema) {
            throw Error.error(5505, this.token.namePrefix);
        }
        return hsqlName2;
    }

    HsqlNameManager.HsqlName readSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.tokenString);
        this.read();
        return hsqlName;
    }

    SchemaObject readSchemaObjectName(int n) {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrePrefix);
        String string = this.session.getSchemaName(this.token.namePrefix);
        SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.tokenString, string, n);
        this.read();
        return schemaObject;
    }

    SchemaObject readSchemaObjectName(HsqlNameManager.HsqlName hsqlName, int n) {
        this.checkIsSchemaObjectName();
        SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.tokenString, hsqlName.name, n);
        if (this.token.namePrefix != null) {
            if (!this.token.namePrefix.equals(hsqlName.name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
            if (this.token.namePrePrefix != null && !this.token.namePrePrefix.equals(this.database.getCatalogName().name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
        }
        this.read();
        return schemaObject;
    }

    Table readTableName() {
        return this.readTableName(false);
    }

    Table readTableName(boolean bl) {
        this.checkIsIdentifier();
        this.lastSynonym = null;
        Table table = this.database.schemaManager.findTable(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix);
        if (table == null) {
            Object object;
            boolean bl2;
            boolean bl3 = bl2 = bl && this.token.namePrefix == null && !this.isViewDefinition;
            if (bl2 && (object = this.database.schemaManager.findSynonym(this.token.tokenString, this.session.getCurrentSchemaHsqlName().name, 3)) != null) {
                table = (Table)this.database.schemaManager.findSchemaObject(((ReferenceObject)object).getTarget());
                this.lastSynonym = ((ReferenceObject)object).getName();
            }
            if (table == null) {
                object = Error.error(5501, this.token.tokenString);
                ((HsqlException)object).setToken(this.token.tokenString);
                throw object;
            }
        }
        this.getRecordedToken().setExpression(table);
        this.read();
        return table;
    }

    ExpressionPeriodOp XreadQuerySystemPeriodSpecOrNull(Table table) {
        int n = this.getPosition();
        if (!table.isSystemVersioned()) {
            return null;
        }
        if (this.token.tokenType != 133) {
            ExpressionPeriodOp expressionPeriodOp = new ExpressionPeriodOp();
            return expressionPeriodOp;
        }
        this.read();
        if (this.token.tokenType != 342) {
            this.rewind(n);
            return null;
        }
        this.read();
        switch (this.token.tokenType) {
            case 14: {
                this.read();
                this.readThis(237);
                Expression expression = this.XreadValueExpression();
                return new ExpressionPeriodOp(expression);
            }
            case 26: {
                this.read();
                this.readIfThis(17);
                Expression expression = this.XreadRowValuePredicand();
                this.readThis(7);
                Expression expression2 = this.XreadRowValuePredicand();
                return new ExpressionPeriodOp(expression, expression2);
            }
            case 137: {
                this.read();
                Expression expression = this.XreadValueExpression();
                this.readThis(353);
                Expression expression3 = this.XreadValueExpression();
                return new ExpressionPeriodOp(expression, expression3);
            }
        }
        throw this.unexpectedToken();
    }

    ExpressionPeriodOp XreadQueryApplicationPeriodSpecOrNull(Table table) {
        PeriodDefinition periodDefinition = table.getApplicationPeriod();
        if (periodDefinition == null) {
            return null;
        }
        if (this.token.tokenType != 133) {
            return null;
        }
        this.read();
        this.readThis(261);
        this.readThis(237);
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(periodDefinition.periodName.getNameString())) {
            throw Error.error(5501, this.token.tokenString);
        }
        this.read();
        this.readThis(137);
        Expression expression = this.XreadValueExpression();
        this.readThis(353);
        Expression expression2 = this.XreadValueExpression();
        ExpressionPeriod expressionPeriod = new ExpressionPeriod(periodDefinition);
        ExpressionPeriod expressionPeriod2 = new ExpressionPeriod(expression, expression2);
        return new ExpressionPeriodOp(61, expressionPeriod, expressionPeriod2);
    }

    ColumnSchema readSimpleColumnName(RangeVariable rangeVariable, boolean bl) {
        ColumnSchema columnSchema = null;
        this.checkIsIdentifier();
        if (!bl && this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int n = rangeVariable.findColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
        if (n == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        columnSchema = rangeVariable.getTable().getColumn(n);
        this.read();
        return columnSchema;
    }

    ColumnSchema readSimpleColumnName(Table table, boolean bl) {
        int n;
        this.checkIsIdentifier();
        if (bl) {
            if (this.token.namePrefix != null && !table.getName().name.equals(this.token.namePrefix)) {
                throw Error.error(5501, this.token.namePrefix);
            }
        } else if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        if ((n = table.findColumn(this.token.tokenString)) == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        ColumnSchema columnSchema = table.getColumn(n);
        this.read();
        return columnSchema;
    }

    StatementQuery compileDeclareCursorOrNull(RangeGroup[] rangeGroupArray, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getPosition();
        this.readThis(93);
        if (this.isReservedKey()) {
            this.rewind(n6);
            return null;
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(19, false);
        switch (this.token.tokenType) {
            case 311: {
                this.read();
                n2 = 2;
                break;
            }
            case 159: {
                this.read();
                n2 = 1;
                break;
            }
            case 15: {
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 226) {
            this.readThis(306);
        } else if (this.token.tokenType == 306) {
            this.read();
            n3 = 1;
        }
        if (this.token.tokenType != 85) {
            this.rewind(n6);
            return null;
        }
        this.readThis(85);
        for (n = 0; n < 2; ++n) {
            if (this.token.tokenType == 390) {
                this.read();
                if (n == 0 && this.token.tokenType == 150) {
                    this.read();
                    n4 = 1;
                    continue;
                }
                this.readThis(292);
                ++n;
                n5 = 1;
                continue;
            }
            if (this.token.tokenType != 392) continue;
            this.read();
            if (n == 0 && this.token.tokenType == 150) {
                this.read();
                continue;
            }
            this.readThis(292);
            ++n;
        }
        this.readThis(133);
        n = ResultProperties.getProperties(n2, 1, n3, n4, n5);
        StatementQuery statementQuery = this.compileCursorSpecification(rangeGroupArray, n, bl);
        statementQuery.setCursorName(hsqlName);
        return statementQuery;
    }

    StatementQuery compileCursorSpecification(RangeGroup[] rangeGroupArray, int n, boolean bl) {
        OrderedHashSet<String> orderedHashSet = null;
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (this.token.tokenType == 133) {
            this.read();
            if (this.token.tokenType == 583 || this.token.tokenType == 128) {
                this.read();
                this.readThis(243);
                n = ResultProperties.addUpdatable(n, false);
            } else {
                this.readThis(371);
                n = ResultProperties.addUpdatable(n, true);
                if (this.token.tokenType == 237) {
                    this.readThis(237);
                    orderedHashSet = new OrderedHashSet<String>();
                    this.readColumnNameList(orderedHashSet, null, false);
                }
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(751);
                }
            }
        }
        if (this.database.sqlSyntaxDb2) {
            if (this.readIfThis(390) && !this.readIfThis("CS") && !this.readIfThis("RR") && !this.readIfThis("RS")) {
                this.readThis("UR");
            }
            if (this.readIfThis(845)) {
                this.readThis(7);
                this.readThis("KEEP");
                if (!this.readIfThis("EXCLUSIVE") && !this.readIfThis("SHARE")) {
                    this.readThis(371);
                }
                this.readThis(722);
            }
        }
        if (ResultProperties.isUpdatable(n)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        if (this.database.sqlLowerCaseIdentifier && !bl) {
            queryExpression.setLowerCaseResultIdentifer();
        }
        queryExpression.resolve(this.session, rangeGroupArray, null);
        StatementQuery statementQuery = bl ? new StatementCursor(this.session, queryExpression, this.compileContext) : new StatementQuery(this.session, queryExpression, this.compileContext);
        return statementQuery;
    }

    StatementDMQL compileShortCursorSpecification(int n) {
        QuerySpecification querySpecification = this.XreadSimpleTable();
        if (ResultProperties.isUpdatable(n)) {
            querySpecification.isUpdatable = true;
        }
        ((QueryExpression)querySpecification).setReturningResult();
        querySpecification.resolve(this.session);
        StatementQuery statementQuery = new StatementQuery(this.session, querySpecification, this.compileContext);
        return statementQuery;
    }

    int readCloseBrackets(int n) {
        int n2;
        for (n2 = 0; n2 < n && this.token.tokenType == 911; ++n2) {
            this.read();
        }
        return n2;
    }

    int readOpenBrackets() {
        int n = 0;
        while (this.token.tokenType == 926) {
            ++n;
            this.read();
        }
        return n;
    }

    void readNestedParenthesisedTokens() {
        this.readThis(926);
        do {
            this.read();
            if (this.token.tokenType == 926) {
                this.readNestedParenthesisedTokens();
            }
            if (this.token.tokenType != 1014) continue;
            throw this.unexpectedToken();
        } while (this.token.tokenType != 911);
        this.read();
    }

    void checkValidCatalogName(String string) {
        if (string != null && !string.equals(this.database.getCatalogName().name)) {
            throw Error.error(5501, string);
        }
    }

    @Override
    void rewind(int n) {
        super.rewind(n);
        this.compileContext.rewind(n);
    }

    public static final class CompileContext {
        final Session session;
        final ParserBase parser;
        final CompileContext baseContext;
        final int basePosition;
        boolean isViewTable;
        private int subqueryDepth;
        private HsqlArrayList<OrderedHashMap<String, TableDerived>> namedSubqueries;
        private final OrderedIntKeyHashMap<ExpressionColumn> parameters = new OrderedIntKeyHashMap();
        private final HsqlArrayList<SchemaObject> usedSequences = new HsqlArrayList(16, true);
        private final HsqlArrayList<FunctionSQLInvoked> usedRoutines = new HsqlArrayList(16, true);
        private final OrderedIntKeyHashMap<RangeVariable> rangeVariables = new OrderedIntKeyHashMap();
        private final HsqlArrayList<SchemaObject> usedTypes = new HsqlArrayList(16, true);
        Type currentDomain;
        boolean contextuallyTypedExpression;
        boolean onDuplicateTypedExpression;
        Routine callProcedure;
        private RangeGroup[] outerRangeGroups = RangeGroup.emptyArray;
        private final int initialRangeVarIndex;
        private int rangeVarIndex;

        public CompileContext(Session session) {
            this(session, null, null);
        }

        public CompileContext(Session session, ParserBase parserBase, CompileContext compileContext) {
            this.session = session;
            this.parser = parserBase;
            this.baseContext = compileContext;
            if (compileContext == null) {
                this.rangeVarIndex = 1;
                this.initialRangeVarIndex = 1;
                this.basePosition = 0;
            } else {
                this.initialRangeVarIndex = this.rangeVarIndex = compileContext.getRangeVarCount();
                this.basePosition = compileContext.parser.getPosition();
                this.subqueryDepth = compileContext.getDepth();
            }
        }

        public void reset() {
            this.rangeVarIndex = this.initialRangeVarIndex;
            this.subqueryDepth = 0;
            this.rangeVariables.clear();
            this.parameters.clear();
            this.usedSequences.clear();
            this.usedRoutines.clear();
            this.callProcedure = null;
            this.usedTypes.clear();
            this.outerRangeGroups = RangeGroup.emptyArray;
            this.currentDomain = null;
            this.contextuallyTypedExpression = false;
        }

        public int getDepth() {
            return this.subqueryDepth;
        }

        public void incrementDepth() {
            ++this.subqueryDepth;
            if (this.baseContext != null) {
                ++this.baseContext.subqueryDepth;
            }
        }

        public void decrementDepth() {
            this.clearSubqueries();
            --this.subqueryDepth;
            if (this.baseContext != null) {
                --this.baseContext.subqueryDepth;
            }
        }

        public void decrementDepth(int n) {
            while (this.subqueryDepth > n) {
                this.decrementDepth();
            }
        }

        public void rewind(int n) {
            if (this.baseContext != null) {
                this.baseContext.rewind(this.basePosition + n);
                return;
            }
            this.rewindRangeVariables(n);
            this.rewindParameters(n);
        }

        private void rewindRangeVariables(int n) {
            for (int i = this.rangeVariables.size() - 1; i >= 0; --i) {
                int n2 = this.rangeVariables.getKeyAt(i, -1);
                if (n2 <= n) continue;
                this.rangeVariables.removeEntry(i);
            }
            if (this.rangeVariables.size() > 0) {
                RangeVariable rangeVariable = (RangeVariable)this.rangeVariables.getValueAt(this.rangeVariables.size() - 1);
                this.rangeVarIndex = rangeVariable.rangePosition + 1;
            } else {
                this.rangeVarIndex = this.initialRangeVarIndex;
            }
        }

        private void rewindParameters(int n) {
            if (this.baseContext != null) {
                this.baseContext.rewindParameters(this.basePosition + n);
                return;
            }
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.nextInt();
                if (n2 < n) continue;
                iterator.remove();
            }
        }

        public void setCurrentSubquery(HsqlNameManager.HsqlName hsqlName) {
            this.isViewTable = hsqlName.type == 4;
        }

        public void registerRangeVariable(RangeVariable rangeVariable) {
            int n = this.basePosition;
            if (this.parser != null) {
                n += this.parser.getPosition();
            }
            if (this.isViewTable) {
                rangeVariable.isViewSubquery = true;
            }
            this.registerRangeVariable(rangeVariable, n);
        }

        private void registerRangeVariable(RangeVariable rangeVariable, int n) {
            if (this.baseContext != null) {
                this.baseContext.registerRangeVariable(rangeVariable, n);
                return;
            }
            rangeVariable.rangePosition = this.getNextRangeVarIndex();
            rangeVariable.level = this.subqueryDepth;
            this.rangeVariables.put(n, rangeVariable);
        }

        public void setNextRangeVarIndex(int n) {
            if (this.baseContext != null) {
                this.baseContext.setNextRangeVarIndex(n);
                return;
            }
            this.rangeVarIndex = n;
        }

        private int getNextRangeVarIndex() {
            if (this.baseContext != null) {
                return this.baseContext.getNextRangeVarIndex();
            }
            return this.rangeVarIndex++;
        }

        public int getNextResultRangeVarIndex() {
            RangeVariable rangeVariable = new RangeVariable(null, null, false, 5);
            this.registerRangeVariable(rangeVariable);
            return rangeVariable.rangePosition;
        }

        public int getRangeVarCount() {
            if (this.baseContext != null) {
                return this.baseContext.getRangeVarCount();
            }
            return this.rangeVarIndex;
        }

        public RangeVariable[] getAllRangeVariables() {
            HsqlArrayList<RangeVariable> hsqlArrayList = new HsqlArrayList<RangeVariable>();
            for (int i = 0; i < this.rangeVariables.size(); ++i) {
                RangeVariable rangeVariable = (RangeVariable)this.rangeVariables.getValueAt(i);
                if (rangeVariable.rangeType == 5) continue;
                hsqlArrayList.add(rangeVariable);
            }
            RangeVariable[] rangeVariableArray = new RangeVariable[hsqlArrayList.size()];
            hsqlArrayList.toArray(rangeVariableArray);
            return rangeVariableArray;
        }

        public RangeGroup[] getOuterRanges() {
            if (this.baseContext != null) {
                return this.baseContext.outerRangeGroups;
            }
            return this.outerRangeGroups;
        }

        public void setOuterRanges(RangeGroup[] rangeGroupArray) {
            this.outerRangeGroups = rangeGroupArray;
        }

        public NumberSequence[] getSequences() {
            if (this.usedSequences.isEmpty()) {
                return NumberSequence.emptyArray;
            }
            NumberSequence[] numberSequenceArray = new NumberSequence[this.usedSequences.size()];
            this.usedSequences.toArray(numberSequenceArray);
            return numberSequenceArray;
        }

        public Routine[] getRoutines() {
            if (this.callProcedure == null && this.usedRoutines.isEmpty()) {
                return Routine.emptyArray;
            }
            OrderedHashSet<Routine> orderedHashSet = new OrderedHashSet<Routine>();
            for (int i = 0; i < this.usedRoutines.size(); ++i) {
                FunctionSQLInvoked functionSQLInvoked = this.usedRoutines.get(i);
                if (functionSQLInvoked.routine == null) continue;
                orderedHashSet.add(functionSQLInvoked.routine);
            }
            if (this.callProcedure != null) {
                orderedHashSet.add(this.callProcedure);
            }
            Routine[] routineArray = new Routine[orderedHashSet.size()];
            orderedHashSet.toArray(routineArray);
            return routineArray;
        }

        private void initSubqueryNames() {
            OrderedHashMap<String, TableDerived> orderedHashMap;
            if (this.namedSubqueries == null) {
                this.namedSubqueries = new HsqlArrayList();
            }
            if (this.namedSubqueries.size() <= this.subqueryDepth) {
                this.namedSubqueries.setSize(this.subqueryDepth + 1);
            }
            if ((orderedHashMap = this.namedSubqueries.get(this.subqueryDepth)) == null) {
                orderedHashMap = new OrderedHashMap();
                this.namedSubqueries.set(this.subqueryDepth, orderedHashMap);
            }
        }

        private void clearSubqueries() {
            OrderedHashMap<String, TableDerived> orderedHashMap;
            if (this.namedSubqueries != null && this.namedSubqueries.size() > this.subqueryDepth && (orderedHashMap = this.namedSubqueries.get(this.subqueryDepth)) != null) {
                orderedHashMap.clear();
            }
        }

        private void registerSubquery(String string) {
            this.initSubqueryNames();
            OrderedHashMap<String, TableDerived> orderedHashMap = this.namedSubqueries.get(this.subqueryDepth);
            boolean bl = orderedHashMap.add(string, null);
            if (!bl) {
                throw Error.error(5504, string);
            }
        }

        private void registerSubquery(String string, TableDerived tableDerived) {
            OrderedHashMap<String, TableDerived> orderedHashMap = this.namedSubqueries.get(this.subqueryDepth);
            orderedHashMap.put(string, tableDerived);
        }

        private void unregisterSubqueries() {
            if (this.namedSubqueries == null) {
                return;
            }
            for (int i = this.subqueryDepth; i < this.namedSubqueries.size(); ++i) {
                OrderedHashMap<String, TableDerived> orderedHashMap = this.namedSubqueries.get(i);
                if (orderedHashMap == null) continue;
                orderedHashMap.clear();
            }
        }

        private TableDerived getNamedSubQuery(String string) {
            TableDerived tableDerived;
            if (this.baseContext != null && (tableDerived = this.baseContext.getNamedSubQuery(string)) != null) {
                return tableDerived;
            }
            if (this.namedSubqueries == null) {
                return null;
            }
            for (int i = this.subqueryDepth; i >= 0; --i) {
                OrderedHashMap<String, TableDerived> orderedHashMap;
                if (this.namedSubqueries.size() <= i || (orderedHashMap = this.namedSubqueries.get(i)) == null || orderedHashMap.getIndex(string) < 0) continue;
                TableDerived tableDerived2 = (TableDerived)orderedHashMap.get((Object)string);
                if (tableDerived2 == null) {
                    HsqlException hsqlException = Error.error(5501, string);
                    hsqlException.setToken(string);
                    throw hsqlException;
                }
                return tableDerived2;
            }
            return null;
        }

        private void addParameter(ExpressionColumn expressionColumn, int n) {
            this.parameters.put(n, expressionColumn);
        }

        private void addDomainOrType(SchemaObject schemaObject) {
            this.usedTypes.add(schemaObject);
        }

        private void addSequence(SchemaObject schemaObject) {
            this.usedSequences.add(schemaObject);
        }

        void addFunctionCall(FunctionSQLInvoked functionSQLInvoked) {
            this.usedRoutines.add(functionSQLInvoked);
        }

        void addProcedureCall(Routine routine) {
            this.callProcedure = routine;
        }

        ExpressionColumn[] getParameters() {
            if (this.parameters.isEmpty()) {
                return ExpressionColumn.emptyArray;
            }
            ExpressionColumn[] expressionColumnArray = new ExpressionColumn[this.parameters.size()];
            this.parameters.valuesToArray(expressionColumnArray);
            this.parameters.clear();
            return expressionColumnArray;
        }

        public OrderedHashSet<HsqlNameManager.HsqlName> getSchemaObjectNames() {
            Object object;
            int n;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            for (n = 0; n < this.usedSequences.size(); ++n) {
                object = this.usedSequences.get(n);
                orderedHashSet.add(object.getName());
            }
            for (n = 0; n < this.usedTypes.size(); ++n) {
                object = this.usedTypes.get(n);
                orderedHashSet.add(object.getName());
            }
            for (n = 0; n < this.rangeVariables.size(); ++n) {
                object = (RangeVariable)this.rangeVariables.getValueAt(n);
                if (((RangeVariable)object).isViewSubquery || ((RangeVariable)object).rangeType == 5) continue;
                HsqlNameManager.HsqlName hsqlName = ((RangeVariable)object).rangeTable.getName();
                if (hsqlName.type == 10) {
                    orderedHashSet.addAll(((RangeVariable)object).getColumnNames());
                    continue;
                }
                if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                orderedHashSet.add(hsqlName);
                orderedHashSet.addAll(((RangeVariable)object).getColumnNames());
                if (((RangeVariable)object).periodCondition == null || !((RangeVariable)object).periodCondition.isSystemVersionCondition()) continue;
                orderedHashSet.add(((RangeVariable)object).rangeTable.systemPeriod.getName());
            }
            Routine[] routineArray = this.getRoutines();
            for (int i = 0; i < routineArray.length; ++i) {
                orderedHashSet.add(routineArray[i].getSpecificName());
            }
            return orderedHashSet;
        }
    }
}

