/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import shaded.io.github.spannm.jackcess.Database;
import shaded.io.github.spannm.jackcess.impl.ByteUtil;
import shaded.io.github.spannm.jackcess.impl.DatabaseImpl;
import shaded.io.github.spannm.jackcess.impl.TableImpl;
import shaded.io.github.spannm.jackcess.util.LinkResolver;
import shaded.io.github.spannm.jackcess.util.MemFileChannel;

public abstract class CustomLinkResolver
implements LinkResolver {
    private static final Random DB_ID = new Random();
    private static final String MEM_DB_PREFIX = "memdb_";
    private static final String FILE_DB_PREFIX = "linkeddb_";
    public static final Database.FileFormat DEFAULT_FORMAT = Database.FileFormat.V2000;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final Path DEFAULT_TEMP_DIR = null;
    private final Database.FileFormat _defaultFormat;
    private final boolean _defaultInMemory;
    private final Path _defaultTempDir;

    protected CustomLinkResolver() {
        this(DEFAULT_FORMAT, false, DEFAULT_TEMP_DIR);
    }

    protected CustomLinkResolver(Database.FileFormat defaultFormat, boolean defaultInMemory, Path defaultTempDir) {
        this._defaultFormat = defaultFormat;
        this._defaultInMemory = defaultInMemory;
        this._defaultTempDir = defaultTempDir;
    }

    protected Database.FileFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    protected boolean isDefaultInMemory() {
        return this._defaultInMemory;
    }

    protected Path getDefaultTempDirectory() {
        return this._defaultTempDir;
    }

    @Override
    public Database resolveLinkedDatabase(Database linkerDb, String linkeeFileName) throws IOException {
        Object customFile = this.loadCustomFile(linkerDb, linkeeFileName);
        if (customFile != null) {
            boolean readOnly = linkerDb instanceof DatabaseImpl && ((DatabaseImpl)linkerDb).isReadOnly();
            return this.createTempDb(customFile, this.getDefaultFormat(), this.isDefaultInMemory(), this.getDefaultTempDirectory(), readOnly);
        }
        return DEFAULT.resolveLinkedDatabase(linkerDb, linkeeFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Database createTempDb(Object customFile, Database.FileFormat format, boolean inMemory, Path tempDir, boolean readOnly) throws IOException {
        TempDatabaseImpl tempDatabaseImpl;
        block5: {
            Path dbFile = null;
            FileChannel channel = null;
            boolean success = false;
            try {
                if (inMemory) {
                    dbFile = Paths.get(MEM_DB_PREFIX + DB_ID.nextLong() + format.getFileExtension(), new String[0]);
                    channel = MemFileChannel.newChannel();
                } else {
                    dbFile = tempDir != null ? Files.createTempFile(tempDir, FILE_DB_PREFIX, format.getFileExtension(), new FileAttribute[0]) : Files.createTempFile(FILE_DB_PREFIX, format.getFileExtension(), new FileAttribute[0]);
                    channel = FileChannel.open(dbFile, DatabaseImpl.RW_CHANNEL_OPTS);
                }
                TempDatabaseImpl.initDbChannel(channel, format);
                TempDatabaseImpl db = new TempDatabaseImpl(this, customFile, dbFile, channel, format, readOnly);
                success = true;
                tempDatabaseImpl = db;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ByteUtil.closeQuietly(channel);
                    CustomLinkResolver.deleteDbFile(dbFile);
                    CustomLinkResolver.closeCustomFile(customFile);
                }
                throw throwable;
            }
            ByteUtil.closeQuietly(channel);
            CustomLinkResolver.deleteDbFile(dbFile);
            CustomLinkResolver.closeCustomFile(customFile);
        }
        return tempDatabaseImpl;
    }

    private static void deleteDbFile(Path dbFile) {
        if (dbFile != null && dbFile.getFileName().toString().startsWith(FILE_DB_PREFIX)) {
            try {
                Files.deleteIfExists(dbFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeCustomFile(Object customFile) {
        if (customFile instanceof Closeable) {
            ByteUtil.closeQuietly((Closeable)customFile);
        }
    }

    protected abstract Object loadCustomFile(Database var1, String var2);

    protected abstract boolean loadCustomTable(Database var1, Object var2, String var3) throws IOException;

    private static class TempDatabaseImpl
    extends DatabaseImpl {
        private final CustomLinkResolver _resolver;
        private final Object _customFile;

        protected TempDatabaseImpl(CustomLinkResolver resolver, Object customFile, Path file, FileChannel channel, Database.FileFormat fileFormat, boolean readOnly) throws IOException {
            super(file, channel, true, false, fileFormat, null, null, null, readOnly, false);
            this._resolver = resolver;
            this._customFile = customFile;
        }

        @Override
        protected TableImpl getTable(String name, boolean includeSystemTables) throws IOException {
            TableImpl table = super.getTable(name, includeSystemTables);
            if (table == null && this._resolver.loadCustomTable(this, this._customFile, name)) {
                table = super.getTable(name, includeSystemTables);
            }
            return table;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                CustomLinkResolver.deleteDbFile(this.getPath());
                CustomLinkResolver.closeCustomFile(this._customFile);
            }
        }

        static FileChannel initDbChannel(FileChannel channel, Database.FileFormat format) throws IOException {
            DatabaseImpl.FileFormatDetails details = TempDatabaseImpl.getFileFormatDetails(format);
            TempDatabaseImpl.transferDatabase(TempDatabaseImpl.getResourceAsStream(details.getEmptyFilePath()), channel);
            return channel;
        }
    }
}

