/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.complex;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.complex.ComplexDataType;
import shaded.io.github.spannm.jackcess.complex.ComplexValue;
import shaded.io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import shaded.io.github.spannm.jackcess.complex.UnsupportedColumnInfo;
import shaded.io.github.spannm.jackcess.complex.UnsupportedValue;
import shaded.io.github.spannm.jackcess.impl.complex.ComplexColumnInfoImpl;

public class UnsupportedColumnInfoImpl
extends ComplexColumnInfoImpl<UnsupportedValue>
implements UnsupportedColumnInfo {
    public UnsupportedColumnInfoImpl(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
    }

    public List<Column> getValueColumns() {
        return this.getTypeColumns();
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.UNSUPPORTED;
    }

    @Override
    protected UnsupportedValueImpl toValue(ComplexValueForeignKey complexValueFk, Row rawValue) {
        ComplexColumnInfoImpl.ComplexValueIdImpl id = this.getValueId(rawValue);
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Column col : this.getValueColumns()) {
            col.setRowValue(values, col.getRowValue(rawValue));
        }
        return new UnsupportedValueImpl(id, complexValueFk, values);
    }

    @Override
    protected Object[] asRow(Object[] row, UnsupportedValue value) throws IOException {
        super.asRow(row, value);
        Map<String, Object> values = value.getValues();
        for (Column col : this.getValueColumns()) {
            col.setRowValue(row, col.getRowValue(values));
        }
        return row;
    }

    public static UnsupportedValue newValue(Map<String, ?> values) {
        return UnsupportedColumnInfoImpl.newValue(INVALID_FK, values);
    }

    public static UnsupportedValue newValue(ComplexValueForeignKey complexValueFk, Map<String, ?> values) {
        return new UnsupportedValueImpl(INVALID_ID, complexValueFk, new LinkedHashMap<String, Object>(values));
    }

    private static class UnsupportedValueImpl
    extends ComplexColumnInfoImpl.ComplexValueImpl
    implements UnsupportedValue {
        private final Map<String, Object> _values;

        private UnsupportedValueImpl(ComplexValue.Id id, ComplexValueForeignKey complexValueFk, Map<String, Object> values) {
            super(id, complexValueFk);
            this._values = values;
        }

        @Override
        public Map<String, Object> getValues() {
            return this._values;
        }

        @Override
        public Object get(String columnName) {
            return this.getValues().get(columnName);
        }

        @Override
        public void set(String columnName, Object value) {
            this.getValues().put(columnName, value);
        }

        @Override
        public void update() throws IOException {
            this.getComplexValueForeignKey().updateUnsupportedValue(this);
        }

        @Override
        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteUnsupportedValue(this);
        }

        public String toString() {
            return "UnsupportedValue(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.getValues();
        }
    }
}

