/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import shaded.io.github.spannm.jackcess.ColumnBuilder;
import shaded.io.github.spannm.jackcess.DataType;
import shaded.io.github.spannm.jackcess.IndexBuilder;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.impl.DatabaseImpl;
import shaded.io.github.spannm.jackcess.impl.IndexData;
import shaded.io.github.spannm.jackcess.impl.IndexImpl;
import shaded.io.github.spannm.jackcess.impl.TableImpl;
import shaded.io.github.spannm.jackcess.impl.TableMutator;

public class TableUpdater
extends TableMutator {
    private final TableImpl _table;
    private ColumnBuilder _column;
    private IndexBuilder _index;
    private int _origTdefLen;
    private int _addedTdefLen;
    private final List<Integer> _nextPages = new ArrayList<Integer>(1);
    private TableMutator.ColumnState _colState;
    private TableMutator.IndexDataState _idxDataState;
    private IndexImpl.ForeignKeyReference _fkReference;

    public TableUpdater(TableImpl table) {
        super(table.getDatabase());
        this._table = table;
    }

    public ColumnBuilder getColumn() {
        return this._column;
    }

    public IndexBuilder getIndex() {
        return this._index;
    }

    @Override
    String getTableName() {
        return this._table.getName();
    }

    @Override
    public int getTdefPageNumber() {
        return this._table.getTableDefPageNumber();
    }

    @Override
    short getColumnNumber(String colName) {
        for (ColumnImpl col : this._table.getColumns()) {
            if (!col.getName().equalsIgnoreCase(colName)) continue;
            return col.getColumnNumber();
        }
        return -1;
    }

    @Override
    public TableMutator.ColumnState getColumnState(ColumnBuilder col) {
        return col == this._column ? this._colState : null;
    }

    @Override
    public TableMutator.IndexDataState getIndexDataState(IndexBuilder idx) {
        return idx == this._index ? this._idxDataState : null;
    }

    void setForeignKey(IndexImpl.ForeignKeyReference fkReference) {
        this._fkReference = fkReference;
    }

    @Override
    public IndexImpl.ForeignKeyReference getForeignKey(IndexBuilder idx) {
        return idx == this._index ? this._fkReference : null;
    }

    int getAddedTdefLen() {
        return this._addedTdefLen;
    }

    void addTdefLen(int add) {
        this._addedTdefLen += add;
    }

    void setOrigTdefLen(int len) {
        this._origTdefLen = len;
    }

    List<Integer> getNextPages() {
        return this._nextPages;
    }

    void resetTdefInfo() {
        this._addedTdefLen = 0;
        this._origTdefLen = 0;
        this._nextPages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnImpl addColumn(ColumnBuilder column) throws IOException {
        this._column = column;
        this.validateAddColumn();
        short columnNumber = (short)this._table.getMaxColumnCount();
        this._column.setColumnNumber(columnNumber);
        if (this._column.getType().isLongValue()) {
            this._colState = new TableMutator.ColumnState();
        }
        this.getPageChannel().startExclusiveWrite();
        try {
            ColumnImpl columnImpl = this._table.mutateAddColumn(this);
            return columnImpl;
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    public IndexImpl addIndex(IndexBuilder index) throws IOException {
        return this.addIndex(index, false, (byte)0, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexImpl addIndex(IndexBuilder index, boolean isInternal, byte ignoreIdxFlags, byte ignoreColFlags) throws IOException {
        this._index = index;
        if (!isInternal) {
            this.validateAddIndex();
        }
        int indexNumber = this._table.getLogicalIndexCount();
        this._index.setIndexNumber(indexNumber);
        this.initIndexDataState(ignoreIdxFlags, ignoreColFlags);
        if (!isInternal) {
            this.getPageChannel().startExclusiveWrite();
        } else {
            this.getPageChannel().startWrite();
        }
        try {
            if (this._idxDataState.getIndexDataNumber() == this._table.getIndexCount()) {
                this._table.mutateAddIndexData(this);
                this.resetTdefInfo();
            }
            IndexImpl indexImpl = this._table.mutateAddIndex(this);
            return indexImpl;
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    boolean validateUpdatedTdef(ByteBuffer tableBuffer) {
        return this._origTdefLen + this._addedTdefLen == tableBuffer.limit();
    }

    private void validateAddColumn() {
        if (this._column == null) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot add column with no column"));
        }
        if (this._table.getColumnCount() + 1 > this.getFormat().MAX_COLUMNS_PER_TABLE) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot add column to table with " + this.getFormat().MAX_COLUMNS_PER_TABLE + " columns"));
        }
        Set<String> colNames = this.getColumnNames();
        this.validateColumn(colNames, this._column);
        if (this._column.isAutoNumber()) {
            EnumSet<DataType> autoTypes = EnumSet.noneOf(DataType.class);
            for (ColumnImpl column : this._table.getAutoNumberColumns()) {
                autoTypes.add(column.getType());
            }
            this.validateAutoNumberColumn(autoTypes, this._column);
        }
    }

    private void validateAddIndex() {
        if (this._index == null) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot add index with no index"));
        }
        if (this._table.getLogicalIndexCount() + 1 > this.getFormat().MAX_INDEXES_PER_TABLE) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot add index to table with " + this.getFormat().MAX_INDEXES_PER_TABLE + " indexes"));
        }
        boolean[] foundPk = new boolean[1];
        Set<String> idxNames = TableUpdater.getIndexNames(this._table, foundPk);
        this.validateIndex(this.getColumnNames(), idxNames, foundPk, this._index);
    }

    private Set<String> getColumnNames() {
        HashSet<String> colNames = new HashSet<String>();
        for (ColumnImpl column : this._table.getColumns()) {
            colNames.add(DatabaseImpl.toLookupName(column.getName()));
        }
        return colNames;
    }

    static Set<String> getIndexNames(TableImpl table, boolean[] foundPk) {
        HashSet<String> idxNames = new HashSet<String>();
        for (IndexImpl index : table.getIndexes()) {
            idxNames.add(DatabaseImpl.toLookupName(index.getName()));
            if (!index.isPrimaryKey() || foundPk == null) continue;
            foundPk[0] = true;
        }
        return idxNames;
    }

    private void initIndexDataState(byte ignoreIdxFlags, byte ignoreColFlags) {
        this._idxDataState = new TableMutator.IndexDataState();
        this._idxDataState.addIndex(this._index);
        IndexData idxData = TableUpdater.findIndexData(this._index, this._table, ignoreIdxFlags, ignoreColFlags);
        int idxDataNumber = idxData != null ? idxData.getIndexDataNumber() : this._table.getIndexCount();
        this._idxDataState.setIndexDataNumber(idxDataNumber);
    }

    static IndexData findIndexData(IndexBuilder idx, TableImpl table, byte ignoreIdxFlags, byte ignoreColFlags) {
        for (IndexData idxData : table.getIndexDatas()) {
            if (!TableUpdater.sameIndexData(idx, idxData, ignoreIdxFlags, ignoreColFlags)) continue;
            return idxData;
        }
        return null;
    }

    private static boolean sameIndexData(IndexBuilder idx1, IndexData idx2, byte ignoreIdxFlags, byte ignoreColFlags) {
        if ((idx1.getFlags() | ignoreIdxFlags) != (idx2.getIndexFlags() | ignoreIdxFlags) || idx1.getColumns().size() != idx2.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < idx1.getColumns().size(); ++i) {
            IndexData.ColumnDescriptor col2;
            IndexBuilder.Column col1 = idx1.getColumns().get(i);
            if (TableUpdater.sameIndexData(col1, col2 = idx2.getColumns().get(i), ignoreColFlags)) continue;
            return false;
        }
        return true;
    }

    private static boolean sameIndexData(IndexBuilder.Column col1, IndexData.ColumnDescriptor col2, int ignoreColFlags) {
        return col1.getName().equals(col2.getName()) && (col1.getFlags() | ignoreColFlags) == (col2.getFlags() | ignoreColFlags);
    }

    @Override
    protected String withErrorContext(String msg) {
        Object objStr = "";
        if (this._column != null) {
            objStr = ";Column=" + this._column.getName();
        } else if (this._index != null) {
            objStr = ";Index=" + this._index.getName();
        }
        return msg + "(Table=" + this._table.getName() + (String)objStr + ")";
    }
}

