/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import shaded.io.github.spannm.jackcess.CursorBuilder;
import shaded.io.github.spannm.jackcess.Index;
import shaded.io.github.spannm.jackcess.IndexBuilder;
import shaded.io.github.spannm.jackcess.impl.ByteUtil;
import shaded.io.github.spannm.jackcess.impl.DatabaseImpl;
import shaded.io.github.spannm.jackcess.impl.IndexData;
import shaded.io.github.spannm.jackcess.impl.JetFormat;
import shaded.io.github.spannm.jackcess.impl.PageChannel;
import shaded.io.github.spannm.jackcess.impl.TableCreator;
import shaded.io.github.spannm.jackcess.impl.TableImpl;
import shaded.io.github.spannm.jackcess.impl.TableMutator;
import shaded.io.github.spannm.jackcess.util.ToStringBuilder;

public class IndexImpl
implements Index,
Comparable<IndexImpl> {
    protected static final System.Logger LOGGER = System.getLogger(IndexImpl.class.getName());
    public static final byte PRIMARY_KEY_INDEX_TYPE = 1;
    public static final byte FOREIGN_KEY_INDEX_TYPE = 2;
    private static final byte CASCADE_UPDATES_FLAG = 1;
    private static final byte CASCADE_DELETES_FLAG = 1;
    private static final byte CASCADE_NULL_FLAG = 2;
    static final byte FK_PRIMARY_TABLE_TYPE = 1;
    static final byte FK_SECONDARY_TABLE_TYPE = 2;
    private static final int INVALID_INDEX_NUMBER = -1;
    private final IndexData _data;
    private final int _indexNumber;
    private final byte _indexType;
    private String _name;
    private final ForeignKeyReference _reference;

    protected IndexImpl(ByteBuffer tableBuffer, List<IndexData> indexDatas, JetFormat format) {
        ByteUtil.forward(tableBuffer, format.SKIP_BEFORE_INDEX_SLOT);
        this._indexNumber = tableBuffer.getInt();
        int indexDataNumber = tableBuffer.getInt();
        byte relIndexType = tableBuffer.get();
        int relIndexNumber = tableBuffer.getInt();
        int relTablePageNumber = tableBuffer.getInt();
        byte cascadeUpdatesFlag = tableBuffer.get();
        byte cascadeDeletesFlag = tableBuffer.get();
        this._indexType = tableBuffer.get();
        this._reference = this._indexType == 2 && relIndexNumber != -1 ? new ForeignKeyReference(relIndexType, relIndexNumber, relTablePageNumber, (cascadeUpdatesFlag & 1) != 0, (cascadeDeletesFlag & 1) != 0, (cascadeDeletesFlag & 2) != 0) : null;
        ByteUtil.forward(tableBuffer, format.SKIP_AFTER_INDEX_SLOT);
        this._data = indexDatas.get(indexDataNumber);
        this._data.addIndex(this);
    }

    public IndexData getIndexData() {
        return this._data;
    }

    @Override
    public TableImpl getTable() {
        return this.getIndexData().getTable();
    }

    public JetFormat getFormat() {
        return this.getTable().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getTable().getPageChannel();
    }

    public int getIndexNumber() {
        return this._indexNumber;
    }

    public byte getIndexFlags() {
        return this.getIndexData().getIndexFlags();
    }

    public int getUniqueEntryCount() {
        return this.getIndexData().getUniqueEntryCount();
    }

    public int getUniqueEntryCountOffset() {
        return this.getIndexData().getUniqueEntryCountOffset();
    }

    @Override
    public String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
    }

    @Override
    public boolean isPrimaryKey() {
        return this._indexType == 1;
    }

    @Override
    public boolean isForeignKey() {
        return this._indexType == 2;
    }

    public ForeignKeyReference getReference() {
        return this._reference;
    }

    @Override
    public IndexImpl getReferencedIndex() throws IOException {
        if (this._reference == null) {
            return null;
        }
        TableImpl refTable = this.getTable().getDatabase().getTable(this._reference.getOtherTablePageNumber());
        if (refTable == null) {
            throw new IOException(this.withErrorContext("Reference to missing table " + this._reference.getOtherTablePageNumber()));
        }
        IndexImpl refIndex = null;
        int idxNumber = this._reference.getOtherIndexNumber();
        for (IndexImpl idx : refTable.getIndexes()) {
            if (idx.getIndexNumber() != idxNumber) continue;
            refIndex = idx;
            break;
        }
        if (refIndex == null) {
            throw new IOException(this.withErrorContext("Reference to missing index " + idxNumber + " on table " + refTable.getName()));
        }
        ForeignKeyReference otherRef = refIndex.getReference();
        if (otherRef == null || otherRef.getOtherTablePageNumber() != this.getTable().getTableDefPageNumber() || otherRef.getOtherIndexNumber() != this._indexNumber) {
            throw new IOException(this.withErrorContext("Found unexpected index " + refIndex.getName() + " on table " + refTable.getName() + " with reference " + otherRef));
        }
        return refIndex;
    }

    @Override
    public boolean shouldIgnoreNulls() {
        return this.getIndexData().shouldIgnoreNulls();
    }

    @Override
    public boolean isUnique() {
        return this.getIndexData().isUnique();
    }

    @Override
    public boolean isRequired() {
        return this.getIndexData().isRequired();
    }

    public List<IndexData.ColumnDescriptor> getColumns() {
        return this.getIndexData().getColumns();
    }

    @Override
    public int getColumnCount() {
        return this.getIndexData().getColumnCount();
    }

    @Override
    public CursorBuilder newCursor() {
        return this.getTable().newCursor().withIndex(this);
    }

    public boolean isInitialized() {
        return this.getIndexData().isInitialized();
    }

    public void initialize() throws IOException {
        this.getIndexData().initialize();
    }

    public IndexData.EntryCursor cursor() throws IOException {
        return this.cursor(null, true, null, true);
    }

    public IndexData.EntryCursor cursor(Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        return this.getIndexData().cursor(startRow, startInclusive, endRow, endInclusive);
    }

    public Object[] constructIndexRowFromEntry(Object ... values) {
        return this.getIndexData().constructIndexRowFromEntry(values);
    }

    public Object[] constructPartialIndexRowFromEntry(Object filler, Object ... values) {
        return this.getIndexData().constructPartialIndexRowFromEntry(filler, values);
    }

    public Object[] constructIndexRow(String colName, Object value) {
        return this.constructIndexRow(Collections.singletonMap(colName, value));
    }

    public Object[] constructPartialIndexRow(Object filler, String colName, Object value) {
        return this.constructPartialIndexRow(filler, Collections.singletonMap(colName, value));
    }

    public Object[] constructIndexRow(Map<String, ?> row) {
        return this.getIndexData().constructIndexRow(row);
    }

    public Object[] constructPartialIndexRow(Object filler, Map<String, ?> row) {
        return this.getIndexData().constructPartialIndexRow(filler, row);
    }

    public String toString() {
        ToStringBuilder sb = ToStringBuilder.builder(this).append("name", "(" + this.getTable().getName() + ") " + this._name).append("number", this._indexNumber).append("isPrimaryKey", this.isPrimaryKey()).append("isForeignKey", this.isForeignKey());
        if (this._reference != null) {
            sb.append("foreignKeyReference", this._reference);
        }
        sb.append("data", this._data);
        return sb.toString();
    }

    @Override
    public int compareTo(IndexImpl other) {
        return Integer.compare(this._indexNumber, other.getIndexNumber());
    }

    protected static void writeDefinitions(TableCreator creator, ByteBuffer buffer) {
        for (IndexBuilder idx : creator.getIndexes()) {
            IndexImpl.writeDefinition(creator, idx, buffer);
        }
        for (IndexBuilder idx : creator.getIndexes()) {
            TableImpl.writeName(buffer, idx.getName(), creator.getCharset());
        }
    }

    protected static void writeDefinition(TableMutator mutator, IndexBuilder idx, ByteBuffer buffer) {
        TableMutator.IndexDataState idxDataState = mutator.getIndexDataState(idx);
        buffer.putInt(1625);
        buffer.putInt(idx.getIndexNumber());
        buffer.putInt(idxDataState.getIndexDataNumber());
        byte idxType = idx.getType();
        if (idxType != 2) {
            buffer.put((byte)0);
            buffer.putInt(-1);
            buffer.putInt(0);
            buffer.put((byte)0);
            buffer.put((byte)0);
        } else {
            ForeignKeyReference reference = mutator.getForeignKey(idx);
            buffer.put(reference.getTableType());
            buffer.putInt(reference.getOtherIndexNumber());
            buffer.putInt(reference.getOtherTablePageNumber());
            byte updateFlags = 0;
            if (reference.isCascadeUpdates()) {
                updateFlags = (byte)(updateFlags | 1);
            }
            byte deleteFlags = 0;
            if (reference.isCascadeDeletes()) {
                deleteFlags = (byte)(deleteFlags | 1);
            }
            if (reference.isCascadeNullOnDelete()) {
                deleteFlags = (byte)(deleteFlags | 2);
            }
            buffer.put(updateFlags);
            buffer.put(deleteFlags);
        }
        buffer.put(idxType);
        buffer.putInt(0);
    }

    private String withErrorContext(String msg) {
        return IndexImpl.withErrorContext(msg, this.getTable().getDatabase(), this.getName());
    }

    private static String withErrorContext(String msg, DatabaseImpl db, String idxName) {
        return msg + " (Db=" + db.getName() + ";Index=" + idxName + ")";
    }

    public static class ForeignKeyReference {
        private final byte _tableType;
        private final int _otherIndexNumber;
        private final int _otherTablePageNumber;
        private final boolean _cascadeUpdates;
        private final boolean _cascadeDeletes;
        private final boolean _cascadeNull;

        public ForeignKeyReference(byte tableType, int otherIndexNumber, int otherTablePageNumber, boolean cascadeUpdates, boolean cascadeDeletes, boolean cascadeNull) {
            this._tableType = tableType;
            this._otherIndexNumber = otherIndexNumber;
            this._otherTablePageNumber = otherTablePageNumber;
            this._cascadeUpdates = cascadeUpdates;
            this._cascadeDeletes = cascadeDeletes;
            this._cascadeNull = cascadeNull;
        }

        public byte getTableType() {
            return this._tableType;
        }

        public boolean isPrimaryTable() {
            return this.getTableType() == 1;
        }

        public int getOtherIndexNumber() {
            return this._otherIndexNumber;
        }

        public int getOtherTablePageNumber() {
            return this._otherTablePageNumber;
        }

        public boolean isCascadeUpdates() {
            return this._cascadeUpdates;
        }

        public boolean isCascadeDeletes() {
            return this._cascadeDeletes;
        }

        public boolean isCascadeNullOnDelete() {
            return this._cascadeNull;
        }

        public String toString() {
            return ToStringBuilder.builder(this).append("otherIndexNumber", this._otherIndexNumber).append("otherTablePageNum", this._otherTablePageNumber).append("isPrimaryTable", this.isPrimaryTable()).append("isCascadeUpdates", this.isCascadeUpdates()).append("isCascadeDeletes", this.isCascadeDeletes()).append("isCascadeNullOnDelete", this.isCascadeNullOnDelete()).toString();
        }
    }
}

