/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import shaded.io.github.spannm.jackcess.impl.CodecHandler;
import shaded.io.github.spannm.jackcess.impl.CodecProvider;
import shaded.io.github.spannm.jackcess.impl.JetFormat;
import shaded.io.github.spannm.jackcess.impl.PageChannel;
import shaded.io.github.spannm.jackcess.impl.UnsupportedCodecException;

public class DefaultCodecProvider
implements CodecProvider {
    public static final CodecProvider INSTANCE = new DefaultCodecProvider();
    public static final CodecHandler DUMMY_HANDLER = new DummyHandler();
    public static final CodecHandler UNSUPPORTED_HANDLER = new UnsupportedHandler();

    @Override
    public CodecHandler createHandler(PageChannel channel, Charset charset) throws IOException {
        JetFormat format = channel.getFormat();
        switch (format.CODEC_TYPE) {
            case NONE: {
                return DUMMY_HANDLER;
            }
            case JET: 
            case OFFICE: {
                ByteBuffer bb = channel.createPageBuffer();
                channel.readRootPage(bb);
                int codecKey = bb.getInt(format.OFFSET_ENCODING_KEY);
                return codecKey == 0 ? DUMMY_HANDLER : UNSUPPORTED_HANDLER;
            }
            case MSISAM: {
                return UNSUPPORTED_HANDLER;
            }
        }
        throw new RuntimeException("Unknown codec type " + format.CODEC_TYPE);
    }

    public static class UnsupportedHandler
    implements CodecHandler {
        @Override
        public boolean canEncodePartialPage() {
            return true;
        }

        @Override
        public boolean canDecodeInline() {
            return true;
        }

        @Override
        public void decodePage(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) {
            throw new UnsupportedCodecException("Decoding not supported.  Please choose a CodecProvider which supports reading the current database encoding.");
        }

        @Override
        public ByteBuffer encodePage(ByteBuffer page, int pageNumber, int pageOffset) {
            throw new UnsupportedCodecException("Encoding not supported.  Please choose a CodecProvider which supports writing the current database encoding.");
        }
    }

    public static class DummyHandler
    implements CodecHandler {
        @Override
        public boolean canEncodePartialPage() {
            return true;
        }

        @Override
        public boolean canDecodeInline() {
            return true;
        }

        @Override
        public void decodePage(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) {
        }

        @Override
        public ByteBuffer encodePage(ByteBuffer page, int pageNumber, int pageOffset) {
            return page;
        }
    }
}

