/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.IJackcessOpenerInterface;
import net.ucanaccess.jdbc.IOnReloadReferenceListener;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessDriver;
import shaded.io.github.spannm.jackcess.Database;
import shaded.io.github.spannm.jackcess.DatabaseBuilder;
import shaded.io.github.spannm.jackcess.DateTimeType;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.Table;

public class DBReference {
    private static final String CIPHER_SPEC = "AES";
    private static List<IOnReloadReferenceListener> onReloadListeners = new ArrayList<IOnReloadReferenceListener>();
    private static String version;
    private final System.Logger logger = System.getLogger(this.getClass().getName());
    private final File dbFile;
    private Database dbIO;
    private FileLock fileLock = null;
    private String id = this.createId();
    private boolean inMemory = true;
    private long lastModified;
    private boolean openExclusive = false;
    private final MemoryTimer memoryTimer;
    private boolean readOnly;
    private boolean readOnlyFileFormat;
    private boolean showSchema;
    private File tempHsql;
    private File toKeepHsql;
    private boolean immediatelyReleaseResources;
    private boolean encryptHSQLDB;
    private String encryptionKey;
    private final String pwd;
    private final IJackcessOpenerInterface jko;
    private Map<String, String> externalResourcesMapping;
    private boolean firstConnection = true;
    private Database.FileFormat dbFormat;
    private boolean columnOrderDisplay;
    private boolean hsqldbShutdown;
    private File mirrorFolder;
    private final Set<File> links = new HashSet<File>();
    private boolean ignoreCase = true;
    private boolean mirrorReadOnly;
    private Integer lobScale;
    private boolean skipIndexes;
    private boolean sysSchema;
    private boolean preventReloading;
    private boolean concatNulls;
    private boolean mirrorRecreated;

    public DBReference(File fl, Database.FileFormat ff, IJackcessOpenerInterface _jko, String _pwd) throws IOException {
        this.dbFile = fl;
        this.pwd = _pwd;
        this.jko = _jko;
        this.lastModified = System.currentTimeMillis();
        this.memoryTimer = new MemoryTimer(this);
        if (!fl.exists() && ff != null) {
            DatabaseBuilder dbb = new DatabaseBuilder();
            this.dbIO = dbb.withAutoSync(false).withFileFormat(ff).withFile(fl).create();
        } else {
            this.dbIO = _jko.open(fl, _pwd);
            try {
                this.readOnlyFileFormat = this.dbIO.getFileFormat().equals((Object)Database.FileFormat.V1997);
                this.dbFormat = this.dbIO.getFileFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbIO.setLinkResolver((linkerDb, linkeeFileName) -> {
                if (linkeeFileName == null) {
                    throw new IOException("Cannot resolve db link");
                }
                File linkeeFile = new File(linkeeFileName);
                Map<String, String> emr = this.externalResourcesMapping;
                if (!linkeeFile.exists() && emr != null && emr.containsKey(linkeeFileName.toLowerCase())) {
                    linkeeFile = new File(emr.get(linkeeFileName.toLowerCase()));
                }
                if (!linkeeFile.exists()) {
                    this.logger.log(System.Logger.Level.WARNING, "External file {0} does not exist", linkeeFile.getAbsolutePath());
                } else {
                    this.links.add(linkeeFile);
                }
                Database ldb = this.open(linkeeFile, _pwd);
                ldb.setDateTimeType(DateTimeType.LOCAL_DATE_TIME);
                return ldb;
            });
            this.dbIO.setDateTimeType(DateTimeType.LOCAL_DATE_TIME);
            this.dbIO.setEnforceForeignKeys(false);
        }
    }

    public Database open(File _dbfl, String _pwd) throws IOException {
        Database ret = this.jko.open(_dbfl, _pwd);
        if (this.columnOrderDisplay) {
            ret.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
        return ret;
    }

    boolean loadedFromKeptMirror(Session session) throws UcanaccessSQLException {
        if (this.toKeepHsql != null && this.toKeepHsql.exists()) {
            if (this.getLastUpdateHSQLDB() >= this.dbFile.lastModified()) {
                return true;
            }
            try {
                this.closeHsqlDb(session, true);
            }
            catch (Exception _ex) {
                throw new UcanaccessSQLException(_ex);
            }
            return false;
        }
        return false;
    }

    public static boolean addOnReloadRefListener(IOnReloadReferenceListener _action) {
        return onReloadListeners.add(_action);
    }

    public static String getVersion() {
        return version;
    }

    public static boolean is2xx() {
        return version.startsWith("2.");
    }

    private long filesUpdateTime() {
        long lm = this.dbFile.lastModified();
        for (File fl : this.links) {
            lm = Math.max(lm, fl.lastModified());
        }
        return lm;
    }

    Connection checkLastModified(Connection _conn, Session _session) throws Exception {
        if (this.lastModified + 2000L > this.filesUpdateTime() || this.preventReloading && !this.checkInside()) {
            return _conn;
        }
        this.updateLastModified();
        this.closeHsqlDb(_session);
        this.dbIO.flush();
        this.dbIO.close();
        this.dbIO = this.open(this.dbFile, this.pwd);
        this.id = this.createId();
        this.firstConnection = true;
        LoadJet lj = new LoadJet(this.getHSQLDBConnection(_session), this.dbIO);
        lj.setSkipIndexes(this.skipIndexes);
        lj.setSysSchema(this.sysSchema);
        lj.loadDB();
        return this.getHSQLDBConnection(_session);
    }

    private boolean checkInside(Database db) throws IOException {
        Table t = db.getSystemTable("MSysObjects");
        for (Row row : t) {
            Object dobj = row.get("DateUpdate");
            Object tobj = row.get("Type");
            if (dobj == null || tobj == null) continue;
            Date dt = (Date)dobj;
            short type = (Short)tobj;
            if (this.lastModified >= dt.getTime() || type != 1 && type != 5 && type != 8) continue;
            return true;
        }
        return false;
    }

    private boolean checkInside() throws IOException {
        boolean reload = this.checkInside(this.dbIO);
        if (reload) {
            return true;
        }
        for (File fl : this.links) {
            Database db = DatabaseBuilder.open(fl);
            reload = this.checkInside(db);
            db.close();
            if (!reload) continue;
            return true;
        }
        return false;
    }

    private List<File> getHSQLDBFiles() {
        if (this.toKeepHsql == null) {
            return List.of();
        }
        File folder = this.toKeepHsql.getParentFile();
        String name = this.toKeepHsql.getName();
        return Stream.of("data", "lck", "lobs", "log", "properties", "script").map(ext -> new File(folder, name + "." + ext)).collect(Collectors.toList());
    }

    private long getLastUpdateHSQLDB() {
        long lu = 0L;
        for (File hsqlF : this.getHSQLDBFiles()) {
            if (!hsqlF.exists() || hsqlF.lastModified() <= lu) continue;
            lu = hsqlF.lastModified();
        }
        if (this.toKeepHsql != null && this.toKeepHsql.exists() && this.toKeepHsql.lastModified() > lu) {
            lu = this.toKeepHsql.lastModified();
        }
        return lu;
    }

    private void closeHsqlDb(Session session) throws IOException {
        this.closeHsqlDb(session, false);
    }

    private void closeHsqlDb(Session _session, boolean _firstConnectionKeeptMirror) throws IOException {
        this.finalizeHsqlDb(_session);
        if (!this.inMemory) {
            if (this.toKeepHsql == null) {
                File folder = this.mirrorFolder == null ? this.dbFile.getParentFile() : this.mirrorFolder;
                File hbase = new File(folder, "UCanAccess_" + this.id);
                if (hbase.exists()) {
                    Arrays.stream(Optional.ofNullable(hbase.listFiles()).orElse(new File[0])).filter(f -> !f.delete()).forEach(f -> this.logger.log(System.Logger.Level.WARNING, "Could not delete file {0}", f));
                }
                hbase.delete();
            } else if (!this.immediatelyReleaseResources || _firstConnectionKeeptMirror) {
                this.toKeepHsql.delete();
                if (!this.toKeepHsql.createNewFile()) {
                    this.logger.log(System.Logger.Level.WARNING, "Could not create file {0}", this.toKeepHsql);
                }
                for (File hsqlf : this.getHSQLDBFiles()) {
                    if (!hsqlf.exists()) continue;
                    hsqlf.delete();
                }
                this.mirrorRecreated = true;
            }
        }
    }

    public void decrementActiveConnection(Session session) {
        this.memoryTimer.decrementActiveConnection(session);
    }

    private void finalizeHsqlDb(Session _session) throws IOException {
        if (!this.hsqldbShutdown) {
            this.releaseLock();
            try (Connection conn = this.getHSQLDBConnection(_session);
                 Statement st = conn.createStatement();){
                st.execute("SHUTDOWN");
                this.hsqldbShutdown = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    File getDbFile() {
        return this.dbFile;
    }

    public Database getDbIO() {
        return this.dbIO;
    }

    private void setIgnoreCase(Connection _conn) {
        try (Statement st = _conn.createStatement();){
            st.execute("SET DATABASE COLLATION \"SQL_TEXT_UCC\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initHSQLDB(Connection _conn) {
        try (Statement st = _conn.createStatement();){
            st.execute("SET DATABASE SQL SYNTAX ora TRUE");
            st.execute(String.format("SET DATABASE SQL CONCAT NULLS %s", this.concatNulls));
            if (this.lobScale == null && this.inMemory) {
                st.execute("SET FILES LOB SCALE 1");
            } else if (this.lobScale != null) {
                st.execute(String.format("SET FILES LOB SCALE %s", this.lobScale));
            }
        }
        catch (Exception _ex) {
            this.logger.log(System.Logger.Level.WARNING, _ex.toString());
        }
    }

    public Connection getHSQLDBConnection(Session _session) throws SQLException {
        boolean keptMirror = this.firstConnection && this.toKeepHsql != null && this.toKeepHsql.exists();
        Connection conn = DriverManager.getConnection(this.getHsqlUrl(_session), Optional.ofNullable(_session.getUser()).orElse("Admin"), _session.getPassword());
        if (version == null) {
            version = conn.getMetaData().getDriverVersion();
        }
        if (this.firstConnection) {
            if (this.ignoreCase && (!keptMirror || this.mirrorRecreated)) {
                this.setIgnoreCase(conn);
            }
            if (!this.mirrorReadOnly || !keptMirror || this.mirrorRecreated) {
                this.initHSQLDB(conn);
            }
            this.firstConnection = false;
            this.mirrorRecreated = false;
        }
        this.hsqldbShutdown = false;
        conn.setAutoCommit(false);
        return conn;
    }

    String getId() {
        return this.id;
    }

    private String getKey() throws SQLException {
        if (this.encryptionKey == null) {
            String url = "jdbc:hsqldb:mem:" + this.id + "_tmp";
            try (Connection conn = DriverManager.getConnection(url);
                 Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery("CALL CRYPT_KEY('AES', null) ");){
                rs.next();
                this.encryptionKey = rs.getString(1);
            }
        }
        return this.encryptionKey;
    }

    private String getHsqlUrl(Session _session) throws SQLException {
        try {
            if (this.openExclusive && this.fileLock == null) {
                this.lockMdbFile();
            }
            Object enc = "";
            String log = "";
            if (this.encryptHSQLDB) {
                enc = ";crypt_key=" + this.getKey() + ";crypt_type=aes;crypt_lobs=true";
            }
            if (!this.inMemory && this.toKeepHsql == null) {
                log = ";hsqldb.log_data=FALSE";
            }
            if (!this.inMemory && this.tempHsql == null) {
                if (this.toKeepHsql != null) {
                    if (!this.toKeepHsql.exists() && !this.toKeepHsql.createNewFile()) {
                        this.logger.log(System.Logger.Level.WARNING, "Could not create file {0}", this.toKeepHsql);
                    }
                    this.tempHsql = this.toKeepHsql;
                } else {
                    File folder = this.mirrorFolder == null ? this.dbFile.getParentFile() : this.mirrorFolder;
                    File hbase = new File(folder, "UCanAccess_" + this.id);
                    hbase.mkdir();
                    this.tempHsql = new File(hbase, this.id);
                    if (!this.tempHsql.createNewFile()) {
                        this.logger.log(System.Logger.Level.WARNING, "Could not create file {0}", this.tempHsql);
                    } else {
                        this.tempHsql.delete();
                    }
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (this.toKeepHsql == null) {
                            this.closeHsqlDb(_session);
                        } else {
                            this.finalizeHsqlDb(_session);
                        }
                    }
                    catch (Exception _ex) {
                        this.logger.log(System.Logger.Level.WARNING, _ex.toString());
                    }
                }));
            }
            String mro = this.mirrorReadOnly ? ";readonly=true" : "";
            return "jdbc:hsqldb:" + (String)(this.inMemory ? "mem:" + this.id : this.tempHsql.getAbsolutePath()) + (String)enc + log + mro;
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public long getInactivityTimeout() {
        return this.memoryTimer.inactivityTimeout;
    }

    private String createId() {
        return UUID.randomUUID() + "-" + new UniqueString();
    }

    public void incrementActiveConnection() {
        this.memoryTimer.incrementActiveConnection();
    }

    public boolean isReadOnly() throws UcanaccessSQLException {
        if (this.readOnly) {
            this.lockMdbFile();
        }
        return this.readOnlyFileFormat || this.readOnly;
    }

    boolean isReadOnlyFileFormat() {
        return this.readOnlyFileFormat;
    }

    boolean isShowSchema() {
        return this.showSchema;
    }

    private File fileLock() {
        File folder = this.dbFile.getParentFile();
        String fileName = this.dbFile.getName();
        int suffixStart = fileName.lastIndexOf(46);
        if (suffixStart < 0) {
            suffixStart = fileName.length();
        }
        String suffix = Database.FileFormat.V2016 == this.dbFormat || Database.FileFormat.V2010 == this.dbFormat || Database.FileFormat.V2007 == this.dbFormat ? ".laccdb" : ".ldb";
        return new File(folder, fileName.substring(0, suffixStart) + suffix);
    }

    private void lockMdbFile() throws UcanaccessSQLException {
        try {
            RandomAccessFile raf;
            FileLock tryLock;
            File flLock = this.fileLock();
            if (!flLock.createNewFile()) {
                this.logger.log(System.Logger.Level.WARNING, "Could not create file {0}", flLock);
            }
            if ((tryLock = (raf = new RandomAccessFile(flLock, "rw")).getChannel().tryLock()) == null) {
                this.readOnly = true;
            } else {
                this.fileLock = tryLock;
                this.readOnly = false;
            }
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public void releaseLock() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
        }
    }

    public void reloadDbIO() throws IOException {
        this.dbIO.flush();
        this.dbIO.close();
        for (IOnReloadReferenceListener listener : onReloadListeners) {
            listener.onReload();
        }
        this.dbIO = this.open(this.dbFile, this.pwd);
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.memoryTimer.setInactivityTimeout(inactivityTimeout);
    }

    public void setInMemory(boolean _inMemory) {
        this.inMemory = _inMemory;
    }

    public void setOpenExclusive(boolean _openExclusive) {
        this.openExclusive = _openExclusive;
    }

    public void setShowSchema(boolean _showSchema) {
        this.showSchema = _showSchema;
    }

    void shutdown(Session _session) throws Exception {
        DBReferenceSingleton.getInstance().remove(this.dbFile.getAbsolutePath());
        if (this.immediatelyReleaseResources) {
            for (IOnReloadReferenceListener listener : onReloadListeners) {
                listener.onReload();
            }
        }
        this.memoryTimer.timer.cancel();
        this.dbIO.flush();
        this.dbIO.close();
        this.closeHsqlDb(_session);
    }

    public void updateLastModified() {
        this.lastModified = this.filesUpdateTime();
    }

    public void setImmediatelyReleaseResources(boolean _immediatelyReleaseResources) {
        this.immediatelyReleaseResources = _immediatelyReleaseResources;
    }

    public void setEncryptHSQLDB(boolean _encryptHSQLDB) {
        this.encryptHSQLDB = _encryptHSQLDB;
    }

    public void setExternalResourcesMapping(Map<String, String> _externalResourcesMapping) {
        this.externalResourcesMapping = _externalResourcesMapping;
    }

    public File getToKeepHsql() {
        return this.toKeepHsql;
    }

    public void setToKeepHsql(File _toKeepHsql) {
        this.toKeepHsql = _toKeepHsql;
    }

    public boolean isEncryptHSQLDB() {
        return this.encryptHSQLDB;
    }

    public void setColumnOrderDisplay() {
        this.columnOrderDisplay = true;
        if (this.dbIO != null) {
            this.dbIO.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public void setMirrorFolder(File _mirrorFolder) {
        this.mirrorFolder = _mirrorFolder;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean _ignoreCase) {
        this.ignoreCase = _ignoreCase;
    }

    public void setMirrorReadOnly(boolean _mirrorReadOnly) {
        this.mirrorReadOnly = _mirrorReadOnly;
    }

    public void setLobScale(Integer _lobScale) {
        this.lobScale = _lobScale;
    }

    public void setSkipIndexes(boolean _skipIndexes) {
        this.skipIndexes = _skipIndexes;
    }

    public void setSysSchema(boolean _sysSchema) {
        this.sysSchema = _sysSchema;
    }

    public boolean isPreventReloading() {
        return this.preventReloading;
    }

    public void setPreventReloading(boolean _preventReloading) {
        this.preventReloading = _preventReloading;
    }

    public boolean isConcatNulls() {
        return this.concatNulls;
    }

    public void setConcatNulls(boolean _concatNulls) {
        this.concatNulls = _concatNulls;
    }

    private static class MemoryTimer {
        private static final long INACTIVITY_TIMEOUT_DEFAULT = 120000L;
        private final System.Logger logger = System.getLogger(this.getClass().getName());
        private final DBReference dbReference;
        private final Timer timer;
        private int activeConnection;
        private long inactivityTimeout = 120000L;
        private long lastConnectionTime;

        MemoryTimer(DBReference _dbReference) {
            this.dbReference = _dbReference;
            this.timer = new Timer(this.getClass().getSimpleName() + "-" + _dbReference.getDbFile().getName(), true);
        }

        synchronized void decrementActiveConnection(final Session _session) {
            --this.activeConnection;
            if (this.dbReference.immediatelyReleaseResources && this.activeConnection == 0) {
                try {
                    this.dbReference.shutdown(_session);
                }
                catch (Exception _ex) {
                    this.logger.log(System.Logger.Level.WARNING, "Error shutting down db {0}: {1}", this.dbReference, _ex.toString());
                }
                this.timer.cancel();
                return;
            }
            if (this.dbReference.inMemory && this.inactivityTimeout > 0L && this.activeConnection == 0) {
                TimerTask task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
                        synchronized (UcanaccessDriver.class) {
                            if (System.currentTimeMillis() - this.getLastConnectionTime() >= inactivityTimeout && this.getActiveConnection() == 0) {
                                try {
                                    dbReference.shutdown(_session);
                                }
                                catch (Exception _ignored) {
                                    logger.log(System.Logger.Level.DEBUG, "Ignore {0}", _ignored.toString());
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                this.timer.schedule(task, this.inactivityTimeout);
            }
        }

        synchronized int getActiveConnection() {
            return this.activeConnection;
        }

        synchronized long getLastConnectionTime() {
            return this.lastConnectionTime;
        }

        synchronized void incrementActiveConnection() {
            ++this.activeConnection;
            if (this.dbReference.inMemory && this.inactivityTimeout > 0L) {
                this.lastConnectionTime = System.currentTimeMillis();
            }
        }

        void setInactivityTimeout(int _inactivityTimeout) {
            this.inactivityTimeout = _inactivityTimeout;
        }
    }

    private static final class UniqueString {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        private static final AtomicInteger COUNTER = new AtomicInteger(1);
        private final String name = LocalDateTime.now().format(FORMATTER) + "_" + String.format("%03d", COUNTER.getAndIncrement());

        private UniqueString() {
        }

        public String toString() {
            return this.name;
        }
    }
}

