/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.complex;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import net.ucanaccess.complex.ComplexBase;
import shaded.io.github.spannm.jackcess.complex.ComplexValue;

public class Attachment
extends ComplexBase {
    private static final long serialVersionUID = 1L;
    private String url;
    private String name;
    private String type;
    private byte[] data;
    private LocalDateTime timeStamp;
    private Integer flags;

    public Attachment(shaded.io.github.spannm.jackcess.complex.Attachment atc) throws IOException {
        super(atc);
        this.url = atc.getFileUrl();
        this.name = atc.getFileName();
        this.type = atc.getFileType();
        this.data = atc.getFileData();
        this.timeStamp = atc.getFileLocalTimeStamp();
        this.flags = atc.getFileFlags();
    }

    public Attachment(ComplexValue.Id id, String tableName, String columnName, String _url, String _name, String _type, byte[] _data, LocalDateTime _timeStamp, Integer _flags) {
        super(id, tableName, columnName);
        this.url = _url;
        this.name = _name;
        this.type = _type;
        this.data = _data;
        this.timeStamp = Attachment.handleJackcessLocalDateTimeResolution(_timeStamp);
        this.flags = _flags;
    }

    public Attachment(String _url, String _name, String _type, byte[] _data, LocalDateTime _timeStamp, Integer _flags) {
        this(CREATE_ID, null, null, _url, _name, _type, _data, _timeStamp, _flags);
    }

    @Override
    public boolean equals(Object _obj) {
        if (this == _obj) {
            return true;
        }
        if (_obj == null || this.getClass() != _obj.getClass()) {
            return false;
        }
        Attachment other = (Attachment)_obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.url == null) {
            return other.url == null;
        }
        return this.url.equals(other.url);
    }

    public byte[] getData() {
        return this.data;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public LocalDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.timeStamp == null ? 0 : this.timeStamp.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public void setData(byte[] _data) {
        this.data = _data;
    }

    public void setFlags(Integer _flags) {
        this.flags = _flags;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public void setTimeStamp(LocalDateTime _timeStamp) {
        this.timeStamp = _timeStamp;
    }

    public void setType(String _type) {
        this.type = _type;
    }

    public void setUrl(String _url) {
        this.url = _url;
    }

    @Override
    public String toString() {
        return String.format("%s[url=%s, name=%s, type=%s, data=%s, timeStamp=%s, flags=%s]", this.getClass().getSimpleName(), this.url, this.name, this.type, Arrays.toString(this.data), this.timeStamp, this.flags);
    }
}

