/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.util.NoSuchElementException;
import shaded.org.hsqldb.lib.Collection;
import shaded.org.hsqldb.lib.Iterator;
import shaded.org.hsqldb.lib.ObjectComparator;

abstract class BaseList<E> {
    protected ObjectComparator<E> comparator = ObjectComparator.defaultComparator;
    protected int elementCount;

    BaseList() {
    }

    public abstract E get(int var1);

    public abstract E remove(int var1);

    public abstract boolean add(E var1);

    public abstract int size();

    public boolean contains(Object object) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            E e = this.get(i);
            if (!this.comparator.equals(e, object)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(E e) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            E e2 = this.get(i);
            if (!this.comparator.equals(e2, e)) continue;
            return i;
        }
        return -1;
    }

    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl = true;
            this.add(iterator.next());
        }
        return bl;
    }

    public boolean addAll(E[] EArray) {
        boolean bl = false;
        for (E e : EArray) {
            bl = true;
            this.add(e);
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + this.elementCount * 3);
        stringBuilder.append("List : size=");
        stringBuilder.append(this.elementCount);
        stringBuilder.append(' ');
        stringBuilder.append('{');
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Iterator<E> iterator() {
        return new BaseListIterator();
    }

    private class BaseListIterator
    implements Iterator<E> {
        int counter = 0;
        boolean removed;

        private BaseListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseList.this.elementCount;
        }

        @Override
        public E next() {
            if (this.counter < BaseList.this.elementCount) {
                this.removed = false;
                Object e = BaseList.this.get(this.counter);
                ++this.counter;
                return e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new NoSuchElementException("Iterator");
            }
            this.removed = true;
            if (this.counter != 0) {
                BaseList.this.remove(this.counter - 1);
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

