/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.util;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import shaded.io.github.spannm.jackcess.Database;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.impl.DatabaseImpl;

public class TableIterableBuilder
implements Iterable<Table> {
    private final Database _db;
    private boolean _includeNormalTables = true;
    private boolean _includeSystemTables;
    private boolean _includeLinkedTables = true;

    public TableIterableBuilder(Database db) {
        this._db = db;
    }

    public boolean isIncludeNormalTables() {
        return this._includeNormalTables;
    }

    public boolean isIncludeSystemTables() {
        return this._includeSystemTables;
    }

    public boolean isIncludeLinkedTables() {
        return this._includeLinkedTables;
    }

    public TableIterableBuilder withIncludeNormalTables(boolean includeNormalTables) {
        this._includeNormalTables = includeNormalTables;
        return this;
    }

    public TableIterableBuilder withIncludeSystemTables(boolean includeSystemTables) {
        this._includeSystemTables = includeSystemTables;
        return this;
    }

    public TableIterableBuilder withIncludeLinkedTables(boolean includeLinkedTables) {
        this._includeLinkedTables = includeLinkedTables;
        return this;
    }

    public TableIterableBuilder withLocalUserTablesOnly() {
        this.withIncludeNormalTables(true);
        this.withIncludeSystemTables(false);
        return this.withIncludeLinkedTables(false);
    }

    public TableIterableBuilder withSystemTablesOnly() {
        this.withIncludeNormalTables(false);
        this.withIncludeSystemTables(true);
        return this.withIncludeLinkedTables(false);
    }

    @Override
    public Iterator<Table> iterator() {
        return ((DatabaseImpl)this._db).iterator(this);
    }

    public Stream<Table> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

