/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.nio.ByteBuffer;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;

public class NullMask {
    private final int _columnCount;
    private final byte[] _mask;

    public NullMask(int columnCount) {
        this._columnCount = columnCount;
        this._mask = new byte[(this._columnCount + 7) / 8];
    }

    public void read(ByteBuffer buffer) {
        buffer.get(this._mask);
    }

    public void write(ByteBuffer buffer) {
        buffer.put(this._mask);
    }

    public boolean isNull(ColumnImpl column) {
        short columnNumber = column.getColumnNumber();
        return columnNumber >= this._columnCount || (this._mask[NullMask.byteIndex(columnNumber)] & NullMask.bitMask(columnNumber)) == 0;
    }

    public void markNotNull(ColumnImpl column) {
        short columnNumber = column.getColumnNumber();
        int maskIndex = NullMask.byteIndex(columnNumber);
        this._mask[maskIndex] = (byte)(this._mask[maskIndex] | NullMask.bitMask(columnNumber));
    }

    public int byteSize() {
        return this._mask.length;
    }

    private static int byteIndex(int columnNumber) {
        return columnNumber / 8;
    }

    private static byte bitMask(int columnNumber) {
        return (byte)(1 << columnNumber % 8);
    }
}

