/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.type;

import shaded.io.github.spannm.jackcess.Database;

public enum AccessVersion {
    V2000(Database.FileFormat.V2000),
    V2003(Database.FileFormat.V2003),
    V2007(Database.FileFormat.V2007),
    V2010(Database.FileFormat.V2010),
    V2016(Database.FileFormat.V2016);

    private static final AccessVersion DEFAULT_ACCESS_VERSION;
    private final Database.FileFormat fileFormat;

    private AccessVersion(Database.FileFormat _fileFormat) {
        this.fileFormat = _fileFormat;
    }

    public Database.FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static AccessVersion getDefaultAccessVersion() {
        return DEFAULT_ACCESS_VERSION;
    }

    public static AccessVersion parse(String _str) {
        if (_str == null) {
            return null;
        }
        String val = _str.strip();
        for (AccessVersion ver : AccessVersion.values()) {
            if (!val.equalsIgnoreCase(ver.name())) continue;
            return ver;
        }
        return null;
    }

    static {
        DEFAULT_ACCESS_VERSION = V2003;
    }
}

