/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.complex;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.UnsupportedValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.exception.UcanaccessSQLException;
import shaded.io.github.spannm.jackcess.complex.ComplexDataType;
import shaded.io.github.spannm.jackcess.complex.ComplexValue;
import shaded.io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import shaded.io.github.spannm.jackcess.impl.complex.ComplexColumnInfoImpl;

public abstract class ComplexBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ComplexValue.Id CREATE_ID = ComplexColumnInfoImpl.INVALID_ID;
    private final int id;
    private String tableName;
    private String columnName;

    protected ComplexBase(ComplexValue.Id _id, String _tableName, String _columnName) {
        this.id = _id.get();
        this.tableName = _tableName;
        this.columnName = _columnName;
    }

    protected ComplexBase(ComplexValue cv) {
        this(cv.getId(), cv.getComplexValueForeignKey().getColumn().getTable().getName(), cv.getComplexValueForeignKey().getColumn().getName());
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String _tableName) {
        this.tableName = _tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String _columnName) {
        this.columnName = _columnName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexBase other = (ComplexBase)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        return this.id == other.id && Objects.equals(this.tableName, other.tableName);
    }

    public static Object[] convert(ComplexValueForeignKey fk) throws IOException, UcanaccessSQLException {
        if (fk.getComplexType().equals((Object)ComplexDataType.ATTACHMENT)) {
            List<shaded.io.github.spannm.jackcess.complex.Attachment> lst = fk.getAttachments();
            Object[] lat = new Attachment[lst.size()];
            for (int i = 0; i < lat.length; ++i) {
                lat[i] = new Attachment(lst.get(i));
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.MULTI_VALUE)) {
            List<shaded.io.github.spannm.jackcess.complex.SingleValue> lst = fk.getMultiValues();
            Object[] lat = new SingleValue[lst.size()];
            for (int i = 0; i < lat.length; ++i) {
                lat[i] = new SingleValue(lst.get(i));
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.VERSION_HISTORY)) {
            List<shaded.io.github.spannm.jackcess.complex.Version> lst = fk.getVersions();
            Object[] lat = new Version[lst.size()];
            for (int i = 0; i < lat.length; ++i) {
                lat[i] = new Version(lst.get(i));
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.UNSUPPORTED)) {
            List<shaded.io.github.spannm.jackcess.complex.UnsupportedValue> lst = fk.getUnsupportedValues();
            Object[] lat = new UnsupportedValue[lst.size()];
            for (int i = 0; i < lat.length; ++i) {
                lat[i] = new UnsupportedValue(lst.get(i));
            }
            return lat;
        }
        throw new UcanaccessSQLException("Complex type not supported yet");
    }

    public String toString() {
        return String.format("%s[id=%s, table=%s, column=%s]", this.getClass().getSimpleName(), this.id, this.tableName, this.columnName);
    }

    static LocalDateTime handleJackcessLocalDateTimeResolution(LocalDateTime _ldt) {
        if (_ldt == null) {
            return _ldt;
        }
        long millis = TimeUnit.NANOSECONDS.toMillis(_ldt.getNano());
        return _ldt.withNano((int)TimeUnit.MILLISECONDS.toNanos(millis));
    }
}

