# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MultiFeatLayout
                                 A QGIS plugin
 This plugin compose a layout with multiple feature maps
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-03
        copyright            : (C) 2021 by Giulio Fattori
        email                : giulio.fattori@tin.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giulio Fattori'
__date__ = '2021-02-03'
__copyright__ = '(C) 2021 by Giulio Fattori'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtWidgets import QAction
from PyQt5.QtGui import QFont, QColor
from qgis.utils import iface
from PyQt5.QtCore import QCoreApplication, QVariant
from qgis.core import (Qgis,
                       #QgsField,
                       #QgsFields,
                       #QgsWkbTypes,
                       QgsApplication,
                       QgsExpression,
                       QgsProject,
                       QgsPrintLayout,
                       QgsLayoutPoint,
                       QgsLayoutSize,
                       QgsUnitTypes,
                       QgsTextFormat,
                       QgsLayoutItemPage,
                       QgsLayoutItemMap,
                       QgsLayoutItemLabel,
                       QgsLayoutMeasurement,
                       QgsLayoutItemScaleBar,
                       QgsMapSettings,
                       #QgsMapRendererParallelJob,
                       QgsLayoutExporter,
                       QgsFeatureRequest,
                       #QgsFeature,
                       QgsGeometry,
                       QgsRectangle,
                       QgsProcessing,
                       #QgsFeatureSink,
                       QgsLayerTreeGroup,
                       QgsLayerTreeLayer,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterString,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterMultipleLayers,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       #QgsProcessingParameterFeatureSource,
                       #QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterFileDestination)
                       
from qgis import processing
import math

#questo per l'icona dell'algoritmo di processing
import os
import inspect
from qgis.PyQt.QtGui import QIcon


class MultiFeatLayoutAlgorithm(QgsProcessingAlgorithm):

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    PAPER_DIM = 'PAPER_DIM'    #dimensione carta
    PAPER_ORI = 'PAPER_ORI'    #orientamento
    COLON_NUM = 'COLON_NUM'    #numero di colonne
    INPUT_LYR = 'INPUT_LYR'    #layer in sequenza
    INPUT_SCL = 'INPUT_SCL'    #input extension
    INPUT_TIT = 'INPUT_TIT'    #input composition title
    INPUT_EXP = 'INPUT_EXP'    #input espressione
    INPUT_SBL = 'INPUT_SBL'    #input sub title
    
    OUTPUT_PDF = 'OUTPUT_PDF'  #pdf in uscita
    OUTPUT = 'OUTPUT'
    

    def tr(self, string):
        """
        Returns a translatable string with the self.tr() function.
        """
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return MultiFeatLayoutAlgorithm()

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Multi Map layout from features'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Multi Map layout from features')
    
    #icona dell'algoritmo di processing
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'feat_icon.svg')))
        return icon
    
    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("<p><mark style='color:green'><strong>Compone un layout di stampa con feature multiple su un singolo foglio\n\
        <mark style='color:blue'><strong>OPZIONI</strong></mark>\n\
        <mark style='color:black'>- Filtro e/o chiave ordinamento\n\
        <mark style='color:black'>- Titolo composizione\n\
        <mark style='color:black'>- Sottotitolo o valore campo\n\
        <mark style='color:black'>- Impostazione dimensioni e orientamento carta\n\
        <mark style='color:black'>- Impostazione numero colonne, le righe vengono di conseguenza\n\
        <mark style='color:black'>- Impostazione scala (default adatta)\n\
        <mark style='color:black'>- Scelta percorso e tipo file di salvataggio (tutti i formati del salva come immagine)</i>\n\
        <mark style='color:black'>- Il layout prodotto ha nome <mark style='color:red'><strong>'MultiFeat_[<i>orientamento</i>]_[<i>formato</i>]\n\
        <mark style='color:blue'><strong>NOTA BENE</strong></mark>\n\
        <mark style='color:black'><strong>Di default l'ordinamento è alfanumerico e gli elementi sul layout son bloccati</strong></mark>\n\
        <p><mark style='color:red'><i><strong>La scala di adattamento dipende dall'estensione della feature \n\
        <mark style='color:black'><strong>Per utilizzare il filtro e/o il sottotitolo con <mark style='color:red'><strong>'Solo elementi selezionati'</mark>: prima impostare i filtri e successivamente selezionarlo")
        
    def flags(self):
        return super().flags() | QgsProcessingAlgorithm.FlagNoThreading
        
    def initAlgorithm(self, config=None):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT_LYR,
                self.tr('Source Layer'),
                [QgsProcessing.TypeVector],
            )
        )
       
        self.addParameter(
            QgsProcessingParameterExpression(
                self.INPUT_EXP,
                self.tr('Filter and order by'),
                parentLayerParameterName=self.INPUT_LYR,
                optional = False,
            )
        )
       
        self.addParameter(
            QgsProcessingParameterString(
                self.INPUT_TIT,
                self.tr('Composition Title [opzionale]'),
                optional = True,
            )
        )

        self.addParameter(
            QgsProcessingParameterExpression(
                self.INPUT_SBL,
                self.tr('Sub title label or expression'),
                parentLayerParameterName=self.INPUT_LYR,
                optional = True
            )
        )

        self.addParameter(
            QgsProcessingParameterEnum(
                self.PAPER_DIM,
                self.tr('Paper Dim'),
                ['A0','A1','A2','A3','A4','A5'],
                defaultValue = 3
            )
        )
    
        self.addParameter(
            QgsProcessingParameterEnum(
                self.PAPER_ORI,
                self.tr('Landscape / Portrait'),
                ['Landscape','Portrait'],
                defaultValue = 0
            )
        )
    
        self.addParameter(
                QgsProcessingParameterNumber(
                    self.COLON_NUM,
                    self.tr('Column number'),
                    defaultValue = 4
                )
            )
            
        self.addParameter(
                QgsProcessingParameterString(
                    self.INPUT_SCL,
                    self.tr('Scale 1:'),
                    defaultValue = 'Fit'
                )
            )
    
        self.addParameter(
            QgsProcessingParameterFileDestination(
                self.OUTPUT_PDF,
                self.tr('Select file type and destination'),
                fileFilter = 'File format (*.bmp *.jpg *.jpeg *.pdf *.png *.svg *.tiff)',
                optional = True,
                createByDefault = False
                )
            )
    
    def processAlgorithm(self, parameters, context, feedback):
        
        draw_lyr = self.parameterAsSource(
            parameters,
            self.INPUT_LYR,
            context)
        
        titolo = self.parameterAsString(
            parameters,
            self.INPUT_TIT,
            context)
        
        sottotitolo = self.parameterAsExpression(
            parameters,
            self.INPUT_SBL,
            context)
            
        espressione = self.parameterAsString(
            parameters,
            self.INPUT_EXP,
            context)
            
        paper_dim = self.parameterAsString(
            parameters,
            self.PAPER_DIM,
            context)
            
        paper_ori = self.parameterAsString(
            parameters,
            self.PAPER_ORI,
            context)
        
        map_scala = self.parameterAsString(
            parameters,
            self.INPUT_SCL,
            context)
        
        col_num = self.parameterAsInt(
            parameters,
            self.COLON_NUM,
            context)
        
        file_dest = self.parameterAsString(
            parameters,
            self.OUTPUT_PDF,
            context)
        
        """
        Here is where the processing itself takes place.
        """
        
        #Imposta formato pagina,  numero di colonne, il nomee la scala
        pagesize = 'A' + paper_dim              #0. formato pagina
        col = 5                                 #1. numero di colonne
        if paper_ori == '0':
            layoutName = "MultiFeat_Landscape_" + pagesize          #2. nome layout Landscape)
        else:
            layoutName = "MultiFeat_Portrait_" + pagesize           #2. nome layout Portrait)
        scala = 'Fit'                           #4. scala di stampa
        perc_ext = .2                           #5. percentuale estens
        feats_count = 30                        #6. feat da plottare
        bordo = 20                              #7 bordo mappa

        #Inizialize references
        project = QgsProject.instance()             #gets a reference to the project instance
        manager = project.layoutManager()           #gets a reference to the layout manager
        root = project.layerTreeRoot()              #get reference to tree root
        canvas = iface.mapCanvas()                  #get reference to canvas
        layer_set = []

        #funzione iterativa scansione TOC per layer visibili
        def get_group_layers(group):
            for child in group.children():
                if isinstance(child, QgsLayerTreeGroup):
                    get_group_layers(child)
                else:
                    layer_set.append(QgsProject.instance().mapLayersByName(child.name())[0])
                    
        #scansione TOC per layer visibili
        for child in root.children():
            if isinstance(child, QgsLayerTreeGroup):
                get_group_layers(child)
            elif isinstance(child, QgsLayerTreeLayer):
                if child.isVisible() == True:
                    layer_set.append(QgsProject.instance().mapLayersByName(child.name())[0])

        #Rimuove il layout se già presente
        layouts_list = manager.printLayouts()
        for layout in layouts_list:
            if layout.name() == layoutName:
                manager.removeLayout(layout)

        # e lo ricrea
        layout = QgsPrintLayout(project)
        layout.initializeDefaults()
        layout.setName(layoutName)
        if paper_ori == '0':
            layout.pageCollection().page(0).setPageSize(pagesize, QgsLayoutItemPage.Orientation.Landscape)
        else:
            layout.pageCollection().page(0).setPageSize(pagesize, QgsLayoutItemPage.Orientation.Portrait)
        manager.addLayout(layout)

            
        #imposta partenza per riga, colonna
        r, c = 0, 0

        # set order by field
        request = QgsFeatureRequest()
        if ' ' in espressione:
            request = QgsFeatureRequest(QgsExpression(espressione))

        if '"' in espressione:
            ordinamento = espressione.split('"')[1].split('"')[0]
        else:
            ordinamento = espressione
        
        clause = QgsFeatureRequest.OrderByClause(ordinamento, ascending = True)
        orderby = QgsFeatureRequest.OrderBy([clause])
        request.setOrderBy(orderby)
        
        #conta quante feature son state restituite
        feats_count = 0
        for feat_sel in draw_lyr.getFeatures(request):
            feats_count += 1
        feedback.pushInfo('Features count '+ str(feats_count))
        
        #calcola il numero di righe in funzione delle colonne
        n_righe = math.ceil(feats_count/col_num)
        
        #calcola dimensione mappa in funzione del foglio meno i bordi in mm
        xm = (layout.pageCollection().page(0).pageSize().width()-2* bordo)/col_num
        ym = (layout.pageCollection().page(0).pageSize().height()-2* bordo)/math.ceil(feats_count/col_num)
        
        # Compute the number of steps to display within the progress bar
        total = 100.0 / feats_count if feats_count else 0
        
        for feat_sel in draw_lyr.getFeatures(request):
            if c == col_num:
                c = 0
                r = r + 1
                
            bbox = feat_sel.geometry().boundingBox()
            bb_H = feat_sel.geometry().boundingBox().height() *(1 + perc_ext)
            bb_W = feat_sel.geometry().boundingBox().width() *(1 + perc_ext)
            
            #Aggiunge una mappa nel layout e la mette in posizione
            map = QgsLayoutItemMap(layout)
            map.setRect(20, 20, 20, 20)
            map.setExtent(bbox)
            map.setId(str(feat_sel[ordinamento]))
            map.attemptMove(QgsLayoutPoint(bordo+xm*c, bordo+ym*r, QgsUnitTypes.LayoutMillimeters))
            map.attemptResize(QgsLayoutSize(xm, ym, QgsUnitTypes.LayoutMillimeters))

            #centra la mappa e la mette in scala
            extent = map.extent()
            
            #override scale and fit map
            if scala == 'Fit':
                if bb_H > map.rect().height():
                    h_map_scala = math.ceil(bb_H/map.rect().height())*1000
                    w_map_scala = math.ceil(bb_W/map.rect().width())*1000
                else:
                    h_map_scala = math.ceil(map.rect().height()/bb_H)*1000
                    w_map_scala = math.ceil(map.rect().width()/bb_W)*1000

            map_scala = max(h_map_scala,w_map_scala)

            center = extent.center()
            newwidth  = extent.width()  / map.scale() * map_scala
            newheight = extent.height() / map.scale() * map_scala
            x1 = center.x() - 0.5 * newwidth
            y1 = center.y() - 0.5 * newheight
            x2 = center.x() + 0.5 * newwidth
            y2 = center.y() + 0.5 * newheight
            map.setExtent(QgsRectangle(x1, y1, x2, y2))

            #aggiunge la mappa al layout di stampa
            layout.addLayoutItem(map)
            
            #determina il set di layer visibili
            layer_set = []
            for child in root.children():
                if isinstance(child, QgsLayerTreeGroup):
                    get_group_layers(child)
                elif isinstance(child, QgsLayerTreeLayer):
                    if child.isVisible() == True:
                            layer_set.append(QgsProject.instance().mapLayersByName(child.name())[0])
                
            map.setLayers(layer_set)
            map.setKeepLayerSet(True)
            map.setKeepLayerStyles(True)
            map.setBackgroundEnabled(False)
            map.setFrameEnabled(True)
            map.setFrameStrokeColor(QColor.fromRgb(255,255,255))
            map.setFrameStrokeWidth(QgsLayoutMeasurement(5,QgsUnitTypes.LayoutMillimeters))
            map.setLocked(True)
            
            #Aggiunge il titolo alla mappa
            title = QgsLayoutItemLabel(layout)
            title.setText(str(feat_sel[ordinamento]))
            title.setFont(QFont("Arial Black", 12))
            title.adjustSizeToText()
            title.attemptMove(QgsLayoutPoint(bordo+xm*c, bordo+ym*r, QgsUnitTypes.LayoutMillimeters))
            layout.addLayoutItem(title)
            title.setLocked(True)
            
            #Aggiunge il sottitolo alla mappa
            if sottotitolo:
                sub_title = sottotitolo
                if '"' in sub_title:
                    sub_title = sottotitolo.split('"')[1].split('"')[0]
                                    
                title = QgsLayoutItemLabel(layout)
                title.setText(str(feat_sel[sub_title]))
                title.setFont(QFont("Arial", 10))
                title.adjustSizeToText()
                title.attemptMove(QgsLayoutPoint(bordo+xm*c, bordo+ 5 +ym*r, QgsUnitTypes.LayoutMillimeters))
                layout.addLayoutItem(title)
                title.setLocked(True)
            
            #Aggiunge la scala
            scalebar = QgsLayoutItemScaleBar(layout)
            scalebar.setStyle('Numeric')
            scalebar.setLinkedMap(map)
            scalebar.setFont(QFont('Arial', 8))
            scalebar.update()
            layout.addLayoutItem(scalebar)
            scalebar.attemptMove(QgsLayoutPoint(bordo+xm*c, bordo+ 8+ym*r, QgsUnitTypes.LayoutMillimeters))
            scalebar.setLocked(True)
            
            # Update the progress bar
            feedback.setProgress(int(feats_count * total))
            
            #incrementa contatore
            c += 1

        label = QgsLayoutItemLabel(layout)
        label.setText(titolo)
        label.setFont(QFont('Arial Black', 20))
        label.adjustSizeToText()
        layout.addLayoutItem(label)
        label.attemptMove(QgsLayoutPoint(bordo, bordo-10, QgsUnitTypes.LayoutMillimeters)) 
        label.setLocked(True)
                
        exporter = QgsLayoutExporter (layout)
        if '.pdf' in file_dest:
            exporter.exportToPdf (file_dest, QgsLayoutExporter.PdfExportSettings())
        else:
            exporter.exportToImage (file_dest, QgsLayoutExporter.ImageExportSettings ())
        
        feedback.pushInfo("WOW The plugin is working as it should, created: " + layoutName + '\n')

        return {self.OUTPUT: None}
