# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MultiJoin
                                 A QGIS plugin
 MultiJoin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-06-28
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Giulio Fattori
        email                : giulio.fattori@tin.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .MultiJoin_dialog import MultiJoinDialog
import os.path

from qgis.core import *
from osgeo import ogr

import qgis
import webbrowser
import datetime

class MultiJoin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MultiJoin_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Multi Join')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MultiJoin', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/MultiJoin/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Multi Join'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Multi Join'),
                action)
            self.iface.removeToolBarIcon(action)

    def OpenShapeFile(self):
        #print('file scelto')
        avan = 0
        self.dlg.progressBar.setValue(avan)
        if ogr.Open(self.dlg.file_widget.filePath()):
            file = ogr.Open(self.dlg.file_widget.filePath())
            layer = file.GetLayer()
            schema = []
            schema.append(layer.GetFIDColumn())
            ldefn = layer.GetLayerDefn()
            for n in range(ldefn.GetFieldCount()):
                fdefn = ldefn.GetFieldDefn(n)
                schema.append(fdefn.name)
            self.dlg.field_combo_box1.clear()
            self.dlg.field_combo_box1.addItems(schema)
            self.dlg.field_combo_box2.clear()
            self.dlg.field_combo_box2.addItems(schema)

    def make_join(self):
        file_error = 1
        #print("make_join")
        #Set the directory where the input files are stored
        directory = os.path.dirname(self.dlg.file_widget.filePath())+'\\'
        #print('directory: ', directory)
        #set fields
        field_join = self.dlg.field_combo_box1.currentText() #"id"
        field_data = self.dlg.field_combo_box2.currentText() #"valore"
        #print(field_join,field_data)

        # Get the list of input files shape or gpgk
        if ".gpkg" in self.dlg.file_widget.filePath():
        #print('file_widget: ', file_widget.filePath())
            g_layer = QgsVectorLayer(self.dlg.file_widget.filePath(),"test","ogr")
            subLayers = g_layer.dataProvider().subLayers()
            fileList = [sublayer.split('!!::!!')[1] for sublayer in subLayers]
        #print('gpkg ',fileList)
        else:
            fileList = [shapefile for shapefile in os.listdir(directory) if shapefile.endswith('.shp')]
        #print('shp ', fileList)
         
        #set progressbar values
        start = datetime.datetime.now()
        avan = 0
        self.dlg.progressBar.setValue(avan)
        perc = int(100/len(fileList))
        
        # Copy the features from all the files in a new list
        feats = []
        for file in fileList:
            if file.endswith('.shp'):
                layer = QgsVectorLayer(directory + file, file, 'ogr')
                layer_name = 'Merged_shp_' + str(layer.featureCount()) + '_' + str(len(fileList))
        #print(file)
            else:
                uri = "%s|layername=%s" % (self.dlg.file_widget.filePath(), file,)
                layer = QgsVectorLayer(uri, file, 'ogr')
                layer_name = 'Merged_gpgk_' + str(layer.featureCount()) + '_' + str(len(fileList))
                
            if not feats:
                for feat in layer.getFeatures():
                    geom = feat.geometry()
                    attrs = feat.attributes()
                    feature = QgsFeature()
                    feature.setGeometry(geom)
                    feature.setAttributes(attrs)
                    feats.append(feature)
                    
                    # Get the Coordinate Reference System and the list of fields from the last input file
                    crs = layer.crs().toWkt()
                    field_list = layer.dataProvider().fields().toList()
                    
                    # Create the merged layer by checking the geometry type of  the input files (for other types, please see the API documentation)
                    if layer.wkbType()==QgsWkbTypes.Point:
                        v_layer = QgsVectorLayer('Point?crs=' + crs, layer_name, "memory")
                    if layer.wkbType()==QgsWkbTypes.LineString:
                        v_layer = QgsVectorLayer('LineString?crs=' + crs, layer_name, "memory")
                    if layer.wkbType()==QgsWkbTypes.Polygon:
                        v_layer = QgsVectorLayer('Polygon?crs=' + crs, layer_name, "memory")
                    if layer.wkbType()==QgsWkbTypes.MultiPolygon:
                        v_layer = QgsVectorLayer('MultiPolygon?crs=' + crs, layer_name, "memory")
                    if layer.wkbType()==QgsWkbTypes.MultiPolygonZ:
                        v_layer = QgsVectorLayer('MultiPolygonZ?crs=' + crs, layer_name, "memory")
               
                    # Add the features to the new merged layer
                    prov = v_layer.dataProvider()
                    prov.addAttributes(field_list)
                    v_layer.updateFields()
                    v_layer.startEditing()
                    prov.addFeatures(feats)
                    v_layer.commitChanges()  
                
                    v_layer.startEditing()
                    for field in v_layer.fields():
                        if field.name() == field_data:
                            idx = v_layer.fields().indexFromName(field.name())
                            if file.endswith('.shp'):
                                field_name = field_data + '_' + os.path.splitext(file)[0]
                            else:
                                field_name = field_data + '_' + file
                            v_layer.renameAttribute(idx, field_name)
                    v_layer.commitChanges()
            else:
                field1_id = v_layer.fields().indexFromName(field_join)
                field2_id = layer.fields().indexFromName(field_data)

                if file.endswith('.shp'):
                    field_name = field_data + '_' + os.path.splitext(file)[0]
                else:
                    field_name = field_data + '_' + file
                try:
                    prov.addAttributes([QgsField(field_name, layer.fields().field(field_data).type())])
                except:
                    msg = u'Missing ' +  field_data + ' in ' + file
                    self.iface.messageBar().pushCritical("Multi Join", msg)
                    file_error = 0
                    
                v_layer.updateFields()
                v_layer.commitChanges()
                
                field_idx = v_layer.fields().indexFromName(field_name)
                #print(field_idx)
                
                for v_feature in v_layer.getFeatures():
                    expression = field_join + " = \'" + str(v_feature[field_join]) +'\''
                    request = QgsFeatureRequest().setFilterExpression(expression)
                    #print(request.filterExpression())
                    for feat in layer.getFeatures(request):
                        #print(k, feat.fields().names(), feat.attributes(), feat.attributes()[field2_id])
                        break
                    new_value = feat.attributes()[field2_id]
                    feat_idx = v_feature.id()
                    #indice del campo Valore
                    v_layer.startEditing()
                    v_layer.changeAttributeValue(feat_idx, field_idx, new_value)
                    v_layer.commitChanges()
                    #break

            avan = avan + perc
            self.dlg.progressBar.setValue(avan)
            
        
        #if no error show merged layer
        self.dlg.progressBar.setValue(0)
        
        if file_error:
            QgsProject.instance().addMapLayer(v_layer)
        
            elapsed = datetime.datetime.now() - start
            msg = u'Merged ' + str(layer.featureCount()) + ' fields from ' + str(len(fileList)) + ' layer (' + str(layer.featureCount()*len(fileList)) + ' values) in ' + str(elapsed) #u"Join done"
            self.iface.messageBar().pushSuccess("Multi Join", msg)
        
        self.dlg.close()
        
    def help_show(self):   
        #chrome_path = 'C:/Program Files (x86)/Google/Chrome/Application/chrome.exe %s'
        help_path = os.path.join(self.plugin_dir,'help','help.html')
        #print(help_path)
        webbrowser.open(help_path)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = MultiJoinDialog()
                
            self.dlg.file_widget.fileChanged.connect(self.OpenShapeFile)
            self.dlg.go_button.clicked.connect(self.make_join)
            self.dlg.help.clicked.connect(self.help_show)
        
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # print('r: ', result)
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
        
