from __future__ import annotations
from ..processing.OsRaster.Rasterize import Rasterize
from .graphab_test_case import GraphabTestCase

from qgis.core import QgsProcessingContext, QgsProcessingFeedback, QgsVectorLayer

import unittest

__author__ = 'gaspard.quentin1905@gmail.com'
__date__ = '2023-06-23'
__copyright__ = 'Copyright 2023, Laboratoire ThéMA'

class TestOsRaster(GraphabTestCase):
    
    def test_rasterize(self):


        # TODO: replace with coherent values
        config = {
            'INPUT': self.vector_layer,
            #'FIELD': None, # optional
            'BURN': 0.0, # optional
            'WIDTH': 0.0,
            'HEIGHT': 0.0,
            #'UNITS': None,
            'NODATA': 0.0, # optional
            'EXTENT': None,
            #'INIT': None,  # optional
            'INVERT': False,
            'ALL_TOUCH': False,
            'OPTIONS': '', # optional
            'DATA_TYPE': 5,
            #'OUTPUT': None
        }

        # init Algorithm, context & feedback
        alg = Rasterize()
        context = QgsProcessingContext()
        feedback = QgsProcessingFeedback()
        
        alg.initAlgorithm(config)
        output: dict[str, any] = alg.getConsoleCommands(config, context, feedback)

        # make tests on the output
        # TODO: make relevant tests
        self.assertIsNotNone(output)

if __name__ == '__main__':
    suite = unittest.makeSuite(TestOsRaster)
    runner = unittest.TextTestRunner(verbosity=2)
    runner.run(suite)
