# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MiMiGIS (Middlebury Minimal GIS)
                                 A QGIS plugin
 This plugin contains tools for teaching introductory QGIS.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-01-29
        copyright            : (C) 2021 by Maja Cannavo and Joseph Holler
        email                : mcannavo@middlebury.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

__author__ = 'Maja Cannavo and Joseph Holler'
__date__ = '2021-01-29'
__copyright__ = '(C) 2021 by Maja Cannavo and Joseph Holler'


import os
from qgis.core import QgsSettings


# add our SVG paths to QGIS settings

# find the paths that are already set for SVGs
current_paths = QgsSettings().value('svg/searchPathsForSVG')

# the path of the MiMiGIS plugin folder
mimigis_path = os.path.dirname(__file__)

# now see if the Maki/NPS icon paths are already in our SVG paths

new_path = os.path.join(mimigis_path, 'SVG')

# paths for each icon set
new_path_maki = os.path.join(new_path, 'maki_icons')
new_path_NPS = os.path.join(new_path, 'NPS_icons')

new_paths = [new_path_maki, new_path_NPS]

# if we don't already have these paths, add them

# first, check to see if we have any current paths
if current_paths:
    for path in new_paths:
        if path not in current_paths:
            current_paths.append(path)
            QgsSettings().setValue('svg/searchPathsForSVG', current_paths)

# if not, set the SVG paths to new_paths 
else:
    QgsSettings().setValue('svg/searchPathsForSVG', new_paths)

# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load MiMiGIS class from file MiMiGIS.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .mimigis import MiMiGISPlugin
    return MiMiGISPlugin()
