# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MetaGAM Geonetwork
                                 A QGIS plugin
 Plugin qui permet de gérer les métadonnées uniques à la métropole de Grenoble.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2022-2025 by Service SIT - Amr HAMADEH, Steven PION-ROUX
        email                : demande_sit@grenoblealpesmetropole.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import xml.etree.ElementTree as ET
from simplejson.errors import JSONDecodeError

import requests

from qgis.core import QgsAbstractMetadataBase

from .Meta_GAM_Geoserver import create_link, check_link, GSLayerNotFound

GN_TIMEOUT = 30


def get_catalog():
    """
    Retrouver l'URL du serveur geonetwork dans les variables d'environnemnt
    """
    return os.environ.get(
        "GN_URL", "https://geonetwork.grenoblealpesmetropole.fr/geonetwork"
    )


CATALOG = get_catalog()


class MetaGamGeonetwork(requests.Session):
    """
    Classe pour gérer les appels API vers le serveur geonetwork
    """

    def __init__(self, verifytls=True):
        super().__init__()
        self.verify = verifytls
        self.connected = False
        self.group = None
        self.token = None

    def connect(self, user, password):
        """
        Tente l'ouverture d'une connexion au serveur geonetwork
        L'appel à cette fonction initialise les headers et cookies qui vont bien
        pour les appels API suivants
        Args:
            user (str): nom d'utilisateur saisie dans le plugin.
            password (str): mot de pass saisie dans le plugin.
        Returns:
            (booléen): un booléen qui indique si la connexion a réussi ou échoué.


        """
        self.headers["Accept"] = "application/json"
        self.auth = (user, password)
        resp = self.get(f"{self.CATALOG}/srv/api/me")
        if resp.status_code in [200, 204]:
            self.token = self.cookies.get("XSRF-TOKEN")
            self.headers["X-XSRF-TOKEN"] = self.token
            user_infos = resp.json()
            profile = user_infos["profile"]

            if profile == "Reviewer":
                self.group = user_infos["groupsWithReviewer"][0]
            elif profile == "Editor":
                self.group = user_infos["groupsWithEditor"][0]
            elif profile == "UserAdmin":
                self.group = user_infos["groupsWithUserAdmin"][0]

            self.connected = True
            return True
        return False

    @property
    def CATALOG(self):
        """
        Retrouve l'URL du serveur geonetwork dans les variables d'environnemnt
        """
        return os.environ.get(
            "GN_URL", "https://geonetwork.grenoblealpesmetropole.fr/geonetwork"
        )

    def request(self, *args, **kwargs):
        return super().request(
            *args,
            **{
                "timeout": GN_TIMEOUT,
                **kwargs,
            },
        )

    def post_meta_gn(self, filepath):
        """_summary_

        Cette fonction  permet de poster des fichiers de métadonnées
        sur GeoNetwork. Elle utilise la fonction connexionGeonetwork
        pour établir une connexion à l'instance de GeoNetwork en fournissant
        les informations d'authentification de l'utilisateur. Et fais
        la mise à jour des fiches (si la fiche de métadonnées existe
        déja alors elle sera écrasée par la nouvelle fiche).
        """

        post_url = (
            f"{self.CATALOG}/srv/api/records?metadataType=METADATA"
            "&uuidProcessing=OVERWRITE&transformWith=_none_"
        )
        if self.group is not None:
            post_url += f"&group={self.group}"

        filename = os.path.basename(filepath)
        with open(filepath, "rb") as file:
            file_to_upload = {"file": (str(filename), file)}
            finfo = {"fullPath": filepath}
            response = self.post(
                post_url,
                files=file_to_upload,
                data=finfo,
            )
            try:
                detail = response.json()
            except JSONDecodeError:
                detail = response.content.decode()
            return {
                "status_code": response.status_code,
                "detail": detail,
            }

    def get_meta_date_gn(self, uuid):
        """_summary_

        Cette fonction récupere la date de publication pour une fiche donnée.
        Elle utilise la fonction connexionGeonetwork pour établir une connexion
        à l'instance de GeoNetwork en fournissant les informations
        d'authentification de l'utilisateur.

        Args:
            uuid (str): identifiant fiche de métadonnées.
        """
        response = self.get(
            self.CATALOG
            + "/srv/api/records/"
            + uuid
            + "/formatters/xml?addSchemaLocation=false&increasePopularity=false&approved=false",
            headers={"Accept": "application/xml", "Content-Type": "application/xml"},
        )
        if response.status_code == 200:
            reponse_xml = response.text
            root = ET.fromstring(reponse_xml)
            date_element = root.find(".//{http://www.isotc211.org/2005/gco}Date")
            date_publication = date_element.text
            return date_publication
        return None


def create_links(layer_schema, layer_name, export_GS_links, checkGS=True):
    link_metro = QgsAbstractMetadataBase.Link()
    link_metro.name = "Grenoble-Alpes Métropole"
    link_metro.type = "https"
    link_metro.description = "Site de la Métropole"
    link_metro.url = " https://www.grenoblealpesmetropole.fr/"
    link_metro.format = "HTTPS"

    list_links = [link_metro]

    if export_GS_links:
        for link_type in ["KML", "GeoJSON", "WMS", "WFS"]:
            link = create_link(layer_schema, layer_name, link_type)
            try:
                # layer validation currently always enforced
                # here not depending on checkbox
                check_link(link)
                list_links.append(link)
            except GSLayerNotFound:
                pass
    return list_links
