# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MetaGAMAdminDialog
                                 A QGIS plugin
 Plugin qui permet de gérer les métadonnées uniques à la métropole de Grenoble.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2022-2025 by Service SIT - Amr HAMADEH, Steven PION-ROUX
        email                : demande_sit@grenoblealpesmetropole.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import QtWidgets, uic
from PyQt5.QtWidgets import QMessageBox
from qgis.core import QgsLayerTreeGroup, QgsLayerTreeLayer, QgsProject
from qgis.PyQt.QtSql import QSqlDatabase

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "Meta_GAM_Admin_dialog.ui")
)


class MetaGamAdminDialog(QtWidgets.QDialog, FORM_CLASS):
    """
    main widget for plugin admin settings
    """

    def __init__(self, parent=None):
        super().__init__(parent)
        self.setupUi(self)
        self.frame_2.setVisible(False)

        self.file_project_widget = self.mQgsFileWidget
        self.filter_ggs_files()
        self.update_groups()
        QgsProject.instance().layersAdded.connect(self.update_groups)
        QgsProject.instance().layersRemoved.connect(self.update_groups)
        layers_treeroot = QgsProject.instance().layerTreeRoot()
        layers_treeroot.layerOrderChanged.connect(self.update_groups)
        self.pb_updateList.clicked.connect(self.update_groups)
        self.pb_connexion.clicked.connect(self.check_admin)
        self.pbClose.clicked.connect(self.close_dialog)
        self.checkBox.stateChanged.connect(self.default_file)
        self.pushButton.clicked.connect(self.update_progressbar)

    def connexion_postgis(self):
        """
        try to connect to configured postgis DB
        """
        res = False
        utilisateur = self.lineEdit.text()
        password = self.mLineEdit.text()
        db = QSqlDatabase.addDatabase("QPSQL")
        db.setHostName("bdd-sig.la-metro.org")
        db.setPort(5432)
        db.setDatabaseName("sig")
        db.setUserName(utilisateur)
        db.setPassword(password)
        if not db.open():
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText(
                "Erreur de connexion à la base de données: " + db.lastError().text()
            )
            msg.setWindowTitle("Erreur!!")
            msg.exec_()
            return res
        query = db.exec_(
            "SELECT pg_has_role('" + db.userName() + "', 'postgres', 'member')"
        )
        query.first()
        is_admin = query.value(0)
        if is_admin:
            res = True
            return res
        msg = QMessageBox()
        msg.setIcon(QMessageBox.Critical)
        msg.setText("Vous n'êtes pas admin sur la base de données")
        msg.setWindowTitle("Erreur!!")
        msg.exec_()
        return res

    def check_admin(self):
        """
        admin rights are granted if the DB connection is successful
        """
        if self.connexion_postgis():
            self.frame_2.setVisible(True)

    def get_project_groups(self):
        """
        get project groups
        """
        # Récupérer le projet courant
        project = QgsProject.instance()
        # Récupérer la liste de tous les groupes de couches du projet
        root = project.layerTreeRoot()
        layer_groups = root.findGroups()
        # Créer une liste pour stocker les groupes racines
        root_groups = []
        # Boucler à travers la liste de tous les groupes de couches
        for group in layer_groups:
            root_groups.append(group)
        return root_groups

    def update_groups(self):
        """
        Ajouter les noms de chaque groupe racine à la QComboBox
        """
        groups = self.get_project_groups()
        self.groupsList.clear()  # Effacer les éléments précédents
        for group in groups:
            self.groupsList.addItem(group.name())

    def default_file(self, state):
        """
        Afficher ou masquer le texte dans QgsFileWidget() selon l'état de coche de QCheckBox()
        """
        if state == 2:  # État de coche activé
            self.file_project_widget.setFilePath(
                os.path.join("S:", "QGIS", "gam", "socle_data_metiers.qgs")
            )
        else:  # État de coche désactivé
            self.file_project_widget.setFilePath("")

    def filter_ggs_files(self):
        """
        show only "*.qgs" files
        """
        self.file_project_widget.setFilter("*.qgs")

    def copy_layers_to_dest(self, group_name, projet_destination, projet_source):
        """
        Obtenez la liste des groupes dans le projet source
        """
        source_group = projet_source.layerTreeRoot().findGroup(group_name)
        dest_group = projet_destination.layerTreeRoot().findGroup(group_name)
        for layer in source_group.findLayers():
            # Copier la couche dans le groupe correspondant dans le projet de destination
            projet_destination.addMapLayer(layer.layer(), False)
            dest_group.addChildNode(QgsLayerTreeLayer(layer.layer()))

    def check_group_exists(self):
        """
        vérification si le groupe existe
        """
        # Ouvre le projet source courant
        destination_project_path = self.file_project_widget.filePath()
        source_project = QgsProject.instance()
        group_name = self.groupsList.currentText()

        # Vérifie si le groupe existe dans le projet de destination
        destination_project = QgsProject()
        destination_project.read(destination_project_path)
        destination_group = destination_project.layerTreeRoot().findGroup(group_name)
        if destination_group is not None:
            new_group = QgsLayerTreeGroup(group_name)
            index = 0
            for child_node in destination_project.layerTreeRoot().children():
                if child_node.name() == group_name:
                    break
                index += 1
            destination_project.layerTreeRoot().removeChildNode(destination_group)
            destination_project.layerTreeRoot().insertChildNode(index, new_group)
            self.copy_layers_to_dest(group_name, destination_project, source_project)
            destination_project.write()
        else:
            destination_project.layerTreeRoot().addGroup(group_name)
            self.copy_layers_to_dest(group_name, destination_project, source_project)
            destination_project.write()
        destination_project.clear()
        del source_project

    def update_progressbar(self):
        """
        faire évoluer la barre de progrès de 0 à 100%
        """
        self.progressBar.setRange(0, 100)
        self.progressBar.setValue(0)
        if self.file_project_widget.filePath() == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Vous n'avez pas choisi de projet!")
            msg.setWindowTitle("Erreur!!")
            msg.exec_()
        else:
            self.check_group_exists()
        self.progressBar.setValue(100)

    def close_dialog(self):
        """
        fermer la fenetre admin
        """
        self.close()
