# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MetaGAMDialog
                                 A QGIS plugin
 Plugin qui permet de gérer les métadonnées uniques à la métropole de Grenoble.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2022-2025 by Service SIT - Amr HAMADEH, Steven PION-ROUX
        email                : demande_sit@grenoblealpesmetropole.fr
 ***************************************************************************/

/***************************************************************************
 *                               h                                          *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json
import os
from glob import glob
import re

import psycopg2
from psycopg2.extras import RealDictCursor
from qgis.core import (
    QgsBox3d,
    QgsMapLayerType,
    QgsCoordinateReferenceSystem,
    QgsCoordinateTransform,
    QgsDataSourceUri,
    QgsProject,
    QgsRectangle,
    QgsLayerMetadata,
    QgsNativeMetadataValidator,
    QgsMapLayer,
    QgsWkbTypes,
)
from qgis.gui import QgsCheckableComboBox, QgsMessageBar
from qgis.core import Qgis
from qgis.PyQt.QtCore import Qt, QUrl
from qgis.PyQt.QtGui import (
    QBrush,
    QColor,
    QDesktopServices,
    QStandardItem,
    QStandardItemModel,
)
from qgis.PyQt.QtWidgets import (
    QDialog,
    QLabel,
    QLineEdit,
    QPushButton,
    QTableView,
    QTreeWidget,
    QVBoxLayout,
    QTreeWidgetItem,
    QCheckBox,
    QComboBox,
    QTextEdit,
)
from qgis.PyQt.uic import loadUiType

from .Meta_GAM_constants import LICENCE_OUVERTE_OD, LICENCE_FERMEE, THEMES_INSPIRE
from .Meta_GAM_Geonetwork import MetaGamGeonetwork, create_links
from .Meta_GAM_Geoserver import check_link, GSLayerNotFound
from .Meta_GAM_QMD_XML import clean_temp, create_zip, remove_all_zip_files

# pylint: disable=too-many-lines

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = loadUiType(
    os.path.join(os.path.dirname(__file__), "Meta_GAM_dialog_base.ui")
)


class MetaGAMDialog(QDialog, FORM_CLASS):
    """
    Main dialog class for layer selection, metadata completion
    and upload to GeoNetwork.
    """

    def __init__(self, parent=None):
        """Constructor."""
        super().__init__(parent)
        self.setupUi(self)
        self.mgGN = MetaGamGeonetwork()
        self.mb = QgsMessageBar(self)
        self.layout().insertWidget(0, self.mb)

        self.treeWidget = self.findChild(QTreeWidget, "treeWidget")
        self.tableGN = self.findChild(QTableView, "tableGN")
        self.tableGN.doubleClicked.connect(self.on_table_gn_double_click)
        self.model = None
        self.layers_niveau = (
            {}
        )  # Dictionnaire pour stocker le nom de la couche et son niveau par rapport à la thématique
        self.dict_cat_iso = {
            "Agriculture": "farming",
            "Biote": "biota",
            "Limites": "boundaries",
            "Climatologie/Météorologie/Atmoshpère": "climatologyMeteorologyAtmosphere",
            "Economie": "economy",
            "Altitude": "elevation",
            "Environnement": "environment",
            "Informations géoscientifiques": "geoscientificInformation",
            "Santé": "health",
            "Imagerie/Cartes de base/Occupation des terres": "imageryBaseMapsEarthCover",
            "Renseignement/Secteur militaire": "intelligenceMilitary",
            "Eaux intérieures": "inlandWaters",
            "Localisation": "location",
            "Océans": "oceans",
            "Planification/Cadastre": "planningCadastre",
            "Société": "society",
            "Structure": "structure",
            "Transport": "transportation",
            "Services d'utilité publique/Communication": "utilitiesCommunication",
        }
        self.UserPassword = None
        self.pbPost.setVisible(False)
        self.label_3.setVisible(False)
        self.checkLinks.setVisible(False)
        self.frame_legende.setVisible(False)
        self.label_Green.setStyleSheet("color: green;")
        self.label_Red.setStyleSheet("color: red;")
        self.label_Orange.setStyleSheet("color: orange;")
        self.tree_checkbox_status = None
        self.labelGeo.setOpenExternalLinks(True)
        self.pbAutoMeta.clicked.connect(self.auto_fill_meta)
        self.pb_meta_cancel.clicked.connect(self.close_plugin)
        self.pb_meta_apply.clicked.connect(self.click_apply)
        self.pbConnexion.clicked.connect(self.check_connexion_gn)
        self.pbPost.clicked.connect(self.update_progressbar)
        self.pbCancel.clicked.connect(self.close_plugin)

    def connexion_postgresql_password(self):
        """
        Prompts the user to enter their PostgreSQL password.

        Try again until connection is successful

        Returns:
            bool: True if the connection to PostgreSQL is successful, False otherwise.
        """

        try:
            success, _ = self.connexion_postgresql(True)
            if success:
                return True
        except psycopg2.Error:
            pass
        # Créer une instance de QDialog
        dialog = QDialog()

        # Créer un label et un champ de texte
        label = QLabel(
            "Veuillez saisir votre mot de passe :\n"
            "(Accès à la base de donnée via le service bd_prod)"
        )
        password_edit = QLineEdit()
        password_edit.setEchoMode(QLineEdit.Password)  # Masquer les caractères saisis

        # Créer un bouton OK
        ok_button = QPushButton("OK")
        ok_button.clicked.connect(
            dialog.accept
        )  # Fermer la fenêtre et renvoyer QDialog.Accepted

        # Créer un layout vertical et ajouter les widgets
        layout = QVBoxLayout(dialog)
        layout.addWidget(label)
        layout.addWidget(password_edit)
        layout.addWidget(ok_button)
        dialog.setWindowTitle("Saisie du mot de passe")
        # Afficher la fenêtre modale et renvoyer la valeur saisie par l'utilisateur
        if dialog.exec_() == QDialog.Accepted:
            self.UserPassword = password_edit.text()
            if self.connexion_postgresql()[0]:
                # La connexion a réussi
                return True
            return self.connexion_postgresql_password()
        return False

    def connexion_postgresql(self, reraise=False):
        """
        Establishes a connection to a PostgreSQL database using the provided service name and user password.
        Returns:
            tuple: A tuple containing a boolean and the connection object.
                - True and the connection object if the connection is successful.
                - False and None if there is an error during the connection attempt.
        Raises:
            psycopg2.Error: If there is an error connecting to the PostgreSQL database.
        """

        try:
            connexion = psycopg2.connect(service="bd_prod", password=self.UserPassword)
            return True, connexion
        except psycopg2.Error as e:
            if reraise:
                raise e
            self.push_message_bar(str(e), Qgis.Critical)
            return False, None

    def get_metadata_gestion_tab(self):
        """
        get liste nom schema objet from database
        """
        connexion = self.connexion_postgresql()[1]
        cur = connexion.cursor()
        cur.execute("SELECT * FROM sit_hydre.v_liste_nom_schema_objet")
        rows = cur.fetchall()
        columns = [desc[0] for desc in cur.description]
        json_list = []
        for row in rows:
            json_list.append(dict(zip(columns, row)))
        return json_list

    def get_metadata_tab(self):
        """
        get metadata from database
        """
        connexion = self.connexion_postgresql()[1]
        cur = connexion.cursor()
        cur.execute("SELECT * FROM sit_hydre.gest_bdd_rel_objets_thematique")
        rows = cur.fetchall()
        columns = [desc[0] for desc in cur.description]
        json_list = []
        for row in rows:
            json_list.append(dict(zip(columns, row)))
        return json_list

    def get_contact_tab(self):
        """
        get contact from database
        """
        connexion = self.connexion_postgresql()[1]
        with connexion.cursor(cursor_factory=RealDictCursor) as cur:
            cur.execute("SELECT * FROM sit_hydre.gest_bdd_contact_referents")
            return cur.fetchall()

    def get_thematique_tab(self):
        """
        get thematique from database
        """
        connexion = self.connexion_postgresql()[1]
        cur = connexion.cursor()
        cur.execute("SELECT * FROM sit_hydre.gest_bdd_thematique")
        rows = cur.fetchall()
        columns = [desc[0] for desc in cur.description]
        json_list = []
        for row in rows:
            json_list.append(dict(zip(columns, row)))
        return json_list

    def get_contact_ID(self, id_thematique):
        """
        get contact ID from database
        """
        connexion = self.connexion_postgresql()[1]
        cur = connexion.cursor()
        cur.execute(
            "SELECT contact_referent_id FROM sit_hydre.gest_bdd_rel_thematique_contact_referents WHERE "
            f"thematique_id = '{id_thematique}'",
        )
        rows = cur.fetchall()
        contact_ids = [row[0] for row in rows]
        return contact_ids

    def get_meta_ID(self, id_objet):
        """
        get meta ID from database
        """
        # print('id_objet : ' + id_objet)
        if id_objet:
            connexion = self.connexion_postgresql()[1]
            cur = connexion.cursor()
            cur.execute(
                "SELECT metadonnees_id FROM sit_hydre.gest_bdd_rel_objets_thematique WHERE objet_id = %s",
                (id_objet,),
            )
            rows = cur.fetchall()
            # print (rows)
            meta_id = [row[0] for row in rows]
            return meta_id
        return None

    def auto_fill_meta(self):
        """_summary_

        Cette fonction a pour objectif de remplir automatiquement les métadonnées d'une couche dans QGIS.
        Tout d'abord, elle récupère une couche de contacts à partir de laquelle elle extrait les informations
        nécessaires pour remplir la partie "contact" des métadonnées de la couche en question.

        Ensuite, elle récupère l'emprise spatiale de la couche et remplit cette information dans la fiche
        de métadonnées. Et c'est pareil pour les autres informations de la fiche metadata.

        """
        if self.connexion_postgresql_password():
            tab_gestion = self.get_metadata_gestion_tab()
            tab_metadata = self.get_metadata_tab()
            tab_contacts = self.get_contact_tab()
            tab_thematique = self.get_thematique_tab()
            # On commence à remplir la fiche des metadonnées
            project = QgsProject.instance()
            for layer in project.mapLayers().values():
                # On parcourt les couches du projets une aprés l'autre
                layer_meta = layer.metadata()  # On récupere la fiche de metadata
                # Recuperer nom du schema de la couche
                uri = QgsDataSourceUri(layer.dataProvider().dataSourceUri())
                layer_schema = uri.schema()
                layer_name = uri.table()
                layer_projet_name = layer.name()
                # On récupere l'emprise spataile
                extent = layer.extent()
                xmin = extent.xMinimum()
                xmax = extent.xMaximum()
                ymin = extent.yMinimum()
                ymax = extent.yMaximum()
                # On remplie l'identifiant et on récupére les infos des métadonnées (categories, motsclés, INSPIRE)
                categories = layer_meta.categories()
                keywords = layer_meta.keywords()
                identif = layer_meta.identifier()
                contact_prenom = None
                contact_nom = None
                contact_mail = None
                licence = None
                meta_titre = None
                thematique_description = None
                description = None
                for obj in tab_gestion:
                    id_objet = obj.get("id_objet")
                    nom_objet = obj.get("nom_objet")
                    nom_schema = obj.get("nom_schema")
                    if nom_objet == layer_name and nom_schema == layer_schema:
                        identif = id_objet
                for obj_meta in tab_metadata:
                    id_objet_meta = obj_meta.get("objet_id")
                    if identif == id_objet_meta:
                        niv_thematique = obj_meta.get("niveau")
                        if niv_thematique == 1:
                            self.layers_niveau[layer.name()] = niv_thematique
                            licence = obj_meta.get("metadonnees")["licences"]
                            categories = obj_meta.get("metadonnees")["categories"]
                            keywords = obj_meta.get("metadonnees")["mots_clefs"]
                            _ = obj_meta.get("metadonnees")["themes_inspire"]
                            description = obj_meta.get("metadonnees_commentaire")
                            id_thematique = obj_meta.get("thematique_id")
                            meta_titre = obj_meta.get("metadonnees_titre")
                            contact_id = self.get_contact_ID(id_thematique)
                            theme_categories = None
                            theme_keywords = None
                            for obj_theme in tab_thematique:
                                id_objet_theme = obj_theme.get("id")
                                if id_objet_theme == id_thematique:
                                    theme_categories = obj_theme.get("metadonnees")[
                                        "categories"
                                    ]
                                    theme_keywords = obj_theme.get("metadonnees")[
                                        "mots_clefs"
                                    ]
                                    thematique_description = obj_theme.get(
                                        "description"
                                    )
                            if categories is not None and theme_categories is not None:
                                # Remplacer les éléments de theme_categories par leurs correspondances
                                categories = [
                                    self.dict_cat_iso.get(
                                        theme_category, theme_category
                                    )
                                    for theme_category in theme_categories
                                ] + categories
                            elif categories is None and theme_categories is not None:
                                categories = theme_categories
                            if keywords is not None and theme_keywords is not None:
                                if isinstance(theme_keywords, str):
                                    theme_keywords = [theme_keywords]
                                for keyword in theme_keywords:
                                    if keyword not in keywords:
                                        keywords.insert(0, keyword)
                            elif keywords is None and theme_keywords is not None:
                                keywords = theme_keywords
                            if len(contact_id) == 0:
                                new_contact = self.create_default_DB_contact(
                                    id_thematique
                                )
                                tab_contacts = [new_contact]
                                contact_id = [new_contact.get("id")]
                            for obj_contact in tab_contacts:
                                if contact_id[0] == obj_contact.get("id"):
                                    contact_nom = obj_contact.get("nom")
                                    contact_prenom = obj_contact.get("prenom")
                                    contact_mail = obj_contact.get("mail")

                if len(self.layers_niveau) > 0:
                    if self.layers_niveau.get(layer_projet_name) == 1:
                        meta_contact = QgsLayerMetadata.Contact()
                        if contact_nom is not None:
                            meta_contact.name = contact_prenom + " " + contact_nom
                            meta_contact.organization = "Grenoble Alpes Métropole"
                            meta_contact.email = contact_mail
                            meta_contact.role = "custodian"
                            address = QgsLayerMetadata.Address()
                            # address.type = 'postal'
                            address.address = "3 Rue Malakoff"
                            address.city = "Grenoble"
                            # address.administrativeArea = 'anyprovince'
                            address.postalCode = "38100"
                            # address.country = 'France'
                            meta_contact.addresses = [address]

                        # On remplit la partie Résumé
                        res = None
                        if (
                            layer.type() != QgsMapLayerType.RasterLayer
                            or layer.type() != QgsMapLayerType.TileLayer
                        ):
                            titre = "Liste des commentaires des colonnes:"
                            com_col = ""
                            titre_2 = "Résumé de la couche:"
                            com_lay = layer.metadata().abstract()
                            if com_lay is None:
                                com_lay = description
                            if (
                                titre_2 in com_lay
                            ):  # ce morceau corresponds à la mise à jour du résumé uniquement
                                # en cas de change dans la base mais aussi evite les doublons
                                start = titre_2
                                end = titre
                                com_lay = (com_lay.split(start))[1].split(end)[0]
                                com_lay = com_lay.strip()
                            for entite in layer.fields():
                                if (
                                    len(entite.comment()) != 0
                                    and len(entite.alias()) != 0
                                ):
                                    com_col = (
                                        com_col
                                        + "\n"
                                        + (
                                            "- "
                                            + entite.name().capitalize()
                                            + " ("
                                            + entite.alias()
                                            + ")"
                                            + ": "
                                            + entite.comment().capitalize()
                                        )
                                    )
                                elif (
                                    len(entite.comment()) != 0
                                    and len(entite.alias()) == 0
                                ):
                                    com_col = (
                                        com_col
                                        + "\n"
                                        + (
                                            "- "
                                            + entite.name().capitalize()
                                            + ": "
                                            + entite.comment().capitalize()
                                        )
                                    )
                                elif (
                                    len(entite.comment()) == 0
                                    and len(entite.alias()) != 0
                                ):
                                    com_col = (
                                        com_col
                                        + "\n"
                                        + (
                                            "- "
                                            + entite.name().capitalize()
                                            + " ("
                                            + entite.alias()
                                            + ")"
                                        )
                                    )
                                com_col = com_col.replace("(", "[").replace(")", "]")
                            if len(com_col) != 0 and len(com_lay) != 0:
                                if titre in com_lay and titre_2 not in com_lay:
                                    res = titre + "\n" + com_col
                                else:
                                    res = (
                                        titre_2
                                        + "\n"
                                        + "\n"
                                        + com_lay
                                        + "\n"
                                        + "\n"
                                        + titre
                                        + "\n"
                                        + com_col
                                    )
                            elif len(com_lay) == 0 and len(com_col) != 0:
                                res = titre + "\n" + com_col
                            elif len(com_lay) != 0 and len(com_col) == 0:
                                res = com_lay
                            elif len(com_col) == 0 and len(com_lay) == 0:
                                res = ""

                            # On ajoute le résumé de la thématique
                            titre_res_theme = "Résumé sur la thématique:"
                            if (
                                thematique_description is not None
                                and titre_res_theme not in res
                            ):
                                res = (
                                    titre_res_theme
                                    + "\n"
                                    + thematique_description
                                    + "\n"
                                    + "\n"
                                    + res
                                )
                            elif (
                                thematique_description is not None
                                and titre_res_theme in res
                            ):
                                searche_theme = re.search(
                                    rf"{titre_res_theme}\s*(.*?)\s*$",
                                    res,
                                    re.DOTALL | re.MULTILINE,
                                )
                                if searche_theme:
                                    texte_extrait = searche_theme.group(1)
                                    if texte_extrait != thematique_description:
                                        res = res.replace(
                                            texte_extrait, thematique_description
                                        )

                        # On remplie le Titre
                        title = layer_meta.title()
                        if meta_titre is not None:
                            title = meta_titre

                        # On remplie la partie Liens
                        if licence is not None:
                            layer_meta.setLicenses([licence])

                        export_GS_links = (
                            layer_meta.licenses() != []
                            and layer_meta.licenses()[0] == LICENCE_OUVERTE_OD
                        )
                        ext_links = create_links(
                            layer_schema, layer_name, export_GS_links
                        )

                        layer_meta.setLinks(ext_links)

                        # On remplie la partie Emprise spatiale
                        source_crs = QgsCoordinateReferenceSystem(3945)
                        target_crs = QgsCoordinateReferenceSystem(4326)
                        ext = QgsLayerMetadata.Extent()
                        se = QgsLayerMetadata.SpatialExtent()
                        se.extentCrs = target_crs
                        transform = QgsCoordinateTransform(
                            source_crs, target_crs, QgsProject.instance()
                        )
                        bounds = QgsBox3d(xmin, ymin, 0, xmax, ymax, 0)
                        source_rect = QgsRectangle(
                            bounds.xMinimum(),
                            bounds.yMinimum(),
                            bounds.xMaximum(),
                            bounds.yMaximum(),
                        )
                        target_rect = transform.transform(source_rect)
                        se.bounds = QgsBox3d(
                            target_rect.xMinimum(),
                            target_rect.yMinimum(),
                            0,
                            target_rect.xMaximum(),
                            target_rect.yMaximum(),
                            0,
                        )
                        ext.setSpatialExtents([se])

                        # On remplie la partie Catégories et mots clés
                        if isinstance(keywords, dict):
                            keywords = list(keywords.values())
                        if keywords is not None:
                            if not isinstance(keywords, list):
                                keywords = [keywords]
                            layer_meta.setKeywords({"": keywords})
                        if categories is not None:
                            layer_meta.setCategories(categories)
                        # On met à jour les metadonnées
                        layer_meta.setIdentifier(identif)
                        if self.chImportAbstract.isChecked():
                            layer_meta.setAbstract(res)
                        layer_meta.setLanguage("FRA")
                        if self.chImportTitle.isChecked():
                            layer_meta.setTitle(title)
                        layer_meta.setContacts([meta_contact])
                        layer_meta.setExtent(ext)
                        layer.setMetadata(layer_meta)
                    self.push_message_bar(
                        f"La fiche métadonnées {layer_name} est remplie!"
                    )
                    # self.activateWindow() # pour remettre la page du plugin en premier plan
                    self.layers_tree()
                    self.set_tree()
                    self.tree_layers_color()
                    self.frame_legende.setVisible(True)
                else:
                    self.push_message_bar(
                        "Aucune couche dans votre projet n'est une couche principale!",
                        Qgis.Critical,
                    )

    def push_message_bar(self, message, level=Qgis.Info):
        """_summary_

        Fonction qui renvoie aprés l'auto-remplissage des métadonnées.

        """
        if level == Qgis.Critical:
            self.mb.pushMessage(
                message, level=level, duration=0
            )  # keep displayed until manual cancel
        else:
            self.mb.pushMessage(message, level=level)

    def meta_qgis_validation(self, layer_name):
        """_summary_

        Cette fonction effectue une validation de la métadonnée pour une couche à l'aide de
        la classe QgsNativeMetadataValidator de QGIS. La méthode (QgsNativeMetadataValidator)
        retourne une liste de résultats de validation, et la première valeur de cette liste
        est renvoyée en sortie de fonction.

        Args:
            layer_name (str): nom de la couche.
        """
        layer = QgsProject.instance().mapLayersByName(layer_name)
        meta = layer[0].metadata()
        validator = QgsNativeMetadataValidator()
        validation = validator.validate(meta)
        return validation[0]

    def close_plugin(self):
        """_summary_

        Fonction qui ferme le plugin.

        """
        self.close()

    def layers_tree(self):
        """_summary_

        Cette fonction serre à structure l'arbre du plugin
        (le tableau qui affiche toutes les informations sur les métadonnées).
        Sans remplir d'information elle définit uniquement sa squelette.

        """
        # list_licenses = ["","Licence Ouverte version 2.0","ODC Open Database License
        # (ODbL) version 1.0","Apache License 2.0","BSD 2-Clause (Simplified) License",
        # "BSD 3-Clause (New) or (Revised) License","CeCILL-B Free Software License Agreement",
        # "MIT License","CeCILL Free Software License Agreement v2.1",
        # "CeCILL-C Free Software License Agreement","GNU General Public License v3.0 or later",
        # "GNU Lesser General Public License v3.0 or later",
        # "GNU Affero General Public License v3.0 or later","Mozilla Public License 2.0",
        # "Eclipse Public License 2.0","European Union Public License 1.2"]
        list_licenses = [
            "",
            LICENCE_OUVERTE_OD,
            LICENCE_FERMEE,
        ]

        list_themes_inspire = [
            "Altitude",
            "Occupation des terres",
            "Ortho-imagerie",
            "Géologie",
            "Unités statistiques",
            "Installations de suivi environnemental",
            "Bâtiments",
            "Sols",
            "Usage des sols",
            "Santé et sécurité des personnes",
            "Services d'utilité publique et services publics",
            "Lieux de production et sites industriels",
            "Installations agricoles et aquacoles",
            "Répartition de la population — démographie",
            "Zones de gestion, de restriction ou de réglementation et unités de déclaration",
            "Zones à risque naturel",
            "Conditions atmosphériques",
            "Caractéristiques géographiques océanographiques",
            "Régions maritimes",
            "Régions biogéographiques",
            "Habitats et biotopes",
            "Répartition des espèces",
            "Sources d'énergie",
            "Ressources minérales",
            "Référentiels de coordonnées",
            "Systèmes de maillage géographique",
            "Dénominations géographiques",
            "Unités administratives",
            "Adresses",
            "Parcelles cadastrales",
            "Réseaux de transport",
            "Hydrographie",
            "Sites protégés",
            "Caractéristiques géographiques météorologiques",
        ]
        popup_texts = [
            "Modèles numériques pour l'altitude des surfaces terrestres, "
            "glaciaires et océaniques. Comprend l'altitude terrestre, "
            "la bathymétrie et la ligne de rivage.",
            "Couverture physique et biologique de la surface terrestre, y compris "
            "les surfaces artificielles, les zones agricoles, les forêts, les zones "
            "(semi-)naturelles, les zones humides et les masses d'eau.",
            "Images géoréférencées de la surface terrestre, provenant de "
            "satellites ou de capteurs aéroportés.",
            "Géologie caractérisée en fonction de la composition et de la structure. "
            "Englobe le substratum rocheux, les aquifères et la géomorphologie.",
            "Unités de diffusion ou d'utilisation d'autres informations statistiques.",
            "La situation et le fonctionnement des installations de suivi environnemental "
            "comprennent l'observation et la mesure des émissions, de l'état du milieu "
            "environnemental et d'autres paramètres de l'écosystème (biodiversité, conditions "
            "écologiques de la végétation, etc.) par les autorités publiques ou pour leur compte.",
            "Situation géographique des bâtiments.",
            "Sols et sous-sol caractérisés selon leur profondeur, texture, structure et "
            "teneur en particules et en matières organiques, pierrosité, érosion, le cas "
            "échéant pente moyenne et capacité anticipée de stockage de l'eau.",
            "Territoire caractérisé selon sa dimension fonctionnelle prévue ou son objet "
            "socioéconomique actuel et futur (par exemple, résidentiel, industriel, "
            "commercial, agricole, forestier, récréatif).",
            "Répartition géographique des pathologies dominantes (allergies, cancers, "
            "maladies respiratoires, etc.) liées directement (pollution de l'air, produits "
            "chimiques, appauvrissement de la couche d'ozone, bruit, etc.) ou indirectement "
            "(alimentation, organismes génétiquement modifiés, etc.) à la qualité de "
            "l'environnement, et ensemble des informations relatif à l'effet de celle-ci "
            "sur la santé des hommes (marqueurs biologiques, déclin de la fertilité, "
            "épidémies) ou leur bien-être (fatigue, stress, etc.).",
            "Comprend les installations d'utilité publique, tels que les égouts ou "
            "les réseaux et installations liés à la gestion des déchets, à l'approvisionnement "
            "énergétique, à l'approvisionnement en eau, ainsi que les services administratifs "
            "et sociaux publics, tels que les administrations publiques, les sites de la "
            "protection civile, les écoles et les hôpitaux.",
            "Sites de production industrielle, y compris les installations couvertes par "
            "la directive 96/61/CE du Conseil du 24 septembre 1996 relative à la prévention "
            "et à la réduction intégrées de la pollution [1] et les installations de "
            "captage d'eau, d'extraction minière et de stockage.",
            "Équipement et installations de production agricoles (y compris les "
            "systèmes d'irrigation, les serres et les étables).",
            "Répartition géographique des personnes, avec les caractéristiques de "
            "population et les niveaux d'activité, regroupées par grille, région, "
            "unité administrative ou autre unité analytique.",
            "Zones gérées, réglementées ou utilisées pour les rapports aux niveaux "
            "international, européen, national, régional et local. Sont inclus les "
            "décharges, les zones restreintes aux alentours des sources d'eau potable, "
            "les zones vulnérables aux nitrates, les chenaux réglementés en mer ou les "
            "eaux intérieures importantes, les zones destinées à la décharge de déchets, "
            "les zones soumises à limitation du bruit, les zones faisant l'objet de "
            "permis d'exploration et d'extraction minière, les districts "
            "hydrographiques, les unités correspondantes utilisées pour les "
            "rapports et les zones de gestion du littoral.",
            "Zones sensibles caractérisées en fonction des risques naturels "
            "(tous les phénomènes atmosphériques, hydrologiques, sismiques, "
            "volcaniques, ainsi que les feux de friche qui peuvent, en raison "
            "de leur situation, de leur gravité et de leur fréquence, nuire "
            "gravement à la société), tels qu'inondations, glissements et "
            "affaissements de terrain, avalanches, incendies de forêts, "
            "tremblements de terre et éruptions volcaniques.",
            "Conditions physiques dans l'atmosphère. Comprend les données "
            "géographiques fondées sur des mesures, sur des modèles ou sur une "
            "combinaison des deux, ainsi que les lieux de mesure.",
            "Conditions physiques des océans (courants, salinité, hauteur des "
            "vagues, etc.).",
            "Conditions physiques des mers et des masses d'eau salée divisées "
            "en régions et en sous-régions à caractéristiques communes.",
            "Zones présentant des conditions écologiques relativement "
            "homogènes avec des caractéristiques communes.",
            "Zones géographiques ayant des caractéristiques écologiques "
            "particulières — conditions, processus, structures et fonctions "
            "(de maintien de la vie) — favorables aux organismes qui y vivent. "
            "Sont incluses les zones terrestres et aquatiques qui se distinguent "
            "par leurs caractéristiques géographiques, abiotiques ou biotiques, "
            "qu'elles soient naturelles ou semi-naturelles.",
            "Répartition géographique de l'occurrence des espèces animales et "
            "végétales regroupées par grille, région, unité administrative ou "
            "autre unité analytique.",
            "Sources d'énergie comprenant les hydrocarbures, l'énergie "
            "hydraulique, la bioénergie, l'énergie solaire, l'énergie "
            "éolienne, etc., le cas échéant accompagnées d'informations "
            "relatives à la profondeur/la hauteur de la source.",
            "Ressources minérales comprenant les minerais métalliques, les "
            "minéraux industriels, etc., le cas échéant accompagnées "
            "d'informations relatives à la profondeur/la hauteur de la ressource.",
            "Systèmes de référencement unique des informations géographiques "
            "dans l'espace sous forme d'une série de coordonnées (x, y, z) "
            "et/ou la latitude et la longitude et l'altitude, en se fondant "
            "sur un point géodésique horizontal et vertical.",
            "Grille multi-résolution harmonisée avec un point d'origine commun "
            "et une localisation ainsi qu'une taille des cellules harmonisées.",
            "Noms de zones, de régions, de localités, de grandes villes, de "
            "banlieues, de villes moyennes ou d'implantations, ou tout autre "
            "élément géographique ou topographique d'intérêt public ou historique.",
            "Unités d'administration séparées par des limites administratives "
            "et délimitant les zones dans lesquelles les États membres "
            "détiennent et/ou exercent leurs compétences, aux fins de "
            "l'administration locale, régionale et nationale.",
            "Localisation des propriétés fondée sur les identifiants des "
            "adresses, habituellement le nom de la rue, le numéro de la "
            "maison et le code postal.",
            "Zones définies par les registres cadastraux ou équivalents.",
            "Réseaux routier, ferroviaire, aérien et navigable ainsi que "
            "les infrastructures associées. Sont également incluses les "
            "correspondances entre les différents réseaux, ainsi que le "
            "réseau transeuropéen de transport tel que défini dans la "
            "décision no 1692/96/CE du Parlement européen et du Conseil "
            "du 23 juillet 1996 sur les orientations communautaires pour "
            "le développement du réseau transeuropéen de transport [1] "
            "et les révisions futures de cette décision.",
            "Éléments hydrographiques, y compris les zones maritimes ainsi "
            "que toutes les autres masses d'eau et les éléments qui y sont "
            "liés, y compris les bassins et sous-bassins hydrographiques. "
            "Conformes, le cas échéant, aux définitions établies par la "
            "directive 2000/60/CE du Parlement européen et du Conseil "
            "du 23 octobre 2000 établissant un cadre pour une politique "
            "communautaire dans le domaine de l'eau [2] et sous forme de réseaux.",
            "Zone désignée ou gérée dans un cadre législatif international, "
            "communautaire ou national en vue d'atteindre des objectifs "
            "spécifiques de conservation.",
            "Conditions météorologiques et leur mesure: précipitations, "
            "température, évapotranspiration, vitesse et direction du vent.",
        ]

        self.treeWidget.clear()
        tree = self.treeWidget
        tree.setColumnCount(4)
        tree.setHeaderLabels(
            ["Geonetwork", "Couches", "Champs de métadonnées manquants", "A compléter"]
        )
        project = QgsProject.instance()
        for layer in project.mapLayers().values():
            layer_meta = layer.metadata()
            layer_name = layer.name()
            if len(self.layers_niveau) > 0:
                if self.layers_niveau.get(layer_name) == 1:
                    if layer_name != "gest_bdd_metadata":
                        attribut = QTreeWidgetItem(tree)
                        checkbox = QCheckBox()
                        # Ajoutez le QCheckBox à la première colonne de l'élément
                        # attribut.setCheckState(0, Qt.Unchecked)
                        tree.setItemWidget(attribut, 0, checkbox)
                        attribut.setText(1, str(layer_name))

                        # Catégories et Mot clés et Thèmes Inspire
                        item_inspire = QTreeWidgetItem(attribut)
                        item_inspire.setText(2, str(THEMES_INSPIRE))
                        value_inspire = QgsCheckableComboBox()
                        value_inspire.addItems(list_themes_inspire)
                        attribut.addChild(item_inspire)
                        tree.setItemWidget(item_inspire, 3, value_inspire)
                        for j in range(value_inspire.count()):
                            value_inspire.itemText(j)
                            popup_text = popup_texts[j]
                            value_inspire.setItemData(j, popup_text, Qt.ToolTipRole)

                        item_keywords = QTreeWidgetItem(attribut)
                        item_keywords.setText(2, str("Mots-clés"))
                        value_keywords = QLineEdit()
                        value_keywords.setPlaceholderText("Keyword1,Keyword2,Keyword3")
                        attribut.addChild(item_keywords)
                        tree.setItemWidget(item_keywords, 3, value_keywords)

                        item_cat = QTreeWidgetItem(attribut)
                        item_cat.setText(2, str("Catégories"))
                        value_cat = QgsCheckableComboBox()
                        items_dict_cat_fr = list(self.dict_cat_iso.keys())
                        for item in items_dict_cat_fr:
                            value_cat.addItem(item)
                        attribut.addChild(item_cat)
                        tree.setItemWidget(item_cat, 3, value_cat)

                        item_licenses = QTreeWidgetItem(attribut)
                        value_licences = QComboBox()
                        value_licences.addItems(list_licenses)
                        item_licenses.setText(2, str("Licence"))
                        # item_licenses.setForeground(2, QColor(255, 165, 0))
                        attribut.addChild(item_licenses)
                        tree.setItemWidget(item_licenses, 3, value_licences)

                        if not self.meta_qgis_validation(layer_name):
                            if layer_meta.title() == "":
                                item_titre = QTreeWidgetItem(attribut)
                                item_titre.setText(2, str("titre"))
                                item_titre.setForeground(2, QBrush(Qt.red))
                                value_titre = QLineEdit()
                                # value_titre.setObjectName("value_titre"+layer_name)
                                attribut.addChild(item_titre)
                                tree.setItemWidget(item_titre, 3, value_titre)
                            if layer_meta.abstract() == "":
                                item_abstract = QTreeWidgetItem(attribut)
                                item_abstract.setText(2, str("Résumé de la couche"))
                                item_abstract.setForeground(2, QColor(255, 165, 0))
                                value_abstract = QTextEdit()
                                value_abstract.setFixedHeight(80)
                                attribut.addChild(item_abstract)
                                tree.setItemWidget(item_abstract, 3, value_abstract)

    def click_apply(self):
        """
        update metadata
        """
        self.get_tree_checkbox_status()
        if self.treeWidget.topLevelItemCount() == 0:
            self.push_message_bar(
                "Vous n'avez pas encore lancé l'auto-remplissage !",
                Qgis.Critical,
            )
        else:
            self.update_meta()
            self.push_message_bar("Vos fiches sont à jour!", Qgis.Success)

        self.tree_layers_color()
        self.set_tree_checkbox_status()

    def update_meta(self):
        dict_inspire = None
        parent = self.treeWidget.invisibleRootItem()
        project = QgsProject.instance()
        for layer in project.mapLayers().values():
            layer_meta = layer.metadata()
            layer_name = layer.name()
            if len(self.layers_niveau) > 0:
                if self.layers_niveau.get(layer_name) == 1:
                    source = str(layer.source())
                    start = source.find("table=") + len("table=")
                    end = source.find(".")
                    layer_schema = source[start:end]
                    layer_schema = layer_schema[1:-1]
                    self.get_new_tree_val(parent, layer_name, layer_meta, layer_schema)
                    layer.setMetadata(layer_meta)
                    dict_inspire = self.dict_tree_INSPIRE_val()
        self.layers_tree()
        self.set_tree()
        self.set_tree_INSPIRE_new_val(dict_inspire)

    def get_new_tree_val(self, root, parent_text, metadata, layer_schema):
        """_summary_

        Cette fonction permet de récupérer les nouvelles métadonnées saisies par
        l'utilisateur dans le plugin, et les insérer dans la fiche de métadonnées.

        Args:
            root (treeWidget): objet qui représente la couche.
            parent_text (str): nom du parent(par exemple nom de la couche).
            metadata (objet Qgis):  un objet qui contient les informations de métadonnées de la couche.
            layer_schema (str) : nom du schema d'une couche.
        """
        connexion = self.connexion_postgresql()[1]
        cur = connexion.cursor()
        themes_inspire = None
        categories = None
        mots_clefs = None
        description = None
        licence = None
        title = None
        for i in range(root.childCount()):
            parent = root.child(i)
            if parent.text(1) == parent_text:
                id_objet = metadata.identifier()
                for j in range(parent.childCount()):
                    child = parent.child(j)
                    widget = self.treeWidget.itemWidget(child, 3)
                    if child.text(2) == THEMES_INSPIRE:
                        selected_inspire = widget.checkedItems()
                        value = []
                        for item in selected_inspire:
                            escaped_item = item.replace("'", "''")
                            value.append(escaped_item)
                        if value != "":
                            themes_inspire = value
                    elif child.text(2) == "Mots-clés":
                        value = widget.text()
                        if value != "":
                            mot = ""
                            list_mot = []
                            if value:
                                for lettre in value:
                                    if lettre == ",":
                                        list_mot.append(mot)
                                        mot = ""
                                    elif lettre != "":
                                        mot += lettre
                                list_mot.append(mot)
                            for item in list_mot[::-1]:
                                if item == "":
                                    list_mot.remove(item)
                            metadata.setKeywords(
                                {
                                    "": list_mot,
                                }
                            )
                            mots_clefs_escaped = []
                            for item in list_mot:
                                escaped_item = item.replace("'", "''")
                                mots_clefs_escaped.append(escaped_item)
                            mots_clefs = mots_clefs_escaped
                    elif child.text(2) == "Catégories":
                        selected_cat = widget.checkedItems()
                        value = []
                        for item in selected_cat:
                            if item in self.dict_cat_iso:
                                value.append(self.dict_cat_iso[item])
                        modified_value = [item.replace("'", "''") for item in value]
                        if value != "":
                            metadata.setCategories(value)
                            categories = modified_value
                    elif child.text(2) == "titre":
                        value = widget.text()
                        title = value
                        metadata.setTitle(value)
                    elif child.text(2) == "Résumé de la couche":
                        value = widget.toPlainText()
                        metadata.setAbstract(value)
                        if value != "":
                            description = value
                    elif child.text(2) == "Licence":
                        value = widget.currentText()
                        metadata.setLicenses([value])
                        licence = value
                        export_GS_links = value == LICENCE_OUVERTE_OD
                        ext_links = create_links(
                            layer_schema, parent_text, export_GS_links
                        )
                        metadata.setLinks(ext_links)
                update_requete = (
                    f"UPDATE sit_hydre.gest_bdd_rel_objets_thematique "
                    f'SET metadonnees = \'{{"licences": {json.dumps(licence)}, '
                    f'"categories": {json.dumps(categories)}, '
                    f'"mots_clefs": {json.dumps(mots_clefs)}, '
                    f'"themes_inspire": {json.dumps(themes_inspire)}}}\' '
                    f"WHERE objet_id = '{id_objet}' AND niveau = 1"
                )
                if description is not None:
                    description = description.replace("'", "''")
                    update_requete2 = (
                        f"UPDATE sit_hydre.gest_bdd_rel_objets_thematique "
                        f"SET metadonnees_commentaire = '{description}' "
                        f"WHERE objet_id = '{id_objet}' AND niveau = 1"
                    )
                    cur.execute(update_requete2)
                if title is not None:
                    update_title_requete = (
                        f"UPDATE sit_hydre.gest_bdd_rel_objets_thematique "
                        f"SET metadonnees_titre = '{title}' "
                        f"WHERE objet_id = '{id_objet}' AND niveau = 1"
                    )
                    cur.execute(update_title_requete)
                cur.execute(update_requete)
                connexion.commit()
        cur.close()
        connexion.close()

    def create_default_DB_contact(self, thematique_id):
        print("Creating default contact data in DB.")
        connexion = self.connexion_postgresql()[1]
        with connexion.cursor(cursor_factory=RealDictCursor) as cur:
            cur.execute(
                "INSERT INTO sit_hydre.gest_bdd_contact_referents "
                "(prenom, nom, mail) "
                "VALUES ("
                "'Service d''information territorial', "
                "'(SIT)', "
                "'demande_sit@grenoblealpesmetropole.fr'"
                ") RETURNING *"
            )
            new_item = cur.fetchone()
            cur.execute(
                "INSERT INTO sit_hydre.gest_bdd_rel_thematique_contact_referents "
                "(thematique_id, contact_referent_id, type_ref) "
                f"VALUES ('{thematique_id}', '{new_item['id']}', '')"
            )
        connexion.commit()
        connexion.close()
        return new_item

    def get_tree_INSPIRE_val(self, layer_name):
        """_summary_

        Fonction qui récupere uniquement les nouvelles valeurs concernant les thémes INSPIRE.

        Args:
            layer_name (str): nom de la couche.
        """
        root = self.treeWidget.invisibleRootItem()
        for i in range(root.childCount()):
            parent = root.child(i)
            if parent.text(1) == layer_name:
                for j in range(parent.childCount()):
                    child = parent.child(j)
                    widget = self.treeWidget.itemWidget(child, 3)
                    if child.text(2) == THEMES_INSPIRE:
                        value = widget.checkedItems()
                        return value
        return None

    def dict_tree_INSPIRE_val(self):
        """_summary_

        Cette fonction  permet de générer un dictionnaire contenant les valeurs des
        métadonnées INSPIRE afin de ne pas perdre cette information qui n'est pas
        implémentée dans Qgis.

        """
        inspire_dict = {}
        for i in range(self.treeWidget.topLevelItemCount()):
            item = self.treeWidget.topLevelItem(i)
            nom_couche = item.text(1)
            inspire_dict[nom_couche] = []
            inspire_val = self.get_tree_INSPIRE_val(nom_couche)
            inspire_dict[nom_couche] = inspire_val
        return inspire_dict

    def set_tree(self):
        """_summary_

        Cette fonction remplit l'arbre pour chaque couche avec les informations
        existantes en utilisant la fonction SetTreeItems.

        """
        parent = self.treeWidget.invisibleRootItem()
        project = QgsProject.instance()
        for layer in project.mapLayers().values():
            layer_meta = layer.metadata()
            layer_name = layer.name()
            if len(self.layers_niveau) > 0:
                if self.layers_niveau.get(layer_name) == 1:
                    self.set_tree_items(parent, layer_name, layer_meta)

    def set_tree_INSPIRE_new_val(self, inspire_dict):
        """_summary_

        Cette fonction remplie la partie des valeurs INSPIRE par les
        valeurs INSPIRE saisies par l'utilisateur auparavant.

        Args:
            inspire_dict (dict): dictionnaire des valeurs INSPIRE qui
            ont été saisies par l'utilisateur.
        """
        root = self.treeWidget.invisibleRootItem()
        for i in range(root.childCount()):
            parent = root.child(i)
            for j in range(parent.childCount()):
                child = parent.child(j)
                widget = self.treeWidget.itemWidget(child, 3)
                if child.text(2) == THEMES_INSPIRE:
                    widget.setCheckedItems(inspire_dict[parent.text(1)])

    def get_INSPIRE_from_db(self, metadata):
        """
        get inspire themes from db
        """
        INSPIRE = None
        tab_meta = self.get_metadata_tab()
        for obj in tab_meta:
            id_objet = obj.get("objet_id")
            if id_objet == metadata.identifier():
                INSPIRE = obj.get("metadonnees")["themes_inspire"]
        return INSPIRE

    def set_tree_items(self, root, parent_text, metadata):
        """_summary_

        Fonction qui remplie les champs vides dans l'arbre par les
        données correspondantes depuis la fiche de métadonnées.

        Args:
            root (treeWidget): objet qui représente la couche.
            parent_text (str): nom du parent(par exemple nom de la couche).
            metadata (objet Qgis):  un objet qui contient les informations de métadonnées de la couche.
        """
        for i in range(root.childCount()):
            parent = root.child(i)
            if parent.text(1) == parent_text:
                for j in range(parent.childCount()):
                    child = parent.child(j)
                    widget = self.treeWidget.itemWidget(child, 3)
                    if child.text(2) == THEMES_INSPIRE:
                        list_inspire = self.get_INSPIRE_from_db(metadata)
                        if list_inspire is not None:
                            widget.setCheckedItems(list_inspire)
                    elif child.text(2) == "Mots-clés":
                        keywords = metadata.keywords()
                        for key in keywords:
                            if key == "":
                                widget.setText(",".join(keywords[key]))
                    elif child.text(2) == "Catégories":
                        categories_selected = metadata.categories()
                        keys_selected = [
                            k
                            for k, v in self.dict_cat_iso.items()
                            if v in categories_selected
                        ]
                        widget.setCheckedItems(keys_selected)
                    elif child.text(2) == "Licence":
                        if metadata.licenses() != []:
                            licence_selected = metadata.licenses()[0]
                        else:
                            licence_selected = ""
                        widget.setCurrentText(licence_selected)
                        if widget.currentIndex() == 0:
                            child.setForeground(2, QColor(255, 165, 0))

    def check_tree_title(self):
        """_summary_

        Fonction qui vérifie que toutes les fiches de métadonnées ont un titre.

        """
        res = True
        root = self.treeWidget.invisibleRootItem()
        for i in range(root.childCount()):
            parent = root.child(i)
            checkbox = self.treeWidget.itemWidget(parent, 0)
            for j in range(parent.childCount()):
                child = parent.child(j)
                if child.text(2) == "titre" and checkbox.isChecked():
                    res = False
        return res

    def tree_layers_color(self):
        """_summary_

        Fonction qui met en place les couleurs des champs de métadonnées
        dans l'arbre en fonction de ce qui est remplis ou pas.

        """
        root = self.treeWidget.invisibleRootItem()
        for i in range(root.childCount()):
            has_title = False
            parent = root.child(i)
            for j in range(parent.childCount()):
                child = parent.child(j)
                widget = self.treeWidget.itemWidget(child, 3)
                if child.text(2) == "titre":
                    parent.setForeground(1, QColor("red"))
                    has_title = True
                elif child.text(2) == "Résumé de la couche" or (
                    child.text(2) == "Licence" and widget.currentIndex() == 0
                ):
                    if has_title:
                        parent.setForeground(1, QColor("red"))
                    else:
                        parent.setForeground(1, QColor("orange"))
                else:
                    parent.setForeground(1, QColor("green"))

    def get_tree_checkbox_status(self):
        """_summary_

        Fonction permet de récuperer la valeur pour le checkbox
        Geonetwork si ca a été coché ou non.

        """
        checkbox_status = {}
        root = self.treeWidget.invisibleRootItem()
        for i in range(root.childCount()):
            parent = root.child(i)
            checkbox = self.treeWidget.itemWidget(parent, 0)
            checkbox_status[i] = checkbox.isChecked()
        # Stocker le dictionnaire en tant qu'attribut du plugin
        self.tree_checkbox_status = checkbox_status
        # print('checkbox : '+ str(checkbox_status) )

    def set_tree_checkbox_status(self):
        """_summary_

        Fonction qui met en place les checkboxes.

        """
        if not hasattr(self, "tree_checkbox_status"):
            return
        checkbox_status = self.tree_checkbox_status
        root = self.treeWidget.invisibleRootItem()
        for i in range(root.childCount()):
            parent = root.child(i)
            checkbox = self.treeWidget.itemWidget(parent, 0)
            if i in checkbox_status:
                checkbox.setChecked(checkbox_status[i])

    def check_connexion_gn(self):
        """_summary_

        Fonction qui vérifie la connexion vers le geonetwork et envoie
        un message en fonction de la réponse.

        """
        username = self.leUsername.text()
        motdepass = self.lePassword.text()
        if username == "" and motdepass == "":
            self.push_message_bar(
                "Vous n'avez pas saisi de username ni de mot de passe", Qgis.Critical
            )
        elif username == "":
            self.push_message_bar("Vous n'avez pas saisi de username", Qgis.Critical)
        elif motdepass == "":
            self.push_message_bar(
                "Vous n'avez pas saisi de mot de passe", Qgis.Critical
            )
        else:
            if self.mgGN.connect(username, motdepass):
                self.push_message_bar(
                    "Connexion reussie!! Postez l'ensemble des fiches métadonnées "
                    'sur notre Geonetwork avec le bouton "Envoi".'
                )
                self.pbPost.setVisible(True)
                self.checkLinks.setVisible(True)
                self.label_3.setVisible(True)
            else:
                self.push_message_bar(
                    "Username ou mot de passe incorrect!!", Qgis.Critical
                )

    def populate_tab_gn(self, success_dict):
        """_summary_

        Fonction qui va gérérer l'affichage des fiches qui sont à envoyer
        au geonetwork dans le tableau de la fenetre geonetwork.

        """
        connexion = self.connexion_postgresql()[1]
        cur = connexion.cursor()
        catalog_gn = self.mgGN.CATALOG + "/srv/fre/catalog.search#/metadata/"
        self.model = QStandardItemModel(
            0, 2
        )  # pylint: disable=attribute-defined-outside-init
        self.model.setHorizontalHeaderLabels(
            ["Couches", "Lien vers les fiches métadonnées dans Geonetwork"]
        )
        project = QgsProject.instance()
        for i, layer in enumerate(project.mapLayers().values()):
            layer_name = layer.name()
            layer_meta = layer.metadata()
            uuid = layer_meta.identifier()
            meta_id = self.get_meta_ID(uuid)
            if self.tree_checkbox_status is not None:
                if self.tree_checkbox_status.get(i):
                    meta_id = meta_id[0]
                    item1 = QStandardItem(layer_name)
                    if success_dict[meta_id]["status_code"] < 400:
                        item2 = QStandardItem(catalog_gn + meta_id)
                        item2.setForeground(
                            QBrush(QColor("blue"), style=Qt.SolidPattern)
                        )
                        item2.setTextAlignment(Qt.AlignCenter)
                        item2.setSelectable(True)
                        item2.setData(
                            catalog_gn + meta_id, Qt.UserRole
                        )  # Stocke l'URL dans les données utilisateur
                        meta_lien = catalog_gn + meta_id
                        update_meta_link = (
                            "UPDATE sit_hydre.gest_bdd_rel_objets_thematique "
                            f"SET metadonnees_lien = '{meta_lien}', "
                            f"metadonnees_titre = '{layer_name}' "
                            f"WHERE metadonnees_id = '{meta_id}'"
                        )
                        cur.execute(update_meta_link)
                        connexion.commit()
                    else:
                        item2 = QStandardItem(
                            f"Error: {success_dict[meta_id]['status_code']}"
                        )
                        item2.setForeground(
                            QBrush(QColor("red"), style=Qt.SolidPattern)
                        )
                    item2.setToolTip(
                        f"[{success_dict[meta_id]['status_code']}] "
                        f"{success_dict[meta_id]['detail']}"
                    )
                    item2.setEditable(False)
                    self.model.appendRow([item1, item2])
        cur.close()
        connexion.close()
        self.tableGN.setModel(self.model)
        self.tableGN.setColumnWidth(1, 450)
        self.tableGN.setColumnWidth(0, 250)

    def on_table_gn_double_click(self, index):
        """_summary_

        Fonction qui est appelé lorsqu'on clique deux fois sur une
        cellule de la table des liens geonetwork. Son rôle est de
        récupérer l'URL stockée dans les données utilisateur de la
        cellule correspondante, puis d'ouvrir cette URL dans le
        navigateur par défaut

        Args:
            index (objet): représente l'index de la cellule double-cliquée.
        """
        row = index.row()
        col = index.column()
        if col == 1:  # Vérifie que la cellule double-cliquée est la deuxième colonne
            url = self.model.item(row, col).data(Qt.UserRole)
            QDesktopServices.openUrl(QUrl(url))

    def get_layer_type(self, layer):
        """
        Déterminer le type de la couche
        """
        layer_type = "unknown"
        if isinstance(layer, QgsMapLayer):
            if layer.type() == QgsMapLayerType.VectorLayer:
                if layer.geometryType() == QgsWkbTypes.NullGeometry:
                    layer_type = "textTable"
                else:
                    layer_type = "vector"
            elif (
                layer.type() == QgsMapLayerType.RasterLayer
                or layer.type() == QgsMapLayerType.TileLayer
            ):
                layer_type = "grid"
        return layer_type

    def get_layer_denominateur(self, layer):
        """
        get dominators of registered map scales
        """
        layer_extent = layer.extent()
        layer_scale = max(layer_extent.width(), layer_extent.height())
        arrondis = [
            1000,
            5000,
            10000,
            25000,
            50000,
            100000,
            200000,
            300000,
            500000,
            1000000,
        ]
        echelle_arrondie = min(arrondis, key=lambda x: abs(x - layer_scale))
        return echelle_arrondie

    def add_INSPIRE_to_xml(self):
        """_summary_

        Fonction qui permet de créer le fichier .zip contenant toutes les
        information d'une fiche de métadonnées à l'aide de la fonction createZip.
        Mais aussi permet d'ajouter les valeurs INSPIRE dans la partie xml de ce fichier.

        """
        project = QgsProject.instance()
        for i, layer in enumerate(project.mapLayers().values()):
            layer_name = layer.name()
            layer_meta = layer.metadata()
            uuid = layer_meta.identifier()
            meta_id = self.get_meta_ID(uuid)
            inspire_keywords = self.get_tree_INSPIRE_val(layer_name)
            self.get_tree_checkbox_status()
            if meta_id is not None:
                if self.tree_checkbox_status is not None:
                    layer_type = self.get_layer_type(layer)
                    layer_dominateur = self.get_layer_denominateur(layer)
                    if self.tree_checkbox_status.get(i):
                        meta_id = meta_id[0]
                        date_publication = self.mgGN.get_meta_date_gn(meta_id)
                        # perform GS layer verifications if checked
                        if self.checkLinks.isChecked():
                            issues = []
                            for link in layer_meta.links():
                                if link.format != "HTTPS":
                                    try:
                                        check_link(link)
                                    except GSLayerNotFound as err:
                                        issues.append(
                                            f"{link.type} link not valid ({err.msg})"
                                        )
                            if issues:
                                self.push_message_bar("\n".join(issues), Qgis.Warning)

                        create_zip(
                            layer_name,
                            meta_id,
                            inspire_keywords,
                            layer_type,
                            layer_dominateur,
                            date_publication,
                        )
                        print(
                            """nom layer : """
                            + str(layer_name)
                            + """
                                uuid : """
                            + str(uuid)
                            + """
                                UUID méta : """
                            + str(meta_id)
                            + """
                                Métadonnées : """
                            + str(inspire_keywords)
                            + """
                                Type : """
                            + str(layer_type)
                            + """
                                Dominateur : """
                            + str(layer_dominateur)
                            + """
                                Date publication : """
                            + str(date_publication)
                            + """
                                envoi sur geonetwork : OK """
                        )

    def launch_meta_post(self):
        """_summary_

        Gestion du répertoire temporaire temp et envoie des fiches vers le geonetwork.

        """
        remove_all_zip_files()
        self.add_INSPIRE_to_xml()
        clean_temp()
        success_dict = {}
        current_file_path = os.path.abspath(__file__)
        temp_file = os.path.join(os.path.dirname(current_file_path), "temp")
        filelist = glob(f"{temp_file}/*.zip")
        for i, filename in enumerate(filelist):
            uuid, _ = os.path.splitext(os.path.basename(filename))
            self.progressBar.setValue(int(100 * i / len(filelist)))
            success_dict[uuid] = self.mgGN.post_meta_gn(filename)
        remove_all_zip_files()
        return success_dict

    def update_progressbar(self):
        """_summary_

        Gestion des messages d'erreur. Et mise à jour de la barre d'évolution.

        """
        self.progressBar.setRange(0, 100)
        self.progressBar.setValue(0)
        if self.check_tree_title():
            success_dict = self.launch_meta_post()
            self.populate_tab_gn(success_dict)
            self.progressBar.setValue(100)
        else:
            self.push_message_bar(
                "Vous n'avez pas saisi un titre pour la couche à envoyer! \n"
                "- Retournez dans ''Gestion de métadonnées'' et ajoutez un titre "
                "à l'endroit ou il n'y en a pas pour la couche en question. \n"
                "- Ensuite sauvegardez les modifications.",
                Qgis.Critical,
            )
