from PyQt4.QtCore import * 
from PyQt4.QtGui import *
from qgis.core import *
import resources


class MaxWidth: 

  def __init__(self, iface):
    self.iface = iface

  def initGui(self):  
    self.action = QAction(QIcon(":/plugins/MaxWidth/icon.png"), \
        "MaxWidth", self.iface.mainWindow())
    QObject.connect(self.action, SIGNAL("activated()"), self.run) 

    self.iface.addToolBarIcon(self.action)
    self.iface.addPluginToMenu("&MaxWidth", self.action)

  def unload(self):
    self.iface.removePluginMenu("&MaxWidth",self.action)
    self.iface.removeToolBarIcon(self.action)


  def run(self):
  	vlayer = self.iface.mapCanvas().currentLayer()
  	provider = vlayer.dataProvider()
  	feat = QgsFeature()
  	points=[]
  	while provider.nextFeature(feat):
  		geom = feat.geometry()
  		for ring in geom.asPolygon():
  			for x,y in ring:
  				points.append([x,y])
  				#print x,y
  	
  	
  	xmin,xmax=[0,0],[0,0]
  	for point in points:
  		x=point[0]
  		y=point[1]
  		if x<xmin[0]: xmin=point
  		if x>xmax[0]: xmax=point
  			
	# create layer
	vl = QgsVectorLayer("LineString", "temporary_points", "memory")
	pr = vl.dataProvider()

	# add fields
	pr.addAttributes( [ QgsField("name", QVariant.String) ] )

	# add a feature
	fet = QgsFeature()
	fet.setGeometry(     QgsGeometry.fromPolyline( [ QgsPoint(xmin[0],xmin[1]), QgsPoint(xmax[0],xmax[1]) ] )     )
	fet.setAttributeMap( { 0 : QVariant("testingg") } )
	pr.addFeatures( [ fet ] )

	# update layer's extent when new features have been added
	# because change of extent in provider is not propagated to the layer
	vl.updateExtents()


	# commit the changes
	vl.commitChanges()

	# Add layer to the canvas
	QgsMapLayerRegistry.instance().addMapLayer(vl)




  	
