<!DOCTYPE qgis PUBLIC 'http://mrcc.com/qgis.dtd' 'SYSTEM'>
<qgis readOnly="0" simplifyDrawingHints="0" simplifyLocal="1" maxScale="100000" hasScaleBasedVisibilityFlag="0" minScale="200000" simplifyAlgorithm="0" labelsEnabled="1" simplifyDrawingTol="1" version="3.10.8-A Coruña" simplifyMaxScale="1" styleCategories="AllStyleCategories">
  <flags>
    <Identifiable>1</Identifiable>
    <Removable>1</Removable>
    <Searchable>1</Searchable>
  </flags>
  <renderer-v2 symbollevels="0" forceraster="0" enableorderby="0" attr="active" type="categorizedSymbol">
    <categories>
      <category symbol="0" render="true" label="Active" value="true"/>
      <category symbol="1" render="true" label="Inactive" value="false"/>
    </categories>
    <symbols>
      <symbol name="0" force_rhr="0" clip_to_extent="1" alpha="1" type="fill">
        <layer enabled="1" class="SimpleFill" locked="0" pass="0">
          <prop v="3x:0,0,0,0,0,0" k="border_width_map_unit_scale"/>
          <prop v="51,172,208,255" k="color"/>
          <prop v="bevel" k="joinstyle"/>
          <prop v="0,0" k="offset"/>
          <prop v="3x:0,0,0,0,0,0" k="offset_map_unit_scale"/>
          <prop v="MM" k="offset_unit"/>
          <prop v="0,0,0,255" k="outline_color"/>
          <prop v="solid" k="outline_style"/>
          <prop v="0.26" k="outline_width"/>
          <prop v="MM" k="outline_width_unit"/>
          <prop v="solid" k="style"/>
          <data_defined_properties>
            <Option type="Map">
              <Option name="name" value="" type="QString"/>
              <Option name="properties"/>
              <Option name="type" value="collection" type="QString"/>
            </Option>
          </data_defined_properties>
        </layer>
      </symbol>
      <symbol name="1" force_rhr="0" clip_to_extent="1" alpha="1" type="fill">
        <layer enabled="1" class="SimpleFill" locked="0" pass="0">
          <prop v="3x:0,0,0,0,0,0" k="border_width_map_unit_scale"/>
          <prop v="0,0,0,255" k="color"/>
          <prop v="bevel" k="joinstyle"/>
          <prop v="0,0" k="offset"/>
          <prop v="3x:0,0,0,0,0,0" k="offset_map_unit_scale"/>
          <prop v="MM" k="offset_unit"/>
          <prop v="0,0,0,255" k="outline_color"/>
          <prop v="solid" k="outline_style"/>
          <prop v="0.26" k="outline_width"/>
          <prop v="MM" k="outline_width_unit"/>
          <prop v="solid" k="style"/>
          <data_defined_properties>
            <Option type="Map">
              <Option name="name" value="" type="QString"/>
              <Option name="properties"/>
              <Option name="type" value="collection" type="QString"/>
            </Option>
          </data_defined_properties>
        </layer>
      </symbol>
    </symbols>
    <source-symbol>
      <symbol name="0" force_rhr="0" clip_to_extent="1" alpha="1" type="fill">
        <layer enabled="1" class="SimpleFill" locked="0" pass="0">
          <prop v="3x:0,0,0,0,0,0" k="border_width_map_unit_scale"/>
          <prop v="152,81,14,255" k="color"/>
          <prop v="bevel" k="joinstyle"/>
          <prop v="0,0" k="offset"/>
          <prop v="3x:0,0,0,0,0,0" k="offset_map_unit_scale"/>
          <prop v="MM" k="offset_unit"/>
          <prop v="0,0,0,255" k="outline_color"/>
          <prop v="solid" k="outline_style"/>
          <prop v="0.26" k="outline_width"/>
          <prop v="MM" k="outline_width_unit"/>
          <prop v="solid" k="style"/>
          <data_defined_properties>
            <Option type="Map">
              <Option name="name" value="" type="QString"/>
              <Option name="properties"/>
              <Option name="type" value="collection" type="QString"/>
            </Option>
          </data_defined_properties>
        </layer>
      </symbol>
    </source-symbol>
    <colorramp name="[source]" type="gradient">
      <prop v="255,255,204,255" k="color1"/>
      <prop v="37,52,148,255" k="color2"/>
      <prop v="0" k="discrete"/>
      <prop v="gradient" k="rampType"/>
      <prop v="0.25;161,218,180,255:0.5;65,182,196,255:0.75;44,127,184,255" k="stops"/>
    </colorramp>
    <rotation/>
    <sizescale/>
  </renderer-v2>
  <labeling type="simple">
    <settings calloutType="simple">
      <text-style useSubstitutions="0" fontWeight="50" fontStrikeout="0" isExpression="0" fontSizeMapUnitScale="3x:0,0,0,0,0,0" fontItalic="0" namedStyle="Normal" textOrientation="horizontal" fontSize="8.25" fontWordSpacing="0" multilineHeight="1" textColor="0,0,0,255" fieldName="name" fontKerning="1" textOpacity="1" blendMode="0" fontLetterSpacing="0" fontUnderline="0" fontSizeUnit="Point" previewBkgrdColor="255,255,255,255" fontCapitals="0" fontFamily="MS Shell Dlg 2">
        <text-buffer bufferBlendMode="0" bufferOpacity="1" bufferNoFill="0" bufferJoinStyle="64" bufferDraw="0" bufferSize="1" bufferSizeMapUnitScale="3x:0,0,0,0,0,0" bufferSizeUnits="MM" bufferColor="255,255,255,255"/>
        <background shapeSizeY="0" shapeRadiiUnit="MM" shapeSizeType="0" shapeDraw="0" shapeOffsetY="0" shapeOffsetUnit="MM" shapeOpacity="1" shapeRadiiX="0" shapeFillColor="255,255,255,255" shapeJoinStyle="64" shapeBorderColor="128,128,128,255" shapeType="0" shapeOffsetMapUnitScale="3x:0,0,0,0,0,0" shapeRadiiY="0" shapeBorderWidthUnit="MM" shapeRadiiMapUnitScale="3x:0,0,0,0,0,0" shapeRotationType="0" shapeSizeUnit="MM" shapeBlendMode="0" shapeBorderWidth="0" shapeOffsetX="0" shapeSizeX="0" shapeSizeMapUnitScale="3x:0,0,0,0,0,0" shapeRotation="0" shapeSVGFile="" shapeBorderWidthMapUnitScale="3x:0,0,0,0,0,0">
          <symbol name="markerSymbol" force_rhr="0" clip_to_extent="1" alpha="1" type="marker">
            <layer enabled="1" class="SimpleMarker" locked="0" pass="0">
              <prop v="0" k="angle"/>
              <prop v="125,139,143,255" k="color"/>
              <prop v="1" k="horizontal_anchor_point"/>
              <prop v="bevel" k="joinstyle"/>
              <prop v="circle" k="name"/>
              <prop v="0,0" k="offset"/>
              <prop v="3x:0,0,0,0,0,0" k="offset_map_unit_scale"/>
              <prop v="MM" k="offset_unit"/>
              <prop v="35,35,35,255" k="outline_color"/>
              <prop v="solid" k="outline_style"/>
              <prop v="0" k="outline_width"/>
              <prop v="3x:0,0,0,0,0,0" k="outline_width_map_unit_scale"/>
              <prop v="MM" k="outline_width_unit"/>
              <prop v="diameter" k="scale_method"/>
              <prop v="2" k="size"/>
              <prop v="3x:0,0,0,0,0,0" k="size_map_unit_scale"/>
              <prop v="MM" k="size_unit"/>
              <prop v="1" k="vertical_anchor_point"/>
              <data_defined_properties>
                <Option type="Map">
                  <Option name="name" value="" type="QString"/>
                  <Option name="properties"/>
                  <Option name="type" value="collection" type="QString"/>
                </Option>
              </data_defined_properties>
            </layer>
          </symbol>
        </background>
        <shadow shadowOffsetGlobal="1" shadowOpacity="0.7" shadowOffsetUnit="MM" shadowRadiusMapUnitScale="3x:0,0,0,0,0,0" shadowOffsetDist="1" shadowColor="0,0,0,255" shadowUnder="0" shadowBlendMode="6" shadowDraw="0" shadowRadiusUnit="MM" shadowRadiusAlphaOnly="0" shadowRadius="1.5" shadowScale="100" shadowOffsetAngle="135" shadowOffsetMapUnitScale="3x:0,0,0,0,0,0"/>
        <dd_properties>
          <Option type="Map">
            <Option name="name" value="" type="QString"/>
            <Option name="properties"/>
            <Option name="type" value="collection" type="QString"/>
          </Option>
        </dd_properties>
        <substitutions/>
      </text-style>
      <text-format leftDirectionSymbol="&lt;" rightDirectionSymbol=">" multilineAlign="0" placeDirectionSymbol="0" wrapChar="" reverseDirectionSymbol="0" decimals="3" addDirectionSymbol="0" autoWrapLength="0" plussign="0" useMaxLineLengthForAutoWrap="1" formatNumbers="0"/>
      <placement centroidInside="0" preserveRotation="1" repeatDistance="0" repeatDistanceUnits="MM" overrunDistanceUnit="MM" predefinedPositionOrder="TR,TL,BR,BL,R,L,TSR,BSR" placementFlags="0" offsetType="0" distUnits="MM" yOffset="0" distMapUnitScale="3x:0,0,0,0,0,0" placement="0" priority="5" geometryGeneratorType="PointGeometry" rotationAngle="0" dist="0" quadOffset="4" geometryGeneratorEnabled="0" maxCurvedCharAngleIn="20" repeatDistanceMapUnitScale="3x:0,0,0,0,0,0" geometryGenerator="" xOffset="0" centroidWhole="0" maxCurvedCharAngleOut="-20" fitInPolygonOnly="0" labelOffsetMapUnitScale="3x:0,0,0,0,0,0" overrunDistance="0" overrunDistanceMapUnitScale="3x:0,0,0,0,0,0" layerType="PolygonGeometry" offsetUnits="MapUnit"/>
      <rendering obstacleType="0" fontMaxPixelSize="10000" zIndex="0" upsidedownLabels="0" scaleMin="1" mergeLines="0" minFeatureSize="0" limitNumLabels="0" drawLabels="1" fontMinPixelSize="3" displayAll="0" maxNumLabels="2000" obstacle="1" scaleMax="10000000" fontLimitPixelSize="0" labelPerPart="0" scaleVisibility="0" obstacleFactor="1"/>
      <dd_properties>
        <Option type="Map">
          <Option name="name" value="" type="QString"/>
          <Option name="properties"/>
          <Option name="type" value="collection" type="QString"/>
        </Option>
      </dd_properties>
      <callout type="simple">
        <Option type="Map">
          <Option name="anchorPoint" value="pole_of_inaccessibility" type="QString"/>
          <Option name="ddProperties" type="Map">
            <Option name="name" value="" type="QString"/>
            <Option name="properties"/>
            <Option name="type" value="collection" type="QString"/>
          </Option>
          <Option name="drawToAllParts" value="false" type="bool"/>
          <Option name="enabled" value="0" type="QString"/>
          <Option name="lineSymbol" value="&lt;symbol name=&quot;symbol&quot; force_rhr=&quot;0&quot; clip_to_extent=&quot;1&quot; alpha=&quot;1&quot; type=&quot;line&quot;>&lt;layer enabled=&quot;1&quot; class=&quot;SimpleLine&quot; locked=&quot;0&quot; pass=&quot;0&quot;>&lt;prop v=&quot;square&quot; k=&quot;capstyle&quot;/>&lt;prop v=&quot;5;2&quot; k=&quot;customdash&quot;/>&lt;prop v=&quot;3x:0,0,0,0,0,0&quot; k=&quot;customdash_map_unit_scale&quot;/>&lt;prop v=&quot;MM&quot; k=&quot;customdash_unit&quot;/>&lt;prop v=&quot;0&quot; k=&quot;draw_inside_polygon&quot;/>&lt;prop v=&quot;bevel&quot; k=&quot;joinstyle&quot;/>&lt;prop v=&quot;60,60,60,255&quot; k=&quot;line_color&quot;/>&lt;prop v=&quot;solid&quot; k=&quot;line_style&quot;/>&lt;prop v=&quot;0.3&quot; k=&quot;line_width&quot;/>&lt;prop v=&quot;MM&quot; k=&quot;line_width_unit&quot;/>&lt;prop v=&quot;0&quot; k=&quot;offset&quot;/>&lt;prop v=&quot;3x:0,0,0,0,0,0&quot; k=&quot;offset_map_unit_scale&quot;/>&lt;prop v=&quot;MM&quot; k=&quot;offset_unit&quot;/>&lt;prop v=&quot;0&quot; k=&quot;ring_filter&quot;/>&lt;prop v=&quot;0&quot; k=&quot;use_custom_dash&quot;/>&lt;prop v=&quot;3x:0,0,0,0,0,0&quot; k=&quot;width_map_unit_scale&quot;/>&lt;data_defined_properties>&lt;Option type=&quot;Map&quot;>&lt;Option name=&quot;name&quot; value=&quot;&quot; type=&quot;QString&quot;/>&lt;Option name=&quot;properties&quot;/>&lt;Option name=&quot;type&quot; value=&quot;collection&quot; type=&quot;QString&quot;/>&lt;/Option>&lt;/data_defined_properties>&lt;/layer>&lt;/symbol>" type="QString"/>
          <Option name="minLength" value="0" type="double"/>
          <Option name="minLengthMapUnitScale" value="3x:0,0,0,0,0,0" type="QString"/>
          <Option name="minLengthUnit" value="MM" type="QString"/>
          <Option name="offsetFromAnchor" value="0" type="double"/>
          <Option name="offsetFromAnchorMapUnitScale" value="3x:0,0,0,0,0,0" type="QString"/>
          <Option name="offsetFromAnchorUnit" value="MM" type="QString"/>
          <Option name="offsetFromLabel" value="0" type="double"/>
          <Option name="offsetFromLabelMapUnitScale" value="3x:0,0,0,0,0,0" type="QString"/>
          <Option name="offsetFromLabelUnit" value="MM" type="QString"/>
        </Option>
      </callout>
    </settings>
  </labeling>
  <customproperties>
    <property value="gid" key="dualview/previewExpressions"/>
    <property value="0" key="embeddedWidgets/count"/>
    <property key="variableNames"/>
    <property key="variableValues"/>
  </customproperties>
  <blendMode>0</blendMode>
  <featureBlendMode>0</featureBlendMode>
  <layerOpacity>1</layerOpacity>
  <SingleCategoryDiagramRenderer diagramType="Histogram" attributeLegend="1">
    <DiagramCategory opacity="1" width="15" barWidth="5" scaleDependency="Area" minimumSize="0" maxScaleDenominator="200000" sizeScale="3x:0,0,0,0,0,0" backgroundAlpha="255" backgroundColor="#ffffff" penWidth="0" scaleBasedVisibility="1" minScaleDenominator="100000" height="15" diagramOrientation="Up" sizeType="MM" labelPlacementMethod="XHeight" penColor="#000000" lineSizeType="MM" rotationOffset="270" penAlpha="255" enabled="0" lineSizeScale="3x:0,0,0,0,0,0">
      <fontProperties style="" description="MS Shell Dlg 2,8.25,-1,5,50,0,0,0,0,0"/>
      <attribute field="" label="" color="#000000"/>
    </DiagramCategory>
  </SingleCategoryDiagramRenderer>
  <DiagramLayerSettings linePlacementFlags="2" priority="0" placement="0" obstacle="0" dist="0" showAll="1" zIndex="0">
    <properties>
      <Option type="Map">
        <Option name="name" value="" type="QString"/>
        <Option name="properties"/>
        <Option name="type" value="collection" type="QString"/>
      </Option>
    </properties>
  </DiagramLayerSettings>
  <geometryOptions removeDuplicateNodes="0" geometryPrecision="0">
    <activeChecks/>
    <checkConfiguration type="Map">
      <Option name="QgsGeometryGapCheck" type="Map">
        <Option name="allowedGapsBuffer" value="0" type="double"/>
        <Option name="allowedGapsEnabled" value="false" type="bool"/>
        <Option name="allowedGapsLayer" value="" type="QString"/>
      </Option>
    </checkConfiguration>
  </geometryOptions>
  <fieldConfiguration>
    <field name="gid">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="name">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="basinnum">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="initlevel">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="level">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="area">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="volume">
      <editWidget type="TextEdit">
        <config>
          <Option type="Map">
            <Option name="IsMultiline" value="false" type="bool"/>
            <Option name="UseHtml" value="false" type="bool"/>
          </Option>
        </config>
      </editWidget>
    </field>
    <field name="active">
      <editWidget type="CheckBox">
        <config>
          <Option type="Map">
            <Option name="CheckedState" value="" type="QString"/>
            <Option name="UncheckedState" value="" type="QString"/>
          </Option>
        </config>
      </editWidget>
    </field>
  </fieldConfiguration>
  <aliases>
    <alias field="gid" name="" index="0"/>
    <alias field="name" name="Name" index="1"/>
    <alias field="basinnum" name="Basin number" index="2"/>
    <alias field="initlevel" name="Reference level (m)" index="3"/>
    <alias field="level" name="Level (m)" index="4"/>
    <alias field="area" name="Area (m2)" index="5"/>
    <alias field="volume" name="Volume (m3)" index="6"/>
    <alias field="active" name="Active" index="7"/>
  </aliases>
  <excludeAttributesWMS/>
  <excludeAttributesWFS/>
  <defaults>
    <default applyOnUpdate="0" field="gid" expression=""/>
    <default applyOnUpdate="0" field="name" expression=""/>
    <default applyOnUpdate="0" field="basinnum" expression=""/>
    <default applyOnUpdate="0" field="initlevel" expression=""/>
    <default applyOnUpdate="0" field="level" expression=""/>
    <default applyOnUpdate="0" field="area" expression=""/>
    <default applyOnUpdate="0" field="volume" expression=""/>
    <default applyOnUpdate="0" field="active" expression=""/>
  </defaults>
  <constraints>
    <constraint unique_strength="1" field="gid" notnull_strength="1" exp_strength="0" constraints="3"/>
    <constraint unique_strength="1" field="name" notnull_strength="0" exp_strength="0" constraints="2"/>
    <constraint unique_strength="1" field="basinnum" notnull_strength="1" exp_strength="0" constraints="3"/>
    <constraint unique_strength="0" field="initlevel" notnull_strength="0" exp_strength="0" constraints="0"/>
    <constraint unique_strength="0" field="level" notnull_strength="0" exp_strength="0" constraints="0"/>
    <constraint unique_strength="0" field="area" notnull_strength="0" exp_strength="0" constraints="0"/>
    <constraint unique_strength="0" field="volume" notnull_strength="0" exp_strength="0" constraints="0"/>
    <constraint unique_strength="0" field="active" notnull_strength="1" exp_strength="0" constraints="1"/>
  </constraints>
  <constraintExpressions>
    <constraint field="gid" desc="" exp=""/>
    <constraint field="name" desc="" exp=""/>
    <constraint field="basinnum" desc="" exp=""/>
    <constraint field="initlevel" desc="" exp=""/>
    <constraint field="level" desc="" exp=""/>
    <constraint field="area" desc="" exp=""/>
    <constraint field="volume" desc="" exp=""/>
    <constraint field="active" desc="" exp=""/>
  </constraintExpressions>
  <expressionfields/>
  <attributeactions>
    <defaultAction value="{00000000-0000-0000-0000-000000000000}" key="Canvas"/>
    <actionsetting shortTitle="" capture="0" action="from qgis.utils import iface&#xd;&#xa;from qgis.gui import QgsMessageBar&#xd;&#xa;import processing&#xd;&#xa;import os&#xd;&#xa;&#xd;&#xa;# Initialisation des parametres pour le calcul des courbes hypsometriques&#xd;&#xa;nom_MNT = 'DEM_basins' #couche raster MNT&#xd;&#xa;nom_casiers = 'basins' # couche vectorielle des casiers&#xd;&#xa;delta_z = 1 # loi surface volume tous les metres&#xd;&#xa;sortie = os.path.abspath(QgsProcessingUtils.tempFolder()) # fichiers resultats dans repertoire users/Appdata/Local/temp/processing_XXX&#xd;&#xa;&#xd;&#xa;# couches Qgis&#xd;&#xa;existence_couches = True&#xd;&#xa;try:&#xd;&#xa;&#x9;couche_MNT = QgsProject.instance().mapLayersByName(nom_MNT)[0]&#xd;&#xa;except:&#xd;&#xa;&#x9;#print('DEM pas trouvé')&#xd;&#xa;&#x9;iface.messageBar().pushMessage('','no DEM_basins layer found', Qgis.Warning, 3)&#xd;&#xa;&#x9;existence_couches = False&#xd;&#xa;&#xd;&#xa;try:&#xd;&#xa;&#x9;couche_basins = QgsProject.instance().mapLayersByName(nom_casiers)[0]&#xd;&#xa;except:&#xd;&#xa;&#x9;#print('basins pas trouvé')&#xd;&#xa;&#x9;iface.messageBar().pushMessage('','no basins layer found', Qgis.Warning, 3)&#xd;&#xa;&#x9;existence_couches = False&#xd;&#xa;&#xd;&#xa;# Generation de la loi surface volume&#xd;&#xa;if existence_couches:&#xd;&#xa;&#x9;# Execution de l'algorithme QGis de courbes hypsometriques &#xd;&#xa;&#x9;resultat = processing.run(&quot;qgis:hypsometriccurves&quot;,&#xd;&#xa;           {'INPUT_DEM':nom_MNT,&#xd;&#xa;            'BOUNDARY_LAYER':nom_casiers,&#xd;&#xa;            'STEP':delta_z,&#xd;&#xa;            'USE_PERCENTAGE':False,&#xd;&#xa;            'OUTPUT_DIRECTORY':sortie})&#xd;&#xa;&#x9;resultat_chemin = resultat['OUTPUT_DIRECTORY']&#xd;&#xa;&#x9;#print(resultat_chemin)&#xd;&#xa;&#x9;&#xd;&#xa;&#x9;# Traitement des casiers selectionnes&#xd;&#xa;&#x9;features = couche_basins.selectedFeatures()&#xd;&#xa;&#x9;if features == []:&#xd;&#xa;&#x9;&#x9;iface.messageBar().pushMessage('','no selected features in basins layer', Qgis.Warning, 3)&#xd;&#xa;&#x9;else:&#xd;&#xa;&#x9;&#x9;couche_basins.startEditing()&#xd;&#xa;&#x9;&#x9;for feature in features:&#xd;&#xa;&#x9;&#x9;&#x9;id = feature.id() # gid du casier&#xd;&#xa;&#x9;&#x9;&#x9;nom_fichier = 'hystogram_basins_'+str(id)+'.csv'&#xd;&#xa;&#x9;&#x9;&#x9;chemin_fichier = os.path.join(resultat_chemin,nom_fichier)&#xd;&#xa;&#x9;&#x9;&#x9;if not os.path.isfile(chemin_fichier):&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;nom_fichier = 'histogram_basins_'+str(id)+'.csv'&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;chemin_fichier = os.path.join(resultat_chemin,nom_fichier)&#xd;&#xa;&#x9;&#x9;&#x9;if not os.path.isfile(chemin_fichier):&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;iface.messageBar().pushMessage('','no file found : {} or {}'.format('hystogram_basins_'+str(id)+'.csv', 'histogram_basins_'+str(id)+'.csv'), Qgis.Warning, 3)&#xd;&#xa;&#x9;&#x9;&#x9;lignes = []&#xd;&#xa;&#x9;&#x9;&#x9;try:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;fichier = open(chemin_fichier,'r')&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;fichier.readline() # entete&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;lignes = fichier.readlines() # lignes surface, elevation&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;fichier.close()&#xd;&#xa;&#x9;&#x9;&#x9;except IOError:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;#print('no DEM found for Basin gid:'+str(id))&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;iface.messageBar().pushMessage('','no DEM found for Basin gid:'+str(id), Qgis.Warning, 3)&#xd;&#xa;&#x9;&#x9;&#xd;&#xa;&#x9;&#x9;&#x9;# Calcul du volume&#xd;&#xa;&#x9;&#x9;&#x9;if lignes !=[]:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;# initialisation&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;volume = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;delta_z = 1.0 # metre&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;surface_inf = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;surface_sup = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;liste_Z =[]&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;liste_S = []&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;liste_V = []&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;index = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;z = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;# Traitement&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;for ligne in lignes:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;chaine = ligne.split(',')&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;surface_inf = surface_sup&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;surface_sup = float(chaine[0])&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;if index ==0:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;z = float(chaine[1])&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;volume = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;else:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;z += delta_z&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;# Ajout du volume elementaire calcule sur la surface moyenne&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;volume += delta_z*(surface_sup+surface_inf)/2&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;# Listes pour la loi surface-volume&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;liste_Z.append(&quot;%0.2f&quot; %z)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;liste_S.append(&quot;%0.0f&quot; %surface_sup)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;liste_V.append(&quot;%0.0f&quot; %volume)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;#print(liste_Z)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;#print(liste_S)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;#print(liste_V)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;index +=1&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;# Ecriture de la loi surface-volume&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;feature['level']=' '.join(liste_Z)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;feature['area']=' '.join(liste_S)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;feature['volume']=' '.join(liste_V)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;couche_basins.updateFeature(feature)&#xd;&#xa;&#x9;&#xd;&#xa;&#x9;&#x9;# Commit et fin de l'edition&#xd;&#xa;&#x9;&#x9;couche_basins.commitChanges()&#xd;&#xa;&#x9;&#x9;#print('loi surface volume calculee')&#xd;&#xa;&#x9;&#x9;iface.messageBar().pushMessage('','water storage relationship generated', Qgis.Success, 3)&#xd;&#xa;&#x9;&#x9;&#xd;&#xa;&#xd;&#xa;&#x9;&#x9;&#xd;&#xa;" icon="" name="Generate water storage relationship" notificationMessage="" isEnabledOnlyWhenEditable="0" id="{2cf075a2-d623-4ee5-b171-b7c5df3a6de5}" type="1">
      <actionScope id="Feature"/>
      <actionScope id="Canvas"/>
      <actionScope id="Field"/>
    </actionsetting>
  </attributeactions>
  <attributetableconfig sortOrder="0" sortExpression="COALESCE(&quot;branch&quot;, '&lt;NULL>')" actionWidgetStyle="dropDown">
    <columns>
      <column name="gid" type="field" hidden="0" width="337"/>
      <column name="name" type="field" hidden="0" width="-1"/>
      <column name="basinnum" type="field" hidden="0" width="-1"/>
      <column name="initlevel" type="field" hidden="0" width="-1"/>
      <column name="level" type="field" hidden="0" width="266"/>
      <column name="area" type="field" hidden="0" width="501"/>
      <column name="volume" type="field" hidden="0" width="1128"/>
      <column name="active" type="field" hidden="0" width="-1"/>
      <column type="actions" hidden="1" width="-1"/>
    </columns>
  </attributetableconfig>
  <conditionalstyles>
    <rowstyles/>
    <fieldstyles/>
  </conditionalstyles>
  <storedexpressions/>
  <editform tolerant="1"></editform>
  <editforminit/>
  <editforminitcodesource>0</editforminitcodesource>
  <editforminitfilepath>C:/Program Files/QGIS/bin</editforminitfilepath>
  <editforminitcode><![CDATA[# -*- coding: utf-8 -*-
"""
Les formulaires QGIS peuvent avoir une fonction Python qui sera appelée à l'ouverture du formulaire.

Utilisez cette fonction pour ajouter plus de fonctionnalités à vos formulaires.

Entrez le nom de la fonction dans le champ "Fonction d'initialisation Python".
Voici un exemple à suivre:
"""
from qgis.PyQt.QtWidgets import QWidget

def my_form_open(dialog, layer, feature):
    geom = feature.geometry()
    control = dialog.findChild(QWidget, "MyLineEdit")

]]></editforminitcode>
  <featformsuppress>0</featformsuppress>
  <editorlayout>tablayout</editorlayout>
  <attributeEditorForm>
    <attributeEditorContainer visibilityExpressionEnabled="0" groupBox="0" showLabel="1" columnCount="1" name="Basin" visibilityExpression="">
      <attributeEditorField showLabel="1" name="name" index="1"/>
      <attributeEditorField showLabel="1" name="basinnum" index="2"/>
      <attributeEditorField showLabel="1" name="initlevel" index="3"/>
      <attributeEditorField showLabel="1" name="active" index="7"/>
      <attributeEditorContainer visibilityExpressionEnabled="0" groupBox="1" showLabel="1" columnCount="1" name="Water storage relationship" visibilityExpression="">
        <attributeEditorField showLabel="1" name="level" index="4"/>
        <attributeEditorField showLabel="1" name="area" index="5"/>
        <attributeEditorField showLabel="1" name="volume" index="6"/>
      </attributeEditorContainer>
    </attributeEditorContainer>
  </attributeEditorForm>
  <editable>
    <field editable="1" name="active"/>
    <field editable="1" name="area"/>
    <field editable="1" name="basinnum"/>
    <field editable="1" name="gid"/>
    <field editable="1" name="initlevel"/>
    <field editable="1" name="level"/>
    <field editable="1" name="name"/>
    <field editable="1" name="volume"/>
  </editable>
  <labelOnTop>
    <field name="active" labelOnTop="0"/>
    <field name="area" labelOnTop="0"/>
    <field name="basinnum" labelOnTop="0"/>
    <field name="gid" labelOnTop="0"/>
    <field name="initlevel" labelOnTop="0"/>
    <field name="level" labelOnTop="0"/>
    <field name="name" labelOnTop="0"/>
    <field name="volume" labelOnTop="0"/>
  </labelOnTop>
  <widgets>
    <widget name="R_basin_link">
      <config/>
    </widget>
  </widgets>
  <previewExpression>gid</previewExpression>
  <mapTip>branch</mapTip>
  <layerGeometryType>2</layerGeometryType>
</qgis>
