<!DOCTYPE qgis PUBLIC 'http://mrcc.com/qgis.dtd' 'SYSTEM'>
<qgis simplifyDrawingHints="0" simplifyLocal="1" styleCategories="AllStyleCategories" simplifyDrawingTol="1" maxScale="100000" labelsEnabled="1" hasScaleBasedVisibilityFlag="0" minScale="200000" simplifyMaxScale="1" simplifyAlgorithm="0" readOnly="0" version="3.4.2-Madeira">
  <flags>
    <Identifiable>1</Identifiable>
    <Removable>1</Removable>
    <Searchable>1</Searchable>
  </flags>
  <renderer-v2 type="categorizedSymbol" forceraster="0" symbollevels="0" enableorderby="0" attr="active">
    <categories>
      <category value="true" label="Active" symbol="0" render="true"/>
      <category value="false" label="Inactive" symbol="1" render="true"/>
    </categories>
    <symbols>
      <symbol type="fill" name="0" clip_to_extent="1" alpha="1">
        <layer locked="0" enabled="1" pass="0" class="SimpleFill">
          <prop k="border_width_map_unit_scale" v="3x:0,0,0,0,0,0"/>
          <prop k="color" v="51,172,208,255"/>
          <prop k="joinstyle" v="bevel"/>
          <prop k="offset" v="0,0"/>
          <prop k="offset_map_unit_scale" v="3x:0,0,0,0,0,0"/>
          <prop k="offset_unit" v="MM"/>
          <prop k="outline_color" v="0,0,0,255"/>
          <prop k="outline_style" v="solid"/>
          <prop k="outline_width" v="0.26"/>
          <prop k="outline_width_unit" v="MM"/>
          <prop k="style" v="solid"/>
          <data_defined_properties>
            <Option type="Map">
              <Option value="" type="QString" name="name"/>
              <Option name="properties"/>
              <Option value="collection" type="QString" name="type"/>
            </Option>
          </data_defined_properties>
        </layer>
      </symbol>
      <symbol type="fill" name="1" clip_to_extent="1" alpha="1">
        <layer locked="0" enabled="1" pass="0" class="SimpleFill">
          <prop k="border_width_map_unit_scale" v="3x:0,0,0,0,0,0"/>
          <prop k="color" v="0,0,0,255"/>
          <prop k="joinstyle" v="bevel"/>
          <prop k="offset" v="0,0"/>
          <prop k="offset_map_unit_scale" v="3x:0,0,0,0,0,0"/>
          <prop k="offset_unit" v="MM"/>
          <prop k="outline_color" v="0,0,0,255"/>
          <prop k="outline_style" v="solid"/>
          <prop k="outline_width" v="0.26"/>
          <prop k="outline_width_unit" v="MM"/>
          <prop k="style" v="solid"/>
          <data_defined_properties>
            <Option type="Map">
              <Option value="" type="QString" name="name"/>
              <Option name="properties"/>
              <Option value="collection" type="QString" name="type"/>
            </Option>
          </data_defined_properties>
        </layer>
      </symbol>
    </symbols>
    <source-symbol>
      <symbol type="fill" name="0" clip_to_extent="1" alpha="1">
        <layer locked="0" enabled="1" pass="0" class="SimpleFill">
          <prop k="border_width_map_unit_scale" v="3x:0,0,0,0,0,0"/>
          <prop k="color" v="152,81,14,255"/>
          <prop k="joinstyle" v="bevel"/>
          <prop k="offset" v="0,0"/>
          <prop k="offset_map_unit_scale" v="3x:0,0,0,0,0,0"/>
          <prop k="offset_unit" v="MM"/>
          <prop k="outline_color" v="0,0,0,255"/>
          <prop k="outline_style" v="solid"/>
          <prop k="outline_width" v="0.26"/>
          <prop k="outline_width_unit" v="MM"/>
          <prop k="style" v="solid"/>
          <data_defined_properties>
            <Option type="Map">
              <Option value="" type="QString" name="name"/>
              <Option name="properties"/>
              <Option value="collection" type="QString" name="type"/>
            </Option>
          </data_defined_properties>
        </layer>
      </symbol>
    </source-symbol>
    <colorramp type="gradient" name="[source]">
      <prop k="color1" v="255,255,204,255"/>
      <prop k="color2" v="37,52,148,255"/>
      <prop k="discrete" v="0"/>
      <prop k="rampType" v="gradient"/>
      <prop k="stops" v="0.25;161,218,180,255:0.5;65,182,196,255:0.75;44,127,184,255"/>
    </colorramp>
    <rotation/>
    <sizescale/>
  </renderer-v2>
  <labeling type="simple">
    <settings>
      <text-style fontUnderline="0" fontWordSpacing="0" fontWeight="50" fontSizeMapUnitScale="3x:0,0,0,0,0,0" isExpression="0" namedStyle="Normal" fontLetterSpacing="0" previewBkgrdColor="#ffffff" fontSize="8.25" fieldName="name" fontFamily="MS Shell Dlg 2" fontCapitals="0" textColor="0,0,0,255" useSubstitutions="0" fontStrikeout="0" fontSizeUnit="Point" fontItalic="0" blendMode="0" textOpacity="1" multilineHeight="1">
        <text-buffer bufferDraw="0" bufferSize="1" bufferSizeUnits="MM" bufferJoinStyle="64" bufferBlendMode="0" bufferSizeMapUnitScale="3x:0,0,0,0,0,0" bufferColor="255,255,255,255" bufferOpacity="1" bufferNoFill="0"/>
        <background shapeDraw="0" shapeRotation="0" shapeType="0" shapeRadiiUnit="MM" shapeSizeY="0" shapeSizeMapUnitScale="3x:0,0,0,0,0,0" shapeBlendMode="0" shapeSizeUnit="MM" shapeSVGFile="" shapeRadiiX="0" shapeSizeX="0" shapeBorderWidthUnit="MM" shapeBorderColor="128,128,128,255" shapeOpacity="1" shapeRadiiY="0" shapeOffsetY="0" shapeOffsetUnit="MM" shapeOffsetMapUnitScale="3x:0,0,0,0,0,0" shapeJoinStyle="64" shapeRotationType="0" shapeBorderWidthMapUnitScale="3x:0,0,0,0,0,0" shapeSizeType="0" shapeOffsetX="0" shapeRadiiMapUnitScale="3x:0,0,0,0,0,0" shapeFillColor="255,255,255,255" shapeBorderWidth="0"/>
        <shadow shadowOffsetDist="1" shadowScale="100" shadowRadiusAlphaOnly="0" shadowUnder="0" shadowDraw="0" shadowOffsetGlobal="1" shadowRadius="1.5" shadowRadiusMapUnitScale="3x:0,0,0,0,0,0" shadowRadiusUnit="MM" shadowBlendMode="6" shadowOffsetUnit="MM" shadowOffsetAngle="135" shadowOpacity="0.7" shadowOffsetMapUnitScale="3x:0,0,0,0,0,0" shadowColor="0,0,0,255"/>
        <substitutions/>
      </text-style>
      <text-format wrapChar="" useMaxLineLengthForAutoWrap="1" plussign="0" reverseDirectionSymbol="0" rightDirectionSymbol=">" leftDirectionSymbol="&lt;" autoWrapLength="0" addDirectionSymbol="0" multilineAlign="0" decimals="3" formatNumbers="0" placeDirectionSymbol="0"/>
      <placement xOffset="0" labelOffsetMapUnitScale="3x:0,0,0,0,0,0" priority="5" quadOffset="4" placement="0" yOffset="0" repeatDistanceMapUnitScale="3x:0,0,0,0,0,0" centroidWhole="0" offsetUnits="MapUnit" predefinedPositionOrder="TR,TL,BR,BL,R,L,TSR,BSR" placementFlags="0" offsetType="0" centroidInside="0" rotationAngle="0" preserveRotation="1" maxCurvedCharAngleIn="20" maxCurvedCharAngleOut="-20" dist="0" repeatDistanceUnits="MM" distUnits="MM" repeatDistance="0" fitInPolygonOnly="0" distMapUnitScale="3x:0,0,0,0,0,0"/>
      <rendering minFeatureSize="0" scaleVisibility="0" fontLimitPixelSize="0" scaleMax="10000000" scaleMin="1" fontMaxPixelSize="10000" limitNumLabels="0" drawLabels="1" fontMinPixelSize="3" upsidedownLabels="0" labelPerPart="0" zIndex="0" obstacleType="0" displayAll="0" obstacle="1" mergeLines="0" maxNumLabels="2000" obstacleFactor="1"/>
      <dd_properties>
        <Option type="Map">
          <Option value="" type="QString" name="name"/>
          <Option name="properties"/>
          <Option value="collection" type="QString" name="type"/>
        </Option>
      </dd_properties>
    </settings>
  </labeling>
  <customproperties>
    <property value="gid" key="dualview/previewExpressions"/>
    <property value="0" key="embeddedWidgets/count"/>
    <property key="variableNames"/>
    <property key="variableValues"/>
  </customproperties>
  <blendMode>0</blendMode>
  <featureBlendMode>0</featureBlendMode>
  <layerOpacity>1</layerOpacity>
  <SingleCategoryDiagramRenderer diagramType="Histogram" attributeLegend="1">
    <DiagramCategory diagramOrientation="Up" penWidth="0" enabled="0" barWidth="5" width="15" maxScaleDenominator="200000" height="15" backgroundColor="#ffffff" rotationOffset="270" minScaleDenominator="100000" lineSizeScale="3x:0,0,0,0,0,0" scaleDependency="Area" penColor="#000000" scaleBasedVisibility="1" minimumSize="0" sizeType="MM" penAlpha="255" sizeScale="3x:0,0,0,0,0,0" opacity="1" labelPlacementMethod="XHeight" lineSizeType="MM" backgroundAlpha="255">
      <fontProperties description="MS Shell Dlg 2,8.25,-1,5,50,0,0,0,0,0" style=""/>
      <attribute color="#000000" field="" label=""/>
    </DiagramCategory>
  </SingleCategoryDiagramRenderer>
  <DiagramLayerSettings priority="0" obstacle="0" linePlacementFlags="2" showAll="1" placement="0" dist="0" zIndex="0">
    <properties>
      <Option type="Map">
        <Option value="" type="QString" name="name"/>
        <Option name="properties"/>
        <Option value="collection" type="QString" name="type"/>
      </Option>
    </properties>
  </DiagramLayerSettings>
  <geometryOptions geometryPrecision="0" removeDuplicateNodes="0">
    <activeChecks/>
    <checkConfiguration/>
  </geometryOptions>
  <fieldConfiguration>
    <field name="gid">
      <editWidget type="TextEdit">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="name">
      <editWidget type="TextEdit">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="basinnum">
      <editWidget type="Range">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="initlevel">
      <editWidget type="TextEdit">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="level">
      <editWidget type="TextEdit">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="area">
      <editWidget type="TextEdit">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="volume">
      <editWidget type="TextEdit">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
    <field name="active">
      <editWidget type="CheckBox">
        <config>
          <Option/>
        </config>
      </editWidget>
    </field>
  </fieldConfiguration>
  <aliases>
    <alias index="0" name="" field="gid"/>
    <alias index="1" name="Name" field="name"/>
    <alias index="2" name="Basin number" field="basinnum"/>
    <alias index="3" name="Reference level (m)" field="initlevel"/>
    <alias index="4" name="Level (m)" field="level"/>
    <alias index="5" name="Area (m2)" field="area"/>
    <alias index="6" name="Volume (m3)" field="volume"/>
    <alias index="7" name="Active" field="active"/>
  </aliases>
  <excludeAttributesWMS/>
  <excludeAttributesWFS/>
  <defaults>
    <default field="gid" expression="" applyOnUpdate="0"/>
    <default field="name" expression="" applyOnUpdate="0"/>
    <default field="basinnum" expression="" applyOnUpdate="0"/>
    <default field="initlevel" expression="" applyOnUpdate="0"/>
    <default field="level" expression="" applyOnUpdate="0"/>
    <default field="area" expression="" applyOnUpdate="0"/>
    <default field="volume" expression="" applyOnUpdate="0"/>
    <default field="active" expression="" applyOnUpdate="0"/>
  </defaults>
  <constraints>
    <constraint exp_strength="0" field="gid" unique_strength="1" constraints="3" notnull_strength="1"/>
    <constraint exp_strength="0" field="name" unique_strength="1" constraints="2" notnull_strength="0"/>
    <constraint exp_strength="0" field="basinnum" unique_strength="1" constraints="2" notnull_strength="0"/>
    <constraint exp_strength="0" field="initlevel" unique_strength="0" constraints="0" notnull_strength="0"/>
    <constraint exp_strength="0" field="level" unique_strength="0" constraints="0" notnull_strength="0"/>
    <constraint exp_strength="0" field="area" unique_strength="0" constraints="0" notnull_strength="0"/>
    <constraint exp_strength="0" field="volume" unique_strength="0" constraints="0" notnull_strength="0"/>
    <constraint exp_strength="0" field="active" unique_strength="0" constraints="0" notnull_strength="0"/>
  </constraints>
  <constraintExpressions>
    <constraint desc="" field="gid" exp=""/>
    <constraint desc="" field="name" exp=""/>
    <constraint desc="" field="basinnum" exp=""/>
    <constraint desc="" field="initlevel" exp=""/>
    <constraint desc="" field="level" exp=""/>
    <constraint desc="" field="area" exp=""/>
    <constraint desc="" field="volume" exp=""/>
    <constraint desc="" field="active" exp=""/>
  </constraintExpressions>
  <expressionfields/>
  <attributeactions>
    <defaultAction value="{00000000-0000-0000-0000-000000000000}" key="Canvas"/>
    <actionsetting notificationMessage="" type="1" name="Generate water storage relationship" shortTitle="" icon="" isEnabledOnlyWhenEditable="0" capture="0" action="from qgis.utils import iface&#xd;&#xa;from qgis.gui import QgsMessageBar&#xd;&#xa;import processing&#xd;&#xa;&#xd;&#xa;# Initialisation des parametres pour le calcul des courbes hypsometriques&#xd;&#xa;nom_MNT = 'DEM_basins' #couche raster MNT&#xd;&#xa;nom_casiers = 'basins' # couche vectorielle des casiers&#xd;&#xa;delta_z = 1 # loi surface volume tous les metres&#xd;&#xa;sortie = QgsProcessingUtils.tempFolder() # fichiers resultats dans repertoire users/Appdata/Local/temp/processing_XXX&#xd;&#xa;&#xd;&#xa;# couches Qgis&#xd;&#xa;existence_couches = True&#xd;&#xa;try:&#xd;&#xa;&#x9;couche_MNT = QgsProject.instance().mapLayersByName(nom_MNT)[0]&#xd;&#xa;except:&#xd;&#xa;&#x9;#print('DEM pas trouvé')&#xd;&#xa;&#x9;iface.messageBar().pushMessage('','no DEM_basins layer found', Qgis.Warning, 3)&#xd;&#xa;&#x9;existence_couches = False&#xd;&#xa;&#xd;&#xa;try:&#xd;&#xa;&#x9;couche_basins = QgsProject.instance().mapLayersByName(nom_casiers)[0]&#xd;&#xa;except:&#xd;&#xa;&#x9;#print('basins pas trouvé')&#xd;&#xa;&#x9;iface.messageBar().pushMessage('','no basins layer found', Qgis.Warning, 3)&#xd;&#xa;&#x9;existence_couches = False&#xd;&#xa;&#xd;&#xa;# Generation de la loi surface volume&#xd;&#xa;if existence_couches:&#xd;&#xa;&#x9;# Execution de l'algorithme QGis de courbes hypsometriques &#xd;&#xa;&#x9;resultat = processing.run(&quot;qgis:hypsometriccurves&quot;,&#xd;&#xa;           {'INPUT_DEM':nom_MNT,&#xd;&#xa;            'BOUNDARY_LAYER':nom_casiers,&#xd;&#xa;            'STEP':delta_z,&#xd;&#xa;            'USE_PERCENTAGE':False,&#xd;&#xa;            'OUTPUT_DIRECTORY':sortie})&#xd;&#xa;&#x9;resultat_chemin = resultat['OUTPUT_DIRECTORY']&#xd;&#xa;&#x9;#print(resultat_chemin)&#xd;&#xa;&#x9;&#xd;&#xa;&#x9;# Traitement des casiers selectionnes&#xd;&#xa;&#x9;features = couche_basins.selectedFeatures()&#xd;&#xa;&#x9;if features == []:&#xd;&#xa;&#x9;&#x9;iface.messageBar().pushMessage('','no selected features in basins layer', Qgis.Warning, 3)&#xd;&#xa;&#x9;else:&#xd;&#xa;&#x9;&#x9;couche_basins.startEditing()&#xd;&#xa;&#x9;&#x9;for feature in features:&#xd;&#xa;&#x9;&#x9;&#x9;id = feature.id() # gid du casier&#xd;&#xa;&#x9;&#x9;&#x9;nom_fichier = 'hystogram_basins_'+str(id)+'.csv'&#xd;&#xa;&#x9;&#x9;&#x9;chemin_fichier = resultat_chemin+'\\'+nom_fichier&#xd;&#xa;&#x9;&#x9;&#x9;lignes = []&#xd;&#xa;&#x9;&#x9;&#x9;try:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;fichier = open(chemin_fichier,'r')&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;fichier.readline() # entete&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;lignes = fichier.readlines() # lignes surface, elevation&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;fichier.close()&#xd;&#xa;&#x9;&#x9;&#x9;except IOError:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;#print('no DEM found for Basin gid:'+str(id))&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;iface.messageBar().pushMessage('','no DEM found for Basin gid:'+str(id), Qgis.Warning, 3)&#xd;&#xa;&#x9;&#x9;&#xd;&#xa;&#x9;&#x9;&#x9;# Calcul du volume&#xd;&#xa;&#x9;&#x9;&#x9;if lignes !=[]:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;# initialisation&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;volume = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;delta_z = 1.0 # metre&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;surface_inf = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;surface_sup = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;liste_Z =[]&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;liste_S = []&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;liste_V = []&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;index = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;z = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;# Traitement&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;for ligne in lignes:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;chaine = ligne.split(',')&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;surface_inf = surface_sup&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;surface_sup = float(chaine[0])&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;if index ==0:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;z = float(chaine[1])&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;volume = 0&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;else:&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;z += delta_z&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;# Ajout du volume elementaire calcule sur la surface moyenne&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;volume += delta_z*(surface_sup+surface_inf)/2&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;# Listes pour la loi surface-volume&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;liste_Z.append(&quot;%0.2f&quot; %z)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;liste_S.append(&quot;%0.0f&quot; %surface_sup)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;liste_V.append(&quot;%0.0f&quot; %volume)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;#print(liste_Z)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;#print(liste_S)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;#print(liste_V)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;index +=1&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;# Ecriture de la loi surface-volume&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;feature['level']=' '.join(liste_Z)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;feature['area']=' '.join(liste_S)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;feature['volume']=' '.join(liste_V)&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;couche_basins.updateFeature(feature)&#xd;&#xa;&#x9;&#xd;&#xa;&#x9;&#x9;# Commit et fin de l'edition&#xd;&#xa;&#x9;&#x9;couche_basins.commitChanges()&#xd;&#xa;&#x9;&#x9;#print('loi surface volume calculee')&#xd;&#xa;&#x9;&#x9;iface.messageBar().pushMessage('','water storage relationship generated', Qgis.Success, 3)&#xd;&#xa;&#x9;&#x9;&#xd;&#xa;&#xd;&#xa;&#x9;&#x9;&#xd;&#xa;" id="{0a9de39b-8e0b-4a5f-a39e-3167b1bf1f36}">
      <actionScope id="Feature"/>
      <actionScope id="Field"/>
      <actionScope id="Canvas"/>
    </actionsetting>
  </attributeactions>
  <attributetableconfig sortExpression="COALESCE(&quot;branch&quot;, '&lt;NULL>')" sortOrder="0" actionWidgetStyle="dropDown">
    <columns>
      <column width="337" type="field" name="gid" hidden="0"/>
      <column width="-1" type="field" name="name" hidden="0"/>
      <column width="-1" type="field" name="basinnum" hidden="0"/>
      <column width="-1" type="field" name="initlevel" hidden="0"/>
      <column width="266" type="field" name="level" hidden="0"/>
      <column width="501" type="field" name="area" hidden="0"/>
      <column width="1128" type="field" name="volume" hidden="0"/>
      <column width="-1" type="field" name="active" hidden="0"/>
      <column width="-1" type="actions" hidden="1"/>
    </columns>
  </attributetableconfig>
  <conditionalstyles>
    <rowstyles/>
    <fieldstyles/>
  </conditionalstyles>
  <editform tolerant="1"></editform>
  <editforminit/>
  <editforminitcodesource>0</editforminitcodesource>
  <editforminitfilepath>C:/Program Files/QGIS/bin</editforminitfilepath>
  <editforminitcode><![CDATA[# -*- coding: utf-8 -*-
"""
Les formulaires QGIS peuvent avoir une fonction Python qui sera appelée à l'ouverture du formulaire.

Utilisez cette fonction pour ajouter plus de fonctionnalités à vos formulaires.

Entrez le nom de la fonction dans le champ "Fonction d'initialisation Python".
Voici un exemple à suivre:
"""
from qgis.PyQt.QtWidgets import QWidget

def my_form_open(dialog, layer, feature):
    geom = feature.geometry()
    control = dialog.findChild(QWidget, "MyLineEdit")

]]></editforminitcode>
  <featformsuppress>0</featformsuppress>
  <editorlayout>tablayout</editorlayout>
  <attributeEditorForm>
    <attributeEditorContainer name="Basin" visibilityExpressionEnabled="0" showLabel="1" columnCount="1" visibilityExpression="" groupBox="0">
      <attributeEditorField index="1" name="name" showLabel="1"/>
      <attributeEditorField index="2" name="basinnum" showLabel="1"/>
      <attributeEditorField index="3" name="initlevel" showLabel="1"/>
      <attributeEditorField index="7" name="active" showLabel="1"/>
      <attributeEditorContainer name="Water storage relationship" visibilityExpressionEnabled="0" showLabel="1" columnCount="1" visibilityExpression="" groupBox="1">
        <attributeEditorField index="4" name="level" showLabel="1"/>
        <attributeEditorField index="5" name="area" showLabel="1"/>
        <attributeEditorField index="6" name="volume" showLabel="1"/>
      </attributeEditorContainer>
    </attributeEditorContainer>
  </attributeEditorForm>
  <editable>
    <field name="active" editable="1"/>
    <field name="area" editable="1"/>
    <field name="basinnum" editable="1"/>
    <field name="gid" editable="1"/>
    <field name="initlevel" editable="1"/>
    <field name="level" editable="1"/>
    <field name="name" editable="1"/>
    <field name="volume" editable="1"/>
  </editable>
  <labelOnTop>
    <field name="active" labelOnTop="0"/>
    <field name="area" labelOnTop="0"/>
    <field name="basinnum" labelOnTop="0"/>
    <field name="gid" labelOnTop="0"/>
    <field name="initlevel" labelOnTop="0"/>
    <field name="level" labelOnTop="0"/>
    <field name="name" labelOnTop="0"/>
    <field name="volume" labelOnTop="0"/>
  </labelOnTop>
  <widgets>
    <widget name="R_basin_link">
      <config/>
    </widget>
  </widgets>
  <previewExpression>gid</previewExpression>
  <mapTip>branch</mapTip>
  <layerGeometryType>2</layerGeometryType>
</qgis>
