# -*- coding: utf-8 -*-
"""
/***************************************************************************
 mapElevMakerDialog
                                 A QGIS plugin
 Create contours and shadings for hiking maps - to be used with QuickOSM presets
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-04-05
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Alberto Bianco
        email                : albbianc@proton.me
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis import processing
from qgis.utils import iface
from qgis.core import QgsField
from qgis.core import QgsSymbolLayerReference
from qgis.core import QgsMapLayerProxyModel
from PyQt5.QtCore import QVariant
#from PyQt5.QtWidgets import QDialogButtonBox
from os.path import abspath, join, pardir, dirname



# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'map_elev_maker_dialog_base.ui'))


class mapElevMakerDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(mapElevMakerDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)


        self.mInputLayerCB.setFilters(QgsMapLayerProxyModel.RasterLayer)
        self.connectSignals()


    def connectSignals(self) -> None:

#        self.goBtn.clicked.connect(self.go)
        self.button_box.accepted.connect(self.go)

    def go(self) -> None:

        demLayer = self.mInputLayerCB.currentLayer()
        canvas = iface.mapCanvas()
        fineStep = self.fineStepSb.value()
        wideStep = self.wideStepSb.value()
        invStepRatio = fineStep/wideStep
        mapStyle = self.styleSelCB.currentText()
        doShading = self.shadingEnableCK.isChecked()
        doFixMask = self.fixMaskCK.isChecked()

        hsAltitude = self.hsAltitudeSb.value()
        hsAzimuth = self.hsAzimuthSb.value()

        fineLayerName = 'contour'
        hillLayerName = 'shading'

        fineStyle = self.plugin_path('resources','presets',mapStyle,'contour.qml')
        hillStyle = self.plugin_path('resources','presets',mapStyle,'hillshade.qml')

        
        #### Get current canvas extension
        cCRS = canvas.mapSettings().destinationCrs().authid()
        cExt = canvas.extent()
        
        canvasExt = (
            str(cExt.xMinimum()) + ',' +
            str(cExt.xMaximum()) + ',' +
            str(cExt.yMinimum()) + ',' +
            str(cExt.yMaximum()) + 
            ' [' + cCRS + ']')
        
            
        
        
        
        #### Clip the DEM layer on current canvas extension
        #try:
        clipped =  processing.run("gdal:cliprasterbyextent",
                                  {'INPUT':demLayer.id(),
                                   'PROJWIN':canvasExt,
                                   'OVERCRS':False,
                                   'NODATA':None,
                                   'OPTIONS':'',
                                   'DATA_TYPE':0,
                                   'EXTRA':'',
                                   'OUTPUT':'TEMPORARY_OUTPUT'}
                                  )['OUTPUT']
        #except:
        #    print("Format not supported")

        if doShading :
            #### Create shading
            try:
                hillShadeFn = processing.run("gdal:hillshade",
                                         {'INPUT':clipped,
                                          'BAND':1,
                                          'Z_FACTOR':1,
                                          'SCALE':1,
                                          'AZIMUTH':hsAzimuth,
                                          'ALTITUDE':hsAltitude,
                                          'COMPUTE_EDGES':False,
                                          'ZEVENBERGEN':False,
                                          'COMBINED':False,
                                          'MULTIDIRECTIONAL':False,
                                          'OPTIONS':'',
                                          'EXTRA':'',
                                          'OUTPUT':'TEMPORARY_OUTPUT'}
                                         )['OUTPUT']
            except:                
                iface.messageBar().pushMessage("Error","Unsupported layer format. Check that it's not a WMS or WCS layer",level = 2)
                return 
                
                

            hillShade = iface.addRasterLayer(hillShadeFn,
                                             hillLayerName)
        
            result = hillShade.loadNamedStyle(hillStyle)
            if not result[1]:
                print(result[0])
                print(hillStyle)
            
            hillShade.triggerRepaint()



        
        #### Create contours
        # Find contours
        ctFineFn = processing.run("gdal:contour",
                       {'INPUT':clipped,
                        'BAND':1,
                        'INTERVAL':fineStep,
                        'FIELD_NAME':'ELEV',
                        'CREATE_3D':False,
                        'IGNORE_NODATA':False,
                        'NODATA':None,
                        'OFFSET':0,
                        'EXTRA':'',
                        'OUTPUT':'TEMPORARY_OUTPUT'}
                       )['OUTPUT']

        ctFine = iface.addVectorLayer(ctFineFn + '|layername=contour',
                                      fineLayerName,
                                      'ogr')
        
        # Recognize coarse contours
        ctFine.startEditing()
        ctFine.addAttribute(QgsField("coarse",QVariant.Int))
        
        for feature in ctFine.getFeatures():
            elevIdx = feature.fieldNameIndex('ELEV')
            coarseIdx = feature.fieldNameIndex('coarse')
            elev = feature.attributes()[elevIdx]
            if (elev/wideStep - elev //wideStep) < invStepRatio * .99:
                ctFine.changeAttributeValue(feature.id(),coarseIdx,1)
            else:
                ctFine.changeAttributeValue(feature.id(),coarseIdx,0)

        ctFine.commitChanges()


        ### Apply style
        result = ctFine.loadNamedStyle(fineStyle)
        if not result[1]:
            print(result[0])
            print(fineStyle)

        ### Fix the contour altitude masking
        if doFixMask :
            print("running mask fix")
            renderer = ctFine.renderer()
            symbol = renderer.rootRule().children()[0].symbol()
            symbollayer = symbol.symbolLayer(0)
            symbolLayerRef = QgsSymbolLayerReference(ctFine.id(), symbollayer.id())
            print(symbolLayerRef)
            ctFine.labeling().rootRule().children()[0].settings().format().mask().setMaskedSymbolLayers( [symbolLayerRef ])
       
        
        ctFine.triggerRepaint()



    def plugin_path(self,*args):
        """Get the path to plugin root folder.
        
        :param args List of path elements e.g. ['img', 'logos', 'image.png']
        :type args: str
        
        :return: Absolute path to the plugin path.
        :rtype: str
        """
        
        path = dirname(__file__)
        #print(path)
        
        for item in args:
            path = abspath(join(path, item))

        
        return path
