# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Majic
                                 A QGIS plugin
 Load MAJIC files into QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-06-26
        copyright            : (C) 2018 by JB Desbas
        email                : jb.desbas@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'JB Desbas'
__date__ = '2018-06-26'
__copyright__ = '(C) 2018 by JB Desbas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import (QgsApplication,QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFile,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsFields,
                       QgsField,
                       QgsFeature)
#from ..majic_dict import MajicDict
#from ..majic_lineparser import majicLineParser
import processing, os


class loadMajicPack(QgsProcessingAlgorithm):
    INPUT = 'INPUT'
    OUTPUT = 'OUTPUT'
    
    def initAlgorithm(self, config):
        self.addParameter(QgsProcessingParameterFile(self.INPUT,self.tr('Majic Files'),QgsProcessingParameterFile.Folder))

        self.addParameter(QgsProcessingParameterFileDestination(self.OUTPUT,self.tr('Geopackage'),fileFilter='GeoPackage (*.gpkg)'))

    def processAlgorithm(self, parameters, context, feedback):
        par={'INPUT':parameters[self.INPUT]}
        self.tableList=['pb00','pb10','pb21','pb30','pb36','pb40','pb50','pb60','pnb10','pnb21','pnb30',
                        'pnb36','pdl10','pdl20','pdl30','prop','lloc','fantoir']
        for e in self.tableList:
            par.update({e:'memory:'+e})

        data=processing.run('majic:loadmajicfiles',par,context=context,feedback=feedback)
        par={'LAYERS':list(data.values()),'OVERWRITE':True,'OUTPUT':parameters[self.OUTPUT]}
        o=processing.run('native:package',par,context=context,feedback=feedback)
        
        return {self.OUTPUT:o['OUTPUT']}

    def name(self):
        return 'loadmajicfilespack'

    def displayName(self):
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return 'majic'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return loadMajicPack()
