# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Majic
                                 A QGIS plugin
 Load MAJIC files into QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-06-26
        copyright            : (C) 2018 by JB Desbas
        email                : jb.desbas@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'JB Desbas'
__date__ = '2018-06-26'
__copyright__ = '(C) 2018 by JB Desbas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFile,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsFields,
                       QgsField,
                       QgsFeature)
from .majic_dict import MajicDict
import processing, os

class majicLineParser:
    def __init__(self,line='',filetype='pb'):
        self.raw=line
        self.filetype=filetype
        self.spec=MajicDict(filetype)
        if filetype not in ['prop','fantoir']:
            self.spec=MajicDict(filetype,self.attribute('cenr'))
        self.attr=self.attribute
    
    def attribute(self,aname):
        if aname=='pci_parcelle':
            return self.attribute('ccodep')+self.attribute('ccocom')+self.attribute('ccosec').zfill(5)+self.attribute('dnupla')
        #ignorer les negatifs (erreur sur les champs ajouté)
        sta=self.spec.val[aname][0]-1
        sto=self.spec.val[aname][1]
        out=self.raw[sta:sto].strip()
        if not out:
            return None
        return self.raw[sta:sto].strip()
        
    def all_attributes(self):
        r={}
        for e in self.spec.val:
            r.update({e:self.attribute(e)})
        return r
    
    def fields(self):
        return self.spec.fields()
    
    def feature(self):
        feat=QgsFeature(self.fields())
        for k,v in self.all_attributes().items():
            feat.setAttribute(k,v)
        return feat


