# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Majic
                                 A QGIS plugin
 Load MAJIC files into QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-06-26
        copyright            : (C) 2018 by JB Desbas
        email                : jb.desbas@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'JB Desbas'
__date__ = '2018-06-26'
__copyright__ = '(C) 2018 by JB Desbas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'
from PyQt5.QtCore import QVariant
from qgis.core import (QgsField,QgsFields)

class MajicDict:
    def __init__(self,file,cenr=None):
        self.val={}
        if file=='pb':
            self.val={
                'ccodep':(1,2),
                'ccodir':(3,3),
                'ccocom':(4,6),
                'invar':(7,16), 
                'cenr':(31,32) }
            if cenr=='00':
                self.val.update({
                    'ccopre':(36,38),
                    'ccosec':(39,40),
                    'dnupla':(41,44),
                    'dnubat':(46,47),
                    'desc':(48,49),
                    'dniv':(50,51),
                    'dpor':(52,56),
                    'ccoriv':(57,60),
                    'ccovoi':(62,66),
                    'dnvoiri':(67,70),
                    'dindic':(71,71),
                    'ccocif':(72,75),
                    'dvoilib':(76,105),
                    'cleinvar':(106,106),
                    'pci_parcelle':(-1,-14)
                    })
            elif cenr=='10':
                self.val.update({
                    'gpdl':(36,36),
                    'dsrpar':(37,37),
                    'dnupro':(38,43),
                    'jdatat':(44,51),
                    'dnufnl':(52,57),
                    'ccoeva':(58,58),
                    'dteloc':(60,60),
                    'gtauom':(61,62),
                    'tcomrd':(63,65),
                    'ccoplc':(66,66),
                    'cconlnc':(67,68),
                    'dvltrt':(69,77),
                    'cc48lc':(82,83),
                    'dloy48a':(84,92),
                    'top48a':(93,93),
                    'dnatlc':(94,94),
                    'cchpr':(108,108),
                    'jannat':(109,112),
                    'dnbniv':(113,114),
                    'hlmsem':(115,115),
                    'postel':(116,116),
                    'dnatcg':(117,118),
                    'jdatcgl':(119,126),
                    'fburx':(148,148),
                    'gimtom':(149,149),
                    'cbtabt':(150,151),
                    'jdbabt':(152,155),
                    'jrtabt':(156,159),
                    'cconac':(169,173),
                    'toprev':(174,174),
                    'ccoifp':(175,177)})
            elif cenr=='21':
                self.val.update({
                    'ccoaff':(36,36),
                    'ccostb':(37,37),
                    'dcapec':(38,39),
                    'dcetlc':(40,42),
                    'ccocac':(46,49),
                    'dnutrf':(50,51),
                    'dcfloc':(52,54),
                    'dsupot':(55,60),
                    'dvlper':(61,69),
                    'dvlpera':(70,78),
                    'gnexpl':(79,80),
                    'ccthp':(111,111),
                    'retimp':(112,112),
                    'dnuref':(113,115),
                    'gnidom':(116,116),
                    'dvltpe':(130,138),
                    'tpevtieom':(144,144),
                    'ccortar':(145,147),
                    'ccorvl':(148,149),
                    'dtaurv':(150,152),
                    'dcmloc':(153,155),
                    'dcsplc_a':(156,160),
                    'dcsglc_a':(161,165),
                    'dcralc_a':(166,170)
                })
            elif cenr=='40':
                self.val.update({
                    'dnudes':(33,35),
                    'aelihp':(36,75),
                    'cconad1':(36,37),
                    'dsueic1':(38,43),
                    'dcimei1':(44,45),
                    'cconad2':(46,47),
                    'dsueic2':(48,53),
                    'dcimei2':(54,55),
                    'cconad3':(56,57),
                    'dsueic3':(58,63),
                    'dcimei3':(64,65),
                    'cconad4':(66,67),
                    'dsueic4':(68,73),
                    'dcimei4':(74,75),
                    'geaulc':(76,76),
                    'gelelc':(77,77),
                    'gesclc':(78,78),
                    'ggazlc':(79,79),
                    'gasclc':(80,80),
                    'gchclc':(81,81),
                    'gvorlc':(82,82),
                    'gteglc':(83,83),
                    'dnbbai':(84,85),
                    'dnbdou':(86,87),
                    'dnblav':(88,89),
                    'dnbwc':(90,91),
                    'deqdha':(92,94),
                    'dnbppr':(95,96),
                    'dnbsam':(97,98),
                    'dnbcha':(99,100),
                    'dnbcu8':(101,102),
                    'dnbcu9':(103,104),
                    'dnbsea':(105,106),
                    'dnbann':(107,108),
                    'dnbpdc':(109,110),
                    'dsupdc':(111,116),
                    'dmatgm':(117,118),
                    'dmatto':(119,120),
                    'jannat':(121,124),
                    'detent':(125,125),
                    'dnbniv':(126,127)
                })
            elif cenr=='50':
                self.val.update({
                    'dnudes':(33,35),
                    'dsupot':(36,44),
                    'dsup1':(45,53),
                    'dsup2':(54,62),
                    'dsup3':(63,71),
                    'dsupk1':(72,80),
                    'dsupk2':(81,89)
                })
            elif cenr=='60':
                self.val.update({
                    'dnudes':(33,35),
                    'dsudep':(36,41),
                    'cconad':(42,43),
                    'asitet':(44,49),
                    'dmatgm':(50,51),
                    'dmatto':(52,53),
                    'detent':(54,54),
                    'geaulc':(55,55),
                    'gelelc':(56,56),
                    'gchclc':(57,57),
                    'dnbbai':(58,59),
                    'dnbdou':(60,61),
                    'dnblav':(62,63),
                    'dnbwc':(64,65),
                    'deqtlc':(66,68),
                    'dcimlc':(69,70),
                    'dcetde':(71,73),
                    'dcspde_a':(77,81)
                })               
        elif file=='pnb':
            self.val={
                'pci_parcelle':(-1,-14),
                'ccodep':(1,2),
                'ccodir':(3,3),
                'ccocom':(4,6),
                'ccopre':(7,9), 
                'ccosec':(10,11),
                'dnupla': (12,15),
                'cenr':(20,21)
                }
            if cenr=='10':
                self.val.update({
                'dcntpa':(22,30),
                'dsrpar':(31,31),
                'dnupro':(32,37),
                'jdatat':(38,45),
                'dreflf':(46,50),
                'gpdl':(51,51),
                'cprsecr':(52,54),
                'ccosecr':(55,56),
                'dnuplar':(57,60),
                'dnupdl':(61,63),
                'gurbpa':(64,64),
                'dparpi':(65,68),
                'ccoarp':(69,69),
                'gparnf':(70,70),
                'gparbat':(71,71),
                'dnuvoi':(86,89),
                'dindic':(90,90),
                'ccovoi':(91,95),
                'ccoriv':(96,99),
                'ccocif':(100,103),
                'cconvo':(136,139),
                'dvoilib':(140,165),
                'ccocomm':(166,168),
                'ccoprem':(169,171),
                'ccosecm':(172,173),
                'dnuplam':(174,177),
                'type':(178,178),
                'ccoifp':(179,181)
                })
            elif cenr=='21':
                self.val.update({
                'ccosub':(16,17),
                'dcntsf':(22,30),
                'dnupro':(31,36),
                'gnexps':(37,38),
                'drcsub':(39,49),
                'drcsuba':(49,58),
                'ccostn':(59,59),
                'cgrnum':(60,61),
                'dsgrpf':(62,63),
                'dclssf':(64,65),
                'cnatsp':(66,70),
                'drgpos':(71,71),
                'ccoprel':(72,74),
                'ccosecl':(75,76),
                'dnuplal':(77,80),
                'dnupdl':(81,83),
                'dnulot':(84,90),
                'gnidom':(137,137),
                'topja':(138,138),
                'datja':(139,146),
                'postel':(147,147),
                'ccortar':(148,150)
                })
            elif cenr=='30':
                self.val.update({
                'ccosub':(16,17),
                'rnuexn':(18,19),
                'vecexn':(22,31),
                'ccolloc':(32,33),
                'pexn':(34,38),
                'gnexts':(39,40),
                'jandeb':(41,44),
                'jfinex':(45,48),
                'rcexnba':(79,88)
                })
        elif file=='pdl':
            self.val={
                'pci_parcelle':(-1,-14),
                'ccodep':(1,2),
                'ccodir':(3,3),
                'ccocom':(4,6),
                'ccopre':(7,9), 
                'ccosec':(10,11),
                'dnupla': (12,15),
                'dnupdl': (16,18),
                'cenr':(26,27),
                'ccocif':(94,97)
            }
            if cenr=='10':
                self.val.update({
                    'dnivim':(28,28),
                    'ctpdl':(29,31),
                    'dnompdl':(32,61),
                    'dmrpdl':(62,81),
                    'gprmut':(82,82),
                    'dnupro':(83,88)
                })
            elif cenr=='20':
                self.val.update({
                    'ccoprea':(28,30),
                    'ccoseca':(31,32),
                    'dnuplaa':(33,36)
                })
            elif cenr=='30':
                self.val.update({
                    'dnulot':(19,25),
                    'cconlo':(28,28),
                    'dcntlo':(29,37),
                    'dnumql':(38,44),
                    'ddenql':(45,51),
                    'dfilot':(52,71),
                    'datact':(72,79),
                    'dnuprol':(83,88),
                    'dreflf':(89,93)
                })
        elif file=='prop':
            self.val={
                'ccodep':(1,2),
                'ccodir':(3,3),
                'ccocom':(4,6),
                'dnupro':(7,12),
                'dnulp':(13,14),
                'ccocif':(15,18),
                'dnuper':(19,24),
                'ccodro':(25,25),
                'ccodem':(26,26),
                'gdesip':(27,27),
                'gtoper':(28,28),
                'ccoqua':(29,29),
                'dnatpr':(35,37),
                'ccogrm':(38,39),
                'dsglpm':(40,49),
                'dforme':(50,53),
                'ddenom':(57,116),
                'gtyp3':(117,117),
                'gtyp4':(118,118),
                'gtyp5':(119,119),
                'gtyp6':(120,120),
                'dlign3':(121,150),
                'dlign4':(151,186),
                'dlign5':(187,216),
                'dlign6':(217,248),
                'ccopay':(249,251),
                'ccodep1a2':(252,253),
                'ccodira':(254,254),
                'ccocomadr':(255,257),
                'ccovoi':(258,262),
                'ccoriv':(263,266),
                'dnvoiri':(267,270),
                'dindic':(271,271),
                'ccopos':(272,276),
                'dqualp':(287,289),
                'dnomlap':(290,319),
                'dprnlp':(320,334),
                'jdatnss':(335,344),
                'dldnss':(345,402),
                'dsiren':(467,475),
                'topja':(478,478),
                'datja':(479,486),
                'dformjur':(534,357),
                'dnomus':(538,597),
                'dprnus':(598,637)
                }
        elif file=='lloc':
            self.val={
            'ccodepl':(1,2),
            'ccodirl':(3,3),
            'ccocoml':(4,6),
            'ccoprel':(7,9), 
            'ccosecl':(10,11),
            'dnuplal': (12,15),
            'dnupdl':(16,18),
            'dnulot':(19,25),
            'cenr':(26,27),
            'ccodepb':(28,29),
            'ccodirb':(30,30),
            'ccocomb':(31,33),
            'ccopreb':(34,36),
            'invloc':(37,46),
            'dnumql':(47,53),
            'ddenql':(54,60)
            }
        elif file=='fantoir':
            self.val={
            'ccodep':(1,2),
            'ccodir':(3,3),
            'ccocom':(4,6),
            'clerivoli':(11,11),
            'natvoie':(12,15),
            'nlibvoie':(16,41),
            'typcom':(43,43),
            'ruractuel':(46,46),
            'carvoi':(49,49),
            'popindic':(50,50),
            'popapart':(60,66),
            'popfict':(67,73),
            'carannu':(74,74),
            'datannu':(75,81),
            'datcrea':(82,88),
            'ccovoi':(104,108),
            'typvoi':(109,109),
            'lieubati':(110,110),
            'motclassant':(113,120)
            }
    def fields(self):
        out=QgsFields()
        for k, v in self.val.items():
            length=abs(v[1]-v[0] )+1
            out.append(QgsField(k,QVariant.String,'varchar',length))
        return out
