# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Majic
                                 A QGIS plugin
 Load MAJIC files into QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-06-26
        copyright            : (C) 2018 by JB Desbas
        email                : jb.desbas@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'JB Desbas'
__date__ = '2018-06-26'
__copyright__ = '(C) 2018 by JB Desbas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFile,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsFields,
                       QgsField,
                       QgsFeature)
from ..majic_dict import MajicDict
from ..majic_lineparser import majicLineParser
import processing, os


class loadMajic(QgsProcessingAlgorithm):
    INPUT = 'INPUT'
    def guess_files(self,lst):
        #table_majic=['bati','fantoir','lloc','nbat','pdl','prop']
        out={'bati':[],'fantoir':[],'lloc':[],'nbat':[],'pdl':[],'prop':[]}
        for e in lst:
           for t in self.table_majic:
                if t.lower() in e.lower():
                    out[t].append(e)
                else:
                    continue
        return out
    
    def initAlgorithm(self, config):
        self.tableList=['pb00','pb10','pb21','pb30','pb36','pb40','pb50','pb60','pnb10','pnb21','pnb30',
                        'pnb36','pdl10','pdl20','pdl30','prop','lloc','fantoir']
        self.table_majic=['bati','fantoir','lloc','nbat','pdl','prop']
        self.addParameter(QgsProcessingParameterFile(self.INPUT,self.tr('Majic Files'),QgsProcessingParameterFile.Folder))
        for e in self.tableList:
            self.addParameter(QgsProcessingParameterFeatureSink(e, self.tr(e)))


    def processAlgorithm(self, parameters, context, feedback):
        folder = self.parameterAsFile(parameters,self.INPUT,context)
        sinks={}
        dest_ids={}
        for e in self.tableList:
            f , cenr = e , ''
            if(e[-2:].isdigit()):
                f , cenr = e[0:len(e)-2] , e[-2:]
            (sinks[e],dest_ids[e]) = self.parameterAsSink(parameters,e, context, MajicDict(f,cenr).fields())
        iProgress=1
        lst_files=[]
        for root,dir,files in os.walk(folder):
            for f in files:
                lst_files.append(os.path.join(root,f))
        
        inFiles=self.guess_files( lst_files)
        
        feedback.setProgressText('pb (1/6)')
        for file in inFiles['bati']:
            with open(file,'r') as f:
                for i,l in enumerate(f):
                    if i<2 : #skip first two line
                        continue
                    line=majicLineParser(l,'pb')
                    feat=line.feature()
                    sinks['pb'+feat.attribute('cenr')].addFeature(feat)
        feedback.setProgress((100/(len(self.table_majic))*iProgress))
        iProgress+=1

        feedback.setProgressText('pnb (2/6)')
        for file in inFiles['nbat']:
            with open(file,'r') as f:
                for i,l in enumerate(f):
                    if feedback.isCanceled():
                        break
                    if i<2 : #skip first two line
                        continue
                    line=majicLineParser(l,'pnb')
                    feat=line.feature()
                    sinks['pnb'+feat.attribute('cenr')].addFeature(feat)
        feedback.setProgress((100/(len(self.table_majic))*iProgress))
        iProgress+=1
        
        feedback.setProgressText('pdl (3/6)')
        for file in inFiles['pdl']:
            with open(file,'r') as f:
                for i,l in enumerate(f):
                    if feedback.isCanceled():
                        break
                    if i<2 : #skip first two line
                        continue
                    line=majicLineParser(l,'pdl')
                    feat=line.feature()
                    sinks['pdl'+feat.attribute('cenr')].addFeature(feat)
        feedback.setProgress((100/(len(self.table_majic))*iProgress))
        iProgress+=1
        
        feedback.setProgressText('prop (4/6)')
        for file in inFiles['prop']:
            with open(file,'r') as f:
                for i,l in enumerate(f):
                    if feedback.isCanceled():
                        break
                    if i<2 : #skip first two line
                        continue
                    line=majicLineParser(l,'prop')
                    feat=line.feature()
                    sinks['prop'].addFeature(feat)
        feedback.setProgress((100/(len(self.table_majic))*iProgress))
        iProgress+=1
        
        feedback.setProgressText('lloc (5/6)')
        for file in inFiles['lloc']:
            with open(file,'r') as f:
                for i,l in enumerate(f):
                    if feedback.isCanceled():
                        break
                    if i<2 : #skip first two line
                        continue
                    line=majicLineParser(l,'lloc')
                    feat=line.feature()
                    sinks['lloc'].addFeature(feat)
        feedback.setProgress((100/(len(self.table_majic))*iProgress))
        iProgress+=1
        
        feedback.setProgressText('fantoir (6/6)')        
        for file in inFiles['fantoir']:
            with open(file,'r') as f:
                for i,l in enumerate(f):
                    if feedback.isCanceled():
                        break
                    if i<2 : #skip first two line
                        continue
                    line=majicLineParser(l,'fantoir')
                    feat=line.feature()
                    sinks['fantoir'].addFeature(feat)
        feedback.setProgress((100/(len(self.table_majic))*iProgress))
        iProgress+=1
                    
        return dest_ids

    def name(self):
        return 'loadmajicfiles'

    def displayName(self):
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return 'majic'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return loadMajic()
