import os, json, traceback
from PyQt4.QtGui import QMessageBox

class SettingsInterface(object):
    pathOptions = os.path.dirname(os.path.abspath(__file__))+os.path.sep+"settings.json"

    def __init__(self):
        pass

    def loadSettings(self, otherPath=None):
        """
            Metodo tramite il quale vengono caricate le impostazioni da recuperare
            ad una nuova esecuzione del plugin.
            Esse sono memorizzate nel file di configurazione, in formato json
        """
        settings = {}
        if otherPath == None:
            otherPath = self.pathOptions
        try:
            with open(otherPath, "r") as f:
                settings = json.load(f)
        except:
            tb = traceback.format_exc()
            QMessageBox.information(None, "Attenzione",
                                    "Caricamento delle impostazioni di configurazione non riuscito.\n" + str(tb))
        finally:
            return settings

    def writeSettings(self, settings, otherPath=None):
        """
            Metodo tramite il quale vengono scritte le impostazioni nel file di configurazione
            qualora ci sia qualcosa di nuovo da memorizzare.
            Esse vengono salvate nel file di configurazione, in formato json
        """
        if otherPath == None:
            otherPath = self.pathOptions
        try:
            with open(otherPath, "w") as f:
                json.dump(settings, f)
        except:
            tb = traceback.format_exc()
            QMessageBox.information(None, "Attenzione", "Salvataggio delle nuove impostazioni non riuscito\n" + str(tb))