# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import resources_rc
from qgis.core import *
import json,traceback, os, importlib, imp
from mapTools.Vectorize2Tool import Vectorize2Tool
from dialogs.SettingsDialog import SettingsDialog

class MagicWand(QObject):
    def __init__(self, iface):
        # save reference to the QGIS interface
        QObject.__init__(self)
        self.iface = iface
        self.legend = iface.legendInterface()
        self.canvas = iface.mapCanvas()
        self.vectorizeTool = None


    def initGui(self):
        self.tlbVectorizeTools = self.iface.addToolBar("MagicWand")
        self.dialogSettings = SettingsDialog(self.iface.mainWindow())
        self.dialogSettings.settingsChanged.connect(self.setChanged)

        self.labelColor = QLabel("     ")
        self.setLabelColor((255,255,255))
        self.tlbVectorizeTools.addWidget(self.labelColor)

        self.vectorizeAct = QAction("&Vectorize", self.iface.mainWindow())
        self.vectorizeAct.setIcon(QIcon(":/VectorizeTools/icons/magic_wand.png"))
        self.vectorizeAct.setEnabled(True)
        self.vectorizeAct.setCheckable(True)

        self.settingsAct = QAction("&Settings", self.iface.mainWindow())
        self.settingsAct.setIcon(QIcon(":/VectorizeTools/icons/settings.png"))
        self.settingsAct.setEnabled(True)
        self.settingsAct.activated.connect(self.dialogSettings.show)

        self.iface.addPluginToMenu("VectorizeTools", self.vectorizeAct)
        self.tlbVectorizeTools.addAction(self.vectorizeAct)
        self.iface.addPluginToMenu("VectorizeTools", self.settingsAct)
        self.tlbVectorizeTools.addAction(self.settingsAct)

        self.createMapTools()


    def setChanged(self, settings):
        self.vectorizeTool.reset()
        self.vectorizeTool.setTolerance(settings["tolerance"])
        self.vectorizeTool.setTimeout(settings["timeout"])
        self.vectorizeTool.setApproximation(settings["approximation"])
        self.vectorizeTool.setViewSteps(settings["viewSteps"])


    def setFunction(self, index):
        if index != 0:
            nomeFunc = self.comboFunctions.currentText()
            self.vectorizeTool.function = getattr(self.vectorizeTool, nomeFunc)

    def createMapTools(self):

        if self.vectorizeTool:
            self.vectorizeTool.reset()

        self.vectorizeTool = Vectorize2Tool(
                 self.canvas,
                 self.iface,
                )
        self.vectorizeTool.setAction(self.vectorizeAct)
        self.vectorizeTool.pixelOver.connect(self.setLabelColor)
        self.vectorizeAct.triggered.connect(self.triggerMapTool)

    def triggerMapTool(self, activated):
        if activated: self.canvas.setMapTool(self.vectorizeTool)
        else: self.canvas.unsetMapTool(self.vectorizeTool)

    def unload(self):
        self.iface.removePluginMenu("MagicWand", self.vectorizeAct)
        self.iface.removePluginMenu("MagicWand", self.settingsAct)

    def setLabelColor(self, color):
        r,g,b = color
        self.labelColor.setStyleSheet("QLabel { background-color : rgb("+str(r)+","+str(g)+","+str(b)+"); border: 1px solid black; }")