
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from MagicWand.config.SettingsInterface import SettingsInterface

class SettingsDialog(QDialog):
    def __init__(self, mainWindow):
        QDialog.__init__(self, mainWindow)
        self.setInt = SettingsInterface()

        self.setObjectName("dlgSettings")
        self.setWindowModality(Qt.ApplicationModal)
        self.setWindowTitle("Settings")
        # self.dlgGetDesc.resize(100, 100)

        self.lblTolerance = QLabel("Tolerance: ")
        self.lblTolerance.setAlignment(Qt.AlignLeft)

        self.spineTolerance = QSpinBox()
        self.spineTolerance.setRange(1, 100)

        self.lblApproximation = QLabel("Approximation: ")
        self.lblApproximation.setAlignment(Qt.AlignLeft)

        self.spineApproximation = QSpinBox()
        self.spineApproximation.setRange(1, 100)

        self.lblTimeout = QLabel("Timeout (sec): ")
        self.lblTimeout.setAlignment(Qt.AlignLeft)

        self.spineTimeout = QSpinBox()
        self.spineTimeout.setRange(1, 100)

        self.checkViewProcess = QCheckBox("Visualizza steps")

        self.btnRestore = QPushButton("Restore default")
        #self.btnRestore.setAlignment(Qt.AlignRight)
        self.btnRestore.clicked.connect(self.restoreSettings)

        self.btnSave = QPushButton("Save")
        #self.btnSave.setAlignment(Qt.AlignRight)
        self.btnSave.clicked.connect(self.saveSettings)

        self.hbox1 = QHBoxLayout()
        self.hbox1.addWidget(self.lblTolerance)
        self.hbox1.addWidget(self.spineTolerance)

        self.hbox2 = QHBoxLayout()
        self.hbox2.addWidget(self.lblApproximation)
        self.hbox2.addWidget(self.spineApproximation)

        self.hbox3 = QHBoxLayout()
        self.hbox3.addWidget(self.lblTimeout)
        self.hbox3.addWidget(self.spineTimeout)

        self.hbox4 = QHBoxLayout()
        self.hbox4.addWidget(self.checkViewProcess)

        self.hbox5 = QHBoxLayout()
        self.hbox5.addWidget(self.btnRestore)
        self.hbox5.addWidget(self.btnSave)

        self.mainLayout = QVBoxLayout()

        self.mainLayout.addLayout(self.hbox1)
        self.mainLayout.addLayout(self.hbox2)
        self.mainLayout.addLayout(self.hbox3)
        self.mainLayout.addLayout(self.hbox4)
        self.mainLayout.addLayout(self.hbox5)

        self.setLayout(self.mainLayout)



        self.spineTolerance.valueChanged.connect(self.setTolerance)
        self.spineTimeout.valueChanged.connect(self.setTimeout)
        self.spineApproximation.valueChanged.connect(self.setApproximation)
        self.checkViewProcess.stateChanged.connect(self.viewStepsStateChanged)


    def show(self):
        self.settings = self.setInt.loadSettings()
        self.spineTolerance.setValue(self.settings["tolerance"])
        self.spineTimeout.setValue(self.settings["timeout"])
        self.spineApproximation.setValue(self.settings["approximation"])
        self.checkViewProcess.setChecked(self.settings["viewSteps"])
        QDialog.show(self)

    def viewStepsStateChanged(self):
        isChecked = self.checkViewProcess.isChecked()
        self.settings["viewSteps"] = isChecked

    def setTolerance(self, value):
        self.settings["tolerance"] = value

    def setTimeout(self, value):
        self.settings["timeout"] = value

    def setApproximation(self, value):
        self.settings["approximation"] = value

    def saveSettings(self):
        self.setInt.writeSettings(self.settings)
        self.settingsChanged.emit(self.settings)
        self.close()

    def restoreSettings(self):
        self.spineTolerance.setValue(self.settings["default_tolerance"])
        self.spineTimeout.setValue(self.settings["default_timeout"])
        self.spineApproximation.setValue(self.settings["default_approximation"])
        self.checkViewProcess.setChecked(self.settings["default_viewSteps"])
        self.settingsChanged.emit(self.settings)
        self.setInt.writeSettings(self.settings)

    settingsChanged = pyqtSignal(object)