# -*- coding: utf-8 -*-
"""
/***************************************************************************

Definition of the web-service object
All the properties required to call a web-service
"""

import urllib2
from xml.etree import ElementTree as ET

class WebServiceParams:
	
    def __init__(self, name, nameES,nameEn,sourceES,sourceEN,creationDate,
                 lastUpdate,descEN,descES,serviceType, layerName,server,QLname, uuid):
		self.name = name
		self.nameES = nameES
		self.nameEn = nameEn
		self.creationDate = creationDate
		self.lastUpdate = lastUpdate
		self.sourceES = sourceES
		self.sourceEN = sourceEN
		self.descES = descES
		self.descEN = descEN
		self.serviceType = serviceType
		self.layerName = layerName
		self.server = server
		self.QLname = QLname
		self.uuid = uuid # geonetwork uuid
		self.desc = ""

    def getName(self, language):
        # check the language
        if language == "EN":
            name = self.nameEn
        elif language == "ES":
            name = self.nameES
        # encode to utf-8
        #name = unicode(name, 'utf-8')
        return name        

    def getSource(self, language):
        # check the language
        if language == "EN":
            src = self.sourceEN
        elif language == "ES":
            src = self.sourceES
        # encode to utf-8
        #src = unicode(src, 'utf-8')
        return src
        

    def loadOnlineData(self, language):
        # check the language
        if not self.desc:
	        if language == "EN":
	            self.desc = self.descEN            
	        elif language == "ES":
	            self.desc = self.descES

            # if uuid defined search info in metadata server
	        if not self.desc and self.uuid:
				file = urllib2.urlopen('http://geoservicios.mtop.gub.uy/geonetwork/srv/es/iso19139.xml?uuid='+self.uuid)
				data = file.read()
				root = ET.fromstring(data)
				namespaces = {'gmd': 'http://www.isotc211.org/2005/gmd', 'gco' : 'http://www.isotc211.org/2005/gco'}
				self.desc = root.find('./gmd:identificationInfo/gmd:MD_DataIdentification/gmd:abstract/gco:CharacterString', namespaces).text
				self.creationDate = root.find('./gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:date/gmd:CI_Date/gmd:date/gco:DateTime', namespaces).text
				self.lastUpdate = root.find('./gmd:dateStamp/gco:DateTime', namespaces).text

		
	
    def webServiceParams(self):

        if self.serviceType == "WMS":
            ignoreRequests = "IgnoreGetFeatureInfoUrl=1&IgnoreGetMapUrl=1&"

            layers = "&layers="+self.layerName[1]
            styles = "&styles="
            url = "&url=" + self.server + "/" + self.layerName[0] +"/wms?"
            EPSG = "EPSG:4326"
            params = "version=1.1.1&contextualWMSLegend=0&crs=" + EPSG +"&dpiMode=7&featureCount=10&format=image/png"

            #construct url to call the webService
            urlWithParams = ignoreRequests + params + layers +  styles +  url
            return  urlWithParams
        
        elif self.serviceType == "WFS":
            url = self.server + "/ows?"
            getFeatureRequest = "SERVICE=WFS&VERSION=1.0.0&REQUEST=GetFeature"
            layer = "&TYPENAME=" + self.layerName[0] + ":" + self.layerName[1]
            EPSG = "&SRSNAME=EPSG:4326"

            urlWithParams = url + getFeatureRequest + layer + EPSG
            return  urlWithParams

        
        
