# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MISLANDAFRICA
                                 A QGIS plugin
 Land Degradation Monitoring PRogram
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-10-04
        copyright            : (C) 2024 by LocateIT
        email                : info@locateit.co.ke
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""
import os
import sys
import site
from qgis.PyQt import QtCore
from tempfile import NamedTemporaryFile
from qgis.core import QgsMessageLog
from qgis.utils import iface

debug = QtCore.QSettings().value('MISLANDAFRICA/debug', True)
# log the details
def log(message, level=0):
    if debug:
        QgsMessageLog.logMessage(message, tag="MISLANDAFRICA", level=level)
        
# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load MISLANDAFRICA class from file MISLANDAFRICA.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .plugin import MISLANDAFRICA
    return MISLANDAFRICA(iface)

def GetTempFilename(suffix):
    f = NamedTemporaryFile(suffix=suffix, delete=False)
    f.close()
    return f.name