# Local Software QGIS Plugin
**Local Software** connects two previously separate ways of looking at the world digitally; Geographic Information Systems (GIS) and Computer-Aided Design (CAD). Local Software systematically connects what we know about the world to what we make in it.

This Local Software QGIS Plugin imports, exports, or makes a set of geoJSON site packages with QGIS. Site packages can be imported into Rhino with Grasshopper [Local Software components](https://beta.uselocalco.de/download).

## Features
Local Software is a set of software packages to connect GIS and CAD software seamlessly. The software is based on the work that the authors did for the [Local Code project](https://books.google.com.mx/books/about/Local_Code.html?id=-KQNrgEACAAJ&source=kp_book_description&redir_esc=y). 
1. Create geoJSON site packages that combine several geospatial layers into a single geoJSON package that can be imported into parametric CAD software.
2. Import geoJSON site packages that have been created in QGIS or in CAD software.
3. Append and export new layers to existing geoJSON site packages. 

## Installing
"Stable" releases are available through the official QGIS plugins repository.

1. In QGIS 3 select `Plugins->Manage` and `Install Plugins`.
2. On the sidebar go to `Settings` and check the `Show also experimental plugins` checkbox
3. Now, go to `All` in the sidebar and search for `Local Software`. Select the plugin and click `Install Plugin`

## Documentation
* How do I use Local Software for Grasshopper? Check out [these](https://beta.uselocalco.de/documentation) tutorials.
* How do I use the QGIS plugin? Check out [this](https://canvas.mit.edu/courses/14233) course that we taugh at MIT. Download the QGIS plugin [here](https://plugins.qgis.org/plugins/LocalSoftware-QGIS/).
* How do I create site packages without QGIS? Check out the Local Software [web application](https://beta.uselocalco.de/).
* How do I install the Rhino Grasshopper plugin? Check out [this](https://www.food4rhino.com/en/app/local-software) page.
