# Linkscape QGIS Plugin v1.7.1

**Ecological Corridor Optimization for Habitat Connectivity**

Linkscape is a QGIS plugin that identifies and optimizes ecological corridors to connect fragmented habitat patches. It uses graph-based algorithms to help conservation planners maximize landscape connectivity under realistic spatial and budget constraints.  

![Example corridors](example-optimized-corridor-locations.png)  
Image: Corridors generated (pink) to strategically connect the maximum landscape area (green) while avoiding impassable land type (orange).  

---

## What’s New in v1.7.1

- **Refreshed dialog UX**: `Parameters | Log` tabs, fixed-size dialog with scrolling parameters, and a Help button that opens a side panel rendered from `linkscape_help.md`.
- **Cleaner runs**: no automatic debug/timing popups or extra report files after completion.
- **Raster summary in-project**: raster runs add a lightweight “Linkscape Raster Summary …” table layer to the project.
- **Vector redundancy (when budget allows)**: the optimizer can add a second, spatially-distinct corridor between the same two patches instead of spreading budget across many long links.
- **Redundancy sanity rules**: redundant candidates are constrained to *facing edges* and reject corridors that “reach through” a patch to the opposite side.
- **Terminology update**: “Obstacles” are now labeled as **Impassable Land Classes** throughout the UI and docs.

## What’s New in v1.6 (since v1.5)

v1.6 focuses on making the v1.5 features more robust, observable, and easier to use in real corridor design workflows.

**1. HDFM optimization (vector)**  

- HDFM is now the supported optimization family for vector runs.  
- Prioritizes corridors that expand connected habitat while respecting budget constraints.

**2. Improved raster corridor width and bottleneck handling**  

- Minimum corridor width is now enforced with a circular offset kernel, so corridors are inflated to roughly the requested width rather than a single-pixel line.  
- Bottleneck rules are applied against true **Impassable Land Classes** only, keeping it possible for corridors to touch habitat edges while blocking unrealistically narrow gaps.

**3. Stepping-stone controls and diagnostics surfaced in the UI**  

- Raster and vector modes both expose a Stepping option with a configurable hop distance.  
- (Updated in v1.7.1) Run outcomes are summarized in the **Log** tab; raster additionally adds a small in-project summary table layer.

**4. Embedded help panel**

- The dialog includes a Help button that opens a side panel populated from `linkscape_help.md`.

**5. Safer and more informative outputs**

- (Updated in v1.7.1) Linkscape focuses on adding output layers to your project; it does not auto-open additional text reports on completion.
- Vector mode validation warns if the input layer has only a single feature, which avoids accidental single-patch runs that cannot produce corridors.  

---

## Table of Contents

1. [Overview](#overview)  
2. [Installation and Access](#installation-and-access)  
3. [Quick Start Guide](#quick-start-guide)  
4. [Raster Workflow](#raster-workflow)  
5. [Vector Workflow](#vector-workflow)  
6. [Optimization Strategies](#optimization-strategies)  
7. [Outputs](#outputs)  
8. [Tips and Best Practices](#tips-and-best-practices)  
9. [Troubleshooting](#troubleshooting)  
10. [Credits](#credits)  

---

## Overview

### What Linkscape Does

Linkscape analyzes habitat patches (either raster cells or vector polygons) and identifies corridors that connect them based on:  

- Available budget in pixels or area units  
- Spatial constraints like maximum search distance and minimum corridor width  
- Optimization mode (Most Connectivity vs Largest Network)  

The plugin supports both raster and vector workflows so you can work directly with land cover grids or polygon habitat maps.

### Key Features

- **Dual workflows**  
  - Raster mode for land cover or habitat grids  
  - Vector mode for polygon patch layers (one feature per patch)  

- **Flexible patch definition (raster)**  
  - Define habitat patches by one or more pixel values or value ranges  
  - Filter out tiny patches below a minimum size before corridor planning  

- **Optimization modes**  
  - Most Connectivity  
  - Largest Network  

- **Impassable Land Classes**  
  - Raster: treat one or more values or ranges as impassable land classes and control whether corridors can squeeze through narrow gaps.  
  - Vector: optionally build a raster grid over one or more impassable polygon layers for pathfinding around barriers (roads, rivers, urban footprints).  

- **Budget-constrained analysis**  
  - Limit total corridor construction cost in pixels (raster) or hectares/acres (vector).  

- **Unit flexibility (vector)**  
  - Choose metric or imperial units for corridor width, distances, and budgets.  

- **Automatic CRS handling (vector)**  
  - Geographic layers are reprojected to an appropriate UTM CRS internally so distances and areas are measured in consistent units.  

---

## Installation and Access

### Prerequisites

- QGIS 3.22 or newer (Linkscape is developed against QGIS 3.x).  
- Standard QGIS Python stack: `numpy`, GDAL/OSGEO, and PyQt5.  

### Installing from a ZIP

1. Download the Linkscape plugin zip from the repository releases page.  
2. In QGIS, go to `Plugins` → `Manage and Install Plugins`.  
3. Choose `Install from ZIP`, browse to the Linkscape zip, and install.  
4. Enable Linkscape in the plugin manager if it is not already enabled.  

Once installed, you will see **Run Linkscape** in the toolbar and in the `Linkscape (SORUS)` menu.  
You can also launch it from the Processing Toolbox under `SORUS → Linkscape Corridor Generation`.

---

## Quick Start Guide

1. **Prepare your data**  
   - Raster mode: add a land cover or habitat raster with integer values that distinguish habitat from non-habitat.  
   - Vector mode: add a polygon layer where each feature is a separate habitat patch.

2. **Launch Linkscape**  
   - Click **Run Linkscape** on the toolbar or from `Linkscape (SORUS)` in the menu.  

3. **Choose mode and layer**  
   - Select the input layer in the combo box.  
   - Pick `Raster` or `Vector` in the layer type selector if the plugin does not infer it correctly.  

4. **Pick an optimization mode**  
   - Use Most Connectivity to maximize total connected habitat area.  
   - Use Largest Network to prioritize one dominant connected network.

5. **Set basic parameters**  
   - Minimum patch size (filters tiny patches out of the habitat pool).  
   - Minimum corridor width.  
   - Budget and maximum search distance.  

6. **Set impassable land classes and stepping (optional but recommended)**  
   - Raster: choose impassable values or ranges, decide if corridors may pass through small gaps, and optionally ignore small sub-min patches as “stepping” habitat.  
   - Vector: enable impassable land classes, select one or more impassable layers, set grid resolution for the navigator, and enable stepping with a hop distance.  

7. **Run and review**  
   - Click **Run**. Watch progress in the **Log** tab.  
   - Outputs are added to your QGIS project; raster runs also add a “Linkscape Raster Summary …” table layer.  
   - After a successful run, the Run button becomes **Close** to avoid accidental re-runs.  

---

## Raster Workflow

Raster mode is designed for land cover or habitat grids, where each cell can be classified as habitat, impassable, or background.

### Patch definition

- **Patch connectivity**: choose 4- or 8-neighbor connectivity when identifying contiguous patches.  
- **Patch values**: specify one or more values that represent habitat (for example 1 for forest, 2 for wetland). Linkscape requires at least one value.  
- **Minimum patch size**: patches smaller than this threshold (in pixels) are removed from the main patch set before corridor planning.  

### Impassable land classes and bottlenecks

- Enable impassable land classes and define one or more impassable values or ranges.  
- Linkscape builds an impassable mask and then a passable mask that:  
  - Treats impassable cells as fully blocked.  
  - Treats habitat cells as non-impassable so corridors can touch patch edges.  
  - Optionally erodes the available space with the corridor width kernel so corridors cannot use gaps narrower than the configured width, unless you allow bottlenecks.

### Corridor budget and search distance

- **Budget (pixels)**: total corridor pixels you are willing to “spend.”  
- **Maximum search distance**: hard cap on how far corridors can reach when searching for candidate links.

### Stepping-stone behavior

- Turn on Stepping to allow small sub-min patches to act as free stepping stones within a hop distance.  
- The raster engine will merge patches reachable under this hop distance into virtual components before running the main optimization, and will track how many patches were merged.

---

## Vector Workflow

Vector mode is designed for polygon patch datasets, where each feature is a separate patch.

### Input requirements

- One feature per patch. If the input layer has only one feature, Linkscape will warn and refuse to run, since a single patch cannot be connected to anything.  

### Units and basic parameters

- Select metric or imperial units in the dialog.  
- Set:
  - Minimum corridor width (meters or feet)  
  - Minimum patch size (hectares or acres)  
  - Budget area (same area units)  
  - Maximum search distance (meters or feet)  

### Impassable land classes and navigator grid

- Enable impassable land classes to route around non-habitat features such as roads, rivers, or urban areas.  
- Select one or more vector impassable layers and a grid resolution for the navigator. The engine builds a raster grid over the combined impassable geometry and uses it for pathfinding.  

### Stepping and hop distance

- Enable stepping and set a hop distance in the same units as corridor width and distances.  
- The vector engine can treat nearby patches as part of the same effective component using **Merge Distance (optional)**, and can optionally allow hop-based stepping during routing with a **Max Hop Distance**.

---

## Optimization Modes

Linkscape supports two optimization modes (implemented with HDFM internally):

### Most Connectivity

- Goal: maximize total connected habitat area across all patches under the budget.

### Largest Network

- Goal: prioritize building one dominant connected network under the budget.

---

## Outputs

For each run, Linkscape can produce:

### Raster mode outputs

- Corridor raster where pixel values indicate the size of the contiguous patch created by including that corridor cell.  
- Optional combined patches+corridors raster (when writing to disk).
- A small in-project summary table layer: `Linkscape Raster Summary (<input layer>)`.

### Vector mode outputs

- Corridor layer as a GeoPackage, with each corridor feature containing:  
  - Patch ids it connects  
  - Length and cost  
  - Connected area and strategy statistics  

### Run summaries

- The **Log** tab provides a concise run summary suitable for copy/paste into notes.
- Raster runs also add an in-project summary table layer.

---

## Tips and Best Practices

- Start with a small area and conservative budget to verify parameter settings before scaling up.  
- Keep patch definitions simple at first. For raster mode, start with a single habitat value and add ranges later.  
- Use stepping and bottleneck controls to adjust realism rather than trying to encode everything into the land cover itself.  
- Use the Log tab summary (and the raster summary table layer) to confirm budgets and connected area before iterating on parameters.

---

## Release Packaging (ZIP)

To build a QGIS-installable ZIP:

1. Ensure the plugin folder is named `Linkscape_v1_7`.
2. Zip the folder contents (the folder itself should be the top-level in the ZIP).
3. In QGIS: `Plugins → Manage and Install Plugins → Install from ZIP`.

---

## Troubleshooting

- **No corridors produced**  
  - Check that budget and max search distance are large enough.  
  - For vector mode, ensure there is more than one patch feature and that impassable land classes are not blocking all routes.

- **Corridors clip into impassable land classes**  
  - Increase minimum corridor width or tighten bottleneck rules in raster mode.  
  - For vector mode, verify that impassable layers are valid and that the navigator grid resolution is appropriate.

- **Runs are slow**  
  - Reduce extent or resample rasters to a coarser resolution.  
  - In vector mode, filter out very small patches with the minimum patch size setting.

---

## Credits

Linkscape was created by Ben Bishop (SORUS) as a practical tool for habitat connectivity and corridor planning.  

Bug reports and feature requests are welcome on the GitHub issue tracker listed in the plugin metadata.  
