# Linkscape at a Glance

- Pick your input layer of fragmented patches. This could be a raster LULC dataset or a vector set of polygon patches. 

- Set an output folder unless you intentionally want a temporary layer.

- If using raster data, tell Linkscape which value(s) you would like to define as patches.

- Set key criteria such as minimum patch size, optimization mode and your budget. 

- Linkscape uses **HDFM** optimization: **Most Connectivity** (maximize connected habitat area) and **Largest Network** (prioritize a single dominant network).

- Enable **Impassable Land Classes** when there are areas that corridors must avoid (roads, water, cities). Set values for this in raster, or select impassable polygon layers in vector mode. If you enable stepping, use **Merge Distance** to virtually merge nearby patches, and **Max Hop Distance** to allow limited “gap” hops across impassable areas / between impassable holes.

- Keep the search distance reasonable—oversized values slow things down.

- If performance is slow, resample very fine rasters or trim your AOI before running.

- The output data comes embedded with helpful info. Resulting raster cells have the value of the total area that they connect. Vector output has info on the corridors and connected patches in its attribute table. 

Need more help? Visit the README in this plugin folder for a deeper walkthrough.
