# Linkscape QGIS Plugin v1.6

**Ecological Corridor Optimization for Habitat Connectivity**

Linkscape is a QGIS plugin that identifies and optimizes ecological corridors to connect fragmented habitat patches. It uses graph-based algorithms to help conservation planners maximize landscape connectivity under realistic spatial and budget constraints.  

![Example corridors](example-optimized-corridor-locations.png)  
Image: Corridors generated (pink) to strategically connect the maximum landscape area (green) while avoiding impassable land type (orange).  

---

## What’s New in v1.6 (since v1.5)

v1.6 focuses on making the v1.5 features more robust, observable, and easier to use in real corridor design workflows.

**1. Stronger vector “Most Connectivity” optimization**  

- Corrects double-counting of already connected patches in the Most Connectivity strategy.  
- Allows redundant links when the budget allows, which can strengthen the overall network without breaking the optimization logic.  
- Detects and prioritizes corridors that pass through a new patch on the way between two patches, so “A → C → B” routes are valued correctly when C is not yet connected.

**2. Improved raster corridor width and bottleneck handling**  

- Minimum corridor width is now enforced with a circular offset kernel, so corridors are inflated to roughly the requested width rather than a single-pixel line.  
- Bottleneck rules are applied against true obstacles only, keeping it possible for corridors to touch habitat edges while blocking unrealistically narrow obstacle gaps.

**3. Stepping-stone controls and diagnostics surfaced in the UI**  

- Raster and vector modes both expose a Stepping option with a configurable hop distance.  
- Run summaries now include stepping statistics (patches merged, virtual components, hop distance) in the summary CSV.  
- The summary CSV is automatically added as a non-spatial table in the project so you can quickly compare runs.

**4. Embedded help panel**

- The main dialog now includes a help pane on the right, populated from `linkscape_help.md`, so practical guidance is visible inside QGIS while you configure parameters.  

**5. Safer and more informative outputs**

- Text summaries and CSV outputs are written with stable names (`ls_mostconn_summary`, `ls_largestpatch_summary`) and are logged in the QGIS message log.  
- Vector mode validation warns if the input layer has only a single feature, which avoids accidental single-patch runs that cannot produce corridors.  

---

## Table of Contents

1. [Overview](#overview)  
2. [Installation and Access](#installation-and-access)  
3. [Quick Start Guide](#quick-start-guide)  
4. [Raster Workflow](#raster-workflow)  
5. [Vector Workflow](#vector-workflow)  
6. [Optimization Strategies](#optimization-strategies)  
7. [Outputs](#outputs)  
8. [Tips and Best Practices](#tips-and-best-practices)  
9. [Troubleshooting](#troubleshooting)  
10. [Credits](#credits)  

---

## Overview

### What Linkscape Does

Linkscape analyzes habitat patches (either raster cells or vector polygons) and identifies corridors that connect them based on:  

- Available budget in pixels or area units  
- Spatial constraints like maximum search distance and minimum corridor width  
- Optimization strategy (build a highly connected network vs grow one dominant patch)  

The plugin supports both raster and vector workflows so you can work directly with land cover grids or polygon habitat maps.

### Key Features

- **Dual workflows**  
  - Raster mode for land cover or habitat grids  
  - Vector mode for polygon patch layers (one feature per patch)  

- **Flexible patch definition (raster)**  
  - Define habitat patches by one or more pixel values or value ranges  
  - Filter out tiny patches below a minimum size before corridor planning  

- **Optimization strategies**  
  - Most Connectivity (Resilient Network)  
  - Largest Patch (Single Dominant Patch)  

- **Obstacle-aware routing**  
  - Raster: treat one or more values or ranges as impassable obstacle cells and control whether corridors can squeeze through narrow gaps.  
  - Vector: optionally build a raster grid over one or more obstacle layers for pathfinding around barriers (roads, rivers, urban footprints).  

- **Budget-constrained analysis**  
  - Limit total corridor construction cost in pixels (raster) or hectares/acres (vector).  

- **Unit flexibility (vector)**  
  - Choose metric or imperial units for corridor width, distances, and budgets.  

- **Automatic CRS handling (vector)**  
  - Geographic layers are reprojected to an appropriate UTM CRS internally so distances and areas are measured in consistent units.  

---

## Installation and Access

### Prerequisites

- QGIS 3.22 or newer (Linkscape is developed against QGIS 3.x).  
- Standard QGIS Python stack: `numpy`, GDAL/OSGEO, and PyQt5.  

### Installing from a ZIP

1. Download the Linkscape plugin zip from the repository releases page.  
2. In QGIS, go to `Plugins` → `Manage and Install Plugins`.  
3. Choose `Install from ZIP`, browse to the Linkscape zip, and install.  
4. Enable Linkscape in the plugin manager if it is not already enabled.  

Once installed, you will see **Run Linkscape** in the toolbar and in the `Linkscape (SORUS)` menu.  

---

## Quick Start Guide

1. **Prepare your data**  
   - Raster mode: add a land cover or habitat raster with integer values that distinguish habitat from non-habitat.  
   - Vector mode: add a polygon layer where each feature is a separate habitat patch.

2. **Launch Linkscape**  
   - Click **Run Linkscape** on the toolbar or from `Linkscape (SORUS)` in the menu.  

3. **Choose mode and layer**  
   - Select the input layer in the combo box.  
   - Pick `Raster` or `Vector` in the layer type selector if the plugin does not infer it correctly.  

4. **Pick an optimization strategy**  
   - Use Most Connectivity to build a resilient network across many patches.  
   - Use Largest Patch to grow a single dominant connected patch.

5. **Set basic parameters**  
   - Minimum patch size (filters tiny patches out of the habitat pool).  
   - Minimum corridor width.  
   - Budget and maximum search distance.  

6. **Set obstacles and stepping (optional but recommended)**  
   - Raster: choose obstacle values or ranges, decide if corridors may pass through small gaps, and optionally ignore small sub-min patches as “stepping” habitat.  
   - Vector: toggle obstacles on, select one or more obstacle layers, set grid resolution for the navigator, and enable stepping with a hop distance.  

7. **Run and review**  
   - Click **Run**. Watch progress and messages in the QGIS message bar and log.  
   - Linkscape will write corridor layers, a text summary, and a summary CSV, then add the CSV as a table in your project.  

---

## Raster Workflow

Raster mode is designed for land cover or habitat grids, where each cell can be classified as habitat, obstacle, or background.

### Patch definition

- **Patch connectivity**: choose 4- or 8-neighbor connectivity when identifying contiguous patches.  
- **Patch values**: specify one or more values that represent habitat (for example 1 for forest, 2 for wetland). Linkscape requires at least one value.  
- **Minimum patch size**: patches smaller than this threshold (in pixels) are removed from the main patch set before corridor planning.  

### Obstacles and bottlenecks

- Enable obstacles and define one or more obstacle values or ranges.  
- Linkscape builds an obstacle mask and then a passable mask that:  
  - Treats obstacle cells as fully impassable.  
  - Treats habitat cells as non-obstacle so corridors can touch patch edges.  
  - Optionally erodes the available space with the corridor width kernel so corridors cannot use gaps narrower than the configured width, unless you allow bottlenecks.

### Corridor budget and search distance

- **Budget (pixels)**: total corridor pixels you are willing to “spend.”  
- **Maximum search distance**: hard cap on how far corridors can reach when searching for candidate links.

### Stepping-stone behavior

- Turn on Stepping to allow small sub-min patches to act as free stepping stones within a hop distance.  
- The raster engine will merge patches reachable under this hop distance into virtual components before running the main optimization, and will track how many patches were merged.

---

## Vector Workflow

Vector mode is designed for polygon patch datasets, where each feature is a separate patch.

### Input requirements

- One feature per patch. If the input layer has only one feature, Linkscape will warn and refuse to run, since a single patch cannot be connected to anything.  

### Units and basic parameters

- Select metric or imperial units in the dialog.  
- Set:
  - Minimum corridor width (meters or feet)  
  - Minimum patch size (hectares or acres)  
  - Budget area (same area units)  
  - Maximum search distance (meters or feet)  

### Obstacles and navigator grid

- Enable obstacles to route around non-habitat features such as roads, rivers, or urban areas.  
- Select one or more vector obstacle layers and a grid resolution for the navigator. The engine builds a raster grid over the combined obstacle geometry and uses it for pathfinding.  

### Stepping and hop distance

- Enable stepping and set a hop distance in the same units as corridor width and distances.  
- The vector engine can treat nearby small patches as part of the same effective component when they are within this hop distance, and it reports merged patches and virtual components in the run statistics.

---

## Optimization Strategies

Both raster and vector workflows share the same high-level strategies, but they are implemented with slightly different logic under the hood.

### Most Connectivity (Resilient Network)

- Goal: maximize total connected habitat area across all patches.  
- Behavior in v1.6: the engine tracks which patches are already connected and only treats the marginal gain from newly connected patches as a benefit. It also allows some redundant corridors when they strengthen the network and budget permits.  

Use this when you care about overall connectivity and redundancy rather than one flagship patch.

### Largest Patch (Single Dominant Patch)

- Goal: grow one very large connected patch by selectively linking surrounding patches.  
- Implementation: the algorithm simulates growing a component starting from the current largest patch and keeps the plan that yields the largest final connected area under budget.  

Use this when your objective is a single high-value core area.

---

## Outputs

For each run, Linkscape can produce:

### Raster mode outputs

- Corridor raster where pixel values indicate the size of the contiguous patch created by including that corridor cell.  
- Optional intermediate rasters (habitat mask, obstacle mask, passable mask), depending on configuration.

### Vector mode outputs

- Corridor layer as a GeoPackage, with each corridor feature containing:  
  - Patch ids it connects  
  - Length and cost  
  - Connected area and strategy statistics  

### Run summaries

After each run, the plugin writes:

- A text summary (`ls_mostconn_summary.txt` or `ls_largestpatch_summary.txt` depending on strategy).  
- A summary CSV with fields:  
  - `output`  
  - `corridors_created`  
  - `patches_connected`  
  - `total_contiguous_area`  
  - `largest_contiguous_area`  
  - `budget_used`  
  - `budget_total`  
  - `budget_units`  
  - `patches_merged`  
  - `virtual_components`  
  - `hop_distance`  

The CSV is automatically added to the QGIS project as a non-spatial table so you can compare runs or join back to other reporting workflows.

---

## Tips and Best Practices

- Start with a small area and conservative budget to verify parameter settings before scaling up.  
- Keep patch definitions simple at first. For raster mode, start with a single habitat value and add ranges later.  
- Use stepping and bottleneck controls to adjust realism rather than trying to encode everything into the land cover itself.  
- Check the summary CSV after each run to understand why some corridors were chosen and how much budget was used.

---

## Troubleshooting

- **No corridors produced**  
  - Check that budget and max search distance are large enough.  
  - For vector mode, ensure there is more than one patch feature and that obstacles are not blocking all routes.

- **Corridors clip into obstacles**  
  - Increase minimum corridor width or tighten bottleneck rules in raster mode.  
  - For vector mode, verify that obstacle layers are valid and that the navigator grid resolution is appropriate.

- **Runs are slow**  
  - Reduce extent or resample rasters to a coarser resolution.  
  - In vector mode, filter out very small patches with the minimum patch size setting.

---

## Credits

Linkscape was created by Ben Bishop (SORUS) as a practical tool for habitat connectivity and corridor planning.  

Bug reports and feature requests are welcome on the GitHub issue tracker listed in the plugin metadata.  
