# -*- coding: utf-8 -*-

"""
/***************************************************************************
 LightPollutionToolbox
                                 A QGIS plugin
 Light pollution indicators (focus on public lighting)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-20
        copyright            : (C) 2020 by Mathieu Chailloux
        email                : mathieu@chailloux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Mathieu Chailloux'
__date__ = '2020-04-20'
__copyright__ = '(C) 2020 by Mathieu Chailloux'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication, QgsProcessingException
from .algs.LightPollutionToolbox_provider import LightPollutionToolboxProvider
from PyQt5.QtCore import QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class LightPollutionToolboxPlugin(object):

    def __init__(self):
        self.provider = None
        
    # def icon(self):
        # cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        # icon = QIcon(os.path.join(os.path.join(cmd_folder, 'lamp.png')))
        # return icon

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = LightPollutionToolboxProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        if QgsApplication.locale() in ['fr','FR']:
            self.switchLang('fr')
        self.initProcessing()
        
        # Switch language to english.
    def switchLang(self,lang):
        #assert(False)
        plugin_dir = os.path.dirname(__file__)
        lang_path = os.path.join(plugin_dir,'i18n','LightPollutionToolbox_' + lang + '.qm')
        if os.path.exists(lang_path):
            #assert(False)
            self.translator = QTranslator()
            self.translator.load(lang_path)
            if qVersion() > '4.3.3':
                #assert(False)
                print(lang_path)
                QCoreApplication.installTranslator(self.translator)
            else:
                return
        else:
            raise QgsProcessingException("No translation file : " + str(en_path))

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
